#!/bin/sh
#
# Here to reload applications.
#
# Need unit and server IP addresses as parameters.
#
if [ $# != 2 ]
then
	echo "Need unit and server IP addresses"
	exit 1
fi

echo "Killing all applications..."
killall openvpn
killall udhcpc
killall udhcpd
killall lighttpd
killall maradns
killall resetIP.sh
killall pppoe
killall pppd
killall hostapd
killall bbmd
# Make sure we're at root level.
#
cd /

# Make file system read-write.
#
echo "Making file system read-write..."
/scripts/read-write.sh

# Show what we're using.
#
echo "  Unit IP address is $1"
echo "Server IP address is $2"

# Bring eth0 to known state.
#
echo "Bringing ethernet interface down/up..."
ifconfig eth0 down
ifconfig eth0 $1 up

# Get apps tarball from server.
#
echo "Getting application tarball from server..."
cd /tmp
tftp -g -r apps.tgz $2
cd /

# Install it.
#
echo "Installing application tarball..."
tar -xvzf /tmp/apps.tgz

# Remove tar file.
#
echo "Removing tarball..."
rm /tmp/apps.tgz

# Done.
#
echo "Done!"
exit 0
