#!/bin/sh

# number of seconds the button should be pressed to reset to defaults
COUNT=3
app_check=0
APP_CHECK_TIME=300
num=1
ppp_error=0

# Source the network definitions.
#
. /app/config/network_eth0.ini
. /app/config/network_eth1.ini


while [ $num -eq 1 ]; do

sleep 1

# Get portf status.
portf_val=$(portf | cut -d' ' -f4)

# Check default pushbutton
portf_val=$(($portf_val & 0x02))

# If default pushbutton is low for desired time.
if [ "$portf_val" = "0" ]
then
	i=$(($i+1))
else	
	i=0	
fi

if [ "$i" = "$COUNT" ]
then
	echo "Default pushbutton pressed: setting default ip and passwords."
	#
	cd /app/config
	tar -xzf /scripts/recover-network.tgz
	cd -
	#
	cd /etc
	/scripts/read-write.sh
	tar -xzf /scripts/recover-etc.tgz
	sleep 3
	/scripts/read-only.sh
	cd -
	# Store new config so it's good for next boot.
	# Does nothing for JFFS2 file systems.
	/scripts/config_store
	# Raise CCI_BIT so that led will blink.
	#portf 0xff
	# Wait a bit.
	#sleep 3
	# Lower CCI_BIT so that led will be solid again.
	#portf 0xfb
fi

#Check if cellular is running. If not working for 20 minutes, we restart cellular again
if [ "$BOOTPROTO_ETH0" = "cellular" ]
then	
	app_check=$(($app_check+1))
	if [ "$app_check" = "$APP_CHECK_TIME" ]
	then
		app_check=0
		pppStatus=$(echo $(ifconfig | grep ppp0 | wc -l))
		if [ "$pppStatus" = "0" ]
		then		
			# either pppd is not running, or there are issues with the modem, so increment error count
			ppp_error=$(($ppp_error+1))
			if [ "$ppp_error" = "4" ]
			then
				ppp_error=0
				poff
				killall pppd
				killall maradns
				killall openvpn
				rm /etc/ppp/resolv.conf
				rm /tmp/pppfile
				porth 0x77
				sleep 2
				porth 0x7f
				sleep 5
				/app/config/cell/startCell.sh & 
			fi
		elif [ "$pppStatus" = "1" ]
		then
			#all is good in cellular world, reset error count
			ppp_error=0
		fi
	fi
fi

done
