//
// File: check.js
// Product: BASrouterLX
// Author: Harpartap Parmar
// Copyright 2018: Contemporary Control Systems, Inc.
//
function checkDigit(val)
{
	var i;
	var digits="0123456789";
	var len=val.length;

	for(i = 0; i < len; i++)
	{
		if (digits.indexOf(val.charAt(i))< 0)
			return 1;
	}

	return 0;
}

function checkHex(val)
{
	var i;
	var hexDigits="0123456789ABCDEFabcdef";
	var len=val.length;

	for(i = 0; i < len; i++)
	{
		if (hexDigits.indexOf(val.charAt(i))< 0)
			return 1;
	}

	return 0;
}

//
//
function IPCheck1(val)
{
	var proceed=checkDigit(val);
	if(proceed==1)
		return 1;
	if(proceed==0)
	{
		if((val<1) || (val >223))
		return 2;
	}
	return 0;
}

//
//
function IPCheck2(val)
{
	var proceed=checkDigit(val);
	if(proceed==1)
		return 1;
	if(proceed==0)
	{
		if((val < 0) || (val > 255))
		return 2;
	}
	return 0;
}

//
//
function IPCheck3(val)
{
	var proceed=checkDigit(val);
	if(proceed==1)
		return 1;
	if(proceed==0)
	{
		if((val < 1) || (val > 254))
		return 2;
	}
	return 0;
}

//
//
function NumberCheck(value, a, b)
{
	var proceed=checkDigit(value);
	if(proceed==1)
	{
		return 1;
	}
	if(proceed==0)
	{
		if((parseInt(value,10) < parseInt(a, 10)) || (parseInt(value,10) > parseInt(b,10)))
		{
			return 2; 
		}
	}
	return 0;
}


function checkNatPage(a)
{
	// Secondary BACnet/IP UDP Port
	var b=a._4_1_0_1;
	var z1=1;
	var z2=1;
	val=b.value;
	if(val.length==0)
	{
		alert('Input a value for Secondary BACnet/IP UDP Port');
		b.focus();
		return false;
	}
	ret=checkHex(val);
	if(ret==1)
	{
		alert('Input hexadecimal value between 0 to FFFF for Secondary BACnet/IP UDP Port');
		b.focus();
		return false;
	}

	if(val==0)
		z1=0;

	// Secondary BACnet/IP Network
	b=a._4_2_0_2;
	val=b.value;
	if(val.length==0)
	{
		alert('Input a value for Secondary BACnet/IP Network');
		b.focus();
		return false;
	}
	ret=NumberCheck(val, 0, 65534);
	if(ret==1)
	{
		alert('Input numerical value for Secondary BACnet/IP Network');
		b.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Secondary BACnet/IP Network value should be between 0 and 65534');
		b.focus();
		return false; 
	}
	
	if(val==0)
		z2=0;

	if(z1!=z2)
	{
		alert('UDP Port and Network number should both be either zero or non-zero');
		b.focus();
		return false;
	}
	

	// Public IP Address
	b=a._4_3_0_1;
	ipVal=b.value
	if(ipVal.length==0)
	{
		alert('Input Public IP Address');
		b.focus();
		return false;	
	}

	ipArray=ipVal.split(".");
	if(ipArray.length != 4)
	{
		alert('Input Valid Public IP Address');
		b.focus();
		return false;
	}

	if((ipArray[0].length ==0) ||(ipArray[1].length==0) || (ipArray[2].length == 0) || (ipArray[3].length==0))
	{
		alert('Input Valid Public IP Address');
		b.focus();
		return false;
	}

	if( (ipArray[0]!=0) || (ipArray[1]!=0) || (ipArray[2]!=0) || (ipArray[3]!=0) ) //0.0.0.0 is valid
	{
		if ( (NumberCheck(ipArray[0], 1, 223) > 0) || (NumberCheck(ipArray[1], 0, 255) > 0) || (NumberCheck(ipArray[2], 0, 255) > 0) || (NumberCheck(ipArray[3], 0, 255) > 0))
		{
			alert('Input Valid Public IP Address');
			b.focus();
			return false;
		}	
	
		if ( ((ipArray[0].length > 1) && (ipArray[0].charAt(0)==0)) || ((ipArray[1].length > 1) && (ipArray[1].charAt(0)==0)) || ((ipArray[2].length > 1) && (ipArray[2].charAt(0)==0)) || ((ipArray[3].length > 1) && (ipArray[3].charAt(0)==0)) )
		{
			alert('Leading Zeros not allowed in IP Address');
			b.focus();
			return false;
		}
		
		//if( ((ipArray[0]<1) || (ipArray[0] >223)) || ((ipArray[1]<0) || (ipArray[1] >255)) ||
		//((ipArray[2]<0) || (ipArray[2] >255)) || ((ipArray[3]<0) || (ipArray[3] >255)) )
		//{
		//	alert('Input Valid Public IP Address');
		//	b.focus();
		//	return false;
		//}
	}
	return true;
}

//
//
function checkSetupPage(a)
{
	var dotted_subnet = new Array("255.0.0.0", "255.128.0.0", "255.192.0.0", "255.224.0.0",
			      	"255.240.0.0", "255.248.0.0", "255.252.0.0", "255.254.0.0",
			      	"255.255.0.0", "255.255.128.0", "255.255.192.0", "255.255.224.0",
			      	"255.255.240.0", "255.255.248.0", "255.255.252.0", "255.255.254.0",
			 	"255.255.255.0", "255.255.255.128", "255.255.255.192", "255.255.255.224",
				"255.255.255.240", "255.255.255.248", "255.255.255.252" );

	var z1=1;
	var z2=1;

	// device instance
	val=a._1_2_0_2.value;
	if(val.length==0)
	{
		alert('Input a value for Device Instance');
		a._1_2_0_2.focus();
		return false;
	}
	ret=NumberCheck(val, 0, 4194302);
	if(ret==1)
	{
		alert('Input numerical value for Device Instance');
		a._1_2_0_2.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Device Instance should be between 0 and 4194302');
		a._1_2_0_2.focus();
		return false; 
	}
	
	// Ethernet Network
	val=a._1_5_0_2.value;
	if(val.length==0)
	{
		alert('Input a value for Ethernet Network');
		a._1_5_0_2.focus();
		return false;
	}
	ret=NumberCheck(val, 0, 65534);
	if(ret==1)
	{
		alert('Input numerical value for Ethernet Network');
		a._1_5_0_2.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Ethernet Network should be between 0 and 65534');
		a._1_5_0_2.focus();
		return false; 
	}

	eth_nw=val;

	// BACnet/IP UDP Port 1
	val=a._1_6_0_1.value;
	if(val.length==0)
	{
		alert('Input a value for BACnet/IP UDP Port 1');
		a._1_6_0_1.focus();
		return false;
	}
	ret=checkHex(val);
	if(ret==1)
	{
		alert('Input hexadecimal value between 0 to FFFF for BACnet/IP UDP Port 1');
		a._1_6_0_1.focus();
		return false;
	}
	if(val==0)
		z1=0;

	// BACnet/IP Network 1 _1_7_0_2 	0-65534
	val=a._1_7_0_2.value;
	if(val.length==0)
	{
		alert('Input a value for BACnet/IP Network 1');
		a._1_7_0_2.focus();
		return false;
	}
	ret=NumberCheck(val, 0, 65534);
	if(ret==1)
	{
		alert('Input numerical value for BACnet/IP Network 1');
		a._1_7_0_2.focus();
		return false;
	}
	if(ret==2)
	{
		alert('BACnet/IP Network 1 value should be between 0 and 65534');
		a._1_7_0_2.focus();
		return false; 
	}
	
	if(val==0)
		z2=0;

	// BACnet/IP UDP Port 1 and BACnet/IP Network 1 both should be zero or non-zero
	if(z1!=z2)
	{
		alert('BACnet/IP UDP Port 1 and BACnet/IP Network 1 should both be either zero or non-zero');
		a._1_6_0_1.focus();
		return false;
	}
	bac_ip_nw1=val;

	// IP Address _1_8_0_1
	ipVal=a._1_8_0_1.value
	if(ipVal.length==0)
	{
		alert('Input IP Address');
		a._1_8_0_1.focus();
		return false;	
	}

	ipArray=ipVal.split(".");
	if(ipArray.length != 4)
	{
		alert('Input Valid IP Address');
		a._1_8_0_1.focus();
		return false;
	}

	if((ipArray[0].length ==0) ||(ipArray[1].length==0) || (ipArray[2].length == 0) || (ipArray[3].length==0))
	{
		alert('Input Valid IP Address');
		a._1_8_0_1.focus();
		return false;
	}
	
	if ( (NumberCheck(ipArray[0], 1, 223) > 0) || (NumberCheck(ipArray[1], 0, 255) > 0) || (NumberCheck(ipArray[2], 0, 255) > 0) || (NumberCheck(ipArray[3], 0, 255) > 0))
	{
		alert('Input Valid IP Address');
		a._1_8_0_1.focus();
		return false;
	}
	
	
	if ( ((ipArray[0].length > 1) && (ipArray[0].charAt(0)==0)) || ((ipArray[1].length > 1) && (ipArray[1].charAt(0)==0)) || ((ipArray[2].length > 1) && (ipArray[2].charAt(0)==0)) || ((ipArray[3].length > 1) && (ipArray[3].charAt(0)==0)) )
	{
		alert('Leading Zeros not allowed in IP Address');
		a._1_8_0_1.focus();
		return false;
	}


	//orig, changed to numbercheck above
	//if( ((ipArray[0]<1) || (ipArray[0] >223)) || ((ipArray[1]<0) || (ipArray[1] >255)) ||
	//((ipArray[2]<0) || (ipArray[2] >255)) || ((ipArray[3]<0) || (ipArray[3] >255)) )
	//{
	//	alert('Input Valid IP Address');
	//	a._1_8_0_1.focus();
	//	return false;
	//}

	// Ip Subnet _1_9_0_2
	var subnet;
	var invSubnet=new Array(4);
	var subnetArray=new Array(4);
	subnet=a._1_9_0_2.value;
	var subnet_val=dotted_subnet[subnet-8];
	subnetArray=subnet_val.split(".");

	//calculate network address for subnet
	var nm_array=new Array(4);
	for (i = 0; i < 4; i++)
		nm_array[i] = ipArray[i] & subnetArray[i];
	//calculate inverse netmask
	for (i = 0; i < 4; i++)
		invSubnet[i] = subnetArray[i] ^ 255;
	
	//calculate broadcast ip address
	var bc_ip=new Array(4);
	for (i = 0; i < 4; i++)
		bc_ip[i] = ipArray[i] | invSubnet[i];

	//
	// Display error if ip address matches network or broadcast IP address
	//
	if((ipArray[0]==nm_array[0]) && (ipArray[1]==nm_array[1]) && (ipArray[2]==nm_array[2]) && (ipArray[3]==nm_array[3]) )
	{
		alert('IP address is equal to Network IP address for subnet. Either change the IP address or IP Subnet value.');
		return false;
	}

	if((ipArray[0]==bc_ip[0]) && (ipArray[1]==bc_ip[1]) && (ipArray[2]==bc_ip[2]) && (ipArray[3]==bc_ip[3]) )
	{
		alert('IP address is equal to Broadcast IP address for subnet.Either change the IP address or IP Subnet value.');
		return false;
	}

	// IP Gateway _1_10_0_1
	gwVal=a._1_10_0_1.value
	if(gwVal.length==0)
	{
		alert('Input IP Gateway Address');
		a._1_10_0_1.focus();
		return false;	
	}

	gwArray=gwVal.split(".");
	if(gwArray.length != 4)
	{
		alert('Input Valid IP Gateway Address');
		a._1_10_0_1.focus();
		return false;
	}

	if((gwArray[0].length ==0) ||(gwArray[1].length==0) || (gwArray[2].length == 0) || (gwArray[3].length==0))
	{
		alert('Input Valid IP Gateway Address');
		a._1_10_0_1.focus();
		return false;
	}
	
	if( (gwArray[0]!=0) || (gwArray[1]!=0) || (gwArray[2]!=0) || (gwArray[3]!=0) )
	{
		if ( (NumberCheck(gwArray[0], 1, 223) > 0) || (NumberCheck(gwArray[1], 0, 255) > 0) || (NumberCheck(gwArray[2], 0, 255) > 0) || (NumberCheck(gwArray[3], 0, 255) > 0))
		{
			alert('Input Valid IP Gateway Address');
			a._1_10_0_1.focus();
			return false;
		}
	
	
		if ( ((gwArray[0].length > 1) && (gwArray[0].charAt(0)==0)) || ((gwArray[1].length > 1) && (gwArray[1].charAt(0)==0)) || ((gwArray[2].length > 1) && (gwArray[2].charAt(0)==0)) || ((gwArray[3].length > 1) && (gwArray[3].charAt(0)==0)) )
		{
			alert('Leading Zeros not allowed in IP Gateway Address');
			a._1_10_0_1.focus();
			return false;
		}
	
		//if( ((gwArray[0]<1) || (gwArray[0] >223)) || ((gwArray[1]<0) || (gwArray[1] >255)) ||
		//((gwArray[2]<0) || (gwArray[2] >255)) || ((gwArray[3]<0) || (gwArray[3] >255)) )
		//{
		//	alert('Input Valid IP Gateway Address');
		//	a._1_10_0_1.focus();
		//	return false;
		//}

		//
		// calculate network address for gw
		var gw_nm_array=new Array(4);
		
		for (i = 0; i < 4; i++)
			gw_nm_array[i] = gwArray[i] & subnetArray[i];

	
		//
		// validate gateway ip address to be in same subnet as ip address
		if( (gw_nm_array[0]!=nm_array[0]) || (gw_nm_array[1]!=nm_array[1]) || (gw_nm_array[2]!=nm_array[2]) 
			|| (gw_nm_array[3]!=nm_array[3]) )
		{
			alert('IP Gateway Address not in IP subnet');
			a._1_10_0_1.focus();
			return false;
		}

		//
		// Display error if gw ip address matches network or broadcast IP address
		//
		if( (gwArray[0]==nm_array[0]) && (gwArray[1]==nm_array[1]) && (gwArray[2]==nm_array[2]) && (gwArray[3]==nm_array[3]) )
		{
			alert('IP Gateway Address is equal to Network IP address for subnet');
			a._1_10_0_1.focus();
			return false;
		}

		if( (gwArray[0]==bc_ip[0]) && (gwArray[1]==bc_ip[1]) && (gwArray[2]==bc_ip[2]) && (gwArray[3]==bc_ip[3]) )
		{
			alert('IP Gateway address is equal to broadcast IP address for subnet');
			a._1_10_0_1.focus();
			return false;
		}
	}	

	// MS/TP MAC
	val=a._1_11_0_2.value;
	if(val.length==0)
	{
		alert('Input a value for MS/TP MAC');
		a._1_11_0_2.focus();
		return false;
	}
	ret=NumberCheck(val, 0, 127);
	if(ret==1)
	{
		alert('Input numerical value for MS/TP MAC');
		a._1_11_0_2.focus();
		return false;
	}
	if(ret==2)
	{
		alert('MS/TP MAC value should be between 0 and 127')
		a._1_11_0_2.focus();
		return false; 
	}

	// MS/TP Network
	val=a._1_12_0_2.value;
	if(val.length==0)
	{
		alert('Input a value for MS/TP Network');
		a._1_12_0_2.focus();
		return false;
	}
	ret=NumberCheck(val, 1, 65534);
	if(ret==1)
	{
		alert('Input numerical value for MS/TP Network');
		a._1_12_0_2.focus();
		return false;
	}
	if(ret==2)
	{
		alert('MS/TP Network value should be between 1 and 65534');
		a._1_12_0_2.focus();
		return false; 
	}
	mstp_nw=val;

	//
	//Check for duplicate network numbers
	if( (eth_nw != 0) && (bac_ip_nw1 != 0) && (eth_nw == bac_ip_nw1))
	{
		alert('Duplicate values for Ethernet Network and BACnet/IP Network 1');
		a._1_5_0_2.focus();
		return false; 
	}

	if( (eth_nw != 0) && (mstp_nw != 0) && (eth_nw == mstp_nw))
	{
		alert('Duplicate values for Ethernet Network and MS/TP Network');
		a._1_7_0_2.focus();
		return false; 
	}
	
	if( (bac_ip_nw1 != 0) && (mstp_nw != 0) && (bac_ip_nw1 == mstp_nw))
	{
		alert('Duplicate values for BACnet/IP Network 1 and MS/TP Network');
		a._1_7_0_2.focus();
		return false; 
	}
	// end duplicate network number check
	//

	// Max Masters
	val=a._1_13_0_2.value;
	if(val.length==0)
	{
		alert('Input a value for Max Masters');
		a._1_13_0_2.focus();
		return false;
	}
	ret=NumberCheck(val, 1, 127);
	if(ret==1)
	{
		alert('Input numerical value for Max Masters');
		a._1_13_0_2.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Max Masters value should be between 1 and 127');
		a._1_13_0_2.focus();
		return false; 
	}

	// Max Info Frames
	val=a._1_14_0_2.value;
	if(val.length==0)
	{
		alert('Input a value for Max Info Frames');
		a._1_14_0_2.focus();
		return false;
	}
	ret=NumberCheck(val, 1, 100);
	if(ret==1)
	{
		alert('Input numerical value for Max Info Frames');
		a._1_14_0_2.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Max Info Frames value should be between 1 and 100');
		a._1_14_0_2.focus();
		return false; 
	}

	return true;
}

function isLeapYear(year)
{
	return year%400 ==0 || (year%100 != 0 && year%4 == 0);
}

function checkTimePage(a)
{
	var numDays=["31","28","31","30","31","30","31","31","30","31","30","31"];
	// Year
	var val=a._9_1_0_2.value;
	
	if(val.length==0)
	{
		alert('Input a value for Year');
		a._9_1_0_2.focus();
		return false;
	}
	ret=NumberCheck(val, 1000, 9999);
	if(ret==1)
	{
		alert('Input valid numerical value for Year');
		a._9_1_0_2.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Enter numerical value for Year in YYYY format');
		a._9_1_0_2.focus();
		return false; 
	}

	var isLeap=isLeapYear(val);	

	// Month
	val=a._9_2_0_2.value;
	if(val.length==0)
	{
		alert('Input a value for Month');
		a._9_2_0_2.focus();
		return false;
	}
	ret=NumberCheck(val, 1, 12);
	if(ret==1)
	{
		alert('Input numerical value for Month');
		a._9_2_0_2.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Month value should be between 1 and 12');
		a._9_2_0_2.focus();
		return false; 
	}

	mnthVal=parseInt(val,10)-1;
	if ((isLeap) && (mnthVal == 1))//feb and leap year
		numDays[mnthVal]=29;	

	// Day
	val=a._9_3_0_2.value;
	if(val.length==0)
	{
		alert('Input a value for Day');
		a._9_3_0_2.focus();
		return false;
	}
	ret=NumberCheck(val, 1, numDays[mnthVal]);
	if(ret==1)
	{
		alert('Input numerical value for Day');
		a._9_3_0_2.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Day value should be between 1 and ' + numDays[mnthVal] + '');
		a._9_3_0_2.focus();
		return false; 
	}
	
	// Hours
	val=a._9_4_0_2.value;
	if(val.length==0)
	{
		alert('Input a value for Hours');
		a._9_4_0_2.focus();
		return false;
	}
	ret=NumberCheck(val, 0, 24);
	if(ret==1)
	{
		alert('Input numerical value for Hours');
		a._9_4_0_2.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Hours value should be between 0 and 24');
		a._9_4_0_2.focus();
		return false; 
	}
	
	// Minutes
	val=a._9_5_0_2.value;
	if(val.length==0)
	{
		alert('Input a value for Minutes');
		a._9_5_0_2.focus();
		return false;
	}
	ret=NumberCheck(val, 0, 60);
	if(ret==1)
	{
		alert('Input numerical value for Minutes');
		a._9_5_0_2.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Minutes value should be between 0 and 60');
		a._9_5_0_2.focus();
		return false; 
	}

	// Secs
	val=a._9_6_0_2.value;
	if(val.length==0)
	{
		alert('Input a value for Seconds');
		a._9_6_0_2.focus();
		return false;
	}
	ret=NumberCheck(val, 0, 60);
	if(ret==1)
	{
		alert('Input numerical value for Seconds');
		a._9_6_0_2.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Seconds value should be between 0 and 60');
		a._9_6_0_2.focus();
		return false; 
	}

	return true;
}


function checkSlaveProxyPage(a)
{
	//MAC Address
	var b=a._5_3_1_2;
	val=b.value;
	if(val.length==0)
	{
		alert('Input a value for Mac Address');
		b.focus();
		return false;
	}
	ret=NumberCheck(val, 0, 254);
	if(ret==1)
	{
		alert('Input numerical value for Mac Address');
		b.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Mac Address value should be between 0 and 254');
		b.focus();
		return false; 
	}
	
	//Device Instance
	var b=a._5_3_2_2;
	val=b.value;
	if(val.length==0)
	{
		alert('Input a value for Device Instance');
		b.focus();
		return false;
	}
	ret=NumberCheck(val, 0, 4194302);
	if(ret==1)
	{
		alert('Input numerical value for Device Instance');
		b.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Device Instance value should be between 0 and 4194302');
		b.focus();
		return false; 
	}

	//Vendor ID
	var b=a._5_3_3_2;
	val=b.value;
	if(val.length==0)
	{
		alert('Input a value for Vendor ID');
		b.focus();
		return false;
	}
	ret=NumberCheck(val, 0, 65535);
	if(ret==1)
	{
		alert('Input numerical value for Vendor ID');
		b.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Vendor ID should be between 0 and 65535');
		b.focus();
		return false; 
	}

	//Max APDU
	var b=a._5_3_4_2;
	val=b.value;
	if(val.length==0)
	{
		alert('Input a value for Max APDU');
		b.focus();
		return false;
	}
	ret=NumberCheck(val, 1, 9999);
	if(ret==1)
	{
		alert('Input numerical value for Max APDU');
		b.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Max APDU value should be between 1 and 9999');
		b.focus();
		return false; 
	}

	        
	return true;
}

function checkSlaveProxyPage2(a)
{
	//Delete Entry
	var b=a._5_3_6_2;
	val=b.value;
	if(val.length==0)
	{
		alert('Input a value to Delete Entry');
		b.focus();
		return false;
	}
	ret=NumberCheck(val, 1, 100);
	if(ret==1)
	{
		alert('Input numerical value to Delete Entry');
		b.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Delete Entry value should be between 1 and 100');
		b.focus();
		return false; 
	}
	
	return true;
}

function checkBdtPage1(a)
{
	//BBMD IP Address
	var b=a._3_1_0_1;
	ipVal=b.value;
	if(ipVal.length==0)
	{
		alert('Input BBMD IP Address');
		b.focus();
		return false;	
	}

	ipArray=ipVal.split(".");
	if(ipArray.length != 4)
	{
		alert('Input Valid BBMD IP Address');
		b.focus();
		return false;
	}

	if((ipArray[0].length ==0) ||(ipArray[1].length==0) || (ipArray[2].length == 0) || (ipArray[3].length==0))
	{
		alert('Input Valid BBMD IP Address');
		b.focus();
		return false;
	}
		

	if( (NumberCheck(ipArray[0], 1, 223) != 0) || (NumberCheck(ipArray[1], 0, 255) != 0) || (NumberCheck(ipArray[2], 0, 255) != 0) || (NumberCheck(ipArray[3], 0, 255) != 0) ) 
	{
		alert('Input Valid BBMD IP Address');
		b.focus();
		return false;
	}
	
	if ( ((ipArray[0].length > 1) && (ipArray[0].charAt(0)==0)) || ((ipArray[1].length > 1) && (ipArray[1].charAt(0)==0)) || ((ipArray[2].length > 1) && (ipArray[2].charAt(0)==0)) || ((ipArray[3].length > 1) && (ipArray[3].charAt(0)==0)) )
	{
			alert('Leading Zeros not allowed in BBMD IP Address');
			b.focus();
			return false;
	}
	

	//if( ((ipArray[0]<1) || (ipArray[0] >223)) || ((ipArray[1]<0) || (ipArray[1] >255)) ||
	//((ipArray[2]<0) || (ipArray[2] >255)) || ((ipArray[3]<0) || (ipArray[3] >255)) )
	//{
	//	alert('Input Valid BBMD IP Address');
	//	b.focus();
	//	return false;
	//}
	
	return true;
}

function checkBdtPage2(a)
{
	//Delete Entry for Broadcast Distribution Table
	var b=a._3_4_0_2;
	val=b.value;
	if(val.length==0)
	{
		alert('Input a value to Delete Entry');
		b.focus();
		return false;
	}
	ret=NumberCheck(val, 1, 50);
	if(ret==1)
	{
		alert('Input numerical value to Delete Entry');
		b.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Delete Entry value should be between 1 and 50');
		b.focus();
		return false; 
	}
	
	return true;
}

function checkPasswordPage(a)
{
	var u=a._11_1_1_1.value;
	var p1=a._11_1_2_1.value;
	var p2=a._11_1_3_1.value;
	var paswd=  /^(?=.*[0-9])(?=.*[a-zA-Z])/;

	if ( ( /[^A-Za-z0-9]/.test(u) ) || ( /[^A-Za-z0-9!%@#\+\^\[\]_{}~]+$/.test(p1) ) )
	{ 
		alert('Only alpha-numeric characters can be used for Username.\nAlpha-numeric and special characters ~ ! @ # % ^ + [ ] { } and _ can be used for Password.');
		return false;
	}

	//check for minimum length of 8 characters
	if( (u.length < 8) || (p1.length < 8) || (p2.length < 8) )
	{
		alert('Username and Password must be atleast 8 characters long.');
		return false;
	}

	//check to see if passwords p1 and p2 match	
	if(p1 != p2)
	{
		alert('Passwords entered do not match. Re-enter passwords and try again.');
		return false;	
	}

	if(p1.match(paswd)) 
	{ 
		
		return true;
	}
	else
	{
		alert('Password must contain atleast one alphabet and one number.');
		return false;
	}

	return true;
}

function checkAdmin1Page(a)
{
	var p=a._3_13_1_2.value;
	var retVal;
	retVal=PortCheck(p);
	if(retVal==false)
		return false;
	
	return true;
}


function extractFilename(path)
{
  var x;
  x = path.lastIndexOf('\\');
  if (x >= 0) // Windows-based path
    return path.substr(x+1);

  x = path.lastIndexOf('/');
  if (x >= 0) // Unix-based path
    return path.substr(x+1);

  return path; // just the filename
}

function updateFilename(path)
{
   var name;	
   name = extractFilename(path);
   document.getElementById('upfile').value = name;
}

function checkConfigPage(a)
{
	var p=a.upfile.value;
	if(p.length == 0)
	{
		alert('Select File to be uploaded');
		return false;
	}
	return true;
}

function SelectWhitelist(a)
{
	if(a==0)
		document.getElementById("wlhide").style.display = "none";
	else if(a==1)
		document.getElementById("wlhide").style.display = "block";
}

//
//
function wlcheck1(a)
{
	var ip1=new Array(4);
	b=a._17_2_0_2;

	if(b.checked)
	{
		ip1[0]=a._17_1_1_2.value;
		ip1[1]=a._17_1_2_2.value;
		ip1[2]=a._17_1_3_2.value;
		ip1[3]=a._17_1_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}
		
		if ( ((ip1[0].length > 1) && (ip1[0].charAt(0)==0)) || ((ip1[1].length > 1) && (ip1[1].charAt(0)==0)) || ((ip1[2].length > 1) && (ip1[2].charAt(0)==0)) || ((ip1[3].length > 1) && (ip1[3].charAt(0)==0)) )
		{
			alert('Leading Zeros not allowed in IP Address');
			b.checked=false;
			return false;
		}
	}
}


//
//
function wlcheck2(a)
{
	var ip1=new Array(4);
	b=a._17_4_0_2;

	if(b.checked)
	{
		ip1[0]=a._17_3_1_2.value;
		ip1[1]=a._17_3_2_2.value;
		ip1[2]=a._17_3_3_2.value;
		ip1[3]=a._17_3_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}
		
		if ( ((ip1[0].length > 1) && (ip1[0].charAt(0)==0)) || ((ip1[1].length > 1) && (ip1[1].charAt(0)==0)) || ((ip1[2].length > 1) && (ip1[2].charAt(0)==0)) || ((ip1[3].length > 1) && (ip1[3].charAt(0)==0)) )
		{
			alert('Leading Zeros not allowed in IP Address');
			b.checked=false;
			return false;
		}
	}
}


//
//
function wlcheck3(a)
{
	var ip1=new Array(4);
	b=a._17_6_0_2;

	if(b.checked)
	{
		ip1[0]=a._17_5_1_2.value;
		ip1[1]=a._17_5_2_2.value;
		ip1[2]=a._17_5_3_2.value;
		ip1[3]=a._17_5_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}
		
		if ( ((ip1[0].length > 1) && (ip1[0].charAt(0)==0)) || ((ip1[1].length > 1) && (ip1[1].charAt(0)==0)) || ((ip1[2].length > 1) && (ip1[2].charAt(0)==0)) || ((ip1[3].length > 1) && (ip1[3].charAt(0)==0)) )
		{
			alert('Leading Zeros not allowed in IP Address');
			b.checked=false;
			return false;
		}
	}
}


//
//
function wlcheck4(a)
{
	var ip1=new Array(4);
	b=a._17_8_0_2;

	if(b.checked)
	{
		ip1[0]=a._17_7_1_2.value;
		ip1[1]=a._17_7_2_2.value;
		ip1[2]=a._17_7_3_2.value;
		ip1[3]=a._17_7_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}
		
		if ( ((ip1[0].length > 1) && (ip1[0].charAt(0)==0)) || ((ip1[1].length > 1) && (ip1[1].charAt(0)==0)) || ((ip1[2].length > 1) && (ip1[2].charAt(0)==0)) || ((ip1[3].length > 1) && (ip1[3].charAt(0)==0)) )
		{
			alert('Leading Zeros not allowed in IP Address');
			b.checked=false;
			return false;
		}
	}
}


//
//
function wlcheck5(a)
{
	var ip1=new Array(4);
	b=a._17_10_0_2;

	if(b.checked)
	{
		ip1[0]=a._17_9_1_2.value;
		ip1[1]=a._17_9_2_2.value;
		ip1[2]=a._17_9_3_2.value;
		ip1[3]=a._17_9_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}
		
		if ( ((ip1[0].length > 1) && (ip1[0].charAt(0)==0)) || ((ip1[1].length > 1) && (ip1[1].charAt(0)==0)) || ((ip1[2].length > 1) && (ip1[2].charAt(0)==0)) || ((ip1[3].length > 1) && (ip1[3].charAt(0)==0)) )
		{
			alert('Leading Zeros not allowed in IP Address');
			b.checked=false;
			return false;
		}
	}
}


//
//
function wlcheck6(a)
{
	var ip1=new Array(4);
	b=a._17_12_0_2;

	if(b.checked)
	{
		ip1[0]=a._17_11_1_2.value;
		ip1[1]=a._17_11_2_2.value;
		ip1[2]=a._17_11_3_2.value;
		ip1[3]=a._17_11_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}
		
		if ( ((ip1[0].length > 1) && (ip1[0].charAt(0)==0)) || ((ip1[1].length > 1) && (ip1[1].charAt(0)==0)) || ((ip1[2].length > 1) && (ip1[2].charAt(0)==0)) || ((ip1[3].length > 1) && (ip1[3].charAt(0)==0)) )
		{
			alert('Leading Zeros not allowed in IP Address');
			b.checked=false;
			return false;
		}
	}
}


//
//
function wlcheck7(a)
{
	var ip1=new Array(4);
	b=a._17_14_0_2;

	if(b.checked)
	{
		ip1[0]=a._17_13_1_2.value;
		ip1[1]=a._17_13_2_2.value;
		ip1[2]=a._17_13_3_2.value;
		ip1[3]=a._17_13_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}
		
		if ( ((ip1[0].length > 1) && (ip1[0].charAt(0)==0)) || ((ip1[1].length > 1) && (ip1[1].charAt(0)==0)) || ((ip1[2].length > 1) && (ip1[2].charAt(0)==0)) || ((ip1[3].length > 1) && (ip1[3].charAt(0)==0)) )
		{
			alert('Leading Zeros not allowed in IP Address');
			b.checked=false;
			return false;
		}
	}
}


//
//
function wlcheck8(a)
{
	var ip1=new Array(4);
	b=a._17_16_0_2;

	if(b.checked)
	{
		ip1[0]=a._17_15_1_2.value;
		ip1[1]=a._17_15_2_2.value;
		ip1[2]=a._17_15_3_2.value;
		ip1[3]=a._17_15_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}
		
		if ( ((ip1[0].length > 1) && (ip1[0].charAt(0)==0)) || ((ip1[1].length > 1) && (ip1[1].charAt(0)==0)) || ((ip1[2].length > 1) && (ip1[2].charAt(0)==0)) || ((ip1[3].length > 1) && (ip1[3].charAt(0)==0)) )
		{
			alert('Leading Zeros not allowed in IP Address');
			b.checked=false;
			return false;
		}
	}
}


//
//
function wlcheck9(a)
{
	var ip1=new Array(4);
	b=a._17_18_0_2;

	if(b.checked)
	{
		ip1[0]=a._17_17_1_2.value;
		ip1[1]=a._17_17_2_2.value;
		ip1[2]=a._17_17_3_2.value;
		ip1[3]=a._17_17_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}
		
		if ( ((ip1[0].length > 1) && (ip1[0].charAt(0)==0)) || ((ip1[1].length > 1) && (ip1[1].charAt(0)==0)) || ((ip1[2].length > 1) && (ip1[2].charAt(0)==0)) || ((ip1[3].length > 1) && (ip1[3].charAt(0)==0)) )
		{
			alert('Leading Zeros not allowed in IP Address');
			b.checked=false;
			return false;
		}
	}
}


//
//
function wlcheck10(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._17_20_0_2;

	if(b.checked)
	{
		ip1[0]=a._17_19_1_2.value;
		ip1[1]=a._17_19_2_2.value;
		ip1[2]=a._17_19_3_2.value;
		ip1[3]=a._17_19_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Whitelist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Whitelist');
			b.checked=false;
			return false;
		}
		
		if ( ((ip1[0].length > 1) && (ip1[0].charAt(0)==0)) || ((ip1[1].length > 1) && (ip1[1].charAt(0)==0)) || ((ip1[2].length > 1) && (ip1[2].charAt(0)==0)) || ((ip1[3].length > 1) && (ip1[3].charAt(0)==0)) )
		{
			alert('Leading Zeros not allowed in IP Address');
			b.checked=false;
			return false;
		}
	}
}

//
//
function checkWhitelistPage(a)
{
	var retVal, validEntry, i;
	var b=new Array(10);
	var wl_globalState=a._17_0_0_2[0].checked;

	b[0]=a._17_2_0_2.checked;
	b[1]=a._17_4_0_2.checked;
	b[2]=a._17_6_0_2.checked;
	b[3]=a._17_8_0_2.checked;
	b[4]=a._17_10_0_2.checked;
	b[5]=a._17_12_0_2.checked;
	b[6]=a._17_14_0_2.checked;
	b[7]=a._17_16_0_2.checked;
	b[8]=a._17_18_0_2.checked;
	b[9]=a._17_20_0_2.checked;

	if(wl_globalState) // if whitelist enabled, check values
	{
		//check atleast one entry is enabled
		validEntry=0;
		
		for(i=0;i<10;i++)
		{
			if(b[i])
			{
				validEntry=1;break;
			}
		}
		if(validEntry==0)
		{
			alert('Enable at least one Whitelist IP Address entry');
			return false;
		}		
		
		//check ip values
		retVal=wlcheck1(a);if(retVal==false) return false;
		retVal=wlcheck2(a);if(retVal==false) return false;
		retVal=wlcheck3(a);if(retVal==false) return false;
		retVal=wlcheck4(a);if(retVal==false) return false;
		retVal=wlcheck5(a);if(retVal==false) return false;
		retVal=wlcheck6(a);if(retVal==false) return false;
		retVal=wlcheck7(a);if(retVal==false) return false;
		retVal=wlcheck8(a);if(retVal==false) return false;
		retVal=wlcheck9(a);if(retVal==false) return false;
		retVal=wlcheck10(a);if(retVal==false) return false;
	}
	return true;
}

//
//
function DisableViewMSTPfile(a)
{
	document.getElementById("viewMSTP_button").disabled = true;
	document.getElementById("viewMSTP_button").value="Please Wait ...";
}
