/*
 * bas_def.java
 *
 * Created on February 6, 2007, 5:18 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 *	Revision History.
 *
 *	22-Jan-2008	Harpartap Parmar
 *                      Changed to Beta Version
 */

package bas_remote;

/**
 * 
 * @author rcw
 */
public class bas_def
{
    //
    // Pre-defined slave address for configuration read/writes.
    //
    public final static int CONFIG_ADDRESS        = 255;
    //
    // Calibration values.
    //
    public final static int DACVAL_LO             = 200; // 1/20th of max DAC.
    public final static int DACVAL_HI             = 4000; // Max DAC.
    public final static int DACVAL_HI_MA          = 3800; // Less than max for mA calibration.
    //
    public final static int ADCVAL_LO             = 50;  // 1/20th of max ADC.
    public final static int ADCVAL_HI             = 1000; // Max ADC.
    //
    public final static int THM_DEF_SPT           = 6700; // 6.7V for 4.7K single range.
    //
    public final static int THM_MAX_ADC           = 1023; // Max scale.
    public final static int THM_MIN_ADC           = 10;  // Min scale.
    //
    public final static int THM_DEF_ADC           = 1000; // 2V ADC input at default values (x1).
    //
    // ----------------------------------------------------------------------
    //
    // Hardware Platform Types
    //
    public final static int UNIT_MODBUS           = 0;   // Generic Modbus unit.
    public final static int UNIT_BAS_TYPE1        = 1;   // 8 channels: 6 Univeral I/O and 2 Relays.
    public final static int UNIT_VIRTUAL          = 2;
    public final static int UNIT_MODBUS_CSV       = 3;   // Modbus unit from CSV file.
    public final static int UNIT_UNKNOWN          = 4;   // For newly inserted racks.
    //
    // Boot Protocol
    //
    public final static int BOOT_PROTOCOL_NONE    = 0;
    public final static int BOOT_PROTOCOL_DHCP    = 1;
    //
    // Channel types.
    //
    public final static int INPUT_RAW           = 0;
    public final static int INPUT_5A            = 1;
    public final static int INPUT_5D            = 2;
    public final static int INPUT_10A           = 3;
    public final static int INPUT_10D           = 4;
    public final static int INPUT_20MA          = 5;
    public final static int INPUT_THM_10KT2     = 6;
    public final static int INPUT_THM_10KT3     = 7;
    public final static int INPUT_RES           = 8;
    public final static int INPUT_PULSE         = 9;
    public final static int INPUT_MCD_BIN       = 10;
    public final static int INPUT_MCD_IREG      = 11;
    public final static int INPUT_MCD_HREG      = 12;
    //
    public final static int OUTPUT_RAW          = 13;
    public final static int OUTPUT_5A           = 14;
    public final static int OUTPUT_5D           = 15;
    public final static int OUTPUT_10A          = 16;
    public final static int OUTPUT_10D          = 17;
    public final static int OUTPUT_20MA         = 18;
    public final static int OUTPUT_RLY          = 19;
    public final static int OUTPUT_MCD_BIN      = 20;
    public final static int OUTPUT_MCD_HREG     = 21;
    //
    // ----------------------------------------------------------------------
    //
    // Modbus endian modes.
    //
    public final static int ENDIAN_LITTLE       = 0;
    public final static int ENDIAN_BIG          = 1;
    //
    // ----------------------------------------------------------------------
    //
    // Modbus data formats.
    //
    public final static int FMT_UNSIGNED        = 0;
    public final static int FMT_SIGNED          = 1;
    public final static int FMT_FLOAT           = 2;
    //
    // ----------------------------------------------------------------------
    //
    // Led states.
    //
    public final static int LED_RED               = 1;
    public final static int LED_GRN               = 2;
    public final static int LED_OFF               = 3;
    public final static int LED_GRN_BLINK         = 4;
    public final static int LED_RED_BLINK         = 5;
    //
    // ----------------------------------------------------------------------
    //
    // Channel states.
    //
    public final static int CHN_OK                = 0;
    public final static int CHN_ERR_SHORT         = 1;
    public final static int CHN_ERR_OPEN          = 2;
    public final static int CHN_ERR_ALM_LO        = 3;
    public final static int CHN_ERR_ALM_HI        = 4;
    public final static int CHN_ERR_RANGE_LO      = 5;
    public final static int CHN_ERR_RANGE_HI      = 6;
    public final static int CHN_ERR_OVERLOAD      = 7;
    //
    // ----------------------------------------------------------------------
    //
    // System status.
    //
    public final static int SYS_OK                = 0;
    public final static int SYS_ERR_CONFIG        = 1;
    public final static int SYS_ERR_CAL           = 2;
    //
    // ----------------------------------------------------------------------
    //
    // Hand/Off/Auto switch stats.
    //
    public final static int HOA_AUTO              = 0;
    public final static int HOA_OFF               = 1;
    public final static int HOA_HAND              = 2;
    //
    // ----------------------------------------------------------------------
    //
    // Baudrates.
    //
    public final static int B_2400                = 0;
    public final static int B_4800                = 1;
    public final static int B_9600                = 2;
    public final static int B_19200               = 3;
    public final static int B_38400               = 4;
    public final static int B_57600               = 5;
    public final static int B_115200              = 6;
    //
    // ----------------------------------------------------------------------
    //
    // Parity.
    //
    public final static int P_NONE                = 0;
    public final static int P_EVEN                = 1;
    public final static int P_ODD                 = 2;
    //
    // ----------------------------------------------------------------------
    //
    // Programming modes.
    //
    public final static int MODE_ONLINE           = 0;
    public final static int MODE_OFFINE           = 1;
    //
    // ----------------------------------------------------------------------
    //
    // Function Codes for REG_UNIT_FCN and REG_CHN_FCN.
    //
    public final static int FCN_ADD               = 0;
    public final static int FCN_DELETE            = 1;
    public final static int FCN_UP                = 2;
    public final static int FCN_DN                = 3;
    public final static int FCN_COMMIT            = 4;
    //
    // ----------------------------------------------------------------------
    //
    // Register read/write modes.
    //
    public final static int MODE_16               = 0;
    public final static int MODE_STR              = 1;
    //
    // ----------------------------------------------------------------------
    //
    // Command Values for REG_RESTART
    //
    public final static int RESET_MASTER          = 5520; // Master: Reset and wait for new config.
    public final static int RESET_SLAVE           = 7455; // Slaves: Reset and wait for new config.
    public final static int RESTART_MASTER        = 2749; // Master: Restart using new config.
    public final static int RESTART_SLAVE         = 5785; // Slaves: Restart using new config.
    //
    // ----------------------------------------------------------------------
    //
    // Modbus register definitions.
    //
    // ----------------------------------------------------------------------
    //
    public final static int BAS_CHN_QTY           = 8;
    public final static int ANA_CHN_QTY           = 6;
    public final static int MAX_UNIT_QTY          = 8;
    //
    // ----------------------------------------------------------------------
    //
    // Run-time data stored in ram, and updated during the operation
    // of the unit.
    //
    // NOTE: Input and output registers are 32-bit values, and can be
    // read or written in a single operation using 32-bit reads and writes.
    //
    // Using a 16-bit read operation on an input register will return the
    // lower 16 bits of the 32-bit value. The upper 16 bits of the 32-bit
    // value is placed in REG_HIWORD_INP, and can be read immediately
    // thereafter.
    //
    // 32-bit writes using 16-bit operations are performed by writing
    // the upper 16 bits of a 32-bit value to REG_HIWORD_OUT, then writing
    // the lower 16 bits of the 32-bit value to the output register. Any
    // other sequence clears REG_HIWORD_OUT so that 16-bit reads from the
    // output registers return correct values.
    //
    // Status registers contain 3 fields in a 16-bit value:
    //
    // 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
    // |<----->|<----->|<------------->|
    // HOA LED CHN_STATUS
    // [15:12] = HOA switch status: HOA_SWITCH_T.
    // [11:08] = LED status: LED_CTL_T.
    // [07:00] = Channel status: CHN_STATUS_T.
    //
    // ----------------------------------------------------------------------
    //
    // Cooked I/O & status registers.
    public final static int REG_STATUS                  = 1;   // 001-100
    //
    public final static int REG_INP                     = 101; // 101-199
    //
    public final static int REG_OUT                     = 201; // 201-299
    //
    // Raw I/O & control registers.
    public final static int REG_INP_RAW                 = 301; // 301-310
    public final static int REG_OUT_RAW                 = 311; // 311-320
    public final static int REG_LED_RAW                 = 321; // 321-330
    public final static int REG_CTL_RAW                 = 331; // 331-340
    //
    // ----------------------------------------------------------------------
    // Unit control data.
    // ----------------------------------------------------------------------
    //
    // Unit status: 0=ONLINE, 1=OFFLINE.
    // Read requests for this register are answered by the data server
    // itself; they never get to the slave.
    //
    public final static int REG_UNIT_STATUS             = 401; // 1 16-bit register.
    //
    // Firmware revision and hardware type; compiled-in.
    //
    public final static int REG_FIRMWARE_REV            = 402;
    public final static int REG_HARDWARE_TYPE           = 403;
    //
    // Stop/start I/O scanning: 0=STOP, 1=START.
    //
    public final static int REG_SCAN_CONTROL            = 404;
    //
    // CCSI BAS Board restart control:
    //
    // 7455 : Reset and wait for new configuration.
    // 5785 : Begin operation with new configuration.
    // 2479 : Restart server (and attached slaves) with new
    // configuration read from updated xml config file.
    //
    public final static int REG_RESTART                 = 405;
    //
    // Default configuration register.
    //
    // Program default values to eeprom.
    // Must write magic number 2749 for config defaults.
    // Must write magic number 7455 for calibration defaults.
    // Must write magic number 5785 to enable calibration programming.
    //
    public final static int REG_CONFIG_DEFAULT          = 406;
    //
    // --------------------------------------------------------------
    // Unit configuration data.
    //
    // Per-Unit Data.
    // This data group are values that are not channel dependent.
    // They are part of the unit configuration.
    //
    // If REG_NODE_ID is '0', the rack will wait for it's node id
    // and channel configuration data from a master. In this case,
    // baudrate, protocol, parity, and interface mode are ignored.
    // Master units always have a '0' node id. Slave units can have
    // either zero or non-zero node ids.
    //
    // If REG_NODE_ID is not '0', the slave rack will use it's programmed
    // channel configuration data, along with the baudrate, protocol,
    // parity, and interface mode; and will begin operation immediately.
    // --------------------------------------------------------------
    //
    public final static int REG_UNIT_CONFIG             = 500;
    //
    // Unit node address when switch reading is '0'.
    public final static int REG_NODE_ID                 = 501;
    //
    // Setup data for the Modbus RS485 two-wire interface
    // on the upstream port.
    //
    // RS485/422 baudrate: BAUDRATE_T
    public final static int REG_BAUDRATE                = 502;
    // Protocol: PROTOCOL_T
    public final static int REG_PROTOCOL                = 503;
    // Parity: PARITY_T
    public final static int REG_PARITY                  = 504;
    // Timeout value in mS.
    public final static int REG_TIMEOUT                 = 505;
    // RTU Inter-frame delay timer; 1uS/count.
    public final static int REG_IFGAP                   = 506;
    // EEPROM 32 byte page register.
    public final static int REG_EEP_PAGE                = 507;
    // Data registers; 16 regs x 2 bytes each.
    public final static int REG_EEP_DATA                = 508;
    //
    // --------------------------------------------------------------
    // Per-Channel configuration data.
    // This data group are per-channel configuration data.
    // These values can be programmed by the user to tailor the
    // operation of the unit.
    //
    // Each channel has it's own calibration and configuration data.
    // Channels are specified by the 4th and 5th digits (thousands) of the
    // register number.
    //
    // Thus, register 2600 is the REG_CHN_TYPE for channel 2.
    // 
    // 1600 - 86xx
    // --------------------------------------------------------------
    //
    public final static int REG_CHN_CFG                 = 600;
    //
    // First two registers are part of the system configuration, and
    // will not be changed during the normal course of operation. They
    // may only be changed by the configuration program in offline mode.
    //
    // Channel type.
    public final static int REG_CHN_TYPE                = 601;
    // Temperature reporting type (1=farenheit, 0=celcius).
    public final static int REG_TEMP_FARENHEIT          = 602;
    //
    // The following registers may be changed while the unit is online.
    // They all read/write device values, (mV, mA*100, mS, deg*10, etc.).
    //
    // Input filtering (power of 2).
    public final static int REG_INP_FILTER              = 603;
    // Valid low and high levels for inputs (mV, mA*100).
    public final static int REG_INP_LEVEL_LO            = 604;
    public final static int REG_INP_LEVEL_HI            = 605;
    // Accumulation period for pulse inputs (mS).
    public final static int REG_PULSE_PERIOD    = 606;
    public final static int REG_PULSE_PERIOD_MSW        = 607;
    // Temperature offset (deg*10).
    public final static int REG_TEMP_OFFSET             = 608;
    // Initial output value (mV , mA*100).
    public final static int REG_INITIAL_VAL             = 609;
    // Override value (device, 32-bit).
    public final static int REG_OVERRIDE_VAL            = 610;
    public final static int REG_OVERRIDE_VAL_MSW        = 611;
    // Hand/Off/Auto switch status (2/1/0).
    public final static int REG_HOA_SWITCH              = 612;
    // Low and high alarm levels (mV, mA*100).
    public final static int REG_ALARM_LO                = 613;
    public final static int REG_ALARM_HI                = 614;
    //
    //
    // --------------------------------------------------------------
    // Calibration data.
    // --------------------------------------------------------------
    //
    public final static int REG_CHN_CAL                 = 700;
    //
    // Thermistor calibration resistors: ohms x 1.
    //
    public final static int REG_THM_CAL_LO              = 701;
    public final static int REG_THM_CAL_HI              = 702;
    //
    // --------------------------------------------------------------
    // Per-Channel calibration data.
    // This data group are per-channel calibration data.
    // These values are programmed into the unit during factory
    // calibration, and are should not be modified without using
    // factory calibration equipment.
    //
    // 1700 - 87xx
    // --------------------------------------------------------------
    //
    // mV output values at DAC calibration points.
    //
    public final static int REG_OUT_CAL_5V_LO           = 703;
    public final static int REG_OUT_CAL_5V_HI           = 704;
    //
    public final static int REG_OUT_CAL_10V_LO          = 705;
    public final static int REG_OUT_CAL_10V_HI          = 706;
    //
    public final static int REG_OUT_CAL_20V_LO          = 707;
    public final static int REG_OUT_CAL_20V_HI          = 708;
    //
    // ADC readings at DAC calibration points.
    //
    public final static int REG_INP_CAL_5V_LO           = 709;
    public final static int REG_INP_CAL_5V_HI           = 710;
    //
    public final static int REG_INP_CAL_10V_LO          = 711;
    public final static int REG_INP_CAL_10V_HI          = 712;
    //
    public final static int REG_INP_CAL_20V_LO          = 713;
    public final static int REG_INP_CAL_20V_HI          = 714;
    //
    // mA output values at DAC calibration points.
    //
    public final static int REG_OUT_CAL_MA_LO           = 715;
    public final static int REG_OUT_CAL_MA_HI           = 716;
    //
    // ADC readings at DAC calibration points.
    //
    public final static int REG_INP_CAL_MA_LO           = 717;
    public final static int REG_INP_CAL_MA_HI           = 718;
    //
    // ADC readings for thermistor calibration resistors.
    //
    public final static int REG_INP_CAL_THM_LO          = 719;
    public final static int REG_INP_CAL_THM_HI          = 720;
    //
    // Write anything to update calibration checksum.
    //
    public final static int REG_CAL_CHECKSUM            = 721;
    //
    // --------------------------------------------------------------
    // --------------------------------------------------------------
    // System configuration data.
    // From here down, the registers apply only to the data server.
    // These registers are ignored by the base boards.
    //
    // ALL TRANSACTIONS ARE DONE WITH STRING FUNCTIONS.
    // --------------------------------------------------------------
    // --------------------------------------------------------------
    //
    public final static int REG_SYS_CFG                 = 800;
    //
    // Must be OFFLINE to modify the configuration.
    //
    // REG_SYS_OFFLINE reads '1' if you are working with the OFFLINE version
    // of the configuration, and are able to perform write operations.
    // REG_SYS_OFFLINE reads '0' if you are working with the ONLINE version
    // of the configuraion, and are only able to perform read operations.
    //
    // A process writes '1' to this register to request ownership of the
    // configuration. If successful, the same process can read this
    // register back as '1'. All other processes will read this register
    // as '0', and will be unable to write.
    //
    // When edits are finished, the process with ownership of the
    // configuration should commit changes, then write '0' to
    // REG_SYS_OFFLINE, releasing the configuration for other processes.
    //
    // If the process with ownership of the configuration terminates
    // without releasing the configuration, a timeout value will be used
    // to release ownership and abandon edits after a specified period
    // of time with no activity.
    //
    public final static int REG_SYS_OFFLINE             = 801; // (R/W)
    // SYS_PROGMODE_T.
    //
    public final static int REG_SYS_FCN                 = 802; // Commit only.
    //
    // Name string for System:
    //
    public final static int REG_SYS_NAME                = 803;
    //
    // Bacnet system parameters.
    //
    public final static int REG_SYS_BAC_INSTANCE        = 804;
    public final static int REG_SYS_BAC_UDP_PORT        = 805;
    public final static int REG_SYS_BAC_BBMD_IP         = 806;
    public final static int REG_SYS_BAC_TTL             = 807;
    //
    // Network parameters.
    //
    public final static int REG_SYS_BOOT_PROTOCOL       = 808; // NONE, or DHCP.
    public final static int REG_SYS_IPADDR              = 809;
    public final static int REG_SYS_NETMASK             = 810;
    public final static int REG_SYS_GATEWAY             = 811;
    public final static int REG_SYS_DNS1                = 812;
    public final static int REG_SYS_DNS2                = 813;
    //
    // Serial interface configuration for attached Modbus compatible devices.
    // Also used if unit is configured as Modbus device.
    //
    public final static int REG_SYS_BAUDRATE            = 814; // BAUDRATE_T.
    public final static int REG_SYS_PROTOCOL            = 815; // PROTOCOL_T.
    public final static int REG_SYS_PARITY              = 816; // PARITY_T.
    public final static int REG_SYS_TIMEOUT             = 817; // PARITY_T.
    public final static int REG_SYS_IFGAP               = 818; // ~1uS/cnt.
    //
    // Polling rates.
    //
    public final static int REG_SYS_POLL_BAS            = 819;
    public final static int REG_SYS_POLL_MCD            = 820;
    public final static int REG_SYS_POLL_OFFLINE        = 821;
    public final static int REG_SYS_READ_DELAY          = 822;
    public final static int REG_SYS_READ_MAX            = 823;

    // BACnet System Parameter for Gateway
    public final static int REG_SYS_BAC_IP_NETWORK      = 824;
    public final static int REG_SYS_BAC_MSTP_NETWORK    = 825;

    // MODBUS Address
    public final static int REG_SYS_MOD_ADDR            = 826;

    //
    // TEMPLATE FILES
    public final static int TEMPLATE_QTY               	= 827; // String.
    public final static int TEMPLATE_INDEX          	= 828; // String.
    public final static int TEMPLATE_FILE_NAME          = 829; // String.
    public final static int TEMPLATE_FILE_TYPE          = 830; // String.

    //
    // Slave unit configuration.
    // Units (up to MAX_UNIT_QTY) indexed via REG_UNIT_IDX.
    // Channels and/or registers are indexed via REG_CHN_IDX.
    //
    // Slave CCSI units are added, deleted, and moved up/dn in the daisy
    // chain via the REG_UNIT_FCN register.
    //
    // REG_UNIT_QTY will be at least '1', because we will always have
    // a base board. And it can't be deleted.
    //
    public final static int REG_UNIT_FCN                = 831; // Add or delete.
    public final static int REG_UNIT_FCN_PARM           = 832; // Optional parameter for function call.
    //
    public final static int REG_UNIT_QTY                = 833; // (R/O) Number of attached units.
    public final static int REG_UNIT_IDX                = 834;
    //
    public final static int REG_UNIT_NAME               = 835; // String.
    public final static int REG_UNIT_TYPE               = 836; // HDWE_TYPE_T.
    public final static int REG_UNIT_ADDR               = 837;
    public final static int REG_UNIT_POLL_DELAY         = 838;
    public final static int REG_UNIT_OFFLINE            = 839; // 1=offline, 0=online.
    public final static int REG_UNIT_INSTANCE           = 840;
    public final static int REG_UNIT_MOD_TYPE           = 841; 
    public final static int REG_UNIT_FILENAME         	= 842;

    public final static int REG_OBJ_QTY                	= 843; // Number of objects
    public final static int REG_UNIT_READ_MAX    		= 844; // Max registers in a group reading
    //
    // Channel configuration.
    //
    // Note that adding, deleting, and moving registers is only
    // applicable to Modbus Compatible Devices, which have a variable
    // number of registers.
    //
    // CCSI Units have a known, fixed, number of channels. Channel
    // configuration may change, but the position and number don't.
    //
    public final static int REG_CHN_FCN                 = 845; // Add or delete.
    public final static int REG_CHN_FCN_PARM            = 846; // Optional parameter for function.
    //
    public final static int REG_CHN_QTY                 = 847; // (R/O) Number of channels in unit.
    public final static int REG_CHN_IDX                 = 848;
    //
    public final static int REG_CHN_NAME                = 849;
    public final static int REG_CHN_BAS_TYPE            = 850;
    public final static int REG_CHN_TEMP_UNITS          = 851;
    //
    // BacNet and scaling configuration data.
    //
    public final static int REG_CHN_INSTANCE            = 852; // BACnet object instance.
    public final static int REG_CHN_BAC_TYPE            = 853;
    public final static int REG_CHN_BAC_UNITS           = 854;
    public final static int REG_CHN_BAC_COV_PCT         = 855;
    public final static int REG_CHN_BAC_DESC            = 856;
    public final static int REG_CHN_SCL_DEV_LO          = 857;
    public final static int REG_CHN_SCL_DEV_HI          = 858;
    public final static int REG_CHN_SCL_USR_LO          = 859;
    public final static int REG_CHN_SCL_USR_HI          = 860;
    //
    // Modbus channel configuration data.
    //
    public final static int REG_MOD_GROUP_EN            = 861;
    public final static int REG_MOD_REG_NUM             = 862;
    public final static int REG_MOD_REG_QTY             = 863;
    public final static int REG_MOD_ENDIAN              = 864;
    public final static int REG_MOD_FORMAT              = 865;
    public final static int REG_MOD_FCN                 = 866;
    //
    // "Online Data Registers"
    //
    public final static int REG_CHN_INP_FILTER          = 867;
    public final static int REG_CHN_INP_LEVEL_LO        = 868;
    public final static int REG_CHN_INP_LEVEL_HI        = 869;
    public final static int REG_CHN_PULSE_PERIOD        = 870;
    public final static int REG_CHN_TEMP_OFFSET         = 871;
    public final static int REG_CHN_INIT_VAL            = 872;
    public final static int REG_CHN_OVERRIDE_VAL        = 873;
    public final static int REG_CHN_HOA_SWITCH          = 874;
    public final static int REG_CHN_ALARM_LO            = 875;
    public final static int REG_CHN_ALARM_HI            = 876;
    //
    public final static int REG_CHN_LIMIT_LO            = 877;
    public final static int REG_CHN_LIMIT_HI            = 878;
    //
    public final static int REG_CHN_PERSISTENT          = 879;
    //
    public final static int REG_CHN_ENABLE          	= 880;
    //
    // Nothing past here.
    //
    public final static int REG_END                     = 881;

    //

    /** Creates a new instance of bas_def */
    public bas_def()
    {
    }

}
