package ConfigUnit;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class writeFlagFile 
{
	public static FTPClient getFtpClient(String ip , String user , String password)
    {
		int reply;
		FTPClient ftp = new FTPClient();

		try
		{
			// Connect to target.
			ftp.connect(ip);

			// After connection attempt, you should check the reply code to
			// verify success.
			reply = ftp.getReplyCode();
			if (!FTPReply.isPositiveCompletion(reply))
			{
				ftp.disconnect();
				System.err.println("FTP server refused connection.");
				ftp = null;
			}
			else
			{
				// Log in.
				ftp.login(user, password);
			}
		} catch (IOException e)
		{
			ftp = null;
			e.printStackTrace();
		}
		// Failure if we get here.
		return ftp;
    }

    public static int writeResetFlagFile( String ip , String user , String password )
	{
		FTPClient 			ftp;
		String				dst = "/tmp/rebootFlag";
		OutputStream		os = null;
		boolean				error = false;
    	
		ftp = getFtpClient(ip, user, password);
    	// If successful.
    	if (ftp != null)
    	{
    		try
    		{
    			// Get output stream
    			os = ftp.storeFileStream(dst);
    			if(os!= null)
    			{
        			os.close();
    			}
    			else
    				error = true;
    		} 
    		catch (IOException e)
    		{
    			error = true;
    			e.printStackTrace();
    		}
    		finally
    		{
    			if (ftp.isConnected())
    			{
    				try
    				{
    					ftp.logout();
    					ftp.disconnect();
    				} 
    				catch (IOException ioe)
    				{
    					error = true;
    				}
    			}
    			ftp = null;
    		}
    	}
    	else
    		error = true;
    	
    	if(error == true)
    		return -1;
    	
    	return 0;
	}

}
