package bacnet;

import javax.swing.JComboBox;

/**
 * @author rcw
 *
 */
public class bac
{
    public class def
    {
        //
        // Numeric values for BACnet properties supported by ReadObj()
        // and WriteObj().
        //
        public final static int COV_INCREMENT       = 22;
        public final static int DESCRIPTION         = 28;
        public final static int HIGH_LIMIT          = 45;
        public final static int LOW_LIMIT           = 59;
        public final static int MAX_PRES_VALUE      = 65;
        public final static int MIN_PRES_VALUE      = 69;
        public final static int OBJECT_IDENTIFIER   = 75;
        public final static int OBJECT_NAME         = 77;
        public final static int OBJECT_TYPE         = 79;
        public final static int OUT_OF_SERVICE      = 81;
        public final static int PRESENT_VALUE       = 85;
        public final static int RELIABILITY         = 103;
        public final static int RELINQUISH_DEFAULT  = 104;
        public final static int STATUS_FLAGS        = 111;
        public final static int UNITSX              = 117;
        public final static int BAC_OBJ_QTY 		= 0xff00;
        public final static int BAC_SYS_NAME		= 0xff01;
        public final static int BAC_DEV_INSTANCE	= 0xff02;
        public final static int BAC_UDP_PORT		= 0xff03;
        public final static int BAC_BBMD_IP         = 0xff04;
        public final static int BAC_TTL             = 0xff05;
        public final static int BAC_OBJ_INDEX       = 0xff06;
        public final static int BAC_MOD_DEV_FILENAME= 0xff07;
        public final static int BAC_MOD_DEV_INSTANCE= 0xff07;
        public final static int SYS_RESTART_SEDONA	= 0xff08;
        public final static int SYS_DATE			= 0xff09;
        public final static int BAC_MOD_NETWORK		= 0xff0a;
        public final static int BAC_BIP_NETWORK		= 0xff0b;
        public final static int BAC_UNIT_QTY		= 0xff0c;
        public final static int BAC_MOD_DEV_MAC		= 0xff0d;
        public final static int BAC_MOD_DEV_NAME	= 0xff0e;
        public final static int BAC_MOD_TYPE		= 0xff0f;
        //
        // Numeric values for various object types.
        //
        public final static int ANALOG_INPUT        = 0;
        public final static int ANALOG_OUTPUT       = 1;
        public final static int ANALOG_VALUE        = 2;
        public final static int BINARY_INPUT        = 3;
        public final static int BINARY_OUTPUT       = 4;
        public final static int BINARY_VALUE        = 5;
        public final static int CALENDAR            = 6;
        public final static int COMMAND             = 7;
        public final static int DEVICE              = 8;
        public final static int EVENT_ENROLLMENT    = 9;
        public final static int FILE_0              = 10;
        public final static int GROUP               = 11;
        public final static int LOOP                = 12;
        public final static int MULTI_STATE_INPUT   = 13;
        public final static int MULTI_STATE_OUTPUT  = 14;
        public final static int NOTIFICATION_CLASS  = 15;
        public final static int PROGRAM             = 16;
        public final static int SCHEDULE            = 17;
    }

    /**
     * BACnet properties.
     * 
     * @author rcw
     *
     */
    public enum prop
    {
        PRESENT_VALUE           ("Present Value",           def.PRESENT_VALUE),
        DESCRIPTION             ("Description",             def.DESCRIPTION),
        OBJECT_NAME             ("Object Name",             def.OBJECT_NAME),
        //OBJECT_TYPE             ("Object Type",             def.OBJECT_TYPE),
        COV_INCREMENT           ("COV Increment",           def.COV_INCREMENT),
        //HIGH_LIMIT              ("High Limit",              def.HIGH_LIMIT),
        //LOW_LIMIT               ("Low Limit",               def.LOW_LIMIT),
        //MAX_PRES_VALUE          ("Max Present Value",       def.MAX_PRES_VALUE),
        //MIN_PRES_VALUE          ("Min Present Value",       def.MIN_PRES_VALUE),
        OUT_OF_SERVICE          ("Out of Service",          def.OUT_OF_SERVICE),
        //RELIABILITY             ("Reliability",             def.RELIABILITY),
        RELINQUISH_DEFAULT      ("Relinquish Default",      def.RELINQUISH_DEFAULT),
        STATUS_FLAGS            ("Status Flags",            def.STATUS_FLAGS),
        UNITSX                  ("Units",                   def.UNITSX),
        //OBJECT_IDENTIFIER       ("Object Identifier",       def.OBJECT_IDENTIFIER),
        //BAC_OBJ_QTY             ("Sys:Object Quantity",     def.BAC_OBJ_QTY),
        //BAC_SYS_NAME            ("Sys:System Name",         def.BAC_SYS_NAME),
        //BAC_DEV_INSTANCE        ("Sys:Device Instance",     def.BAC_DEV_INSTANCE),
        //BAC_UDP_PORT            ("Sys:UDP Port",            def.BAC_UDP_PORT),
        //BAC_BBMD_IP             ("Sys:BBMD IP Address",     def.BAC_BBMD_IP),
        //BAC_TTL                 ("Sys:Time to Live",        def.BAC_TTL),
        //BAC_OBJ_INDEX           ("Sys:Object Instance",     def.BAC_OBJ_INDEX),   
        ;

        private String      enum_txt;
        private int         enum_val;
        
        prop( String txt , int val )
        {
            enum_txt = txt;
            enum_val = val;
        }

        /**
         * @return Enumerated value of BACnet property.
         */
        public int getEnum(){return enum_val;}
        
        /**
         * Overrides java.lang.Enum#toString() to provide
         * user-friendly text.
         */
        public String toString(){return enum_txt;}
    }
    
    /**
     * Subset of BACnet I/O types supported by the BAS Remote.
     * Intended to be loaded into a combo box for channel type selection.
     * 
     * @author rcw
     */
    public enum type
    {
        ANALOG_INPUT        ("Analog Input",    def.ANALOG_INPUT),
        ANALOG_OUTPUT       ("Analog Output",   def.ANALOG_OUTPUT),
        ANALOG_VALUE        ("Analog Value",    def.ANALOG_VALUE),
        BINARY_INPUT        ("Binary Input",    def.BINARY_INPUT),
        BINARY_OUTPUT       ("Binary Output",   def.BINARY_OUTPUT),
        //BINARY_VALUE        ("Binary Value",    def.BINARY_VALUE),
        ;
        
        private String    enum_txt;
        private int       enum_val;
        
        type( String txt , int val )
        {
            enum_txt = txt;
            enum_val = val;
        }

        public int getEnum(){return enum_val;}
        
        public static type getType( int eval )
        {
            for ( type t : type.values() )
            {
                if ( t.getEnum() == eval )
                    return t;
            }
            return null;
        }
        
        /**
         * Fills a combo box with group objects and sets the
         * selected index per the string from the configuration
         * file.<p>
         * Called when box is first initialized from config file.
         * 
         * @param b = combo box to be filled
         * @param s = string from configuration file
         */
        public static void fillComboBox(JComboBox b , String s)
        {
            b.removeAllItems();
            for (type t : type.values())
            {
                b.addItem(t);
            }
            b.setSelectedIndex(type.valueOf(s).ordinal());
        }

        /**
         * Overrides java.lang.Enum#toString() to provide
         * user-friendly text.
         */
        public String toString(){return enum_txt;}
    }
    
    public enum unit
    {
        //Area
        SQUARE_METERS                       ("SqM"),        // 0
        SQUARE_FEET                         ("SqF"),        // 1
        //Electrical
        MILLIAMPERES                        ("mA"),         // 2
        AMPERES                             ("A"),          // 3
        OHMS                                ("Ohms"),       // 4
        VOLTS                               ("Volts"),      // 5
        KILOVOLTS                           ("KV"),         // 6
        MEGAVOLTS                           ("MV"),         // 7
        VOLT_AMPERES                        ("VA"),         // 8
        KILOVOLT_AMPERES                    ("KVA"),        // 9
        MEGAVOLT_AMPERES                    ("MVA"),        //10
        VOLT_AMPERES_REACTIVE               ("VAR"),        //11
        KILOVOLT_AMPERES_REACTIVE           ("KVAR"),       //12
        MEGAVOLT_AMPERES_REACTIVE           ("MVAR"),       //13
        DEGREES_PHASE                       ("Deg Ph"),     //14
        POWER_FACTOR                        ("PF"),         //15
        //Energy
        JOULES                              ("J"),          //16
        KILOJOULES                          ("KJ"),         //17
        WATT_HOURS                          ("WH"),         //18
        KILOWATT_HOURS                      ("KWH"),        //19
        BTU                                 ("BTU"),        //20
        THERM                               ("THERM"),      //21
        TON_HOR                             ("T_HOR"),      //22
        //Enthalpy
        JOULES_PER_KILOGRAM_DRY_AIR         ("J/KgDA"),     //23
        BTU_PER_POUND_DRY_AIR               ("BTU/LbDA"),   //24
        //Frecuency
        CYCLES_PER_HOUR                     ("CPH"),        //25
        CYCLES_PER_MINUTE                   ("CPM"),        //26
        HERTZ                               ("HZ"),         //27
        //Humidity
        GRAMS_OF_WATER_PER_KILOGRAM_DRY_AIR ("gW/KgDA"),    //28
        PERCENT_RELATIVE_HUMIDITY           ("%RH"),        //29
        //Length
        MILLIMETER                          ("mm"),         //30
        METERS                              ("m"),          //31
        INCH                                ("in"),         //32
        FEET                                ("ft"),         //33
        //Light
        WATTS_PER_SQUARE_FOOT               ("W/SqF"),      //34
        WATTS_PER_SQUARE_METER              ("W/SqM"),      //35
        LUMEN                               ("LUMEN"),      //36
        LUX                                 ("LUX"),        //37
        FOOT_CANDLES                        ("FtCdl"),      //38
        //Mass
        KILOGRAMS                           ("Kg"),         //39
        POUNDS_MASS                         ("Lbm"),        //40
        TONS                                ("TONS"),       //41
        //Mass Flow
        KILOGRAMS_PER_SECOND                ("Kg/sec"),     //42
        KILOGRAMS_PER_MINUTE                ("Kg/min"),     //43
        KILOGRAMS_PER_HOUR                  ("Kg/hr"),      //44
        POUNDS_MASS_PER_MINUTE              ("Lbm/min"),    //45
        POUNDS_MASS_PER_HOUR                ("Lbm/hr"),     //46
        //Power
        WATTS                               ("W"),          //47
        KILOWATTS                           ("KW"),         //48
        MEGAWATTS                           ("MW"),         //49
        BTU_PER_HOUR                        ("BTU/hr"),     //50
        HORSEPOWER                          ("HP"),         //51
        TONS_REFRIGERATIONS                 ("Tons R"),     //52
        //Pressure
        PASCALS                             ("Ps"),         //53
        KILOPASCAL                          ("KPs"),        //54
        BAR                                 ("BAR"),        //55
        POUNDS_FORCE_PER_SQUARE_INCH        ("Lb/SqIn"),    //56
        CENTIMETERS_OF_WATER                ("cmH2O"),      //57
        INCHES_OF_WATER                     ("inH20"),      //58
        MILLIMETERS_OF_MERCURY              ("mmHg"),       //59
        CENTIMETERS_OF_MERCURY              ("cmHg"),       //60
        INCHES_OF_MERCURY                   ("inHg"),       //61
        //Temperature
        DEGREES_CELSIUS                     ("DegC"),       //62
        DEGREES_KELVIN                      ("DegK"),       //63
        DEGREES_FAHRENHEIT                  ("DegF"),       //64
        DEGREE_DAYS_CELSIUS                 ("DegDC"),      //65
        DEGREE_DAYS_FAHRENHEIT              ("DegDF"),      //66
        //Time
        YEAR                                ("yr"),         //67
        MONTH                               ("mo"),         //68
        WEEK                                ("wk"),         //69
        DAY                                 ("d"),          //70
        HOUR                                ("hr"),         //71
        MINUTE                              ("min"),        //72
        SECOND                              ("sec"),        //73
        //Velocity
        METERS_PER_SECOND                   ("M/sec"),      //74
        KILOMETERS_PER_HOUR                 ("KM/hr"),      //75
        FEET_PER_SECOND                     ("Ft/sec"),     //76
        FEET_PER_MINUTE                     ("Ft/min"),     //77
        MILES_PER_HOUR                      ("MPH"),        //78
        //Volume
        CUBIC_FEET                          ("cuFt"),       //79
        CUBIC_METERS                        ("cuM"),        //80
        IMPERIAL_GALLONS                    ("IMGal"),      //81
        LITERS                              ("L"),          //82
        US_GALLONS                          ("USGal"),      //83
        //Volumetric Flow
        CUBIC_FEET_PER_MINUTE               ("CuFt/min"),   //84
        CUBIC_METERS_PER_SECOND             ("CuM/sec"),    //85
        IMPERIAL_GALLONS_PER_MINUTE         ("IMGal/min"),  //86
        LITERS_PER_SECOND                   ("L/sec"),      //87
        LITERS_PER_MINUTE                   ("L/min"),      //88
        US_GALLONS_PER_MINUTE               ("USGal/min"),  //89
        //Others
        DEGREES_ANGULAR                     ("Deg"),        // 90
        DEGREES_CELSIUS_PER_HOUR            ("DegC/hr"),    // 91
        DEGREES_CELSIUS_PER_MINUTE          ("DegC/min"),   // 92
        DEGREES_FAHRENHEIT_PER_HOUR         ("DegF/hr"),    // 93
        DEGREES_FAHRENHEIT_PER_MINUTE       ("DegF/min"),   // 94
        NO_UNITS                            ("NO_UNITS"),   // 95
        PARTS_PER_MILLION                   ("ppm"),        // 96
        PARTS_PER_BILLION                   ("ppb"),        // 97
        PERCENT                             ("%"),          // 98
        PERCENT_PER_SECOND                  ("%/sec"),      // 99
        PER_MINUTE                          ("/min"),       //100
        PER_SECOND                          ("/sec"),       //101
        PSI_PER_DEGREE_FAHRENHEIT           ("PSI/DegF"),   //102
        RADIANS                             ("RAD"),        //103
        REVOLUTIONS_PER_MINUTE              ("RPM"),        //104
        //
        INVALID                             ("Invalid"),    // Invalid.
        ;
        
        private String      enum_txt;
        
        unit( String val )
        {
            enum_txt = val;
        }
        
        public static int getEnum(String s)
        {
            unit    u = unit.valueOf(s);
            
            if (u != null)
                return unit.valueOf(s).ordinal();
            else
                return INVALID.ordinal();
        }
        
        public int getEnum(){return ordinal();}
        
        public String getTxt() {return enum_txt;}
    }
    
    public enum group
    {
        AREA                ("Area",             0, 2),
        ELECTRICAL          ("Electrical",       2,14),
        ENERGY              ("Energy",          16, 7),
        ENTHALPY            ("Enthalpy",        23, 2),
        FREQUENCY           ("Frequency",       25, 3),
        HUMIDITY            ("Humidity",        28, 2),
        LENGTH              ("Length",          30, 4),
        LIGHT               ("Light",           34, 5),
        MASS                ("Mass",            39, 3),
        MASS_FLOW           ("Mass Flow",       42, 5),
        POWER               ("Power",           47, 6),
        PRESSURE            ("Pressure",        53, 9),
        TEMPERATURE         ("Temperature",     62, 5),
        TIME                ("Time",            67, 7),
        VELOCITY            ("Velocity",        74, 5),
        VOLUME              ("Volume",          79, 5),
        VOLUMETRIC_FLOW     ("Volumetric Flow", 84, 6),
        OTHERS              ("Others",          90,16),
        ;
        
        private String      enum_txt;
        private int         index , qty;
        
        group( String val , int i , int q )
        {
            enum_txt = val;
            index = i;
            qty = q;
        }
        
        /**
         * @return Enumerated value.
         */
        public int getEnum() {return ordinal();}
        
        /**
         * @return Text associated with unit group.
         */
        public String getTxt() {return enum_txt;}
        
        /**
         * @return Starting index of group within unit enums.
         */
        public int getIndex()  {return index;}
        
        /**
         * @return Number of unit enums in group.
         */
        public int getQty()    {return qty;}
        
        public static group getGroup(int unit_val)
        {
            group       retval = AREA;
            
            // Find group.
            for ( group g : group.values() )
            {
                if ( (g.index + g.qty) >= unit_val)
                {
                    retval = g;
                    break;
                }
            }
            // And return.
            return retval;
        }
        
        /**
         * Overrides java.lang.Enum#toString() to provide
         * user-friendly text.
         */
        public String toString()    {return enum_txt;}       
    }
    
    public enum devtype
    {
        //Area
    	BAS_STAT		("BASstat"),							// 0
        UK24MOD			("Belimo UK24MOD"),        				// 1
        CVM_NRG96		("Circutor CVM-NRG96"), 				// 2
        S7810M			("Honeywell S7810M"),					// 3
        Cube_350		("Northern Design Cube 350"), 			// 4
        FIOD_1600		("Renu Electronics FIOD 1600"),			// 5
        FIOD_0008		("Renu Electronics FIOD 0008"),         // 6
        FIOD_0808    	("Renu Electronics FIOD 0808"),         // 7
        Power_Logic_800	("Schneider Electric Power Logic 800"),	// 8
        H8035      		("Veris H8035/8036"),        			// 9
        WNC_3Y_208_MB  	("Wattnode WNC-3Y-208-MB"),        		//10
        WNC_3Y_400_MB 	("Wattnode WNC-3Y-400-MB"),        		//11
        WNC_3Y_480_MB  	("Wattnode WNC-3Y-480-MB"),       		//12
        WNC_3Y_600_MB  	("Wattnode WNC-3Y-600-MB"),       		//13
        WNC_3D_240_MB   ("Wattnode WNC-3D-240-MB"),     		//14
        WNC_3D_400_MB   ("Wattnode WNC-3D-400-MB"),        	 	//15
        ;
        
        private String      enum_txt;
        
        devtype( String val )
        {
            enum_txt = val;
        }
        
        public static int getEnum(String s)
        {
            devtype    u = devtype.valueOf(s);
            
            if (u != null)
                return devtype.valueOf(s).ordinal();
            return 0;
        }
        
        public int getEnum(){return ordinal();}
        
        public String getTxt() {return enum_txt;}
    }

    /**
     * Class that holds BACnet units value and two
     * combo box indexes.
     */
    public static class cbx_idx_t
    {
        public int      units;          // BACnet units.
        public int      grp_idx;        // Group combo box index.
        public int      unit_idx;       // Unit combo box index.
    }
    
    /**
     * Returns the combo box indexes associated
     * with the BACnet units value.
     * 
     * @param cbx holds BACnet units and two combo box index values.
     * @return 0 if success, -1 if units value is out of range.
     */
    public static int UnitsToCbx( cbx_idx_t cbx )
    {
        group   last_group = group.AREA;
        
        // Return if units out of range.
        if ( cbx.units >= unit.values().length )
            return -1;
        // Find group.
        for ( group g : group.values() )
        {
            if ( g.getIndex() > cbx.units )
                break;
            last_group = g;
        }
        cbx.grp_idx = last_group.ordinal();
        // Assign unit index.
        cbx.unit_idx = cbx.units - last_group.getIndex();
        // And return.
        return 0;
    }
    
    /**
     * Returns the BACnet unit value associated with
     * the combo box indexes.
     * 
     * @param cbx holds BACnet units and two combo box index values.
     * @return 0 if success, -1 if either index is out of range.
     */
    public static int CbxToUnits( cbx_idx_t cbx )
    {
        // If group index out of range.
        if ( cbx.grp_idx >= group.values().length )
            return 0;
        // Compute unit value.
        cbx.units = group.values()[cbx.grp_idx].getIndex() + cbx.unit_idx;
        // If unit value is out of range.
        if ( cbx.units >= unit.values().length )
            return -1;
        // And return.
        return 0;
    }
    
    /**
     * Given the string value of units from the configuration file,
     * this function sets the selected index within a pre-configured
     * group combo box, then fills a units combo box with unit objects
     * and sets the selected index for the unit combo box.<p>
     * Called when the channel data is reloaded.
     *
     * @param groupBox = initialized group combo box
     * @param unitBox = units combo box to be filled
     * @param s = string value of units from config file
     */
    public static void fillComboBox(JComboBox groupBox , JComboBox unitBox , String s)
    {
        int     i , unit_val , unit_idx;
        
        // Get unit value of string.
        unit_val = unit.getEnum(s);
        // Get group associated with unit value.
        group g = group.getGroup(unit_val);
        // Set selected group.
        groupBox.setSelectedIndex(g.ordinal());
        // Get array of units.
        unit[] unit_list = unit.values();
        // Clear unit combo box.
        unitBox.removeAllItems();
        // Fill unit combo box.
        for (i = 0 ; i < g.qty ; ++i)
        {
            unitBox.addItem(unit_list[g.index + i]);
        }
        // Get unit index within group.
        unit_idx = unit_val - g.index;
        // Set selected unit.
        unitBox.setSelectedIndex(unit_idx);
    }
    
    /**
     * Given the integer value of units from the configuration file,
     * this function sets the selected index within a pre-configured
     * group combo box, then fills a units combo box with unit objects
     * and sets the selected index for the unit combo box.<p>
     * Called when the channel data is reloaded.
     *
     * @param groupBox = initialized group combo box
     * @param unitBox = units combo box to be filled
     * @param unit_val = integer value of units
     */
    public static void fillComboBox(JComboBox groupBox , JComboBox unitBox , int unit_val)
    {
        unit            u;
        
        // Get unit.
        unit[] unit_list = unit.values();
        // Sanity check.
        if (unit_val >= unit_list.length)
            u = unit.INVALID;
        else
            u = unit_list[unit_val];
        // Use previous function.
        fillComboBox(groupBox,unitBox,u.name());
    }
    
    /**
     * Fills the unit combo box with objects from the selected group
     * in the group combo box. It sets the selected index of the
     * unit combo box to 0.<p>
     * Called when the group combo box selection changes.
     *  
     * @param groupBox = combo box with selected group.
     * @param unitBox = units combo box to be filled.
     */
    public static void fillComboBox(JComboBox groupBox , JComboBox unitBox)
    {
        int         i;
        
        // Get array of units.
        unit[] unit_list = unit.values();
        // Get selected group.
        group g = (group)groupBox.getSelectedItem();
        // Clear unit combo box.
        unitBox.removeAllItems();
        // Fill unit combo box.
        for (i = 0 ; i < g.qty ; ++i)
        {
            unitBox.addItem(unit_list[g.index + i]);
        }
        // Set default selected unit.
        unitBox.setSelectedIndex(0);
    }
}
