package ModbusMapping;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Timer;
import java.util.TimerTask;

import javax.swing.DefaultListModel;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingWorker;
import javax.swing.border.TitledBorder;

import java.io.IOException;
import modbus.*;
import bacnet.bac;
import bas_remote.*;

public class ModbusMappingApplet extends JApplet
{

    private JTextField EbxModAddr;
    private JComboBox CbxDevInstance;
    /**
	 * 
	 */
    private static final long serialVersionUID   = 1L;
    private JList             overallStatusList;
    private JLabel            errorLabel;
    private DefaultListModel  listModel;

    /**
     * Member variables.
     */
    private String            hostAddress;
    static boolean            dbug_on            = false;
    static String             dbug_ip            = "192.168.92.68";
    static int                dbug_unit          = 1;
    private mod.device        comBas             = new mod.device();
    //    
    Timer                     err_tmr;
    TimerTask                 err_tmr_task;
    int                       err_tmr_cnt;
    int 					  dev_index	 	 	 = 0;
    int						  dev_qty			 = 0;
    //
    private boolean           applet_running     = true;
    private ConnectTask       connect_task       = new ConnectTask();

    private final JPanel      PnlStatus          = new JPanel();
    private final JComboBox   CbxInstance        = new JComboBox();
    private final JComboBox   CbxProperty        = new JComboBox();
    private final JTextField  EbxPropVal         = new JTextField();
    private final JLabel      propertyValueLabel = new JLabel();
    private final JScrollPane ScpStatus          = new JScrollPane();

    /**
     * Object data used in combo box for instance selection.
     */
    private class obj_data
    {
        String		instance;
        bac.type	type;
        String		name;
        String		description;

        public String toString()
        {
        	String		i , t = null;
        	
        	switch (type)
        	{
        		case ANALOG_INPUT:
        			t = "AI";
        			break;
        		case ANALOG_OUTPUT:
        			t = "AO";
        			break;
        		case ANALOG_VALUE:
        			t = "AV";
        			break;
        		case BINARY_INPUT:
        			t = "BI";
        			break;
        		case BINARY_OUTPUT:
        			t = "BO";
        			break;
        	}
        	i = "        " + instance;
        	i = i.substring(i.length() - 7);
            return i + " : " + t + " : " + name;
        }
    }

    /**
     * Unit data used in listModel for displaying
     * online/offline unit status.
     */
    private class unit_data
    {
        String  address;
        boolean online;
        int		devInst;
        
        public String toString()
        {
            if (online)
                return "Address " + address + "  Dev Instance " + devInst + " Online";
            else
                return "Address " + address + "  Dev Instance " + devInst + " Offline";
        }
    }

    class ListItem
    {
    	private Color 		color;
    	private unit_data	value;
    	
    	public ListItem(Color c, unit_data s)
    	{
    		color = c;
    		value = s;
    	}
    	
    	public Color getColor()
    	{
    		return color;
    	}
    	
    	public unit_data getData()
    	{
    		return value;
    	}
    }

    public class MyCellRenderer extends JLabel implements ListCellRenderer
    {

    	/**
    	 * 
    	 */
    	private static final long serialVersionUID = 1L;

    	public MyCellRenderer ()
    	{
    		// don't paint behind the component
    		setOpaque(true);
    	}

    	// value: value to display
    	// index: cell index
    	// iss: is selected
    	// chf: cell has focus?
    	public Component getListCellRendererComponent(JList list, Object value,
    			int index, boolean iss, boolean chf) 
    	{
    		// set the text and background color for rendering
    		setText(((ListItem)value).getData().toString());
    		setForeground(((ListItem)value).getColor());
			setBackground(Color.WHITE);
    		
			/*
    		// set a border if the list item is selected
    		if(iss)
    		{
    			setBorder(BorderFactory.createLineBorder(Color.blue, 2));
    		}
    		else
    		{
    			setBorder(BorderFactory.createLineBorder(list.getBackground(), 2));
    		}
    		*/
    		return this;
    	}

    }

    /**
     * Create the applet
     */
    public ModbusMappingApplet()
    {
        super();
        getContentPane().setLayout(null);
        //
        initComponents();
    }

    public void init()
    {
        // Get code base string.
        hostAddress = this.getCodeBase().toString().toLowerCase();
        // If forcing the address.
        if (dbug_on == true)
            hostAddress = dbug_ip;
        // Else if executing from local machine.
        else if (hostAddress.startsWith("file"))
            hostAddress = "localhost";
        // Else for real.
        else
        {
            hostAddress = hostAddress.replace("http://", " ");
            hostAddress = hostAddress.replace("/", " ").trim();
        }
        // Connect with host.
        comBas.Connect(hostAddress, mod_dev_t.PORT_TCP, mod_def.PROT_TCP);
        if (!comBas.IsConnected())
        {
            errorLabel.setText("Cannot connect to target");
            errorLabel.setVisible(true);
        }

        // If we're connected.
        if (comBas.IsConnected())
        {
            CbxDevInstance.removeAllItems();
            GetInstanceValues();
            GetUnitData();
            if(dev_qty > 0)
            {
                CbxInstance.removeAllItems();
            	// Set combo box selection.
            	GetObjInstanceValues(0);
            	CbxInstance.setSelectedIndex(0);
            	GetModAddrValues(0);
            }
            dev_index = 0;        	
        }
        // Else put default message.
        else
        {
        	CbxDevInstance.addItem("None Available");
            CbxInstance.addItem("None Available");
        }

        // Create timer and task.
        err_tmr = new Timer();
        err_tmr_task = new TimerTask()
        {
            public void run()
            {
                CheckErrorLabel();
                UpdateUnitStatus(); // debug:delete
            }
        };
        // Set timer to start after 1 second with 1 second interval.
        err_tmr.scheduleAtFixedRate(err_tmr_task, 1000, 1000);

        // Add selections to property combo box.
        CbxProperty.removeAllItems();
        for (bac.prop p : bac.prop.values())
        {
            CbxProperty.addItem(p);
        }
        CbxProperty.setSelectedIndex(0);

        // Start connect task.
        connect_task.execute();
    }

    public void destroy()
    {
        applet_running = false;
        comBas.Disconnect();
    }

    /**
     * This thread operates in the background to try and re-establish the link
     * with the host should it be broken.
     * 
     * @author rcw
     * 
     */
    public class ConnectTask extends SwingWorker<Void, Void>
    {
        @Override
        public Void doInBackground()
        {
            while (applet_running)
            {
                if (!comBas.IsConnected())
                {
                    comBas.Connect(hostAddress, mod.def.PORT_TCP, mod.def.PROT_TCP);
                }
                try
                {
                    Thread.sleep(2000);
                } catch (InterruptedException e)
                {
                }
            }
            return null;
        }
    }

    public void ProcessError( String text )
    {
        mod.err e = mod.err.getObj(text);

        switch (e)
        {
            // We ignore ILLEGAL errors here.
            case ILLEGAL_DATA_ADDRESS:
            case ILLEGAL_FUNCTION:
            case ILLEGAL_DATA_VALUE:
            case ILLEGAL_OBJECT_INSTANCE:
                break;
            default:
                comBas.Disconnect();
                break;
        }
        errorLabel.setText(text);
        errorLabel.setVisible(true);
    }

    // get device instance for all units
    private void GetInstanceValues()
    {
        int 		cnt;
        String		dd;
        // Return if not connected.
        if (!comBas.IsConnected())
            return;
        // Use try/catch.
        try
        {
            // Get the number of units.
            dev_qty = comBas.ReadCfgInt(bas_def.REG_UNIT_QTY);
            for(cnt = 0; cnt < dev_qty; cnt++)
            {
                // Write unit index.
                comBas.WriteCfg(bas_def.REG_UNIT_IDX, cnt);
                dd = comBas.ReadCfgStr(bas_def.REG_UNIT_INSTANCE);
            	// Add device to list.
            	CbxDevInstance.addItem(dd);
            }
        } 
        catch (IOException e)
        {
            ProcessError(e.getMessage());
        }
    }

    private void GetModAddrValues(int index)
	{
		String	modAddr = null;
		
        // Return if not connected.
        if (!comBas.IsConnected())
            return;
        try 
        {
            synchronized(this)
            {
            	comBas.WriteCfg(bas_def.REG_UNIT_IDX, index);
            }
		} 
        catch (IOException e) 
        {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		try 
		{
            synchronized(this)
            {
            	modAddr = comBas.ReadCfgStr(bas_def.REG_UNIT_ADDR);
            }
			modAddr = modAddr.replace(':', '/');
		} 
		catch (IOException e) 
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		EbxModAddr.setText(modAddr);
	}
	
    private void GetObjInstanceValues(int index)
    {
        int 		i, obj_qty = 0;
        obj_data 	od;
        // Return if not connected.
        if (!comBas.IsConnected())
            return;
        // Get the number of objects.
        try 
        {
            synchronized(this)
            {
            	obj_qty = comBas.ReadObjIntX(index, 0, bac.def.BAC_OBJ_QTY);
            }
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
        // Loop to get all object instances.
        for (i = 0; i < obj_qty; ++i)
        {
        	// Create data object.
        	od = new obj_data();
        	// Get object instance.
        	try 
        	{
                synchronized(this)
                {
                	od.instance = comBas.ReadObjStrX(index, i, bac.def.OBJECT_IDENTIFIER);
                }
			} 
        	catch (IOException e) 
        	{
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
        	// Get object type.
        	try 
        	{
                synchronized(this)
                {
                	od.type = bac.type.getType(comBas.ReadObjIntX(index, i, bac.def.OBJECT_TYPE));
                }
			} 
        	catch (IOException e) 
        	{
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
            // Get object name.
            try 
            {
                synchronized(this)
                {
                	od.name = comBas.ReadObjStrX(index, i , bac.def.OBJECT_NAME);
                }
			} 
            catch (IOException e) 
            {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
            // Get object description.
            try 
            {
                synchronized(this)
                {
                	od.description = comBas.ReadObjStrX(index, i , bac.def.DESCRIPTION);
                }
			} 
            catch (IOException e) 
            {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
        	// Add object to list.
        	CbxInstance.addItem(od);
        }
    }

    private void UpdateUnitStatus()
    {
        int i;
        int unit_status;
        unit_data ud;
        ListItem	item;
        boolean cur_status;
        boolean data_changed = false;
        Color	customColor;
        
        // Return if not connected.
        if (!comBas.IsConnected())
            return;
        // Use try/catch.
        try
        {
            for (i = 0; i < listModel.size(); ++i)
            {
                // Get unit data.
            	item = (ListItem) listModel.get(i);
                ud = (unit_data)item.getData();
                // Save current status.
                cur_status = ud.online;
                // Get unit status as unit-indexed value: nn401, where 'nn'
                // is the 1-based unit number.
                synchronized(this)
                {
                	unit_status = comBas.ReadReg16(bas_def.CONFIG_ADDRESS, mod.RegIdx(i, bas_def.REG_UNIT_STATUS));
                }
                // Set unit status.
                if (unit_status == 0)
                {
                    ud.online = true;
                    customColor = Color.GREEN;
                    item.color = customColor.darker();
                }
                else
                {
                    ud.online = false;
                    item.color = Color.BLACK;
                }
                // If status has changed.
                if (ud.online != cur_status)
                    data_changed = true;
            }
            // If data has changed.
            if (data_changed)
            {
                // Force update.
                overallStatusList.validate();
                overallStatusList.repaint();
            }
        } catch (IOException e)
        {
            ProcessError(e.getMessage());
        }
    }

	private void GetUnitData()
    {
        int 		i , unit_qty;
        unit_data 	ud;
        ListItem	item;
        
        // Return if not connected.
        if (!comBas.IsConnected())
            return;
        // Use try/catch.
        try
        {
            // clear listbox
            listModel.clear();
            // Get unit quantity.
            unit_qty = comBas.ReadCfgInt(bas_def.REG_UNIT_QTY);	
            // For each unit.
            for (i = 0; i < unit_qty; i++)
            {
                // Create new unit data object.
                ud = new unit_data();
                // Get the unit's Modbus address.
                comBas.WriteCfg(bas_def.REG_UNIT_IDX, i);
                ud.address = comBas.ReadCfgStr(bas_def.REG_UNIT_ADDR);
                ud.address = ud.address.replace(':', '/');
                ud.devInst = comBas.ReadCfgInt(bas_def.REG_UNIT_INSTANCE);
                // Assume it's offline.
                ud.online = false;
                item = new ListItem(Color.BLACK, null);
                item.value = ud;
                // Add element to list model.
                listModel.addElement(item);
            }
            // Force update.
            PnlStatus.validate();
        } catch (IOException e)
        {
            ProcessError(e.getMessage());
        }
    }

    // Clear error text after 3 seconds, or set counter
    // when error is detected.
    //
    void CheckErrorLabel()
    {
        // Leave error up if we're not connected.
        if (!comBas.IsConnected())
            return;
        // If error counter is not zero.
        if (err_tmr_cnt != 0)
        {
            // Decrement it.
            --err_tmr_cnt;
            // If it just went to zero.
            if (err_tmr_cnt == 0)
            {
                // Turn off error indicator.
                errorLabel.setVisible(false);
            }
            return;
        }
        // If error has occurred.
        if (errorLabel.isVisible() == true)
        {
            // Initialize counter for 3 seconds.
            err_tmr_cnt = 3;
        }
    }

    private void readModbusValue()
    {
        int 		instance , property;
        obj_data 	od;
        bac.prop 	bp;
        String		tmp = null;
        int			dev_instance;
        
        // Return if not connected.
        if (!comBas.IsConnected())
            return;
        // Use try/catch.
        try
        {
        	tmp = (String)CbxDevInstance.getSelectedItem();
        	if(tmp == null)
        	{
                errorLabel.setText("Error: Invalid Device Instance");
                errorLabel.setVisible(true);
                return;        		
        	}
        	else
        	{
        		dev_instance = Integer.decode(tmp);
        		if((dev_instance < 0) || (dev_instance > 0x3FFFFE))
        		{
        			errorLabel.setText("Error: Invalid Device Instance");
        			errorLabel.setVisible(true);
        			return;        		
        		}
        	}
            // Get object data.
            od = (obj_data) CbxInstance.getSelectedItem();
            instance = Integer.decode(od.instance);
            // Get property.
            bp = (bac.prop) CbxProperty.getSelectedItem();
            property = bp.getEnum();
            // Show result.
            EbxPropVal.setText(comBas.ReadObjStr(dev_instance, instance, property));
            errorLabel.setText("SUCCESS");
        } catch (IOException e)
        {
            ProcessError(e.getMessage());
        }
    }

    private void writeModbusValue()
    {
        int 		instance , property;
        obj_data 	od;
        bac.prop 	bp;
        String		tmp;
        int			dev_instance;
        
        // Return if not connected.
        if (!comBas.IsConnected())
            return;
        // Use try/catch.
        try
        {
        	tmp = (String)CbxDevInstance.getSelectedItem();
        	dev_instance = Integer.decode(tmp);
        	if((dev_instance < 0) || (dev_instance > 0x3FFFFE))
        	{
                errorLabel.setText("Error: Invalid Device Instance");
                errorLabel.setVisible(true);
                return;        		
        	}
            // Write unit index.
            comBas.WriteCfg(bas_def.REG_UNIT_IDX, dev_index);
            // Get object data.
            od = (obj_data) CbxInstance.getSelectedItem();
            instance = Integer.decode(od.instance);
            if(instance < 0)
        	{
                errorLabel.setText("Error: Invalid Object Instance");
                errorLabel.setVisible(true);
                return;        		
        	}
            // Get property.
            bp = (bac.prop) CbxProperty.getSelectedItem();
            property = bp.getEnum();
            // Error if not present value.
            if (property != bac.def.PRESENT_VALUE)
            {
                errorLabel.setText("WR Not Possible");
                errorLabel.setVisible(true);
                return;
            }
            // Show result.
            comBas.WriteObj(dev_instance, instance, property, EbxPropVal.getText());
            errorLabel.setText("SUCCESS");
        } catch (IOException e)
        {
            ProcessError(e.getMessage());
        }
    }

    // Here to sleep for a short time.
    //
    void MilliSleep( int ms )
    {
        try
        {
            Thread.sleep(ms);
        } catch (InterruptedException e)
        {
        }
    }

    private void initComponents()
    {
        final JButton BnRead = new JButton();
        BnRead.addActionListener(new ActionListener() {
        	public void actionPerformed(final ActionEvent arg0) {
                readModbusValue();
        	}
        });
        BnRead.setBounds(34, 227, 76, 24);
        BnRead.setText("Read");
        getContentPane().add(BnRead);

        final JLabel deviceInstanceLabel = new JLabel();
        deviceInstanceLabel.setFont(new Font("Sans", Font.PLAIN, 12));
        deviceInstanceLabel.setText("Device Instance");
        deviceInstanceLabel.setBounds(34, 28, 126, 14);
        getContentPane().add(deviceInstanceLabel);

        final JLabel objInstanceLabel = new JLabel();
        objInstanceLabel.setFont(new Font("Sans", Font.PLAIN, 12));
        objInstanceLabel.setBounds(34, 77, 125, 14);
        objInstanceLabel.setText("Object Instance");
        getContentPane().add(objInstanceLabel);

        final JButton BnWrite = new JButton();
        BnWrite.addActionListener(new ActionListener() {
        	public void actionPerformed(final ActionEvent arg0) {
                writeModbusValue();
        	}
        });
        BnWrite.setBounds(131, 227, 76, 24);
        BnWrite.setText("Write");
        getContentPane().add(BnWrite);

        final JLabel objValueLabel = new JLabel();
        objValueLabel.setFont(new Font("Sans", Font.PLAIN, 12));
        objValueLabel.setBounds(34, 127, 125, 14);
        objValueLabel.setText("Object Property");
        getContentPane().add(objValueLabel);

        listModel = new DefaultListModel();

        errorLabel = new JLabel();
        errorLabel.setForeground(Color.RED);
        errorLabel.setBackground(Color.BLACK);
        errorLabel.setText("ERROR");
        errorLabel.setBounds(157, 177, 228, 14);
        errorLabel.setVisible(false);
        getContentPane().add(errorLabel);

        getContentPane().add(PnlStatus);
        PnlStatus.setBorder(new TitledBorder(null, "Unit Status", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, null, null));
        PnlStatus.setLayout(new BorderLayout());
        PnlStatus.setBounds(34, 257, 351, 191);

        PnlStatus.add(ScpStatus, BorderLayout.CENTER);
        overallStatusList = new JList(listModel);
        overallStatusList.setBackground(Color.WHITE);
        overallStatusList.setCellRenderer(new MyCellRenderer());
        ScpStatus.setViewportView(overallStatusList);

        CbxDevInstance = new JComboBox();
        CbxDevInstance.setFont(new Font("Sans", Font.PLAIN, 12));
        CbxDevInstance.setBounds(34, 48, 126, 23);
        getContentPane().add(CbxDevInstance);
        if(dbug_on == false)
        {
        	CbxDevInstance.addItemListener(new ItemListener()
        	{
        		public void itemStateChanged( final ItemEvent arg0 )
        		{
        			dev_index = CbxDevInstance.getSelectedIndex();  
        			// Clear the box.
        			CbxInstance.removeAllItems();
        			GetObjInstanceValues(dev_index);
        			CbxInstance.setSelectedIndex(0);
        			GetModAddrValues(dev_index);
        		}
        	});
        }
        
        getContentPane().add(CbxInstance);
        CbxInstance.setFont(new Font("Sans", Font.PLAIN, 12));
        CbxInstance.setBounds(34, 97, 456, 24);

        getContentPane().add(CbxProperty);
        CbxProperty.setFont(new Font("Sans", Font.PLAIN, 12));
        CbxProperty.addItemListener(new ItemListener() {
            public void itemStateChanged(final ItemEvent arg0)
            {
                bac.prop    p = (bac.prop)CbxProperty.getSelectedItem();
                
                if (p != bac.prop.PRESENT_VALUE)
                    BnWrite.setEnabled(false);
                else
                    BnWrite.setEnabled(true);
            }
        });
        CbxProperty.setBounds(34, 147, 157, 24);

        getContentPane().add(EbxPropVal);
        EbxPropVal.setBounds(34, 197, 270, 24);

        getContentPane().add(propertyValueLabel);
        propertyValueLabel.setFont(new Font("Sans", Font.PLAIN, 12));
        propertyValueLabel.setText("Property Value");
        propertyValueLabel.setBounds(34, 177, 110, 14);
        

        final JLabel modbusAddressLabel = new JLabel();
        modbusAddressLabel.setFont(new Font("Sans", Font.PLAIN, 12));
        modbusAddressLabel.setText("Modbus Address");
        modbusAddressLabel.setBounds(212, 28, 110, 14);
        getContentPane().add(modbusAddressLabel);

        EbxModAddr = new JTextField();
        EbxModAddr.setFont(new Font("Sans", Font.PLAIN, 14));
        EbxModAddr.setBounds(212, 47, 187, 24);
        EbxModAddr.setEditable(false);
        getContentPane().add(EbxModAddr);

        if(dbug_on == true)
        {
            final JButton openButton = new JButton();
            openButton.addActionListener(new ActionListener() 
            {
            	public void actionPerformed(final ActionEvent arg0) 
            	{
                	dev_index = CbxDevInstance.getSelectedIndex();    
                    // Clear the box.
                    CbxInstance.removeAllItems();
                	GetObjInstanceValues(dev_index);
                	CbxInstance.setSelectedIndex(0);
                	GetModAddrValues(dev_index);
            	}
            });
            openButton.setText("Open");
            openButton.setBounds(131, 10, 76, 24);
            getContentPane().add(openButton);
        }
    }

}
