/*
 * Decompiled with CFR 0.152.
 */
package modbus;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import modbus.mod_def;
import modbus.mod_ex;
import modbus.mod_rxtx;
import modbus.obj_param_t;
import modbus.reg_pair_t;

public class mod_dev_t {
    public static final int PORT_DF1 = 5001;
    public static final int PORT_TCP = 502;
    public static final int PORT_RCLI = 5003;
    public static final int TIMEOUT_CONNECT = 3000;
    public static final int TIMEOUT_RX = 7000;
    public static final byte SKT_BIT = 1;
    public static final byte DIS_BIT = 2;
    public static final byte DOS_BIT = 4;
    private Socket skt;
    private byte m_flags = 0;
    public InputStream dis;
    public OutputStream dos;
    public mod_ex mex;
    public mod_rxtx mxt;
    public boolean m_connected = false;
    public byte m_error = 0;

    public boolean IsConnected() {
        return this.m_connected;
    }

    public void Disconnect() {
        if ((this.m_flags & 2) != 0) {
            this.m_flags = (byte)(this.m_flags & 0xFFFFFFFD);
            try {
                this.dis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((this.m_flags & 4) != 0) {
            this.m_flags = (byte)(this.m_flags & 0xFFFFFFFB);
            try {
                this.dos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((this.m_flags & 1) != 0) {
            this.m_flags = (byte)(this.m_flags & 0xFFFFFFFE);
            try {
                this.skt.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.m_connected = false;
    }

    public int Connect(String DottedIpAddress, int port, int protocol) {
        this.skt = new Socket();
        this.m_flags = (byte)(this.m_flags | 1);
        try {
            this.skt.bind(null);
        }
        catch (IOException e) {
            this.Disconnect();
            return -1;
        }
        InetSocketAddress addr = new InetSocketAddress(DottedIpAddress, port);
        if (addr.isUnresolved()) {
            return -1;
        }
        try {
            this.skt.connect(addr, 3000);
        }
        catch (IOException e) {
            this.Disconnect();
            return -1;
        }
        try {
            this.skt.setSoTimeout(7000);
        }
        catch (IOException e) {
            this.Disconnect();
            return -1;
        }
        try {
            this.dos = this.skt.getOutputStream();
        }
        catch (IOException e) {
            this.Disconnect();
            return -1;
        }
        this.m_flags = (byte)(this.m_flags | 4);
        try {
            this.dis = this.skt.getInputStream();
        }
        catch (IOException e) {
            this.Disconnect();
            return -1;
        }
        this.m_flags = (byte)(this.m_flags | 2);
        this.mex = new mod_ex();
        this.mxt = new mod_rxtx(this.dis, this.dos);
        this.mxt.SetProtocol((byte)protocol);
        this.m_connected = true;
        return 0;
    }

    public int SetTimeout(int msTimeout) {
        try {
            this.skt.setSoTimeout(msTimeout);
        }
        catch (IOException e) {
            this.Disconnect();
            return -1;
        }
        return 0;
    }

    public void SetProtocol(int protocol) {
        switch (protocol) {
            case 2: 
            case 3: {
                this.mxt.SetProtocol((byte)protocol);
                break;
            }
        }
    }

    public int GetProtocol() {
        return this.mxt.GetProtocol();
    }

    public String GetError() {
        int err_idx = this.mex.b[0] & 0xFF;
        if (err_idx <= mod_def.ErrStr.length) {
            return mod_def.ErrStr[err_idx];
        }
        return "UNKOWN ERROR CODE";
    }

    public int ReadReg16(int slave, int reg) {
        this.mex.slv_adr = (byte)slave;
        this.mex.fcn = (byte)3;
        this.mex.itm_adr = (short)reg;
        this.mex.itm_qty = 1;
        if (this.mxt.MasterTx(this.mex) != 0) {
            this.m_error = this.mex.b[0];
            return -1;
        }
        this.m_error = 0;
        return this.mex.w[0] & 0xFFFF;
    }

    public int WriteReg16(int slave, int reg, int value) {
        this.mex.slv_adr = (byte)slave;
        this.mex.fcn = (byte)16;
        this.mex.itm_adr = (short)reg;
        this.mex.itm_qty = 1;
        this.mex.w[0] = (short)value;
        return this.mxt.MasterTx(this.mex);
    }

    public int WriteReg16(int slave, int reg, int[] value) {
        this.mex.slv_adr = (byte)slave;
        this.mex.fcn = (byte)16;
        this.mex.itm_adr = (short)reg;
        this.mex.itm_qty = (short)value.length;
        int i = 0;
        while (i < this.mex.itm_qty) {
            this.mex.w[i] = (short)value[i];
            ++i;
        }
        return this.mxt.MasterTx(this.mex);
    }

    public int ReadReg16(int slave, int reg, int chn) {
        this.mex.slv_adr = (byte)slave;
        this.mex.fcn = (byte)3;
        this.mex.itm_adr = (short)this.mex.RegIdx(chn, reg);
        this.mex.itm_qty = 1;
        if (this.mxt.MasterTx(this.mex) != 0) {
            this.m_error = this.mex.b[0];
            return -1;
        }
        this.m_error = 0;
        return this.mex.w[0] & 0xFFFF;
    }

    public int WriteReg16(int slave, int reg, int value, int chn) {
        this.mex.slv_adr = (byte)slave;
        this.mex.fcn = (byte)16;
        this.mex.itm_adr = (short)this.mex.RegIdx(chn, reg);
        this.mex.itm_qty = 1;
        this.mex.w[0] = (short)value;
        return this.mxt.MasterTx(this.mex);
    }

    public int RegPair(int slave, int reg, boolean write) {
        this.mex.slv_adr = (byte)slave;
        this.mex.fcn = write ? (byte)16 : (byte)3;
        this.mex.itm_adr = (short)reg;
        this.mex.itm_qty = (short)2;
        return this.mxt.MasterTx(this.mex);
    }

    public int ReadRegPair(int slave, int reg, reg_pair_t rp) {
        int val;
        if (this.RegPair(slave, reg, false) != 0) {
            return -1;
        }
        if (rp.big_endian) {
            val = this.mex.w[0] & 0xFFFF;
            val <<= 16;
            val |= this.mex.w[1] & 0xFFFF;
        } else {
            val = this.mex.w[1] & 0xFFFF;
            val <<= 16;
            val |= this.mex.w[0] & 0xFFFF;
        }
        if (rp.float_op) {
            rp.f = Float.intBitsToFloat(val);
        } else {
            rp.i = val;
        }
        return 0;
    }

    public int WriteRegPair(int slave, int reg, reg_pair_t rp) {
        int val = rp.float_op ? Float.floatToRawIntBits(rp.f) : rp.i;
        if (rp.big_endian) {
            this.mex.w[0] = (short)(val >> 16);
            this.mex.w[1] = (short)val;
        } else {
            this.mex.w[0] = (short)val;
            this.mex.w[1] = (short)(val >> 16);
        }
        return this.RegPair(slave, reg, true);
    }

    public int ReadInp(int slave, int reg) {
        this.mex.slv_adr = (byte)slave;
        this.mex.fcn = (byte)2;
        this.mex.itm_adr = (short)reg;
        this.mex.itm_qty = 1;
        if (this.mxt.MasterTx(this.mex) == 0) {
            if ((this.mex.b[0] & 1) > 0) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public int ReadCoil(int slave, int reg) {
        this.mex.slv_adr = (byte)slave;
        this.mex.fcn = 1;
        this.mex.itm_adr = (short)reg;
        this.mex.itm_qty = 1;
        if (this.mxt.MasterTx(this.mex) == 0) {
            if (this.mex.b[0] > 0) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public int WriteCoil(int slave, int reg, int value) {
        this.mex.slv_adr = (byte)slave;
        this.mex.fcn = (byte)5;
        this.mex.itm_adr = (short)reg;
        this.mex.itm_qty = 1;
        this.mex.b[0] = value != 0 ? (byte)1 : 0;
        return this.mxt.MasterTx(this.mex);
    }

    public String ReadBasReg(int slave, int reg) {
        this.mex.slv_adr = (byte)slave;
        this.mex.fcn = (byte)100;
        this.mex.itm_adr = (short)reg;
        this.mex.itm_qty = 1;
        if (this.mxt.MasterTx(this.mex) == 0) {
            return this.mex.s[0];
        }
        return "ERROR: " + this.GetError();
    }

    public String WriteBasReg(int slave, int reg, String val) {
        this.mex.slv_adr = (byte)slave;
        this.mex.fcn = (byte)101;
        this.mex.itm_adr = (short)reg;
        this.mex.itm_qty = 1;
        this.mex.s[0] = val;
        if (this.mxt.MasterTx(this.mex) == 0) {
            return "SUCCESS";
        }
        return "ERROR: " + this.GetError();
    }

    public String ReadCfgStr(int reg) {
        this.mex.slv_adr = (byte)-1;
        this.mex.fcn = (byte)100;
        this.mex.itm_adr = (short)reg;
        this.mex.itm_qty = 1;
        if (this.mxt.MasterTx(this.mex) == 0) {
            return this.mex.s[0];
        }
        return "ERROR: " + this.GetError();
    }

    public int ReadCfgInt(int reg) {
        this.mex.slv_adr = (byte)-1;
        this.mex.fcn = (byte)100;
        this.mex.itm_adr = (short)reg;
        this.mex.itm_qty = 1;
        if (this.mxt.MasterTx(this.mex) == 0) {
            return Integer.decode(this.mex.s[0]);
        }
        return -1;
    }

    public int WriteCfgStr(int reg, String val) {
        this.mex.slv_adr = (byte)-1;
        this.mex.fcn = (byte)101;
        this.mex.itm_adr = (short)reg;
        this.mex.itm_qty = 1;
        this.mex.s[0] = val;
        return this.mxt.MasterTx(this.mex);
    }

    public int WriteCfgInt(int reg, int val) {
        this.mex.slv_adr = (byte)-1;
        this.mex.fcn = (byte)101;
        this.mex.itm_adr = (short)reg;
        this.mex.itm_qty = 1;
        this.mex.s[0] = Integer.toString(val);
        return this.mxt.MasterTx(this.mex);
    }

    public int ReadObj(obj_param_t obj) {
        this.mex.slv_adr = (byte)-1;
        this.mex.fcn = (byte)106;
        this.mex.itm_adr = obj.index ? (short)-32767 : (short)1;
        this.mex.itm_qty = 1;
        this.mex.l[0] = obj.instance;
        this.mex.w[0] = (short)obj.property;
        if (this.mxt.MasterTx(this.mex) == 0) {
            obj.value = this.mex.s[0];
            return 0;
        }
        return this.mex.b[0] & 0xFF;
    }

    public int WriteObj(obj_param_t obj) {
        this.mex.slv_adr = (byte)-1;
        this.mex.fcn = (byte)107;
        this.mex.itm_adr = obj.index ? (short)-32767 : (short)1;
        this.mex.itm_qty = 1;
        this.mex.l[0] = obj.instance;
        this.mex.w[0] = (short)obj.property;
        this.mex.s[0] = obj.value;
        if (this.mxt.MasterTx(this.mex) == 0) {
            return 0;
        }
        return this.mex.b[0] & 0xFF;
    }
}

