/*
 * Decompiled with CFR 0.152.
 */
package modbus;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public class mod {
    public static int RegIdx(int chn, int reg) {
        return reg + (chn + 1) * 1000;
    }

    public class def {
        public static final int MOD_MAX_REG = 32;
        public static final int MOD_MAX_BYTE = 512;
        public static final byte MOD_DLE = 16;
        public static final byte MOD_STX = 2;
        public static final byte MOD_ETX = 3;
        public static final int PROT_ASCII = 0;
        public static final int PROT_RTU = 1;
        public static final int PROT_DF1 = 2;
        public static final int PROT_TCP = 3;
        public static final int PORT_DF1 = 5001;
        public static final int PORT_TCP = 502;
        public static final int PORT_RCLI = 5003;
        public static final int SIZE_16 = 1;
        public static final int SIZE_STR = 2;
        public static final int READ_COILS = 1;
        public static final int READ_DISCRETE_INPUTS = 2;
        public static final int READ_HOLDING_REGISTERS = 3;
        public static final int READ_INPUT_REGISTERS = 4;
        public static final int WRITE_SINGLE_COIL = 5;
        public static final int WRITE_SINGLE_REGISTER = 6;
        public static final int READ_EXCEPTION_STATUS = 7;
        public static final int FETCH_COMM_EVENT_CTR = 11;
        public static final int FETCH_COMM_EVENT_LOG = 12;
        public static final int WRITE_MULTIPLE_COILS = 15;
        public static final int WRITE_MULTIPLE_REGISTERS = 16;
        public static final int REPORT_SLAVE_ID = 17;
        public static final int READ_GENERAL_REFERENCE = 20;
        public static final int WRITE_GENERAL_REFERENCE = 21;
        public static final int MASK_WRITE_4X_REGISTER = 22;
        public static final int READ_WRITE_4X_REGISTERS = 23;
        public static final int READ_FIFO_QUEUE = 24;
        public static final int RD_REGS_16 = 3;
        public static final int WR_REGS_16 = 16;
        public static final int RD_REGS_STR = 100;
        public static final int WR_REGS_STR = 101;
        public static final int RD_REGS_LIST = 102;
        public static final int WR_REGS_LIST = 103;
        public static final int RELAY_MESSAGE = 104;
        public static final int MRPC_FCN = 105;
        public static final int RD_OBJ = 106;
        public static final int WR_OBJ = 107;
        public static final int RD_DEV_REGS_STR = 108;
        public static final int WR_DEV_REGS_STR = 109;
        public static final int RD_DEV_REGS_LIST = 110;
        public static final int WR_DEV_REGS_LIST = 111;
        public static final int RD_FILE = 112;
        public static final int WR_FILE = 113;
        public static final int DEL_FILE = 114;
        public static final byte UNKNOWN_ERROR = 0;
        public static final byte ILLEGAL_FUNCTION = 1;
        public static final byte ILLEGAL_DATA_ADDRESS = 2;
        public static final byte ILLEGAL_DATA_VALUE = 3;
        public static final byte SLAVE_DEVICE_FAILURE = 4;
        public static final byte ACKNOWLEDGE = 5;
        public static final byte SLAVE_DEVICE_BUSY = 6;
        public static final byte NEGATIVE_ACKNOWLEDGE = 7;
        public static final byte MEMORY_PARITY_ERROR = 8;
        public static final byte GATEWAY_NO_PATH = 10;
        public static final byte GATEWAY_TIMEOUT = 11;
        public static final byte RX_PACKET_CORRUPT = 12;
        public static final byte DATA_RX_ERROR = 13;
        public static final byte DATA_TX_ERROR = 14;
        public static final byte ILLEGAL_OBJECT_INSTANCE = 15;
        public static final byte BAS_STAT = 0;
        public static final byte BELIMO_UK24MOD = 1;
        public static final byte CIRCUTOR_CVM_NRG96 = 2;
        public static final byte HONEYWELL_S7810M = 3;
        public static final byte NORTHERN_DESIGN_350 = 4;
        public static final byte RENU_FIOD_1600 = 5;
        public static final byte RENU_FIOD_0008 = 6;
        public static final byte RENU_FIOD_0808 = 7;
        public static final byte SCHNEIDER_PL800 = 8;
        public static final byte VERIS_H8035 = 10;
        public static final byte WNC_3Y_208_MB = 11;
        public static final byte WNC_3Y_400_MB = 12;
        public static final byte WNC_3Y_480_MB = 13;
        public static final byte WNC_3Y_600_MB = 14;
        public static final byte WNC_3D_240_MB = 15;
        public static final byte WNC_3D_400_MB = 16;
        public static final byte WNC_3D_480_MB = 17;
    }

    public static class device {
        public static final int CONFIG_ADDRESS = 255;
        private static final int TIMEOUT_CONNECT = 3000;
        private static final int TIMEOUT_RX = 1000;
        private static final byte SKT_BIT = 1;
        private static final byte DIS_BIT = 2;
        private static final byte DOS_BIT = 4;
        private Socket skt;
        private byte m_flags = 0;
        private InputStream dis;
        private OutputStream dos;
        private packet pkt;
        private transfer trf;
        private boolean m_connected = false;

        public void Disconnect() {
            if ((this.m_flags & 2) != 0) {
                this.m_flags = (byte)(this.m_flags & 0xFFFFFFFD);
                try {
                    this.dis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((this.m_flags & 4) != 0) {
                this.m_flags = (byte)(this.m_flags & 0xFFFFFFFB);
                try {
                    this.dos.flush();
                    this.dos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((this.m_flags & 1) != 0) {
                this.m_flags = (byte)(this.m_flags & 0xFFFFFFFE);
                try {
                    this.skt.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.m_connected = false;
        }

        public int Connect(String DottedIpAddress, int port, int protocol) {
            this.skt = new Socket();
            this.m_flags = (byte)(this.m_flags | 1);
            try {
                this.skt.bind(null);
            }
            catch (IOException e) {
                this.Disconnect();
                return -1;
            }
            InetSocketAddress addr = new InetSocketAddress(DottedIpAddress, port);
            if (addr.isUnresolved()) {
                return -1;
            }
            try {
                this.skt.connect(addr, 3000);
            }
            catch (IOException e) {
                this.Disconnect();
                return -1;
            }
            try {
                this.skt.setSoTimeout(1000);
            }
            catch (IOException e) {
                this.Disconnect();
                return -1;
            }
            try {
                this.dos = this.skt.getOutputStream();
            }
            catch (IOException e) {
                this.Disconnect();
                return -1;
            }
            this.m_flags = (byte)(this.m_flags | 4);
            try {
                this.dis = this.skt.getInputStream();
            }
            catch (IOException e) {
                this.Disconnect();
                return -1;
            }
            this.m_flags = (byte)(this.m_flags | 2);
            this.pkt = new packet();
            this.trf = new transfer(this.dis, this.dos);
            this.trf.SetProtocol((byte)protocol);
            this.m_connected = true;
            return 0;
        }

        public boolean IsConnected() {
            return this.m_connected;
        }

        public int SetTimeout(int msTimeout) {
            try {
                if (msTimeout == -1) {
                    this.skt.setSoTimeout(1000);
                } else {
                    this.skt.setSoTimeout(msTimeout);
                }
            }
            catch (IOException e) {
                this.Disconnect();
                return -1;
            }
            return 0;
        }

        public void SetProtocol(int protocol) {
            switch (protocol) {
                case 2: 
                case 3: {
                    this.trf.SetProtocol((byte)protocol);
                    break;
                }
            }
        }

        public int GetProtocol() {
            return this.trf.GetProtocol();
        }

        public String GetError() {
            return err.getName(this.pkt.b[0] & 0xFF);
        }

        public int ReadCoil(int slave, int reg) throws IOException {
            this.pkt.slv_adr = (byte)slave;
            this.pkt.fcn = 1;
            this.pkt.itm_adr = (short)reg;
            this.pkt.itm_qty = 1;
            this.trf.MasterTx(this.pkt);
            if (this.pkt.b[0] > 0) {
                return 1;
            }
            return 0;
        }

        public int WriteCoil(int slave, int reg, int val) throws IOException {
            this.pkt.slv_adr = (byte)slave;
            this.pkt.fcn = (byte)5;
            this.pkt.itm_adr = (short)reg;
            this.pkt.itm_qty = 1;
            this.pkt.b[0] = (byte)val;
            return this.trf.MasterTx(this.pkt);
        }

        public int ReadInp(int slave, int reg) throws IOException {
            this.pkt.slv_adr = (byte)slave;
            this.pkt.fcn = (byte)2;
            this.pkt.itm_adr = (short)reg;
            this.pkt.itm_qty = 1;
            this.trf.MasterTx(this.pkt);
            if ((this.pkt.b[0] & 1) > 0) {
                return 1;
            }
            return 0;
        }

        public int ReadRegInp16(int slave, int reg) throws IOException {
            this.pkt.slv_adr = (byte)slave;
            this.pkt.fcn = (byte)4;
            this.pkt.itm_adr = (short)reg;
            this.pkt.itm_qty = 1;
            this.trf.MasterTx(this.pkt);
            return this.pkt.w[0] & 0xFFFF;
        }

        public int ReadReg16(int slave, int reg) throws IOException {
            this.pkt.slv_adr = (byte)slave;
            this.pkt.fcn = (byte)3;
            this.pkt.itm_adr = (short)reg;
            this.pkt.itm_qty = 1;
            this.trf.MasterTx(this.pkt);
            return this.pkt.w[0] & 0xFFFF;
        }

        public int ReadReg16(int slave, int reg, short[] dst, int qty) throws IOException {
            this.pkt.slv_adr = (byte)slave;
            this.pkt.fcn = (byte)3;
            this.pkt.itm_adr = (short)reg;
            this.pkt.itm_qty = (short)qty;
            this.trf.MasterTx(this.pkt);
            int i = 0;
            while (i < qty) {
                dst[i] = this.pkt.w[i];
                ++i;
            }
            return 0;
        }

        public int WriteReg16(int slave, int reg, int value) throws IOException {
            this.pkt.slv_adr = (byte)slave;
            this.pkt.fcn = (byte)16;
            this.pkt.itm_adr = (short)reg;
            this.pkt.itm_qty = 1;
            this.pkt.w[0] = (short)value;
            return this.trf.MasterTx(this.pkt);
        }

        public int WriteReg16(int slave, int reg, int[] value, int qty) throws IOException {
            this.pkt.slv_adr = (byte)slave;
            this.pkt.fcn = (byte)16;
            this.pkt.itm_adr = (short)reg;
            this.pkt.itm_qty = (short)qty;
            int i = 0;
            while (i < this.pkt.itm_qty) {
                this.pkt.w[i] = (short)value[i];
                ++i;
            }
            return this.trf.MasterTx(this.pkt);
        }

        public int RegInpPair(int slave, int reg, boolean write) throws IOException {
            this.pkt.slv_adr = (byte)slave;
            if (write) {
                return -1;
            }
            this.pkt.fcn = (byte)4;
            this.pkt.itm_adr = (short)reg;
            this.pkt.itm_qty = (short)2;
            return this.trf.MasterTx(this.pkt);
        }

        public int RegPair(int slave, int reg, boolean write) throws IOException {
            this.pkt.slv_adr = (byte)slave;
            this.pkt.fcn = write ? (byte)16 : (byte)3;
            this.pkt.itm_adr = (short)reg;
            this.pkt.itm_qty = (short)2;
            return this.trf.MasterTx(this.pkt);
        }

        public int ReadRegPair(int slave, int reg, regOp32 rop) throws IOException {
            int val;
            this.RegPair(slave, reg, false);
            if (rop.big_endian) {
                val = this.pkt.w[0] & 0xFFFF;
                val <<= 16;
                val |= this.pkt.w[1] & 0xFFFF;
            } else {
                val = this.pkt.w[1] & 0xFFFF;
                val <<= 16;
                val |= this.pkt.w[0] & 0xFFFF;
            }
            if (rop.float_op) {
                rop.f = Float.intBitsToFloat(val);
            } else {
                rop.i = val;
            }
            return 0;
        }

        public int ReadRegInpPair(int slave, int reg, regOp32 rop) throws IOException {
            int val;
            this.RegInpPair(slave, reg, false);
            if (rop.big_endian) {
                val = this.pkt.w[0] & 0xFFFF;
                val <<= 16;
                val |= this.pkt.w[1] & 0xFFFF;
            } else {
                val = this.pkt.w[1] & 0xFFFF;
                val <<= 16;
                val |= this.pkt.w[0] & 0xFFFF;
            }
            if (rop.float_op) {
                rop.f = Float.intBitsToFloat(val);
            } else {
                rop.i = val;
            }
            return 0;
        }

        public int WriteRegPair(int slave, int reg, regOp32 rop) throws IOException {
            int val = rop.float_op ? Float.floatToRawIntBits(rop.f) : rop.i;
            if (rop.big_endian) {
                this.pkt.w[0] = (short)(val >> 16);
                this.pkt.w[1] = (short)val;
            } else {
                this.pkt.w[0] = (short)val;
                this.pkt.w[1] = (short)(val >> 16);
            }
            return this.RegPair(slave, reg, true);
        }

        public int ReadRegInt(int slv, int reg) throws IOException {
            this.pkt.slv_adr = (byte)slv;
            this.pkt.fcn = (byte)100;
            this.pkt.itm_adr = (short)reg;
            this.pkt.itm_qty = 1;
            this.trf.MasterTx(this.pkt);
            try {
                return Integer.decode(this.pkt.s[0]);
            }
            catch (NumberFormatException ne) {
                IOException e = new IOException(err.ILLEGAL_DATA_VALUE.name());
                throw e;
            }
        }

        public String ReadRegStr(int slv, int reg) throws IOException {
            this.pkt.slv_adr = (byte)slv;
            this.pkt.fcn = (byte)100;
            this.pkt.itm_adr = (short)reg;
            this.pkt.itm_qty = 1;
            this.trf.MasterTx(this.pkt);
            return this.pkt.s[0];
        }

        public void ReadRegStr(int slv, int reg, String[] dst, int qty) throws IOException {
            this.pkt.slv_adr = (byte)slv;
            this.pkt.fcn = (byte)100;
            this.pkt.itm_adr = (short)reg;
            this.pkt.itm_qty = (short)qty;
            this.trf.MasterTx(this.pkt);
            int i = 0;
            while (i < qty) {
                dst[i] = this.pkt.s[i];
                ++i;
            }
        }

        public void ReadRegList(int slv, int[] reg, String[] dst, int qty) throws IOException {
            this.pkt.slv_adr = (byte)slv;
            this.pkt.fcn = (byte)102;
            this.pkt.itm_adr = 0;
            this.pkt.itm_qty = (short)qty;
            int i = 0;
            while (i < qty) {
                this.pkt.w[i] = (short)reg[i];
                ++i;
            }
            this.trf.MasterTx(this.pkt);
            i = 0;
            while (i < qty) {
                dst[i] = this.pkt.s[i];
                ++i;
            }
        }

        public int WriteReg(int slv, int reg, String val) throws IOException {
            this.pkt.slv_adr = (byte)slv;
            this.pkt.fcn = (byte)101;
            this.pkt.itm_adr = (short)reg;
            this.pkt.itm_qty = 1;
            this.pkt.s[0] = val;
            return this.trf.MasterTx(this.pkt);
        }

        public int WriteReg(int slv, int reg, int val) throws IOException {
            this.pkt.slv_adr = (byte)slv;
            this.pkt.fcn = (byte)101;
            this.pkt.itm_adr = (short)reg;
            this.pkt.itm_qty = 1;
            this.pkt.s[0] = Integer.toString(val);
            return this.trf.MasterTx(this.pkt);
        }

        public int ReadObjInt(int devInstance, int instance, int property) throws IOException {
            this.pkt.slv_adr = (byte)-1;
            this.pkt.fcn = (byte)106;
            this.pkt.itm_adr = 1;
            this.pkt.itm_qty = 1;
            this.pkt.l[0] = devInstance;
            this.pkt.l[1] = instance;
            this.pkt.w[0] = (short)property;
            this.trf.MasterTx(this.pkt);
            try {
                return Integer.decode(this.pkt.s[0]);
            }
            catch (NumberFormatException ne) {
                IOException e = new IOException(err.ILLEGAL_DATA_VALUE.name());
                throw e;
            }
        }

        public int ReadObjIntX(int devIndex, int index, int property) throws IOException {
            this.pkt.slv_adr = (byte)-1;
            this.pkt.fcn = (byte)106;
            this.pkt.itm_adr = (short)-32767;
            this.pkt.itm_qty = 1;
            this.pkt.l[0] = devIndex;
            this.pkt.l[1] = index;
            this.pkt.w[0] = (short)property;
            this.trf.MasterTx(this.pkt);
            try {
                return Integer.decode(this.pkt.s[0]);
            }
            catch (NumberFormatException ne) {
                IOException e = new IOException(err.ILLEGAL_DATA_VALUE.name());
                throw e;
            }
        }

        public String ReadObjStr(int devInstance, int instance, int property) throws IOException {
            this.pkt.slv_adr = (byte)-1;
            this.pkt.fcn = (byte)106;
            this.pkt.itm_adr = 1;
            this.pkt.itm_qty = 1;
            this.pkt.l[0] = devInstance;
            this.pkt.l[1] = instance;
            this.pkt.w[0] = (short)property;
            this.trf.MasterTx(this.pkt);
            return this.pkt.s[0];
        }

        public String ReadObjStrX(int devIndex, int index, int property) throws IOException {
            this.pkt.slv_adr = (byte)-1;
            this.pkt.fcn = (byte)106;
            this.pkt.itm_adr = (short)-32767;
            this.pkt.itm_qty = 1;
            this.pkt.l[0] = devIndex;
            this.pkt.l[1] = index;
            this.pkt.w[0] = (short)property;
            this.trf.MasterTx(this.pkt);
            return this.pkt.s[0];
        }

        public int WriteObj(int devInstance, int instance, int property, int value) throws IOException {
            this.pkt.slv_adr = (byte)-1;
            this.pkt.fcn = (byte)107;
            this.pkt.itm_adr = 1;
            this.pkt.itm_qty = 1;
            this.pkt.l[0] = devInstance;
            this.pkt.l[1] = instance;
            this.pkt.w[0] = (short)property;
            this.pkt.s[0] = Integer.toString(value);
            return this.trf.MasterTx(this.pkt);
        }

        public int WriteObj(int devInstance, int instance, int property, String value) throws IOException {
            this.pkt.slv_adr = (byte)-1;
            this.pkt.fcn = (byte)107;
            this.pkt.itm_adr = 1;
            this.pkt.itm_qty = 1;
            this.pkt.l[0] = devInstance;
            this.pkt.l[1] = instance;
            this.pkt.w[0] = (short)property;
            this.pkt.s[0] = value;
            return this.trf.MasterTx(this.pkt);
        }

        public int ReadCfgInt(int reg) throws IOException {
            this.pkt.slv_adr = (byte)-1;
            this.pkt.fcn = (byte)100;
            this.pkt.itm_adr = (short)reg;
            this.pkt.itm_qty = 1;
            this.trf.MasterTx(this.pkt);
            try {
                return Integer.decode(this.pkt.s[0]);
            }
            catch (NumberFormatException ne) {
                IOException e = new IOException(err.ILLEGAL_DATA_VALUE.name());
                throw e;
            }
        }

        public String ReadCfgStr(int reg) throws IOException {
            this.pkt.slv_adr = (byte)-1;
            this.pkt.fcn = (byte)100;
            this.pkt.itm_adr = (short)reg;
            this.pkt.itm_qty = 1;
            this.trf.MasterTx(this.pkt);
            return this.pkt.s[0];
        }

        public int WriteCfg(int reg, String val) throws IOException {
            this.pkt.slv_adr = (byte)-1;
            this.pkt.fcn = (byte)101;
            this.pkt.itm_adr = (short)reg;
            this.pkt.itm_qty = 1;
            this.pkt.s[0] = val;
            return this.trf.MasterTx(this.pkt);
        }

        public int WriteCfg(int reg, int val) throws IOException {
            this.pkt.slv_adr = (byte)-1;
            this.pkt.fcn = (byte)101;
            this.pkt.itm_adr = (short)reg;
            this.pkt.itm_qty = 1;
            this.pkt.s[0] = Integer.toString(val);
            return this.trf.MasterTx(this.pkt);
        }
    }

    public static enum err {
        UNKNOWN_ERROR("Unknown Error", 0),
        ILLEGAL_FUNCTION("Illegal Function", 1),
        ILLEGAL_DATA_ADDRESS("Illegal Data Address", 2),
        ILLEGAL_DATA_VALUE("Illegal Data Value", 3),
        SLAVE_DEVICE_FAILURE("Slave Device Failure", 4),
        ACKNOWLEDGE("Acknowledge", 5),
        SLAVE_DEVICE_BUSY("Slave Device Busy", 6),
        NEGATIVE_ACKNOWLEDGE("Negative Acknowledge", 7),
        MEMORY_PARITY_ERROR("Memory Parity Error", 8),
        GATEWAY_NO_PATH("Gateway No Path", 10),
        GATEWAY_TIMEOUT("Gateway Timeout", 11),
        RX_PACKET_CORRUPT("RX Packet Corrupt", 12),
        DATA_RX_ERROR("RX Data Error", 13),
        DATA_TX_ERROR("TX Data Error", 14),
        ILLEGAL_OBJECT_INSTANCE("Illegal Object Instance", 15);

        private String enum_txt;
        private int enum_val;

        private err(String txt, int val) {
            this.enum_txt = txt;
            this.enum_val = val;
        }

        public int getEnum() {
            return this.enum_val;
        }

        public String getText() {
            return this.enum_txt;
        }

        public static String getName(int eval) {
            err[] errArray = err.values();
            int n = errArray.length;
            int n2 = 0;
            while (n2 < n) {
                err e = errArray[n2];
                if (e.enum_val == eval) {
                    return e.name();
                }
                ++n2;
            }
            return UNKNOWN_ERROR.name();
        }

        public static err getObj(String val) {
            try {
                return err.valueOf(val);
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN_ERROR;
            }
        }
    }

    private static class packet {
        public short tran_id;
        public short prot_id;
        public short mbap_len;
        public byte slv_adr;
        public byte fcn;
        public short itm_adr;
        public short itm_qty;
        public byte[] b = new byte[512];
        public short[] w = new short[64];
        public int[] l = new int[32];
        public float[] f = new float[32];
        public String[] s = new String[32];
    }

    public static class regOp32 {
        public boolean float_op;
        public boolean big_endian;
        public short[] w = new short[2];
        public int i;
        public float f;
    }

    private static class transfer {
        static final int MASK8 = 255;
        static final int MASK16 = 65535;
        int BUFFER_SIZE = 512;
        byte protocol = (byte)3;
        int last_char;
        int rx_length;
        int adu_length;
        byte[] rxBuf;
        byte[] xxBuf;
        byte[] txBuf;
        InputStream dis = null;
        OutputStream dos = null;

        private int BinToTx(int length, byte[] src, byte[] dst) {
            int frame_length = 0;
            int src_idx = 0;
            int dst_idx = 0;
            switch (this.protocol) {
                case 2: {
                    dst[dst_idx++] = 16;
                    dst[dst_idx++] = 2;
                    int i = length;
                    while (i > 0) {
                        byte dchar;
                        if ((dchar = src[src_idx++]) == 16) {
                            dst[dst_idx++] = dchar;
                            ++frame_length;
                        }
                        dst[dst_idx++] = dchar;
                        ++frame_length;
                        --i;
                    }
                    dst[dst_idx++] = 16;
                    dst[dst_idx++] = 3;
                    frame_length += 4;
                    break;
                }
                case 3: {
                    System.arraycopy(src, 0, dst, 0, length);
                    frame_length = length;
                    break;
                }
            }
            return frame_length;
        }

        private int RxToBin(int length, byte[] src, byte[] dst) {
            int frame_length = 0;
            switch (this.protocol) {
                case 2: {
                    if (src[0] != 16) {
                        return -1;
                    }
                    if (src[1] != 2) {
                        return -1;
                    }
                    int src_idx = 2;
                    int dst_idx = 0;
                    boolean end_of_packet = false;
                    int last_chr = 0;
                    int i = length -= 2;
                    while (i-- > 0) {
                        int this_chr = src[src_idx++];
                        if (last_chr == 16) {
                            if (this_chr == 16) {
                                dst[dst_idx++] = 16;
                                --length;
                                last_chr = 0;
                                continue;
                            }
                            if (this_chr == 3) {
                                if (i != 0) {
                                    return -1;
                                }
                                end_of_packet = true;
                                continue;
                            }
                            return -1;
                        }
                        if (this_chr == 16) {
                            last_chr = 16;
                            continue;
                        }
                        dst[dst_idx++] = this_chr;
                        last_chr = this_chr;
                    }
                    if (!end_of_packet) {
                        return -1;
                    }
                    frame_length = length - 2;
                    break;
                }
                case 3: {
                    frame_length = length;
                    System.arraycopy(src, 0, dst, 0, length);
                    break;
                }
            }
            return frame_length;
        }

        private void ResetRx() {
            this.last_char = 0;
            this.rx_length = 0;
            this.adu_length = 0;
        }

        private int RxChar(int dchar) {
            this.rxBuf[this.rx_length++] = (byte)dchar;
            block0 : switch (this.protocol) {
                case 2: {
                    switch (this.rx_length) {
                        case 1: {
                            if (dchar == 16) break block0;
                            this.rx_length = 0;
                            dchar = 0;
                            break block0;
                        }
                        case 2: {
                            if (dchar == 2) break block0;
                            this.rx_length = 0;
                            dchar = 0;
                            break block0;
                        }
                    }
                    if (this.last_char != 16) break;
                    if (dchar == 16) {
                        dchar = 0;
                        break;
                    }
                    if (dchar != 3) break;
                    return this.rx_length;
                }
                case 3: {
                    if (this.adu_length == 0) {
                        if (this.rx_length != 6) break;
                        this.adu_length = (this.rxBuf[4] & 0xFF) << 8;
                        this.adu_length += this.rxBuf[5] & 0xFF;
                        this.adu_length += 6;
                        break;
                    }
                    if (this.rx_length < this.adu_length) break;
                    return this.rx_length;
                }
            }
            this.last_char = dchar;
            return 0;
        }

        private void DrainDis() throws IOException {
            while (this.dis.available() != 0) {
                if (this.dis.read() != -1) continue;
                break;
            }
        }

        private int WaitPacket() throws IOException {
            boolean packet_found = false;
            int rx_count = this.dis.read(this.xxBuf);
            if (rx_count < 0) {
                IOException e = new IOException(err.DATA_RX_ERROR.name());
                throw e;
            }
            if (rx_count == this.BUFFER_SIZE) {
                this.DrainDis();
                this.ResetRx();
                IOException e = new IOException(err.DATA_RX_ERROR.name());
                throw e;
            }
            this.ResetRx();
            int i = 0;
            while (i < rx_count) {
                if (this.RxChar(this.xxBuf[i]) != 0) {
                    packet_found = true;
                    break;
                }
                ++i;
            }
            if (!packet_found) {
                this.DrainDis();
                this.ResetRx();
                IOException e = new IOException(err.DATA_RX_ERROR.name());
                throw e;
            }
            return this.rx_length;
        }

        private int BytesToString(byte[] src, int b_idx, packet mex, int s_idx) {
            byte dchar;
            mex.s[s_idx] = "";
            while ((dchar = src[b_idx++]) != 0) {
                int n = s_idx;
                mex.s[n] = String.valueOf(mex.s[n]) + Character.toString((char)dchar);
            }
            return b_idx;
        }

        private int StringToBytes(byte[] dst, int b_idx, packet mex, int s_idx) {
            int length = mex.s[s_idx].length();
            int i = 0;
            while (i < length) {
                dst[b_idx++] = (byte)mex.s[s_idx].charAt(i);
                ++i;
            }
            dst[b_idx++] = 0;
            return b_idx;
        }

        private int MasterTx(packet pkt) throws IOException {
            int frame_length;
            int i;
            byte byte_msk;
            int xx_idx = 0;
            int rx_idx = 0;
            if (this.protocol == 3) {
                this.xxBuf[xx_idx++] = (byte)(pkt.tran_id >> 8);
                this.xxBuf[xx_idx++] = (byte)pkt.tran_id;
                this.xxBuf[xx_idx++] = (byte)(pkt.prot_id >> 8);
                this.xxBuf[xx_idx++] = (byte)pkt.prot_id;
                xx_idx += 2;
            }
            this.xxBuf[xx_idx++] = pkt.slv_adr;
            this.xxBuf[xx_idx++] = pkt.fcn;
            int tmpval = pkt.itm_adr - 1;
            this.xxBuf[xx_idx++] = (byte)(tmpval >> 8);
            this.xxBuf[xx_idx++] = (byte)tmpval;
            switch (pkt.fcn) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.xxBuf[xx_idx++] = (byte)(pkt.itm_qty >> 8);
                    this.xxBuf[xx_idx++] = (byte)pkt.itm_qty;
                    break;
                }
                case 5: {
                    tmpval = pkt.b[0] != 0 ? 65280 : 0;
                    this.xxBuf[xx_idx++] = (byte)(tmpval >> 8);
                    this.xxBuf[xx_idx++] = (byte)tmpval;
                    break;
                }
                case 6: {
                    this.xxBuf[xx_idx++] = (byte)(pkt.w[0] >> 8);
                    this.xxBuf[xx_idx++] = (byte)pkt.w[0];
                    break;
                }
                case 15: {
                    this.xxBuf[xx_idx++] = (byte)(pkt.itm_qty >> 8);
                    this.xxBuf[xx_idx++] = (byte)pkt.itm_qty;
                    byte byte_cnt = (byte)(pkt.itm_qty / 8);
                    if ((pkt.itm_qty & 7) != 0) {
                        byte_cnt = (byte)(byte_cnt + 1);
                    }
                    this.xxBuf[xx_idx++] = byte_cnt;
                    byte byte_val = 0;
                    byte_msk = 1;
                    i = 0;
                    while (i < pkt.itm_qty) {
                        if (pkt.b[i] != 0) {
                            byte_val = (byte)(byte_val | byte_msk);
                        }
                        if (byte_msk == 128) {
                            this.xxBuf[xx_idx++] = byte_val;
                            byte_val = 0;
                            byte_msk = 1;
                            byte_cnt = (byte)(byte_cnt - 1);
                        } else {
                            byte_msk = (byte)(byte_msk << 1);
                        }
                        ++i;
                    }
                    if (byte_cnt == 0) break;
                    this.xxBuf[xx_idx++] = byte_val;
                    break;
                }
                case 16: {
                    this.xxBuf[xx_idx++] = (byte)(pkt.itm_qty >> 8);
                    this.xxBuf[xx_idx++] = (byte)pkt.itm_qty;
                    this.xxBuf[xx_idx++] = (byte)(pkt.itm_qty * 2);
                    i = 0;
                    while (i < pkt.itm_qty) {
                        this.xxBuf[xx_idx++] = (byte)(pkt.w[i] >> 8);
                        this.xxBuf[xx_idx++] = (byte)pkt.w[i];
                        ++i;
                    }
                    break;
                }
                case 100: {
                    this.xxBuf[xx_idx++] = (byte)(pkt.itm_qty >> 8);
                    this.xxBuf[xx_idx++] = (byte)pkt.itm_qty;
                    break;
                }
                case 101: {
                    this.xxBuf[xx_idx++] = (byte)(pkt.itm_qty >> 8);
                    this.xxBuf[xx_idx++] = (byte)pkt.itm_qty;
                    i = 0;
                    while (i < pkt.itm_qty) {
                        xx_idx = this.StringToBytes(this.xxBuf, xx_idx, pkt, i);
                        ++i;
                    }
                    break;
                }
                case 105: {
                    this.xxBuf[xx_idx++] = (byte)(pkt.itm_qty >> 8);
                    this.xxBuf[xx_idx++] = (byte)pkt.itm_qty;
                    i = 0;
                    while (i < pkt.itm_qty) {
                        this.xxBuf[xx_idx++] = (byte)(pkt.l[i] >> 24);
                        this.xxBuf[xx_idx++] = (byte)(pkt.l[i] >> 16);
                        this.xxBuf[xx_idx++] = (byte)(pkt.l[i] >> 8);
                        this.xxBuf[xx_idx++] = (byte)pkt.l[i];
                        ++i;
                    }
                    break;
                }
                case 102: {
                    this.xxBuf[xx_idx++] = (byte)(pkt.itm_qty >> 8);
                    this.xxBuf[xx_idx++] = (byte)pkt.itm_qty;
                    i = 0;
                    while (i < pkt.itm_qty) {
                        this.xxBuf[xx_idx++] = (byte)(pkt.w[i] >> 8);
                        this.xxBuf[xx_idx++] = (byte)pkt.w[i];
                        ++i;
                    }
                    break;
                }
                case 106: 
                case 107: {
                    pkt.itm_qty = (short)(pkt.itm_adr & Short.MAX_VALUE);
                    this.xxBuf[xx_idx++] = (byte)(pkt.l[0] >> 24);
                    this.xxBuf[xx_idx++] = (byte)(pkt.l[0] >> 16);
                    this.xxBuf[xx_idx++] = (byte)(pkt.l[0] >> 8);
                    this.xxBuf[xx_idx++] = (byte)pkt.l[0];
                    this.xxBuf[xx_idx++] = (byte)(pkt.l[1] >> 24);
                    this.xxBuf[xx_idx++] = (byte)(pkt.l[1] >> 16);
                    this.xxBuf[xx_idx++] = (byte)(pkt.l[1] >> 8);
                    this.xxBuf[xx_idx++] = (byte)pkt.l[1];
                    i = 0;
                    while (i < pkt.itm_qty) {
                        this.xxBuf[xx_idx++] = (byte)(pkt.w[i] >> 8);
                        this.xxBuf[xx_idx++] = (byte)pkt.w[i];
                        if (pkt.fcn == 107) {
                            xx_idx = this.StringToBytes(this.xxBuf, xx_idx, pkt, i);
                        }
                        ++i;
                    }
                    break;
                }
                default: {
                    IOException e = new IOException(err.ILLEGAL_FUNCTION.name());
                    throw e;
                }
            }
            if (this.protocol == 3) {
                frame_length = xx_idx - 6;
                this.xxBuf[4] = (byte)(frame_length >> 8);
                this.xxBuf[5] = (byte)frame_length;
            }
            frame_length = this.BinToTx(xx_idx, this.xxBuf, this.txBuf);
            this.dos.write(this.txBuf, 0, frame_length);
            if (pkt.slv_adr == 0) {
                return 0;
            }
            frame_length = this.WaitPacket();
            frame_length = this.RxToBin(frame_length, this.rxBuf, this.rxBuf);
            rx_idx = 0;
            if (this.protocol == 3) {
                pkt.tran_id = (short)(this.rxBuf[rx_idx++] << 8);
                pkt.tran_id = (short)(pkt.tran_id | this.rxBuf[rx_idx++] & 0xFF);
                pkt.prot_id = (short)(this.rxBuf[rx_idx++] << 8);
                pkt.prot_id = (short)(pkt.prot_id | this.rxBuf[rx_idx++] & 0xFF);
                pkt.mbap_len = (short)(this.rxBuf[rx_idx++] << 8);
                pkt.mbap_len = (short)(pkt.mbap_len | this.rxBuf[rx_idx++] & 0xFF);
            }
            pkt.slv_adr = this.rxBuf[rx_idx++];
            pkt.fcn = this.rxBuf[rx_idx++];
            if ((pkt.fcn & 0x80) != 0) {
                IOException e = new IOException(err.getName(this.rxBuf[rx_idx] & 0xFF));
                throw e;
            }
            switch (pkt.fcn) {
                case 5: 
                case 6: 
                case 15: 
                case 16: {
                    break;
                }
                case 1: 
                case 2: {
                    ++rx_idx;
                    byte_msk = 1;
                    i = 0;
                    while (i < pkt.itm_qty) {
                        pkt.b[i] = (this.rxBuf[rx_idx] & byte_msk) != 0 ? (byte)1 : 0;
                        if (byte_msk == 128) {
                            ++rx_idx;
                            byte_msk = 1;
                        } else {
                            byte_msk = (byte)(byte_msk << 1);
                        }
                        ++i;
                    }
                    break;
                }
                case 3: 
                case 4: {
                    ++rx_idx;
                    i = 0;
                    while (i < pkt.itm_qty) {
                        pkt.w[i] = (short)(this.rxBuf[rx_idx++] << 8);
                        int n = i++;
                        pkt.w[n] = (short)(pkt.w[n] | this.rxBuf[rx_idx++] & 0xFF);
                    }
                    break;
                }
                case 100: 
                case 102: {
                    rx_idx += 2;
                    pkt.itm_qty = (short)(this.rxBuf[rx_idx++] << 8);
                    pkt.itm_qty = (short)(pkt.itm_qty | this.rxBuf[rx_idx++] & 0xFF);
                    i = 0;
                    while (i < pkt.itm_qty) {
                        rx_idx = this.BytesToString(this.rxBuf, rx_idx, pkt, i);
                        ++i;
                    }
                    break;
                }
                case 101: {
                    break;
                }
                case 105: {
                    rx_idx += 2;
                    pkt.itm_qty = (short)(this.rxBuf[rx_idx++] << 8);
                    pkt.itm_qty = (short)(pkt.itm_qty | this.rxBuf[rx_idx++] & 0xFF);
                    i = 0;
                    while (i < pkt.itm_qty) {
                        pkt.l[i] = this.rxBuf[rx_idx++] << 24 & 0xFF000000;
                        int n = i;
                        pkt.l[n] = pkt.l[n] | this.rxBuf[rx_idx++] << 16 & 0xFF0000;
                        int n2 = i;
                        pkt.l[n2] = pkt.l[n2] | this.rxBuf[rx_idx++] << 8 & 0xFF00;
                        int n3 = i++;
                        pkt.l[n3] = pkt.l[n3] | this.rxBuf[rx_idx++] & 0xFF;
                    }
                    break;
                }
                case 106: 
                case 107: {
                    if (pkt.fcn == 107) break;
                    pkt.itm_qty = this.rxBuf[rx_idx++];
                    i = 0;
                    while (i < pkt.itm_qty) {
                        rx_idx = this.BytesToString(this.rxBuf, rx_idx, pkt, i);
                        ++i;
                    }
                    break;
                }
            }
            return 0;
        }

        private void SetProtocol(byte mod_protocol) {
            this.protocol = mod_protocol;
        }

        private int GetProtocol() {
            return this.protocol;
        }

        private transfer(InputStream is, OutputStream os) {
            this.dis = is;
            this.dos = os;
            this.rxBuf = new byte[this.BUFFER_SIZE];
            this.xxBuf = new byte[this.BUFFER_SIZE];
            this.txBuf = new byte[this.BUFFER_SIZE];
        }
    }
}

