/*
 * Decompiled with CFR 0.152.
 */
package ModregPanel;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.EtchedBorder;
import modbus.mod;

public class ModregPanel
extends JPanel {
    private ButtonGroup BngEndian = new ButtonGroup();
    private ButtonGroup BngDataType = new ButtonGroup();
    private ButtonGroup BngRegType = new ButtonGroup();
    private JSeparator SepVert;
    private JPanel panel;
    private JLabel valueFormatLabel;
    private JRadioButton RbnBE;
    private JRadioButton RbnLE;
    private JRadioButton RbnFloat;
    private JRadioButton RbnInteger;
    private JRadioButton rbn4x;
    private JRadioButton rbn3x;
    private JRadioButton rbn0x;
    private JLabel statusLabel;
    private JLabel valueLabel;
    private JLabel LblRegister;
    private JLabel LblAddress;
    private JButton BnWrite;
    private JButton BnRead;
    private JTextField EbStatus;
    private JTextField EbValue;
    private JTextField EbRegister;
    private JTextField EbAddress;
    private JTextField EbConnect;
    private JLabel LblConnect;
    private static final long serialVersionUID = 1L;
    private final JLabel Lbl32BitFormat = new JLabel();
    private final JLabel Lbl32BitEndian = new JLabel();
    private final JRadioButton rbn1x = new JRadioButton();
    public static final int MODE_COIL = 0;
    public static final int MODE_16 = 1;
    public static final int MODE_32 = 2;
    public static final int MODE_FLOAT = 3;
    public static final int MODE_STRING = 4;
    private String hostAddress;
    private boolean applet_running = true;
    private boolean connect_task_running = false;
    private mod.device comBas = new mod.device();
    private ConnectTask connect_task = new ConnectTask();
    private JCheckBox ckb32bit;

    public ModregPanel() {
        this.initComponents();
        this.myInit();
    }

    public void Destroy() {
        this.applet_running = false;
        this.comBas.Disconnect();
    }

    public boolean IsConnected() {
        return this.comBas.IsConnected();
    }

    public void Disconnect() {
        this.comBas.Disconnect();
        this.EbAddress.setEditable(false);
        this.EbRegister.setEditable(false);
        this.EbValue.setEditable(false);
        this.BnRead.setEnabled(false);
        this.BnWrite.setEnabled(false);
    }

    public void Connect(String address, boolean start_connect_task) {
        this.hostAddress = address;
        this.comBas.Connect(this.hostAddress, 502, 3);
        if (this.comBas.IsConnected()) {
            this.EbConnect.setText("Connected to target");
            this.EbAddress.setEditable(true);
            this.EbRegister.setEditable(true);
            this.EbValue.setEditable(true);
            this.BnRead.setEnabled(true);
            this.BnWrite.setEnabled(true);
        } else {
            this.EbConnect.setText("Cannot connect to target");
        }
        if (start_connect_task && !this.connect_task_running) {
            this.connect_task.execute();
            this.connect_task_running = true;
        }
    }

    private void Show32(boolean _32Bit) {
        if (_32Bit) {
            this.RbnInteger.setEnabled(true);
            this.RbnFloat.setEnabled(true);
            this.RbnLE.setEnabled(true);
            this.RbnBE.setEnabled(true);
        } else {
            this.RbnInteger.setEnabled(false);
            this.RbnFloat.setEnabled(false);
            this.RbnLE.setEnabled(false);
            this.RbnBE.setEnabled(false);
        }
    }

    private void UpdateRbn() {
        boolean enable32 = false;
        boolean writeEnable = true;
        String regLabel = "Register Number";
        if (this.rbn0x.isSelected()) {
            regLabel = "Coil Number";
        } else if (this.rbn1x.isSelected()) {
            writeEnable = false;
            regLabel = "Input Number";
        } else if (this.rbn3x.isSelected()) {
            writeEnable = false;
            enable32 = true;
        } else if (this.rbn4x.isSelected()) {
            enable32 = true;
        }
        this.ckb32bit.setEnabled(enable32);
        this.Show32(this.ckb32bit.isSelected());
        this.BnWrite.setEnabled(writeEnable);
        this.LblRegister.setText(regLabel);
        this.validate();
        this.repaint();
    }

    private void ErrorMessage(String text) {
        mod.err e = mod.err.getObj(text);
        switch (e) {
            case ILLEGAL_FUNCTION: 
            case ILLEGAL_DATA_ADDRESS: 
            case ILLEGAL_DATA_VALUE: 
            case ILLEGAL_OBJECT_INSTANCE: {
                this.EbStatus.setText(e.getText());
                break;
            }
            default: {
                this.EbStatus.setText(text);
                if (!this.connect_task_running) break;
                this.Disconnect();
            }
        }
    }

    private void ReadVal() {
        mod.regOp32 rp = new mod.regOp32();
        int slv = Integer.decode(this.EbAddress.getText());
        int reg = Integer.decode(this.EbRegister.getText());
        if (!this.comBas.IsConnected()) {
            return;
        }
        if (this.rbn0x.isSelected()) {
            try {
                this.EbValue.setText(Integer.toString(this.comBas.ReadCoil(slv, reg)));
                this.EbStatus.setText("SUCCESS");
            }
            catch (IOException e) {
                this.ErrorMessage(e.getMessage());
            }
        } else if (this.rbn1x.isSelected()) {
            try {
                this.EbValue.setText(Integer.toString(this.comBas.ReadInp(slv, reg)));
                this.EbStatus.setText("SUCCESS");
            }
            catch (IOException e) {
                this.ErrorMessage(e.getMessage());
            }
        } else if (this.rbn3x.isSelected() || this.rbn4x.isSelected()) {
            if (this.ckb32bit.isSelected()) {
                rp.float_op = this.RbnFloat.isSelected();
                rp.big_endian = this.RbnBE.isSelected();
                try {
                    if (this.rbn4x.isSelected()) {
                        this.comBas.ReadRegPair(slv, reg, rp);
                    } else {
                        this.comBas.ReadRegInpPair(slv, reg, rp);
                    }
                    if (this.RbnFloat.isSelected()) {
                        this.EbValue.setText(Float.toString(rp.f));
                    } else {
                        this.EbValue.setText(Integer.toString(rp.i));
                    }
                    this.EbStatus.setText("SUCCESS");
                }
                catch (IOException e) {
                    this.ErrorMessage(e.getMessage());
                }
            } else {
                try {
                    if (this.rbn4x.isSelected()) {
                        int tmp = this.comBas.ReadReg16(slv, reg);
                        this.EbValue.setText(Integer.toString(tmp));
                    } else {
                        int tmp = this.comBas.ReadRegInp16(slv, reg);
                        this.EbValue.setText(Integer.toString(tmp));
                    }
                    this.EbStatus.setText("SUCCESS");
                }
                catch (IOException e) {
                    this.ErrorMessage(e.getMessage());
                }
            }
        } else {
            try {
                this.EbValue.setText(this.comBas.ReadRegStr(slv, reg));
                this.EbStatus.setText("SUCCESS");
            }
            catch (IOException e) {
                this.ErrorMessage(e.getMessage());
            }
        }
    }

    private int[] ParseVal(String val) {
        int[][] strIdx = new int[32][2];
        int val_len = val.length();
        ByteBuffer bbuf = ByteBuffer.wrap(val.getBytes());
        if (val_len == 0) {
            return null;
        }
        int strCnt = 0;
        strIdx[0][0] = 0;
        int i = 0;
        while (i < val_len) {
            if (bbuf.get() == 44) {
                strIdx[strCnt][1] = i;
                if (++strCnt >= strIdx.length) {
                    return null;
                }
                int n = i + 1;
                strIdx[strCnt][1] = n;
                strIdx[strCnt][0] = n;
            }
            ++i;
        }
        strIdx[strCnt][1] = val_len;
        int[] int_val = new int[++strCnt];
        i = 0;
        while (i < strCnt) {
            int tmpVal;
            try {
                tmpVal = Integer.decode(val.substring(strIdx[i][0], strIdx[i][1]));
            }
            catch (NumberFormatException e) {
                return null;
            }
            int_val[i] = tmpVal;
            ++i;
        }
        return int_val;
    }

    private void WriteVal() {
        mod.regOp32 rp = new mod.regOp32();
        int slv = Integer.decode(this.EbAddress.getText());
        int reg = Integer.decode(this.EbRegister.getText());
        if (!this.comBas.IsConnected()) {
            return;
        }
        if (this.rbn0x.isSelected()) {
            int val = Integer.decode(this.EbValue.getText());
            try {
                this.comBas.WriteCoil(slv, reg, val);
                this.EbStatus.setText("SUCCESS");
            }
            catch (IOException e) {
                this.ErrorMessage(e.getMessage());
            }
        } else if (this.rbn4x.isSelected()) {
            if (this.ckb32bit.isSelected()) {
                rp.float_op = this.RbnFloat.isSelected();
                rp.big_endian = this.RbnBE.isSelected();
                if (rp.float_op) {
                    rp.f = Float.parseFloat(this.EbValue.getText());
                } else {
                    rp.i = Integer.parseInt(this.EbValue.getText());
                }
                try {
                    this.comBas.WriteRegPair(slv, reg, rp);
                    this.EbStatus.setText("SUCCESS");
                }
                catch (IOException e) {
                    this.ErrorMessage(e.getMessage());
                }
            } else {
                int[] write_val = this.ParseVal(this.EbValue.getText());
                if (write_val != null) {
                    try {
                        this.comBas.WriteReg16(slv, reg, write_val, write_val.length);
                    }
                    catch (IOException e) {
                        this.ErrorMessage(e.getMessage());
                    }
                } else {
                    this.EbStatus.setText("ERROR: Bad number format");
                }
            }
        } else {
            try {
                this.comBas.WriteReg(slv, reg, this.EbValue.getText());
                this.EbStatus.setText("SUCCESS");
            }
            catch (IOException e) {
                this.ErrorMessage(e.getMessage());
            }
        }
    }

    private void myInit() {
        this.RbnInteger.setEnabled(false);
        this.RbnFloat.setEnabled(false);
        this.RbnLE.setEnabled(false);
        this.RbnBE.setEnabled(false);
        this.BnRead.setEnabled(false);
        this.BnWrite.setEnabled(false);
    }

    private void initComponents() {
        this.setLayout(null);
        this.EbAddress = new JTextField();
        this.EbAddress.setEditable(false);
        this.EbAddress.setText("1");
        this.EbAddress.setBounds(10, 128, 125, 25);
        this.add(this.EbAddress);
        this.EbRegister = new JTextField();
        this.EbRegister.setEditable(false);
        this.EbRegister.setText("1");
        this.EbRegister.setBounds(10, 179, 125, 25);
        this.add(this.EbRegister);
        this.EbValue = new JTextField();
        this.EbValue.setEditable(false);
        this.EbValue.setBounds(10, 230, 125, 25);
        this.add(this.EbValue);
        this.EbStatus = new JTextField();
        this.EbStatus.setBounds(10, 298, 440, 25);
        this.add(this.EbStatus);
        this.BnRead = new JButton();
        this.BnRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ModregPanel.this.ReadVal();
            }
        });
        this.BnRead.setFont(new Font("Sans", 0, 12));
        this.BnRead.setText("READ");
        this.BnRead.setBounds(151, 261, 122, 25);
        this.add(this.BnRead);
        this.BnWrite = new JButton();
        this.BnWrite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ModregPanel.this.WriteVal();
            }
        });
        this.BnWrite.setFont(new Font("Sans", 0, 12));
        this.BnWrite.setText("WRITE");
        this.BnWrite.setBounds(329, 261, 122, 25);
        this.add(this.BnWrite);
        this.LblAddress = new JLabel();
        this.LblAddress.setFont(new Font("Sans", 0, 12));
        this.LblAddress.setText("Slave Address");
        this.LblAddress.setBounds(10, 108, 122, 14);
        this.add(this.LblAddress);
        this.LblRegister = new JLabel();
        this.LblRegister.setFont(new Font("Sans", 0, 12));
        this.LblRegister.setText("Register Number");
        this.LblRegister.setBounds(10, 159, 125, 14);
        this.add(this.LblRegister);
        this.valueLabel = new JLabel();
        this.valueLabel.setFont(new Font("Sans", 0, 12));
        this.valueLabel.setText("Value");
        this.valueLabel.setBounds(10, 210, 77, 14);
        this.add(this.valueLabel);
        this.statusLabel = new JLabel();
        this.statusLabel.setFont(new Font("Sans", 0, 12));
        this.statusLabel.setText("Status");
        this.statusLabel.setBounds(10, 278, 77, 14);
        this.add(this.statusLabel);
        this.valueFormatLabel = new JLabel();
        this.valueFormatLabel.setHorizontalAlignment(0);
        this.valueFormatLabel.setAlignmentX(0.5f);
        this.valueFormatLabel.setText("Value Format");
        this.valueFormatLabel.setBounds(151, 28, 261, 14);
        this.add(this.valueFormatLabel);
        this.panel = new JPanel();
        this.panel.setLayout(null);
        this.panel.setBorder(new EtchedBorder(1));
        this.panel.setBounds(151, 48, 300, 207);
        this.add(this.panel);
        this.RbnInteger = new JRadioButton();
        this.RbnInteger.setSelected(true);
        this.BngDataType.add(this.RbnInteger);
        this.RbnInteger.setBounds(188, 37, 104, 22);
        this.panel.add(this.RbnInteger);
        this.RbnInteger.setFont(new Font("Sans", 0, 12));
        this.RbnInteger.setText("Integer");
        this.RbnFloat = new JRadioButton();
        this.BngDataType.add(this.RbnFloat);
        this.RbnFloat.setBounds(188, 72, 104, 22);
        this.panel.add(this.RbnFloat);
        this.RbnFloat.setFont(new Font("Sans", 0, 12));
        this.RbnFloat.setText("Float");
        this.RbnLE = new JRadioButton();
        this.RbnLE.setSelected(true);
        this.BngEndian.add(this.RbnLE);
        this.RbnLE.setBounds(188, 134, 104, 22);
        this.panel.add(this.RbnLE);
        this.RbnLE.setFont(new Font("Sans", 0, 12));
        this.RbnLE.setText("LOW : HIGH");
        this.RbnBE = new JRadioButton();
        this.BngEndian.add(this.RbnBE);
        this.RbnBE.setBounds(188, 169, 104, 22);
        this.panel.add(this.RbnBE);
        this.RbnBE.setFont(new Font("Sans", 0, 12));
        this.RbnBE.setText("HIGH : LOW");
        this.rbn0x = new JRadioButton();
        this.rbn0x.setToolTipText("Modbus 0x Coil (Read-Write)");
        this.rbn0x.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ModregPanel.this.UpdateRbn();
            }
        });
        this.BngRegType.add(this.rbn0x);
        this.rbn0x.setBounds(10, 10, 140, 22);
        this.panel.add(this.rbn0x);
        this.rbn0x.setFont(new Font("Sans", 0, 12));
        this.rbn0x.setText("0X:Coil");
        this.rbn3x = new JRadioButton();
        this.rbn3x.setToolTipText("Modbus 3x Input Register(s) (Read-Only)");
        this.rbn3x.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ModregPanel.this.UpdateRbn();
            }
        });
        this.BngRegType.add(this.rbn3x);
        this.rbn3x.setBounds(10, 75, 140, 22);
        this.panel.add(this.rbn3x);
        this.rbn3x.setFont(new Font("Sans", 0, 12));
        this.rbn3x.setText("3X:Input Reg");
        this.rbn4x = new JRadioButton();
        this.rbn4x.setSelected(true);
        this.rbn4x.setToolTipText("Modbus 4x Holding Register(s) (Read-Write)");
        this.BngRegType.add(this.rbn4x);
        this.rbn4x.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ModregPanel.this.UpdateRbn();
            }
        });
        this.rbn4x.setBounds(10, 106, 140, 22);
        this.panel.add(this.rbn4x);
        this.rbn4x.setFont(new Font("Sans", 0, 12));
        this.rbn4x.setText("4X:Holding Reg");
        this.SepVert = new JSeparator();
        this.SepVert.setOrientation(1);
        this.SepVert.setBounds(159, 0, 11, 207);
        this.panel.add(this.SepVert);
        this.panel.add(this.Lbl32BitFormat);
        this.Lbl32BitFormat.setFont(new Font("Dialog", 0, 12));
        this.Lbl32BitFormat.setText("32-Bit Format");
        this.Lbl32BitFormat.setBounds(188, 10, 104, 14);
        this.panel.add(this.Lbl32BitEndian);
        this.Lbl32BitEndian.setFont(new Font("Dialog", 0, 12));
        this.Lbl32BitEndian.setText("32-Bit Endian");
        this.Lbl32BitEndian.setBounds(188, 107, 104, 14);
        this.panel.add(this.rbn1x);
        this.rbn1x.setToolTipText("Modbus 1x Input (Read-Only)");
        this.rbn1x.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ModregPanel.this.UpdateRbn();
            }
        });
        this.BngRegType.add(this.rbn1x);
        this.rbn1x.setFont(new Font("Dialog", 0, 12));
        this.rbn1x.setText("1X:Discrete Input");
        this.rbn1x.setBounds(10, 40, 140, 22);
        this.ckb32bit = new JCheckBox("32-bit");
        this.ckb32bit.setToolTipText("Two Modbus Registers used as one value");
        this.ckb32bit.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (ModregPanel.this.ckb32bit.isSelected()) {
                    ModregPanel.this.Show32(true);
                } else {
                    ModregPanel.this.Show32(false);
                }
            }
        });
        this.ckb32bit.setFont(new Font("Dialog", 0, 12));
        this.ckb32bit.setBounds(10, 137, 140, 23);
        this.panel.add(this.ckb32bit);
        this.LblConnect = new JLabel();
        this.LblConnect.setFont(new Font("Dialog", 0, 12));
        this.LblConnect.setText("Connect Status");
        this.LblConnect.setBounds(10, 48, 122, 14);
        this.add(this.LblConnect);
        this.EbConnect = new JTextField();
        this.EbConnect.setText("Not Connected");
        this.EbConnect.setEditable(false);
        this.EbConnect.setBounds(10, 68, 125, 25);
        this.add(this.EbConnect);
    }

    public class ConnectTask
    extends SwingWorker<Void, Void> {
        @Override
        public Void doInBackground() {
            while (ModregPanel.this.applet_running) {
                if (!ModregPanel.this.comBas.IsConnected()) {
                    ModregPanel.this.comBas.Connect(ModregPanel.this.hostAddress, 502, 3);
                    if (ModregPanel.this.comBas.IsConnected()) {
                        ModregPanel.this.EbAddress.setEditable(true);
                        ModregPanel.this.EbRegister.setEditable(true);
                        ModregPanel.this.EbValue.setEditable(true);
                        ModregPanel.this.BnRead.setEnabled(true);
                        ModregPanel.this.BnWrite.setEnabled(true);
                        ModregPanel.this.EbConnect.setText("Connected to target");
                    }
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

