/*
 * Decompiled with CFR 0.152.
 */
package sedona.util;

public class VendorUtil {
    public static void checkVendorName(String string) throws Exception {
        if (string.length() == 0) {
            throw new Exception("Invalid vendor name '" + string + "' (size is zero)");
        }
        if (string.length() > 32) {
            throw new Exception("Invalid vendor name '" + string + "' (size > 32 chars)");
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9')) {
                throw new Exception("Invalid vendor name '" + string + "' (must be allphanumeric)");
            }
            ++n;
        }
    }

    public static void checkPlatformPrefix(String string, String string2) throws Exception {
        if (string2 == null) {
            return;
        }
        String string3 = string.toLowerCase() + '-';
        if (!string2.startsWith(string3)) {
            throw new Exception("Platform id must be prefixed with '" + string3 + "' (case-sensitive)");
        }
    }
}

