/*
 * Decompiled with CFR 0.152.
 */
package sedonac.ast;

import java.util.ArrayList;
import java.util.HashMap;
import sedonac.Location;
import sedonac.ast.AstVisitor;
import sedonac.ast.AstWriter;
import sedonac.ast.Block;
import sedonac.ast.FacetDef;
import sedonac.ast.FacetsNode;
import sedonac.ast.FieldDef;
import sedonac.ast.KitDef;
import sedonac.ast.MethodDef;
import sedonac.ast.ParamDef;
import sedonac.ast.SlotDef;
import sedonac.ir.IrType;
import sedonac.namespace.ArrayType;
import sedonac.namespace.Kit;
import sedonac.namespace.Namespace;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;
import sedonac.namespace.TypeUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TypeDef
extends FacetsNode
implements Type {
    public KitDef kit;
    public int flags;
    public String name;
    public String qname;
    public Type base;
    public String doc;
    public FacetDef[] facets;
    public int id;
    public SlotDef[] reflectiveSlots;
    public IrType ir;
    private ArrayList slots;
    private HashMap slotsByName;

    public Kit kit() {
        return this.kit;
    }

    public String name() {
        return this.name;
    }

    public String qname() {
        return this.qname;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isRef() {
        return true;
    }

    public boolean isNullable() {
        return true;
    }

    public boolean isArray() {
        return false;
    }

    public Type arrayOf() {
        throw new UnsupportedOperationException();
    }

    public ArrayType.Len arrayLength() {
        throw new UnsupportedOperationException();
    }

    public String signature() {
        return this.qname;
    }

    public int sizeof() {
        return TypeUtil.ir(this).sizeof();
    }

    public Type base() {
        return this.base;
    }

    public boolean is(Type type) {
        return TypeUtil.is(this, type);
    }

    public boolean equals(Object object) {
        return TypeUtil.equals(this, object);
    }

    public int hashCode() {
        return this.signature().hashCode();
    }

    public String toString() {
        return this.signature();
    }

    public boolean isObj() {
        return this.qname.equals("sys::Obj");
    }

    public boolean isComponent() {
        return this.qname.equals("sys::Component");
    }

    public boolean isaComponent() {
        return TypeUtil.isaComponent(this);
    }

    public boolean isVirtual() {
        return this.qname.equals("sys::Virtual");
    }

    public boolean isaVirtual() {
        return TypeUtil.isaVirtual(this);
    }

    public boolean isBuf() {
        return this.qname.equals("sys::Buf");
    }

    public boolean isLog() {
        return this.qname.equals("sys::Log");
    }

    public boolean isStr() {
        return this.qname.equals("sys::Str");
    }

    public boolean isType() {
        return this.qname.equals("sys::Type");
    }

    public boolean isBool() {
        return false;
    }

    public boolean isByte() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isInt() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isShort() {
        return false;
    }

    public boolean isVoid() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isNumeric() {
        return false;
    }

    public boolean isWide() {
        return false;
    }

    public boolean isReflective() {
        return TypeUtil.isReflective(this);
    }

    public int id() {
        if (this.id < 0) {
            throw new IllegalStateException(this.qname);
        }
        return this.id;
    }

    public Slot[] slots() {
        return this.slots.toArray(new Slot[this.slots.size()]);
    }

    public Slot[] declared() {
        return this.slotDefs();
    }

    public Slot slot(String string) {
        return (Slot)this.slotsByName.get(string);
    }

    public void addSlot(Slot slot) {
        String string = slot.name();
        if (this.slotsByName.containsKey(string)) {
            throw new IllegalStateException(slot.qname());
        }
        this.slots.add(slot);
        this.slotsByName.put(string, slot);
    }

    public int flags() {
        return this.flags;
    }

    public boolean isAbstract() {
        boolean bl = false;
        if ((this.flags & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isConst() {
        boolean bl = false;
        if ((this.flags & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isFinal() {
        boolean bl = false;
        if ((this.flags & 4) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isInternal() {
        boolean bl = false;
        if ((this.flags & 8) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isPublic() {
        boolean bl = false;
        if ((this.flags & 0x10) != 0) {
            bl = true;
        }
        return bl;
    }

    public SlotDef[] slotDefs() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.slots.size()) {
            Slot slot = (Slot)this.slots.get(n);
            if (slot.parent() == this) {
                arrayList.add(this.slots.get(n));
            }
            ++n;
        }
        return arrayList.toArray(new SlotDef[arrayList.size()]);
    }

    public MethodDef[] methodDefs() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.slots.size()) {
            if (this.slots.get(n) instanceof MethodDef) {
                arrayList.add(this.slots.get(n));
            }
            ++n;
        }
        return arrayList.toArray(new MethodDef[arrayList.size()]);
    }

    public FieldDef[] fieldDefs() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.slots.size()) {
            if (this.slots.get(n) instanceof FieldDef) {
                arrayList.add(this.slots.get(n));
            }
            ++n;
        }
        return arrayList.toArray(new FieldDef[arrayList.size()]);
    }

    public MethodDef makeInstanceInit(Namespace namespace) {
        String string = "_iInit";
        MethodDef methodDef = (MethodDef)this.slotsByName.get(string);
        if (methodDef == null) {
            int n = 0;
            methodDef = new MethodDef(this.loc, this, n, string, FacetDef.empty, namespace.voidType, new ParamDef[0], new Block(this.loc));
            methodDef.synthetic = true;
            this.addSlot(methodDef);
        }
        return methodDef;
    }

    public MethodDef makeStaticInit(Namespace namespace) {
        String string = "_sInit";
        MethodDef methodDef = (MethodDef)this.slotsByName.get(string);
        if (methodDef == null) {
            int n = 4096;
            methodDef = new MethodDef(this.loc, this, n, string, FacetDef.empty, namespace.voidType, new ParamDef[0], new Block(this.loc));
            methodDef.synthetic = true;
            this.addSlot(methodDef);
        }
        return methodDef;
    }

    public void walk(AstVisitor astVisitor, int n) {
        astVisitor.enterType(this);
        if (this.base != null) {
            this.base = astVisitor.type(this.base);
        }
        this.walkFacets(astVisitor, n);
        if (n >= 2) {
            int n2 = 0;
            while (n2 < this.slots.size()) {
                Slot slot = (Slot)this.slots.get(n2);
                if (slot.parent() == this) {
                    ((SlotDef)this.slots.get(n2)).walk(astVisitor, n);
                }
                ++n2;
            }
        }
        astVisitor.exitType(this);
    }

    public void write(AstWriter astWriter) {
        astWriter.w("class ").w(this.qname).nl();
        astWriter.w("{").nl();
        int n = 0;
        while (n < this.slots.size()) {
            if (this.slots.get(n) instanceof SlotDef) {
                if (n > 0) {
                    astWriter.nl();
                }
                ++astWriter.indent;
                ((SlotDef)this.slots.get(n)).write(astWriter);
                --astWriter.indent;
            }
            ++n;
        }
        astWriter.w("}").nl();
    }

    private final /* synthetic */ void this() {
        this.id = -1;
        this.slots = new ArrayList();
        this.slotsByName = new HashMap();
    }

    public TypeDef(Location location, KitDef kitDef, int n, String string, FacetDef[] facetDefArray) {
        super(location, facetDefArray);
        this.this();
        this.kit = kitDef;
        this.flags = n;
        this.name = string;
        this.qname = kitDef.name + "::" + string;
        this.id = TypeUtil.predefinedId(this.qname);
    }
}

