/*
 * Decompiled with CFR 0.152.
 */
package sedonac.ast;

import sedonac.Location;
import sedonac.ast.AstVisitor;
import sedonac.ast.AstWriter;
import sedonac.ast.Block;
import sedonac.ast.FacetDef;
import sedonac.ast.ParamDef;
import sedonac.ast.SlotDef;
import sedonac.ast.TypeDef;
import sedonac.namespace.Method;
import sedonac.namespace.Namespace;
import sedonac.namespace.NativeId;
import sedonac.namespace.Type;
import sedonac.namespace.TypeUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MethodDef
extends SlotDef
implements Method {
    public ParamDef[] params;
    public Type ret;
    public Block code;
    public int maxLocals;
    public NativeId nativeId;
    public int initStmtIndex;

    public boolean isField() {
        return false;
    }

    public boolean isMethod() {
        return true;
    }

    public Type returnType() {
        return this.ret;
    }

    public Type[] paramTypes() {
        Type[] typeArray = new Type[this.params.length];
        int n = 0;
        while (n < this.params.length) {
            typeArray[n] = this.params[n].type;
            ++n;
        }
        return typeArray;
    }

    public Type actionType(Namespace namespace) {
        if (this.params.length == 0) {
            return namespace.voidType;
        }
        return this.params[0].type;
    }

    public int numParams() {
        return TypeUtil.numParams(this);
    }

    public boolean isInstanceInit() {
        return this.name.equals("_iInit");
    }

    public boolean isStaticInit() {
        return this.name.equals("_sInit");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isStatic()) {
            stringBuffer.append("static ");
        }
        stringBuffer.append(this.ret).append(' ').append(this.name).append('(');
        int n = 0;
        while (n < this.params.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.params[n]);
            ++n;
        }
        return stringBuffer.append(')').toString();
    }

    public void walk(AstVisitor astVisitor, int n) {
        astVisitor.enterMethod(this);
        this.walkFacets(astVisitor, n);
        this.ret = astVisitor.type(this.ret);
        int n2 = 0;
        while (n2 < this.params.length) {
            this.params[n2].walk(astVisitor);
            ++n2;
        }
        if (n >= 3 && this.code != null) {
            this.code.walk(astVisitor);
        }
        astVisitor.exitMethod(this);
    }

    public void write(AstWriter astWriter) {
        astWriter.indent().w(this).nl();
        if (this.code != null) {
            this.code.write(astWriter);
        }
    }

    private final /* synthetic */ void this() {
        this.initStmtIndex = 0;
    }

    public MethodDef(Location location, TypeDef typeDef, int n, String string, FacetDef[] facetDefArray, Type type, ParamDef[] paramDefArray, Block block) {
        super(location, typeDef, n, string, facetDefArray);
        this.this();
        this.ret = type;
        this.params = paramDefArray;
        this.code = block;
    }
}

