/*
 * Decompiled with CFR 0.152.
 */
package sedonac.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import sedona.Buf;
import sedona.KitPart;
import sedona.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SCodeParser {
    Buf buf;
    public boolean bigEndian;
    public int majorVer;
    public int minorVer;
    public int blockSize;
    public int refSize;
    public int imageSize;
    public int dataSize;
    public int mainMethod;
    public int scodeFlags;
    public KitPart[] kits;

    public KitPart[] parse(File file) throws IOException {
        return this.parse(Buf.readFrom((File)file));
    }

    public KitPart[] parse(Buf buf) throws IOException {
        this.buf = buf;
        buf.pos = 0;
        if (buf.i4() != 1590737415) {
            buf.pos = 0;
            this.bigEndian = false;
            buf.bigEndian = false;
            if (buf.i4() != 1590737415) {
                throw new IOException("Invalid magic for scode");
            }
        }
        this.majorVer = buf.u1();
        this.minorVer = buf.u1();
        this.blockSize = buf.u1();
        this.refSize = buf.u1();
        this.imageSize = buf.i4();
        this.dataSize = buf.i4();
        this.mainMethod = buf.u2();
        buf.u2();
        int n = buf.u2();
        int n2 = buf.u1();
        this.scodeFlags = buf.u1();
        if (this.majorVer != 1 || this.minorVer != 5) {
            throw new IOException("Unsupported scode version " + this.majorVer + '.' + this.minorVer);
        }
        KitPart[] kitPartArray = new KitPart[n2];
        int n3 = 0;
        while (n3 < n2) {
            buf.pos = n * this.blockSize + n3 * 2;
            kitPartArray[n3] = this.parseKit(buf.u2());
            ++n3;
        }
        this.kits = kitPartArray;
        return kitPartArray;
    }

    private final KitPart parseKit(int n) throws IOException {
        this.buf.pos = n * this.blockSize;
        int n2 = this.buf.u1();
        int n3 = this.buf.u1();
        String string = this.parseStr(this.buf.u2());
        String string2 = this.parseStr(this.buf.u2());
        int n4 = this.buf.u2();
        int n5 = this.buf.i4();
        return new KitPart(string, n5, Version.parse((String)string2));
    }

    private final String parseStr(int n) throws IOException {
        int n2 = n * this.blockSize;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (this.buf.bytes[n2 + n3] != 0) {
            stringBuffer.append((char)this.buf.bytes[n2 + n3]);
            ++n3;
        }
        return stringBuffer.toString();
    }

    public void dump() {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.dump(printWriter);
        printWriter.flush();
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("  majorVer:   " + this.majorVer);
        printWriter.println("  minorVer :  " + this.minorVer);
        printWriter.println("  endian:     " + (this.bigEndian ? "big" : "little"));
        printWriter.println("  blockSize:  " + this.blockSize);
        printWriter.println("  refSize:    " + this.refSize);
        printWriter.println("  imageSize:  " + this.imageSize);
        printWriter.println("  dataSize:   " + this.dataSize);
        printWriter.println("  scodeFlags: 0x" + Integer.toHexString(this.scodeFlags));
        StringBuffer stringBuffer = new StringBuffer("    debug:    ");
        boolean bl = false;
        if ((this.scodeFlags & 1) != 0) {
            bl = true;
        }
        printWriter.println(stringBuffer.append(bl).toString());
        StringBuffer stringBuffer2 = new StringBuffer("    test:     ");
        boolean bl2 = false;
        if ((this.scodeFlags & 2) != 0) {
            bl2 = true;
        }
        printWriter.println(stringBuffer2.append(bl2).toString());
        printWriter.println("  kits:");
        int n = 0;
        while (n < this.kits.length) {
            printWriter.println("    " + this.kits[n] + ' ' + this.kits[n].version);
            ++n;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("usage: SCodeParser <file>");
            return;
        }
        SCodeParser sCodeParser = new SCodeParser();
        sCodeParser.parse(new File(stringArray[0]));
        sCodeParser.dump();
    }

    private final /* synthetic */ void this() {
        this.bigEndian = true;
    }

    public SCodeParser() {
        this.this();
    }
}

