/*
 * Decompiled with CFR 0.152.
 */
package sedonac.analysis;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.ast.AstNode;
import sedonac.ast.Expr;
import sedonac.ast.FacetsNode;
import sedonac.ast.FieldDef;
import sedonac.ast.MethodDef;
import sedonac.ast.SlotDef;
import sedonac.ast.TypeDef;
import sedonac.namespace.Field;
import sedonac.namespace.Method;
import sedonac.namespace.Type;

public class UnusedCodeAnalysis
extends CompilerStep {
    private HashMap refs;

    public void run() {
        this.refs = new HashMap();
        this.walkAst(3);
        this.logUnused();
        this.refs = null;
    }

    public void enterType(TypeDef typeDef) {
        super.enterType(typeDef);
        if (typeDef.isInternal() && !this.refs.containsKey(typeDef)) {
            this.refs.put(typeDef, null);
        }
    }

    public void enterMethod(MethodDef methodDef) {
        super.enterMethod(methodDef);
        if ((methodDef.isInternal() || methodDef.isPrivate()) && !this.refs.containsKey(methodDef)) {
            this.refs.put(methodDef, null);
        }
        if (methodDef.qname().equals("sys::Sys.malloc") || methodDef.qname().equals("sys::Sys.free")) {
            this.refs.put(methodDef, methodDef);
        }
    }

    public void enterField(FieldDef fieldDef) {
        super.enterField(fieldDef);
        if ((fieldDef.isInternal() || fieldDef.isPrivate()) && !this.refs.containsKey(fieldDef)) {
            this.refs.put(fieldDef, null);
        }
        this.markReferenced(fieldDef.type);
    }

    public Expr expr(Expr expr) {
        switch (expr.id) {
            case 65: {
                this.markReferenced(((Expr.Call)expr).method);
                break;
            }
            case 66: {
                this.markReferenced(((Expr.Cast)expr).type);
                break;
            }
            case 63: {
                this.markReferenced(((Expr.Field)expr).field);
                break;
            }
            case 60: {
                this.markReferenced(((Expr.Local)expr).type);
                break;
            }
            case 12: {
                this.markReferenced(((Expr.Literal)expr).asSlot().parent());
                break;
            }
            case 70: {
                this.markReferenced(expr.type);
                break;
            }
            case 11: {
                this.markReferenced(((Expr.Literal)expr).asType());
                break;
            }
        }
        return super.expr(expr);
    }

    private final void markReferenced(Type type) {
        if (type == null || !type.isInternal() || !(type instanceof TypeDef)) {
            return;
        }
        this.refs.put(type, type);
    }

    private final void markReferenced(Method method) {
        if (method == null || method.isPublic() || method.isProtected() || !(method instanceof MethodDef)) {
            return;
        }
        this.refs.put(method, method);
    }

    private final void markReferenced(Field field) {
        if (field == null || field.isPublic() || field.isProtected() || !(field instanceof FieldDef)) {
            return;
        }
        if (this.curMethod != null && this.curMethod.isInstanceInit()) {
            return;
        }
        this.refs.put(field, field);
    }

    private final void logUnused() {
        AstNode[] astNodeArray = this.refs.keySet().toArray(new AstNode[this.refs.size()]);
        Arrays.sort(astNodeArray, new Comparator(){

            public final int compare(Object object, Object object2) {
                return ((AstNode)object).loc.compareTo(((AstNode)object2).loc);
            }
        });
        int n = 0;
        while (n < astNodeArray.length) {
            AstNode astNode = astNodeArray[n];
            if (this.refs.get(astNode) == null) {
                FacetsNode facetsNode;
                if (astNode instanceof TypeDef) {
                    facetsNode = (TypeDef)astNode;
                    this.warn("internal class '" + ((TypeDef)facetsNode).qname() + "' is not used", ((TypeDef)facetsNode).loc);
                } else if (astNode instanceof MethodDef) {
                    facetsNode = (MethodDef)astNode;
                    String string = ((SlotDef)facetsNode).isInternal() ? "internal" : "private";
                    this.warn(string + " method '" + ((SlotDef)facetsNode).qname() + "' is not used", ((MethodDef)facetsNode).loc);
                }
            }
            ++n;
        }
    }

    public void exitMethod(MethodDef methodDef) {
        this.markReferenced(methodDef.ret);
        Type[] typeArray = methodDef.paramTypes();
        int n = 0;
        while (n < typeArray.length) {
            this.markReferenced(typeArray[n]);
            ++n;
        }
        super.exitMethod(methodDef);
    }

    public UnusedCodeAnalysis(Compiler compiler) {
        super(compiler);
    }
}

