/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wb.jenser.tool;

import com.tridium.platSerial.BSerialPortPlatformService;
import com.tridium.sys.Nre;
import javax.baja.sys.BComponent;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class SerialHelper {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BSerialPortPlatformService getSerialService() throws Exception {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("sun.arch.data.model");
        Type type = null;
        if (string.toLowerCase().indexOf("win") > -1) {
            if ("32".equals(string2)) {
                type = Sys.getType((String)"platSerialWin32:SerialPortPlatformServiceWin32");
            } else {
                if (!"64".equals(string2)) throw new UnsupportedOperationException("unsupported data model: " + string2);
                type = Sys.getType((String)"platSerialWin64:SerialPortPlatformServiceWin64");
            }
        } else if (string.toLowerCase().indexOf("linux") > -1) {
            throw new UnsupportedOperationException("Linux Serial service not supported.");
        }
        if (type == null) {
            throw new UnsupportedOperationException("No serial service is available for OS: " + string);
        }
        BSerialPortPlatformService bSerialPortPlatformService = null;
        try {
            return (BSerialPortPlatformService)Nre.serviceManager.getService(type.getTypeSpec().toString());
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            bSerialPortPlatformService = (BSerialPortPlatformService)type.getInstance();
            Nre.serviceManager.register((BComponent)bSerialPortPlatformService);
            bSerialPortPlatformService.start();
            bSerialPortPlatformService.checkPropertiesLoaded();
        }
        return bSerialPortPlatformService;
    }
}

