/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wb.jenser.tool;

import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.wb.jenser.tool.BPortType;
import com.tridium.wb.jenser.tool.BWbJenserTool;
import com.tridium.wb.jenser.tool.ports.BCoordinatorPort;
import com.tridium.wb.jenser.tool.ports.BFlasherPort;
import com.tridium.wb.jenser.tool.ports.BUnknownPort;
import com.tridium.wb.jenser.tool.ports.BWbJenserPort;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.util.HashMap;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.tool.BWbService;
import javax.baja.workbench.view.BWbView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BConfigurationView
extends BWbView {
    public static final Action jenserStateChanged = BConfigurationView.newAction((int)0, null);
    public static final Action selectionModified = BConfigurationView.newAction((int)0, null);
    public static final Action listItemSelected = BConfigurationView.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE;
    private static int lastSelected;
    public static final Lexicon lex;
    static final BImage serialPortIcon;
    static final BBrush mouseFocusBg;
    static final BBrush mouseFocusBorder;
    private static BBoolean viewLock;
    public final String lexAutoStart;
    public final String lexConnectSettings;
    public final String lexCurrentSettings;
    public final String lexEnablingCoord;
    public final String lexToolNotRunning;
    public final String lexNeedWizard;
    public final String lexNotLicensed;
    public final String lexOpeningCoord;
    public final String lexPortName;
    public final String lexPortType;
    public final String lexReadingChannel;
    public final String lexReadingConfig;
    public final String lexReadingPanId;
    public final String lexReadingDiag;
    public final String lexRestartCoord;
    public final String lexWritingConfig;
    BWbJenserTool tool;
    PortModel portModel;
    BWbJenserPort selectedPort;
    private BEdgePane content;
    private BSplitPane split;
    private BLabel state;
    private BToolBar toolbar;
    private Command startMgrCmd;
    private Command stopMgrCmd;
    private HashMap portToView;
    static /* synthetic */ Class class$com$tridium$wb$jenser$tool$BConfigurationView;

    public void jenserStateChanged() {
        this.invoke(jenserStateChanged, null, null);
    }

    public void selectionModified() {
        this.invoke(selectionModified, null, null);
    }

    public void listItemSelected(BWidgetEvent bWidgetEvent) {
        this.invoke(listItemSelected, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        super.doLoadValue(bObject, context);
        BBoolean bBoolean = viewLock;
        synchronized (bBoolean) {
            if (viewLock.getBoolean()) {
                throw new Exception("You can only have one instance of the Configuration View open at a time");
            }
            viewLock = BBoolean.TRUE;
        }
        this.tool = (BWbJenserTool)bObject;
        this.portToView = new HashMap();
        this.content = new BEdgePane();
        this.content.setTop((BWidget)new BBorderPane(this.makeStateView(context), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)2, (double)0.0)));
        this.split = new BSplitPane(BOrientation.vertical, 20.0);
        this.split.setWidget1(this.makePortTable());
        this.split.setWidget2(this.makeEmptyView());
        this.content.setCenter((BWidget)this.split);
        this.linkTo((BComponent)this.tool, (Slot)BWbJenserTool.stateChanged, (Slot)jenserStateChanged);
        this.portModel.getSelection().select(lastSelected);
        this.setContent((BWidget)this.content);
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws CannotSaveException, Exception {
        if (this.selectedPort != null) {
            this.selectedPort.doSaveValue(this, bObject, context);
        }
        return super.doSaveValue(bObject, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deactivated() {
        block4: {
            super.deactivated();
            BBoolean bBoolean = viewLock;
            synchronized (bBoolean) {
                if (this.tool != null) {
                    viewLock = BBoolean.FALSE;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
                if (this.portModel == null) break block4;
            }
            lastSelected = this.portModel.getSelection().getRow();
        }
    }

    protected BWbJenserPort[] ports() {
        return this.tool.config == null ? new BWbJenserPort[]{} : this.tool.config.getJenserPorts();
    }

    public void updateCurrentView(BWidget bWidget) {
        this.portToView.put(this.selectedPort, bWidget);
        this.split.setWidget2(bWidget);
    }

    protected BWidget makeEmptyView() {
        Object object = null;
        object = this.tool.isToolRunning() ? new BNullWidget() : (this.tool.isFailed() && !this.tool.licensed ? new BLabel(this.lexNotLicensed) : new BLabel(this.lexToolNotRunning));
        BBorderPane bBorderPane = new BBorderPane((BWidget)object, BBorder.solid);
        bBorderPane.setFill(Theme.widget().getWindowBackground());
        return new BBorderPane((BWidget)bBorderPane, BBorder.inset, BInsets.DEFAULT);
    }

    protected BWidget makeStateView(Context context) {
        BGridPane bGridPane = new BGridPane(3);
        bGridPane.setHalign(BHalign.left);
        this.state = new BLabel(this.tool.stateToIcon(), this.tool.getDisplayName(context));
        bGridPane.add(null, (BValue)this.state);
        this.toolbar = new BToolBar();
        this.toolbar.add(null, (BValue)new BSeparator());
        this.startMgrCmd = new StartMgr();
        this.toolbar.add("start", this.startMgrCmd);
        this.stopMgrCmd = new StopMgr();
        this.toolbar.add("stop", this.stopMgrCmd);
        this.toolbar.add(null, (BValue)new BSeparator());
        bGridPane.add(null, (BValue)this.toolbar);
        bGridPane.add(null, (BValue)new BCheckBox((ToggleCommand)new MgrAutoStart()));
        return new BBorderPane((BWidget)bGridPane, BBorder.solid, BInsets.make((double)5, (double)5, (double)5, (double)5));
    }

    protected BWidget makePortTable() {
        this.portModel = new PortModel();
        BTable bTable = new BTable((TableModel)this.portModel, (TableController)new PortController());
        bTable.setMultipleSelection(false);
        bTable.setCellRenderer((TableCellRenderer)new PortCellRenderer());
        this.linkTo((BComponent)bTable, (Slot)BTable.selectionModified, (Slot)selectionModified);
        return BTitlePane.makePane((String)this.lexPortName, (BTable)bTable, (String)this.lexPortName.toLowerCase());
    }

    public void doJenserStateChanged() {
        this.state.setImage(this.tool.stateToIcon());
        this.startMgrCmd.setEnabled(this.tool.isStartable());
        this.stopMgrCmd.setEnabled(this.tool.isStoppable());
        if (this.tool.isToolRunning() || this.tool.isStopped()) {
            this.portModel.updateTable(true);
            this.portModel.getSelection().select(lastSelected, true);
        } else {
            this.split.setWidget2(this.makeEmptyView());
        }
    }

    public void doSelectionModified() {
        int n = this.portModel.getSelection().getRow();
        if (this.isModified()) {
            this.portToView.remove((Object)this.selectedPort);
            this.clearModified();
        }
        if (n < 0 || this.ports().length == 0) {
            this.selectedPort = null;
            this.split.setWidget2(this.makeEmptyView());
        } else if (this.selectedPort != this.ports()[n]) {
            if (this.selectedPort != null) {
                this.selectedPort.unloadView(this);
            }
            this.selectedPort = this.ports()[n];
            if (!this.portToView.containsKey((Object)this.selectedPort)) {
                this.portToView.put(this.selectedPort, this.selectedPort.makeView(this));
            }
            this.split.setWidget2((BWidget)this.portToView.get((Object)this.selectedPort));
        }
        lastSelected = n;
    }

    public void doListItemSelected(BWidgetEvent bWidgetEvent) {
        PortController portController = (PortController)this.portModel.getController();
        String string = (String)portController.list.getSelectedItem();
        this.portToView.remove((Object)this.portModel.getPort(portController.popupRow));
        this.tool.config.changePortType(this.portModel.getPort(portController.popupRow), BPortType.make(string));
        UiEnv.get().closePopup((BWidget)portController.list);
        if (portController.getSelection().getRow() == portController.popupRow) {
            this.selectedPort = null;
        }
        portController.getSelection().select(portController.popupRow, true);
        this.portModel.updateTable();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lexAutoStart = lex.getText("autostart");
        this.lexConnectSettings = lex.getText("connectSettings");
        this.lexCurrentSettings = lex.getText("currentSettings");
        this.lexEnablingCoord = lex.getText("enablingCoord");
        this.lexToolNotRunning = lex.getText("notRunning", new Object[]{lex.getText("WbJenserTool.displayName")});
        this.lexNeedWizard = lex.getText("needWizard", new Object[]{lex.getText("NewCoordinatorWizard.displayName")});
        this.lexNotLicensed = lex.getText("notLicensed");
        this.lexOpeningCoord = lex.getText("openingCoord");
        this.lexPortName = lex.getText("portName");
        this.lexPortType = lex.getText("portType");
        this.lexReadingChannel = lex.getText("readingChannel");
        this.lexReadingConfig = lex.getText("readingConfig");
        this.lexReadingPanId = lex.getText("readingPan");
        this.lexReadingDiag = lex.getText("readingDiag");
        this.lexRestartCoord = lex.getText("restartCoord");
        this.lexWritingConfig = lex.getText("writingConfig");
    }

    public BConfigurationView() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$wb$jenser$tool$BConfigurationView;
        if (clazz == null) {
            clazz = class$com$tridium$wb$jenser$tool$BConfigurationView = BConfigurationView.class("[Lcom.tridium.wb.jenser.tool.BConfigurationView;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lastSelected = -1;
        Class clazz2 = class$com$tridium$wb$jenser$tool$BConfigurationView;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$wb$jenser$tool$BConfigurationView = BConfigurationView.class("[Lcom.tridium.wb.jenser.tool.BConfigurationView;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        serialPortIcon = BImage.make((String)"module://icons/x16/serialPort.png");
        mouseFocusBg = BBrush.make((String)"#ccf");
        mouseFocusBorder = BBrush.make((String)"#669");
        viewLock = BBoolean.FALSE;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class PortModel
    extends TableModel {
        String[] cols;

        public int getColumnCount() {
            return this.cols.length;
        }

        public String getColumnName(int n) {
            return this.cols[n];
        }

        public int getRowCount() {
            int n = 0;
            if (BConfigurationView.this.tool.isToolRunning()) {
                n = BConfigurationView.this.ports().length;
            }
            return n;
        }

        public Object getValueAt(int n, int n2) {
            BWbJenserPort bWbJenserPort = BConfigurationView.this.ports()[n];
            switch (n2) {
                case 0: {
                    return bWbJenserPort.getPortName();
                }
                case 1: {
                    return bWbJenserPort.getPortType().getTag();
                }
                case 2: {
                    return "";
                }
                case 3: {
                    return "";
                }
            }
            throw new IllegalStateException("col: " + n2);
        }

        public BWbJenserPort getPort(int n) {
            return BConfigurationView.this.ports()[n];
        }

        public boolean isPortCol(int n) {
            boolean bl = false;
            if (n == 0) {
                bl = true;
            }
            return bl;
        }

        public boolean isTypeCol(int n) {
            boolean bl = false;
            if (n == 1) {
                bl = true;
            }
            return bl;
        }

        public boolean isAutoStartCell(int n, int n2) {
            boolean bl = false;
            if (n2 == 2 && !BConfigurationView.this.ports()[n].isFlasher()) {
                bl = true;
            }
            return bl;
        }

        public BImage getRowIcon(int n) {
            return serialPortIcon;
        }

        private final /* synthetic */ void this() {
            this.cols = new String[]{BConfigurationView.this.lexPortName, BConfigurationView.this.lexPortType, BConfigurationView.this.lexAutoStart, ""};
        }

        public PortModel() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class StartMgr
    extends Command {
        public CommandArtifact doInvoke() {
            BWbService.getManager().start((BWbService)BConfigurationView.this.tool);
            return null;
        }

        public StartMgr() {
            super((BWidget)BConfigurationView.this, BConfigurationView.this.getType().getModule(), "cv.cmd.startMgr");
            this.setEnabled(BConfigurationView.this.tool.isStartable());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class StopMgr
    extends Command {
        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public CommandArtifact doInvoke() {
            try {
                BConfigurationView.this.tool.stopAdapters = true;
                BWbService.getManager().stop((BWbService)BConfigurationView.this.tool);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                BConfigurationView.this.tool.stopAdapters = false;
                throw throwable;
            }
            {
                Object var2_3 = null;
                BConfigurationView.this.tool.stopAdapters = false;
                return null;
            }
        }

        public StopMgr() {
            super((BWidget)BConfigurationView.this, BConfigurationView.this.getType().getModule(), "cv.cmd.stopMgr");
            this.setEnabled(BConfigurationView.this.tool.isStoppable());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MgrAutoStart
    extends ToggleCommand {
        public CommandArtifact doInvoke() throws Exception {
            BWbService.getManager().setAutoStart(BConfigurationView.this.tool.getType().getTypeInfo(), this.isSelected());
            return null;
        }

        public MgrAutoStart() {
            super((BWidget)BConfigurationView.this, BConfigurationView.this.getType().getModule(), "cv.cmd.mgrAutoStart");
            this.setSelected(BWbService.getManager().isAutoStart(BConfigurationView.this.tool.getType().getTypeInfo()));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class PortController
    extends TableController {
        BList list;
        int popupRow;

        private final void buildList() {
            this.list = new BList();
            this.list.setMultipleSelection(false);
            this.list.addItem(BImage.make((BIcon)new BUnknownPort().getIcon()), (Object)BPortType.unknown.getTag());
            this.list.addItem(BImage.make((BIcon)new BCoordinatorPort().getIcon()), (Object)BPortType.adapter.getTag());
            if (!BConfigurationView.this.portModel.getPort(this.popupRow).isCoordinator()) {
                this.list.addItem(BImage.make((BIcon)new BFlasherPort().getIcon()), (Object)BPortType.flasher.getTag());
            }
            this.list.setController(new ListController(){

                protected final void itemEntered(BMouseEvent bMouseEvent, int n) {
                    this.getSelection().deselectAll();
                    this.getSelection().select(n);
                }
            });
            this.list.setRenderer(new ListRenderer(){

                public final void paintItem(Graphics graphics, ListRenderer.Item item) {
                    this.paintItemBackground(graphics, item);
                    double d = 4;
                    graphics.drawImage(item.icon, d, (item.height - item.icon.getHeight()) / (double)2);
                    String string = this.getItemText(item);
                    double d2 = Theme.table().getCellFont().getHeight();
                    double d3 = Theme.table().getCellFont().getAscent();
                    double d4 = (item.height - d2) / (double)2;
                    graphics.setFont(Theme.table().getCellFont());
                    graphics.drawString(string, d += 17.0, d4 + d3);
                }
            });
            BConfigurationView.this.linkTo((BComponent)this.list, (Slot)BList.actionPerformed, (Slot)listItemSelected);
        }

        protected void cellEntered(BMouseEvent bMouseEvent, int n, int n2) {
            if (UiEnv.get().isPopupOpen((BWidget)this.list)) {
                return;
            }
            if (BConfigurationView.this.portModel.isTypeCol(n2)) {
                this.getModel().updateTable();
            }
            super.cellEntered(bMouseEvent, n, n2);
        }

        protected void cellExited(BMouseEvent bMouseEvent, int n, int n2) {
            if (UiEnv.get().isPopupOpen((BWidget)this.list)) {
                return;
            }
            this.getModel().updateTable();
            super.cellExited(bMouseEvent, n, n2);
        }

        protected void cellPressed(BMouseEvent bMouseEvent, int n, int n2) {
            if (BConfigurationView.this.portModel.isTypeCol(n2)) {
                this.popupRow = n;
                this.buildList();
                this.list.setSelectedIndex(BConfigurationView.this.portModel.getPort(n).getPortType().getOrdinal());
                BTable bTable = this.getTable();
                BScrollBar bScrollBar = bTable.getHscrollBar();
                BScrollBar bScrollBar2 = bTable.getVscrollBar();
                RectGeom rectGeom = bTable.getCellBounds(n, n2);
                double d = rectGeom.x;
                double d2 = rectGeom.y + rectGeom.height;
                double d3 = bTable.getCellWidth(n2);
                if (bScrollBar.isVisible()) {
                    d -= (double)bScrollBar.getPosition();
                }
                if (bScrollBar2.isVisible()) {
                    d2 -= (double)bScrollBar2.getPosition() * rectGeom.height;
                }
                this.list.computePreferredSize();
                UiEnv.get().openPopup((BWidget)this.list, (BWidget)this.getTable(), d, d2, d3, -1.0);
                this.list.requestFocus();
            } else if (BConfigurationView.this.portModel.isAutoStartCell(n, n2)) {
                RectGeom rectGeom = this.getTable().getCellBounds(n, n2);
                double d = bMouseEvent.getX() - rectGeom.x;
                if (d > (double)2 && d < 12.0) {
                    BWbJenserPort bWbJenserPort = BConfigurationView.this.portModel.getPort(n);
                    bWbJenserPort.setAutoStart(bWbJenserPort.getAutoStart() ^ true);
                    BConfigurationView.this.portModel.updateTable();
                } else {
                    super.cellPressed(bMouseEvent, n, n2);
                }
            } else {
                super.cellPressed(bMouseEvent, n, n2);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class PortCellRenderer
    extends TableCellRenderer {
        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            switch (cell.column) {
                case 1: {
                    return this.getFont(cell).width(BPortType.adapter.getTag()) + 20.0 + 22.0;
                }
                case 2: {
                    return 20.0;
                }
            }
            return super.getPreferredCellWidth(cell);
        }

        public double getCellHeight() {
            return 18.0;
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            if (BConfigurationView.this.portModel.isTypeCol(cell.column)) {
                this.paintTypeCell(graphics, cell);
            } else if (BConfigurationView.this.portModel.isAutoStartCell(cell.row, cell.column)) {
                this.paintAutoStartCell(graphics, cell);
            } else {
                super.paintCell(graphics, cell);
            }
        }

        void paintTypeCell(Graphics graphics, TableCellRenderer.Cell cell) {
            this.paintCellBackground(graphics, cell);
            if (cell.row == this.getController().getMouseOverRow() && cell.column == this.getController().getMouseOverColumn()) {
                graphics.setBrush(mouseFocusBg);
                graphics.fillRect(0.0, 0.0, cell.width, cell.height);
                graphics.setBrush(mouseFocusBorder);
                graphics.strokeRect(0.0, 0.0, cell.width - (double)2, cell.height - (double)2);
                graphics.setBrush(this.getForeground(cell));
            }
            double d = cell.width - 9.0;
            double d2 = (cell.height - (double)3) / (double)2;
            graphics.strokeLine(d, d2, d + (double)4, d2);
            graphics.strokeLine(d + 1.0, d2 + 1.0, d + (double)3, d2 + 1.0);
            graphics.strokeLine(d + (double)2, d2 + (double)2, d + (double)2, d2 + (double)2);
            BImage bImage = BImage.make((BIcon)BConfigurationView.this.portModel.getPort(cell.row).getIcon());
            double d3 = 3;
            double d4 = (cell.height - bImage.getHeight()) / (double)2;
            graphics.drawImage(bImage, d3, d4);
            String string = BConfigurationView.this.portModel.getPort(cell.row).getPortType().getTag();
            double d5 = bImage.getWidth() + d3 + d3;
            BFont bFont = this.getFont(cell);
            graphics.setFont(bFont);
            graphics.drawString(string, d5, (cell.height + bFont.getAscent() - bFont.getDescent()) / (double)2);
        }

        void paintAutoStartCell(Graphics graphics, TableCellRenderer.Cell cell) {
            BWbJenserPort bWbJenserPort = BConfigurationView.this.portModel.getPort(cell.row);
            if (bWbJenserPort.getPortType().equals((Object)BPortType.unknown)) {
                super.paintCell(graphics, cell);
                return;
            }
            this.paintCellBackground(graphics, cell);
            double d = 2;
            double d2 = (cell.height - 16.0) / (double)2;
            double d3 = d;
            double d4 = d2 + cell.height / (double)2 - (double)5;
            double d5 = 10.0;
            double d6 = 10.0;
            graphics.setBrush(BColor.black.toBrush());
            graphics.strokeRect(d3, d4, d5, d6);
            if (bWbJenserPort.getAutoStart()) {
                graphics.strokeLine(d3, d4, d3 + d5, d4 + d6);
                graphics.strokeLine(d3, d4 + d5, d3 + d5, d4);
            }
        }

        PortCellRenderer() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Selection
    extends TableSelection {
        public void select(int n, boolean bl) {
            System.out.println("select int, bool");
            if (n >= 0 && !this.isSelected(n) && !((BNiagaraWbShell)BConfigurationView.this.getWbShell()).confirmHyperlink()) {
                return;
            }
            super.select(n, bl);
        }

        Selection() {
        }
    }
}

