/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pansheet.digraph.algo;

import com.tridium.pansheet.digraph.Digraph;
import com.tridium.pansheet.digraph.Edge;
import com.tridium.pansheet.digraph.LayerSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class LongestPathLayering {
    protected final Digraph dag;
    protected LayerSet layers;
    protected HashSet U;
    protected HashSet Z;

    public LayerSet assignLayers() {
        if (this.U.size() == this.dag.cardinality()) {
            return this.layers;
        }
        LayerSet.Layer layer = this.layers.newLayer();
        while (this.U.size() != this.dag.cardinality()) {
            Object object = this.findSink();
            if (object != null) {
                layer.add(object);
                this.U.add(object);
                continue;
            }
            layer = this.layers.newLayer();
            this.Z.addAll(this.U);
        }
        this.promoteVertices();
        this.normalize();
        return this.layers;
    }

    private final Object findSink() {
        Iterator iterator = this.dag.vertices().iterator();
        block0: while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.U.contains(e)) continue;
            Set set = this.dag.getOutEdges(e);
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Edge edge = (Edge)iterator2.next();
                if (!this.Z.contains(edge.head)) continue block0;
            }
            return e;
        }
        return null;
    }

    private final void promoteVertices() {
        boolean bl = false;
        do {
            bl = false;
            int n = 1;
            while (n < this.layers.height()) {
                LayerSet.Layer layer = this.layers.getLayer(n);
                int n2 = 0;
                while (n2 < layer.width()) {
                    block5: {
                        Object object = layer.getVertex(n2);
                        int n3 = -1;
                        Iterator iterator = this.dag.getInEdges(object).iterator();
                        while (iterator.hasNext()) {
                            Edge edge = (Edge)iterator.next();
                            if ((n3 = Math.max(n3, this.layers.rank(edge.tail))) != n - 1) {
                                continue;
                            }
                            break block5;
                        }
                        layer.vertices.remove(object);
                        this.layers.getLayer(n3 + 1).add(object);
                        bl = true;
                    }
                    ++n2;
                }
                ++n;
            }
        } while (bl);
    }

    private final void normalize() {
        int n = 0;
        while (n < this.layers.height() - 2) {
            LayerSet.Layer layer = this.layers.getLayer(n);
            LayerSet.Layer layer2 = this.layers.getLayer(n + 1);
            int n2 = 0;
            while (n2 < layer.width()) {
                Object object = layer.getVertex(n2);
                Set set = this.dag.getOutEdges(object);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Edge edge = (Edge)iterator.next();
                    if (layer2.contains(edge.head)) continue;
                    this.dag.removeEdge(edge);
                    Object object2 = object;
                    String string = "(* " + object + ':' + edge.head + ", ";
                    int n3 = n + 1;
                    LayerSet.Layer layer3 = this.layers.getLayer(n3);
                    while (!layer3.contains(edge.head)) {
                        Digraph.DummyVertex dummyVertex = new Digraph.DummyVertex(string + n3 + ')');
                        layer3.add(dummyVertex);
                        new Edge(object2, dummyVertex, edge.edgeData).addEdge(this.dag);
                        object2 = dummyVertex;
                        layer3 = this.layers.getLayer(++n3);
                    }
                    new Edge(object2, edge.head, edge.edgeData).addEdge(this.dag);
                }
                ++n2;
            }
            ++n;
        }
    }

    public LongestPathLayering(Digraph digraph) {
        this.dag = digraph;
        this.U = new HashSet();
        this.Z = new HashSet();
        this.layers = new LayerSet(digraph);
    }
}

