/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pansheet.digraph;

import com.tridium.pansheet.digraph.Edge;
import com.tridium.pansheet.digraph.Vertex;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.baja.util.BUuid;

public class Digraph {
    protected final LinkedHashMap graph = new LinkedHashMap();
    protected final LinkedHashSet edges = new LinkedHashSet();

    public boolean addVertex(Object object) {
        if (this.graph.containsKey(object)) {
            return false;
        }
        this.graph.put(object, new Vertex(object));
        return true;
    }

    public void removeVertex(Object object) {
        Vertex vertex = this.tryGetVertex(object);
        if (vertex != null) {
            Iterator iterator = vertex.getIncidentEdges().iterator();
            while (iterator.hasNext()) {
                this.removeEdge((Edge)iterator.next());
            }
            this.graph.remove(object);
        }
    }

    public boolean containsVertex(Object object) {
        boolean bl = false;
        if (this.tryGetVertex(object) != null) {
            bl = true;
        }
        return bl;
    }

    protected Vertex getVertex(Object object) {
        Vertex vertex = (Vertex)this.graph.get(object);
        if (vertex == null) {
            throw new IllegalStateException("vertex not in graph: " + object);
        }
        return vertex;
    }

    protected Vertex tryGetVertex(Object object) {
        try {
            return this.getVertex(object);
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    public int cardinality() {
        return this.graph.size();
    }

    public Set vertices() {
        return Collections.unmodifiableSet(this.graph.keySet());
    }

    public int degree(Object object) {
        return this.inDegree(object) + this.outDegree(object);
    }

    public int inDegree(Object object) {
        return this.getVertex((Object)object).predToInEdges.size();
    }

    public int outDegree(Object object) {
        return this.getVertex((Object)object).succToOutEdges.size();
    }

    public Set getInEdges(Object object) {
        return this.getVertex(object).getInEdges();
    }

    public Set getOutEdges(Object object) {
        return this.getVertex(object).getOutEdges();
    }

    public Set getIncidentEdges(Object object) {
        return this.getVertex(object).getIncidentEdges();
    }

    public Object getEdgeData(Object object, Object object2) {
        Set set = this.getOutEdges(object);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (!edge.head.equals(object2)) continue;
            return edge.edgeData;
        }
        return null;
    }

    public boolean isDummyVertex(Object object) {
        return object instanceof DummyVertex;
    }

    public Edge addEdge(Object object, Object object2) {
        this.addVertex(object);
        this.addVertex(object2);
        Vertex vertex = this.getVertex(object);
        Vertex vertex2 = this.getVertex(object2);
        Edge edge = vertex.getOutEdge(object2);
        if (edge == null) {
            edge = new Edge(object, object2);
            vertex.succToOutEdges.put(object2, edge);
            vertex2.predToInEdges.put(object, edge);
            this.edges.add(edge);
        }
        return edge;
    }

    public void removeEdge(Edge edge) {
        if (!this.edges.remove(edge)) {
            return;
        }
        this.getVertex(edge.tail).removeEdge(edge);
        this.getVertex(edge.head).removeEdge(edge);
    }

    public void removeEdge(Object object, Object object2) {
        this.removeEdge(new Edge(object, object2));
    }

    public boolean containsEdge(Edge edge) {
        return this.edges.contains(edge);
    }

    public boolean containsEdge(Object object, Object object2) {
        return this.containsEdge(new Edge(object, object2));
    }

    public Digraph copy() {
        Digraph digraph = new Digraph();
        Iterator iterator = this.vertices().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            digraph.addVertex(e);
            Iterator iterator2 = this.getOutEdges(e).iterator();
            while (iterator2.hasNext()) {
                Edge edge = (Edge)iterator2.next();
                edge.addEdge(digraph);
            }
        }
        return digraph;
    }

    public void dumpAdjacencyList(String string) {
        this.dumpAdjacencyList(string, System.out);
    }

    public void dumpAdjacencyList(String string, PrintStream printStream) {
        printStream.println("\n" + string);
        Iterator iterator = this.graph.values().iterator();
        while (iterator.hasNext()) {
            Vertex vertex = (Vertex)iterator.next();
            printStream.println(vertex);
            Iterator iterator2 = vertex.getIncidentEdges().iterator();
            while (iterator2.hasNext()) {
                printStream.println("  " + iterator2.next());
            }
        }
    }

    public static void main(String[] stringArray) {
        Digraph digraph = new Digraph();
        digraph.addVertex("v0");
        digraph.addVertex("v1");
        Edge edge = digraph.addEdge("v0", "v1");
        edge.edgeData = "foo";
        digraph.dumpAdjacencyList("g");
        Digraph digraph2 = digraph.copy();
        digraph2.addEdge("v1", "v2");
        digraph2.dumpAdjacencyList("copy");
        digraph.dumpAdjacencyList("g");
    }

    public static class DummyVertex {
        private final Object id;

        public int hashCode() {
            int n = 1;
            int n2 = 0;
            if (this.id != null) {
                n2 = this.id.hashCode();
            }
            n = 31 * n + n2;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            DummyVertex dummyVertex = (DummyVertex)object;
            return !(this.id == null ? dummyVertex.id != null : !this.id.equals(dummyVertex.id));
        }

        public String toString() {
            return this.id.toString();
        }

        public DummyVertex() {
            this(BUuid.make());
        }

        public DummyVertex(Object object) {
            this.id = object;
        }
    }
}

