/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet.user;

import com.tridium.sedonanet.user.BSedonaRoleService;
import com.tridium.sedonanet.user.BSedonaUserManagementService;
import com.tridium.sedonanet.user.BSedonaUserService;
import com.tridium.sedonanet.user.BUserEvent;
import com.tridium.sedonanet.user.BUserSyncTask;
import com.tridium.util.backport.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.baja.driver.BDeviceExt;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BSedonaUsersExt
extends BDeviceExt
implements BIMixIn {
    public static final Property status = BSedonaUsersExt.newProperty((int)3, (BValue)BStatus.stale, null);
    public static final Property faultCause = BSedonaUsersExt.newProperty((int)3, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (int)55));
    public static final Property enabled = BSedonaUsersExt.newProperty((int)0, (boolean)true, null);
    public static final Property userMap = BSedonaUsersExt.newProperty((int)5, (BValue)BNameMap.DEFAULT, null);
    public static final Property syncTask = BSedonaUsersExt.newProperty((int)0, (BValue)new BUserSyncTask(), null);
    public static final Action handleUserEvent = BSedonaUsersExt.newAction((int)4, (BValue)new BUserEvent(), null);
    public static final Action handleRoleEvent = BSedonaUsersExt.newAction((int)4, (BValue)new BUserEvent(), null);
    public static final Type TYPE;
    private static final BIcon Icon;
    private static final String UserServiceLink = "userServiceLink";
    private static final String RoleServiceLink = "roleServiceLink";
    private BStatus prevStatus;
    static /* synthetic */ Class class$com$tridium$sedonanet$user$BSedonaUsersExt;

    public final BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public final void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public final String getFaultCause() {
        return this.getString(faultCause);
    }

    public final void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public final boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public final void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public final BNameMap getUserMap() {
        return (BNameMap)this.get(userMap);
    }

    public final void setUserMap(BNameMap bNameMap) {
        this.set(userMap, (BValue)bNameMap, null);
    }

    public final BUserSyncTask getSyncTask() {
        return (BUserSyncTask)this.get(syncTask);
    }

    public final void setSyncTask(BUserSyncTask bUserSyncTask) {
        this.set(syncTask, (BValue)bUserSyncTask, null);
    }

    public final void handleUserEvent(BUserEvent bUserEvent) {
        this.invoke(handleUserEvent, (BValue)bUserEvent, null);
    }

    public final void handleRoleEvent(BUserEvent bUserEvent) {
        this.invoke(handleRoleEvent, (BValue)bUserEvent, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final String getDisplayNameInParent(Context context) {
        return "Sedona Users";
    }

    public final String[] getUsernames() {
        return this.getUserMap().list();
    }

    public final Set getRoles(String string) {
        BFormat bFormat = this.getUserMap().get(string);
        if (bFormat == null) {
            return null;
        }
        Object[] objectArray = TextUtil.split((String)bFormat.getFormat(), (char)',');
        return new HashSet(Arrays.asList((Object[])objectArray));
    }

    public final Map userToRoles() {
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        String[] stringArray = this.getUsernames();
        int n = 0;
        while (n < stringArray.length) {
            hashMap.put(stringArray[n], this.getRoles(stringArray[n]));
            ++n;
        }
        return hashMap;
    }

    public final void setUserMap(Map map) {
        BNameMap bNameMap = BNameMap.DEFAULT;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set = (Set)map.get(string);
            if (set.isEmpty()) continue;
            String string2 = TextUtil.join((String[])set.toArray(new String[set.size()]), (char)',');
            bNameMap = BNameMap.make((BNameMap)bNameMap, (String)string, (String)string2);
        }
        this.setUserMap(bNameMap);
    }

    public final void setRoles(String string, Set set) {
        if (set == null) {
            throw new NullPointerException("roles is null");
        }
        BNameMap bNameMap = this.getUserMap();
        if (set.isEmpty()) {
            bNameMap = BNameMap.remove((BNameMap)bNameMap, (String)string);
        } else {
            String string2 = TextUtil.join((String[])set.toArray(new String[set.size()]), (char)',');
            bNameMap = BNameMap.make((BNameMap)bNameMap, (String)string, (String)string2);
        }
        this.setUserMap(bNameMap);
    }

    public final void doHandleUserEvent(BUserEvent bUserEvent) {
        if (1 == bUserEvent.getId()) {
            this.setUserMap(BNameMap.remove((BNameMap)this.getUserMap(), (String)bUserEvent.getN()));
        } else if (3 == bUserEvent.getId()) {
            BNameMap bNameMap = this.getUserMap();
            BFormat bFormat = bNameMap.get(bUserEvent.getOldName());
            if (bFormat != null) {
                bNameMap = BNameMap.remove((BNameMap)bNameMap, (String)bUserEvent.getOldName());
                this.setUserMap(BNameMap.make((BNameMap)bNameMap, (String)bUserEvent.getN(), (BFormat)bFormat));
            }
        } else if (2 == bUserEvent.getId()) {
            this.getSyncTask().schedule();
        }
    }

    public final void doHandleRoleEvent(BUserEvent bUserEvent) {
        if (bUserEvent.getId() == 0) {
            return;
        }
        String string = bUserEvent.getN();
        String[] stringArray = this.getUsernames();
        int n = 0;
        while (n < stringArray.length) {
            Set set = this.getRoles(stringArray[n]);
            if (set.contains(string)) {
                if (1 == bUserEvent.getId()) {
                    set.remove(string);
                    this.setRoles(stringArray[n], set);
                } else if (2 == bUserEvent.getId()) {
                    this.getSyncTask().schedule();
                    return;
                }
            } else if (3 == bUserEvent.getId() && set.contains(bUserEvent.getOldName())) {
                set.remove(bUserEvent.getOldName());
                set.add(string);
                this.setRoles(stringArray[n], set);
            }
            ++n;
        }
    }

    public final void started() throws Exception {
        super.started();
        if (!this.isRunning()) {
            return;
        }
        this.updateStatus();
        this.linkToServices();
    }

    public final void stopped() throws Exception {
        super.stopped();
        if (!this.isRunning()) {
            return;
        }
        this.updateStatus();
        this.unlinkFromServices();
    }

    public final void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (enabled == property) {
            this.updateStatus();
        } else if (status == property) {
            if (this.becameOperational()) {
                this.getSyncTask().execute();
            }
            this.prevStatus = this.getStatus();
        } else if (userMap == property) {
            this.getSyncTask().schedule();
        }
    }

    private final void linkToServices() {
        BSedonaUserManagementService bSedonaUserManagementService = this.getManagementService();
        if (bSedonaUserManagementService == null) {
            return;
        }
        if (this.get(UserServiceLink) == null) {
            this.linkTo(UserServiceLink, bSedonaUserManagementService.getUserService(), (Slot)BSedonaUserService.userEvent, (Slot)handleUserEvent);
        }
        if (this.get(RoleServiceLink) == null) {
            this.linkTo(RoleServiceLink, bSedonaUserManagementService.getRoleService(), (Slot)BSedonaRoleService.roleEvent, (Slot)handleRoleEvent);
        }
    }

    private final void unlinkFromServices() {
        Property property = null;
        property = this.getProperty(UserServiceLink);
        if (property != null) {
            this.remove(property);
        }
        if ((property = this.getProperty(RoleServiceLink)) != null) {
            this.remove(property);
        }
    }

    public final void updateStatus() {
        super.updateStatus();
        this.setStatus(BStatus.makeStale((BStatus)this.getStatus(), (boolean)false));
        BSedonaUserManagementService bSedonaUserManagementService = this.getManagementService();
        if (bSedonaUserManagementService == null) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("Sedona user management service not found");
            return;
        }
        if (bSedonaUserManagementService.getStatus().isFault()) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("Sedona user management service is in fault");
            return;
        }
        BStatus bStatus = this.getDevice().getStatus();
        BStatus bStatus2 = this.getStatus();
        boolean bl = false;
        if (bStatus.isDisabled() || !this.getEnabled()) {
            bl = true;
        }
        bStatus2 = BStatus.makeDisabled((BStatus)bStatus2, (boolean)bl);
        bStatus2 = BStatus.makeDown((BStatus)bStatus2, (boolean)bStatus.isDown());
        this.setStatus(bStatus2);
        this.setFaultCause("");
    }

    public final boolean isOperational() {
        return this.isOperational(this.getStatus());
    }

    private final boolean isOperational(BStatus bStatus) {
        boolean bl = false;
        if (bStatus.isDisabled() || bStatus.isDown() || bStatus.isFault()) {
            bl = true;
        }
        return bl ^ true;
    }

    private final boolean becameOperational() {
        boolean bl = false;
        if (!this.isOperational(this.prevStatus) && this.isOperational(this.getStatus())) {
            bl = true;
        }
        return bl;
    }

    public final BSedonaUserManagementService getManagementService() {
        try {
            return (BSedonaUserManagementService)Sys.getService((Type)BSedonaUserManagementService.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            return null;
        }
    }

    public final BIcon getIcon() {
        return Icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.prevStatus = BStatus.ok;
    }

    public BSedonaUsersExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$sedonanet$user$BSedonaUsersExt;
        if (clazz == null) {
            clazz = class$com$tridium$sedonanet$user$BSedonaUsersExt = BSedonaUsersExt.class("[Lcom.tridium.sedonanet.user.BSedonaUsersExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Icon = BIcon.std((String)"user.png");
    }
}

