/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet.driver.point;

import com.tridium.sedonanet.driver.BSedonaBaseDevice;
import com.tridium.sedonanet.driver.BSedonaBaseNetwork;
import com.tridium.sedonanet.driver.comm.NoSessionException;
import com.tridium.sedonanet.driver.comm.SoxMsg;
import com.tridium.sedonanet.driver.comm.TimeOutException;
import com.tridium.sedonanet.driver.point.BSedonaPointDeviceExt;
import com.tridium.sedonanet.driver.point.BSedonaTuningPolicy;
import com.tridium.sedonanet.driver.point.SedPntUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ByteArrayUtil;
import javax.baja.util.Lexicon;
import obix.Obj;
import obix.Real;
import obix.Str;
import obix.io.BinObixDecoder;
import obix.io.BinObixEncoder;
import sedona.Bool;
import sedona.Buf;
import sedona.Byte;
import sedona.Double;
import sedona.Float;
import sedona.Int;
import sedona.Long;
import sedona.Short;
import sedona.Slot;
import sedona.Value;
import sedona.sox.SoxComponent;
import sedona.util.TextUtil;
import sedona.web.WebReq;
import sedona.web.WebRes;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSedonaProxyExt
extends BProxyExt
implements BIPollable {
    private static final Lexicon lex = Lexicon.make((String)"sedonanet");
    private static final String CONFIG = lex.getText("config");
    private static final String RUNTIME = lex.getText("runtime");
    private static final String AS_STR = lex.getText("asStr");
    private static final String AS_BUF = lex.getText("asBuf");
    public static final Property address = BSedonaProxyExt.newProperty((int)0, (String)"", null);
    public static final Property config = BSedonaProxyExt.newProperty((int)1, (boolean)false, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)CONFIG), (BFacets)BFacets.make((String)"falseText", (String)RUNTIME)));
    public static final Property typeId = BSedonaProxyExt.newProperty((int)1, (int)-1, null);
    public static final Property asStr = BSedonaProxyExt.newProperty((int)1, (boolean)true, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)AS_STR), (BFacets)BFacets.make((String)"falseText", (String)AS_BUF)));
    public static final Type TYPE;
    private static final String SEDONA_BOOL_FALSE;
    private static final String SEDONA_BOOL_TRUE;
    private static final String SEDONA_BOOL_NULL;
    public static final BEnumRange SEDONA_BOOL_RANGE;
    static final int CHOPAN_BOOL = 128;
    static final int CHOPAN_INT = 192;
    static final int CHOPAN_REAL = 256;
    static final int CHOPAN_STR = 320;
    int compId;
    int propId;
    Boolean cfg;
    int requestSize;
    int responseSize;
    boolean polled;
    static /* synthetic */ Class class$com$tridium$sedonanet$driver$point$BSedonaProxyExt;

    public String getAddress() {
        return this.getString(address);
    }

    public void setAddress(String string) {
        this.setString(address, string, null);
    }

    public boolean getConfig() {
        return this.getBoolean(config);
    }

    public void setConfig(boolean bl) {
        this.setBoolean(config, bl, null);
    }

    public int getTypeId() {
        return this.getInt(typeId);
    }

    public void setTypeId(int n) {
        this.setInt(typeId, n, null);
    }

    public boolean getAsStr() {
        return this.getBoolean(asStr);
    }

    public void setAsStr(boolean bl) {
        this.setBoolean(asStr, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BSedonaBaseNetwork getSedonaNetwork() {
        return (BSedonaBaseNetwork)this.getNetwork();
    }

    public final BSedonaBaseDevice getSedonaDevice() {
        return (BSedonaBaseDevice)this.getDevice();
    }

    public final BSedonaPointDeviceExt getSedonaPointDeviceExt() {
        return (BSedonaPointDeviceExt)this.getDeviceExt();
    }

    public final BSedonaTuningPolicy getSedonaTuningPolicy() {
        return (BSedonaTuningPolicy)this.getTuningPolicy();
    }

    public String toString(Context context) {
        BComplex bComplex = this.getParent();
        return (bComplex != null ? bComplex.getName() : "---") + ':' + this.getAddress();
    }

    public final BPollFrequency getPollFrequency() {
        return ((BSedonaTuningPolicy)this.getTuningPolicy()).getPollFrequency();
    }

    public void started() throws Exception {
        super.started();
        this.getComponentId();
        this.getPropId();
        this.getCfg();
        if (this.isFatalFault()) {
            return;
        }
        this.checkTypeId();
        this.requestSize = this.getAddress().length() + 2;
        if (this.getParentPoint().getType().is(BBooleanPoint.TYPE)) {
            this.responseSize = 3;
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)address)) {
            this.requestSize = this.getAddress().length() + 2;
            this.checkResubscribe(context, true);
        } else if (property.equals((Object)config) || property.equals((Object)tuningPolicyName)) {
            this.checkResubscribe(context, false);
        }
    }

    public void tuningChanged(BSedonaTuningPolicy bSedonaTuningPolicy, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (bSedonaTuningPolicy == null || bSedonaTuningPolicy == this.getTuningPolicy()) {
            this.checkResubscribe(context, false);
        }
    }

    public Type getDeviceExtType() {
        return BSedonaPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    public void readSubscribed(Context context) throws Exception {
        if (!this.isRunning()) {
            return;
        }
        BSedonaTuningPolicy bSedonaTuningPolicy = this.getSedonaTuningPolicy();
        if (bSedonaTuningPolicy.isSoxEvent()) {
            if (this.isFatalFault()) {
                return;
            }
            this.getSedonaNetwork().postAsync(new Async(this, context){

                public final void run() {
                    BSedonaProxyExt.this.doReadSubscribed(this.net, this.dev, this.cx);
                }
            });
        } else if (bSedonaTuningPolicy.isSoxPolled()) {
            this.getSedonaNetwork().getPollScheduler().subscribe(this);
            this.polled = true;
        } else if (bSedonaTuningPolicy.isChopan()) {
            this.getSedonaDevice().pollSubscribe(this);
            this.polled = true;
        }
    }

    public void readUnsubscribed(Context context) throws Exception {
        this.getSedonaNetwork().postAsync(new Async(this, context){

            public final void run() {
                BSedonaProxyExt.this.doReadUnsubscribed(this.net, this.dev, this.cx);
            }
        });
    }

    public boolean write(Context context) throws Exception {
        try {
            this.getSedonaNetwork().postWrite(new Async(this, context){

                public final void run() {
                    BSedonaProxyExt.this.doWrite(this.cx);
                }
            });
            return true;
        }
        catch (Throwable throwable) {
            this.writeFail(throwable.toString());
            return false;
        }
    }

    public void doPoll() {
        BSedonaBaseDevice bSedonaBaseDevice = this.getSedonaDevice();
        if (bSedonaBaseDevice.isDown()) {
            return;
        }
        if (!bSedonaBaseDevice.getEnabled()) {
            return;
        }
        if (!this.getEnabled()) {
            return;
        }
        BSedonaTuningPolicy bSedonaTuningPolicy = this.getSedonaTuningPolicy();
        if (bSedonaTuningPolicy.isSoxEvent() || bSedonaTuningPolicy.isSoxPolled()) {
            this.doPollSox(bSedonaBaseDevice);
        } else if (bSedonaTuningPolicy.isChopan()) {
            this.doPollChopan(bSedonaBaseDevice);
        }
    }

    public void doWrite(Context context) {
        BSedonaTuningPolicy bSedonaTuningPolicy;
        if (this.getTypeId() < 0) {
            try {
                this.doPoll();
            }
            catch (Exception exception) {
                this.writeFail("typeId not yet read");
            }
        }
        if ((bSedonaTuningPolicy = this.getSedonaTuningPolicy()).isSoxEvent() || bSedonaTuningPolicy.isSoxPolled()) {
            this.doWriteSox(context);
        } else if (bSedonaTuningPolicy.isChopan()) {
            this.doWriteChopan(context);
        }
    }

    void doReadSubscribed(BSedonaBaseNetwork bSedonaBaseNetwork, BSedonaBaseDevice bSedonaBaseDevice, Context context) {
        try {
            bSedonaBaseDevice.watchPoint(this, context);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string != null) {
                this.readFail(exception.getMessage());
            }
            this.readFail(exception.toString());
        }
    }

    public void doReadUnsubscribed(BSedonaBaseNetwork bSedonaBaseNetwork, BSedonaBaseDevice bSedonaBaseDevice, Context context) {
        bSedonaBaseNetwork.getPollScheduler().unsubscribe(this);
        bSedonaBaseDevice.pollUnsubscribe(this);
        bSedonaBaseDevice.unwatchPoint(this, context);
    }

    protected BStatusValue getWriteVal() {
        BStatusValue bStatusValue = this.getWriteValue();
        if (bStatusValue.getStatus().isNull() && (this.getActiveLevel() == 17 || !(bStatusValue instanceof BStatusBoolean))) {
            return null;
        }
        return bStatusValue;
    }

    protected void setReadStatus(BStatusValue bStatusValue) {
    }

    protected int getWriteCompId() {
        return this.getComponentId();
    }

    protected int getWritePropId() {
        return this.getPropId();
    }

    protected String getWriteAddress() {
        return this.getAddress();
    }

    private final void doPollSox(BSedonaBaseDevice bSedonaBaseDevice) {
        int n = this.getComponentId();
        int n2 = this.getPropId();
        if (n < 0 || n2 < 0) {
            this.readFail("Invalid address");
            return;
        }
        try {
            int n3;
            SoxMsg soxMsg = SoxMsg.make(114);
            soxMsg.u2(n);
            soxMsg.u1(n2);
            SoxMsg soxMsg2 = this.getSedonaNetwork().comm().sendRequest(bSedonaBaseDevice, soxMsg);
            if (soxMsg2 == null) {
                throw new TimeOutException("no response");
            }
            bSedonaBaseDevice.pingOk();
            soxMsg2.u1();
            soxMsg2.u1();
            if (soxMsg2.u2() != n) {
                this.logSox().message("Response has invalid compId");
            }
            if (soxMsg2.u1() != n2) {
                this.logSox().message("Response has invalid propId");
            }
            if (!this.isSoxTypeOk(n3 = soxMsg2.read())) {
                this.readFail("Wrong proxy type for Sedona " + sedona.Type.predefinedName((int)n3));
                return;
            }
            this.setTypeId(n3);
            BSimple bSimple = soxMsg2.readValue(this.getTypeId());
            boolean bl = this.getParentPoint().getType().is(BEnumPoint.TYPE);
            BStatusBoolean bStatusBoolean = null;
            if (bSimple == null) {
                if (bl) {
                    bStatusBoolean = new BStatusEnum((BEnum)BDynamicEnum.make((int)2, (BEnumRange)SEDONA_BOOL_RANGE));
                } else {
                    bStatusBoolean = new BStatusBoolean();
                    bStatusBoolean.setStatusNull(true);
                }
            } else if (bSimple instanceof BBoolean) {
                if (bl) {
                    int n4 = ((BBoolean)bSimple).getBoolean();
                    bStatusBoolean = new BStatusEnum((BEnum)BDynamicEnum.make((int)n4, (BEnumRange)SEDONA_BOOL_RANGE));
                } else {
                    bStatusBoolean = new BStatusBoolean(((BBoolean)bSimple).getBoolean());
                }
            } else if (bSimple instanceof BNumber) {
                if (bl) {
                    BEnumRange bEnumRange = ((BStatusEnum)this.getParentPoint().getOutStatusValue()).getValue().getRange();
                    bStatusBoolean = new BStatusEnum((BEnum)BDynamicEnum.make((int)((BNumber)bSimple).getInt(), (BEnumRange)bEnumRange));
                } else {
                    bStatusBoolean = new BStatusNumeric(((BNumber)bSimple).getDouble());
                }
            } else {
                bStatusBoolean = bSimple instanceof BBlob ? (this.getAsStr() ? new BStatusString(BSedonaProxyExt.toStr(new Buf(((BBlob)bSimple).copyBytes()))) : new BStatusString(BSedonaProxyExt.toStr(((BBlob)bSimple).copyBytes()))) : new BStatusString(bSimple.toString());
            }
            this.setReadStatus((BStatusValue)bStatusBoolean);
            if (!bStatusBoolean.getType().is(this.getReadValue().getType())) {
                this.readFail("Wrong point type:" + bStatusBoolean);
            } else {
                this.readOk((BStatusValue)bStatusBoolean);
            }
        }
        catch (TimeOutException timeOutException) {
            if (this.logSox().isTraceOn()) {
                this.logSox().trace("Timeout polling " + (Object)((Object)this) + " in " + this.getSedonaDevice());
            }
            this.readFail(timeOutException.getMessage());
            bSedonaBaseDevice.doPing();
        }
        catch (NoSessionException noSessionException) {
            if (this.logSox().isTraceOn()) {
                this.logSox().trace("NoSessionException polling " + (Object)((Object)this) + " in " + this.getSedonaDevice() + " via Sox:" + (Object)((Object)noSessionException));
            }
            this.readFail(noSessionException.getMessage());
            bSedonaBaseDevice.doPing();
        }
        catch (Throwable throwable) {
            if (this.logSox().isTraceOn()) {
                this.logSox().trace("Exception polling " + (Object)((Object)this) + " in " + this.getSedonaDevice() + " via Sox:", throwable);
            }
            this.readFail(throwable.toString());
        }
    }

    private final void doWriteSox(Context context) {
        int n = this.getTypeId();
        if (n < 0) {
            this.writeFail("typeId not yet read");
            return;
        }
        try {
            BStatusValue bStatusValue = this.getWriteVal();
            if (bStatusValue == null) {
                this.writeReset();
                return;
            }
            Object object = null;
            if (this.getSedonaNetwork().comm().peekCommSession(this.getSedonaDevice()) == null) {
                this.getSedonaDevice().addPendingWrite(this);
                this.getSedonaNetwork().comm().getCommSession(this.getSedonaDevice());
            }
            if (bStatusValue instanceof BStatusBoolean) {
                object = bStatusValue.getStatus().isNull() ? null : BBoolean.make((boolean)((BStatusBoolean)bStatusValue).getValue());
            } else if (bStatusValue instanceof BStatusNumeric) {
                object = BDouble.make((double)((BStatusNumeric)bStatusValue).getValue());
            } else if (bStatusValue instanceof BStatusEnum) {
                int n2 = ((BStatusEnum)bStatusValue).getValue().getOrdinal();
                if (n == 1) {
                    switch (n2) {
                        case 0: {
                            object = BBoolean.FALSE;
                            break;
                        }
                        case 1: {
                            object = BBoolean.TRUE;
                            break;
                        }
                        case 2: {
                            object = null;
                            break;
                        }
                    }
                } else {
                    object = BInteger.make((int)((BStatusEnum)bStatusValue).getValue().getOrdinal());
                }
            } else {
                if (this.getAsStr()) {
                    n = 101;
                }
                object = BString.make((String)bStatusValue.valueToString(context));
            }
            SoxMsg soxMsg = SoxMsg.make(119);
            soxMsg.u2(this.getWriteCompId());
            soxMsg.u1(this.getWritePropId());
            soxMsg.writeValue((BSimple)object, n);
            SoxMsg soxMsg2 = this.getSedonaNetwork().comm().sendRequest(this.getSedonaDevice(), soxMsg);
            this.getSedonaDevice().pingOk();
            if (soxMsg2.isFailed()) {
                soxMsg2.seek(2);
                String string = soxMsg2.str();
                this.writeFail("Sox Error:" + string);
            } else {
                this.setReadStatus(bStatusValue);
                this.writeOk(bStatusValue);
                this.readOk(bStatusValue);
            }
        }
        catch (TimeOutException timeOutException) {
            this.writeFail("Sox timeout");
        }
        catch (Exception exception) {
            if (this.logSox().isTraceOn()) {
                this.logSox().trace("Exception writing " + (Object)((Object)this) + " via Sox:", (Throwable)exception);
            }
            this.writeFail(exception.toString());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doPollChopan(BSedonaBaseDevice bSedonaBaseDevice) {
        try {
            WebReq webReq = new WebReq();
            webReq.uri = this.getAddress();
            webReq.set("Transaction-Id", "" + this.getSedonaDevice().xid());
            webReq.set("Accept", "application/octet-stream");
            webReq.set("Cache-Control", "max-age=20");
            if (this.logCho().isTraceOn()) {
                this.logCho().trace("polling " + (Object)((Object)this) + ':');
                webReq.writeText((OutputStream)System.out);
            }
            WebRes webRes = this.getSedonaNetwork().chopanComm().send(bSedonaBaseDevice.getAddress(), webReq);
            bSedonaBaseDevice.pingOk();
            if (this.logCho().isTraceOn()) {
                this.logCho().trace("response:");
                webRes.writeText((OutputStream)System.out);
            }
            if (webRes.code == 200) {
                this.responseSize = webRes.body.length;
                BinObixDecoder binObixDecoder = null;
                try {
                    binObixDecoder = new BinObixDecoder((InputStream)new ByteArrayInputStream(webRes.body));
                    this.readValue(binObixDecoder);
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    binObixDecoder.close();
                    throw throwable;
                }
                {
                    Object var6_9 = null;
                    binObixDecoder.close();
                    return;
                }
            }
            if (webRes.code == 504) {
                bSedonaBaseDevice.ping();
            }
            this.readFail("Error:" + webRes.code);
            if (!this.logCho().isTraceOn()) return;
            String string = webRes.reason;
            if (webRes.body != null) {
                string = string + "; body=" + ByteArrayUtil.toHexString((byte[])webRes.body);
            }
            this.logCho().trace("CHoPAN poll failed on " + (Object)((Object)this) + ": Error " + webRes.code + ' ' + string);
            return;
        }
        catch (Throwable throwable) {
            if (this.logCho().isTraceOn()) {
                this.logCho().trace("Exception polling " + (Object)((Object)this) + " via CHoPAN:", throwable);
            }
            this.readFail(throwable.toString());
        }
    }

    private final void doWriteChopan(Context context) {
        if (this.getTypeId() < 0) {
            this.writeFail("typeId not yet read");
            return;
        }
        try {
            BStatusValue bStatusValue = this.getWriteVal();
            if (bStatusValue == null) {
                this.writeReset();
                return;
            }
            WebReq webReq = new WebReq();
            webReq.method = "PUT";
            webReq.set("Transaction-Id", "" + this.getSedonaDevice().xid());
            webReq.uri = this.getWriteAddress();
            webReq.body = this.writeValue(bStatusValue);
            if (webReq.body == null) {
                throw new IllegalStateException("Unknown typeId:" + this.getTypeId());
            }
            if (this.logCho().isTraceOn()) {
                this.logCho().trace("writing " + (Object)((Object)this) + ':');
                webReq.writeText((OutputStream)System.out);
            }
            WebRes webRes = this.getSedonaNetwork().chopanComm().send(this.getSedonaDevice().getAddress(), webReq);
            this.getSedonaDevice().pingOk();
            if (this.logCho().isTraceOn()) {
                this.logCho().trace("response:");
                webRes.writeText((OutputStream)System.out);
            }
            if (webRes.code == 200) {
                this.setReadStatus(bStatusValue);
                this.writeOk(bStatusValue);
                this.getSedonaDevice().pingOk();
                this.readOk(bStatusValue);
            } else {
                if (webRes.code == 504) {
                    this.getSedonaDevice().ping();
                }
                this.writeFail("Error:" + webRes.code);
                if (this.logCho().isTraceOn()) {
                    String string = webRes.reason;
                    if (webRes.body != null) {
                        string = string + "; body=" + ByteArrayUtil.toHexString((byte[])webRes.body);
                    }
                    this.logCho().trace("CHoPAN write failed on " + (Object)((Object)this) + ": Error " + webRes.code + ' ' + string);
                }
            }
        }
        catch (Exception exception) {
            if (this.logCho().isTraceOn()) {
                this.logCho().trace("Exception writing " + (Object)((Object)this) + " via CHoPAN:", (Throwable)exception);
            }
            this.writeFail(exception.toString());
        }
    }

    public int getRequestSize() {
        return this.requestSize;
    }

    public int getResponseSize() {
        return this.responseSize;
    }

    public void readValue(BinObixDecoder binObixDecoder) {
        try {
            BStatusNumeric bStatusNumeric;
            Obj obj = binObixDecoder.decodeDocument(false);
            BStatusValue bStatusValue = (BStatusValue)this.getReadValue().newCopy();
            boolean bl = this.getParentPoint().getType().is(BEnumPoint.TYPE);
            int n = obj.getBinCode() << 4;
            if (!this.isChopanTypeOk(n)) {
                this.readFail("Wrong proxy type for CHoPAN " + obj.getElement());
                return;
            }
            this.setTypeId(n);
            switch (n) {
                case 128: {
                    if (bl) {
                        int n2 = ((obix.Bool)obj).get();
                        if (obj.isNull()) {
                            n2 = 2;
                        }
                        bStatusNumeric = new BStatusEnum((BEnum)BDynamicEnum.make((int)n2, (BEnumRange)SEDONA_BOOL_RANGE));
                        break;
                    }
                    bStatusNumeric = new BStatusBoolean(((obix.Bool)obj).get());
                    if (!obj.isNull()) break;
                    bStatusNumeric.setStatusNull(true);
                    break;
                }
                case 256: {
                    bStatusNumeric = new BStatusNumeric(((Real)obj).get());
                    break;
                }
                case 192: {
                    if (bl) {
                        BEnumRange bEnumRange = ((BStatusEnum)bStatusValue).getValue().getRange();
                        bStatusNumeric = new BStatusEnum((BEnum)BDynamicEnum.make((int)((int)((obix.Int)obj).get()), (BEnumRange)bEnumRange));
                        break;
                    }
                    bStatusNumeric = new BStatusNumeric((double)((obix.Int)obj).get());
                    break;
                }
                case 320: {
                    bStatusNumeric = new BStatusString(((Str)obj).get());
                    break;
                }
                default: {
                    this.logCho().message("CHoPAN readValue() on " + (Object)((Object)this) + ": unknown binCode=" + obj.getBinCode());
                    bStatusNumeric = new BStatusString(obj.toDisplayString());
                }
            }
            if (bStatusNumeric.getType().is(bStatusValue.getType())) {
                this.setReadStatus((BStatusValue)bStatusNumeric);
                this.readOk((BStatusValue)bStatusNumeric);
                this.getSedonaDevice().pingOk();
            } else {
                this.readFail("Wrong point type:" + bStatusNumeric);
            }
        }
        catch (Exception exception) {
            this.readFail(exception.toString());
        }
    }

    private final byte[] writeValue(BStatusValue bStatusValue) throws Exception {
        Real real = null;
        boolean bl = this.getParentPoint().getType().is(BEnumPoint.TYPE);
        int n = this.getTypeId();
        block0 : switch (n) {
            case 128: {
                if (bl) {
                    int n2 = ((BStatusEnum)bStatusValue).getValue().getOrdinal();
                    switch (n2) {
                        case 0: {
                            real = new obix.Bool(false);
                            break block0;
                        }
                        case 1: {
                            real = new obix.Bool(true);
                            break block0;
                        }
                    }
                    real = new obix.Bool(true);
                    real.setNull(true);
                    break;
                }
                real = new obix.Bool(((BStatusBoolean)bStatusValue).getBoolean());
                break;
            }
            case 256: {
                real = new Real(((BStatusNumeric)bStatusValue).getValue());
                break;
            }
            case 192: {
                if (bl) {
                    real = new obix.Int((long)((BStatusEnum)bStatusValue).getValue().getOrdinal());
                    break;
                }
                real = new obix.Int((long)((BStatusNumeric)bStatusValue).getValue());
                break;
            }
            case 320: {
                real = new Str(((BStatusString)bStatusValue).getValue());
                break;
            }
            default: {
                return null;
            }
        }
        if (bStatusValue.getStatus().isNull()) {
            real.setNull(true);
        }
        return BinObixEncoder.toBytes((Obj)real);
    }

    public final void update(SoxComponent soxComponent) {
        try {
            Buf buf;
            if (!this.getEnabled()) {
                return;
            }
            int n = this.getPropId();
            Slot slot = soxComponent.type.slot(n);
            Value value = soxComponent.get(slot);
            BBoolean bBoolean = null;
            this.setConfig(slot.isConfig());
            int n2 = value.typeId();
            if (!this.isSoxTypeOk(n2)) {
                this.readFail("Datatype mismatch: Wrong proxy type for Sedona " + sedona.Type.predefinedName((int)n2));
                return;
            }
            this.setTypeId(n2);
            switch (this.getTypeId()) {
                case 0: {
                    break;
                }
                case 1: {
                    bBoolean = BBoolean.make((boolean)((Bool)value).val);
                    break;
                }
                case 2: {
                    bBoolean = BInteger.make((int)((Byte)value).val);
                    break;
                }
                case 3: {
                    bBoolean = BInteger.make((int)((Short)value).val);
                    break;
                }
                case 4: {
                    bBoolean = BInteger.make((int)((Int)value).val);
                    break;
                }
                case 5: {
                    bBoolean = BLong.make((long)((Long)value).val);
                    break;
                }
                case 6: {
                    bBoolean = BDouble.make((double)((Float)value).val);
                    break;
                }
                case 7: {
                    bBoolean = BDouble.make((double)((Double)value).val);
                    break;
                }
                case 101: {
                    bBoolean = BString.make((String)((sedona.Str)value).toString());
                    break;
                }
                case 8: {
                    buf = (Buf)value;
                    try {
                        String string = slot.isAsStr() ? BSedonaProxyExt.toStr(buf) : BSedonaProxyExt.toStr(buf.bytes);
                        bBoolean = BString.make((String)string);
                    }
                    catch (Exception exception) {
                        this.logSox().message("exception processing buf[" + buf.size + "] for " + (Object)((Object)this) + ':' + exception);
                        bBoolean = BString.make((String)("err:" + buf.dumpToString()));
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown value type " + this.getTypeId() + '\'' + (char)this.getTypeId() + '\'');
                }
            }
            buf = this.getParentPoint().getOutStatusValue();
            boolean bl = buf.getType().is(BStatusEnum.TYPE);
            if (bBoolean instanceof BBoolean) {
                if (bl) {
                    Bool bool = (Bool)value;
                    int n3 = 0;
                    if (bool.val) {
                        n3 = 1;
                    }
                    if (value.isNull()) {
                        n3 = 2;
                    }
                    buf = new BStatusEnum((BEnum)BDynamicEnum.make((int)n3, (BEnumRange)SEDONA_BOOL_RANGE));
                } else {
                    buf = new BStatusBoolean(bBoolean.getBoolean());
                    if (value.typeId() == 1) {
                        buf.setStatusNull(value.isNull());
                    }
                }
            } else if (bBoolean instanceof BNumber) {
                if (bl) {
                    BEnumRange bEnumRange = ((BStatusEnum)buf).getValue().getRange();
                    buf = new BStatusEnum((BEnum)BDynamicEnum.make((int)((BNumber)bBoolean).getInt(), (BEnumRange)bEnumRange));
                } else {
                    buf = new BStatusNumeric(((BNumber)bBoolean).getDouble());
                }
            } else {
                buf = new BStatusString(bBoolean.toString());
            }
            this.setReadStatus((BStatusValue)buf);
            this.readOk((BStatusValue)buf);
        }
        catch (Exception exception) {
            if (this.logSox().isTraceOn()) {
                this.logSox().trace("Exception processing Sox update:", (Throwable)exception);
            }
            this.readFail(exception.toString());
        }
    }

    protected int getActiveLevel() {
        return this.getWriteValue().getStatus().geti("activeLevel", 17);
    }

    private final boolean isSoxTypeOk(int n) {
        Type type = this.getParentPoint().getOutStatusValue().getType();
        if (n < 0 || n > 101) {
            return false;
        }
        switch (n) {
            case 0: {
                return true;
            }
            case 1: {
                boolean bl = false;
                if (type == BStatusBoolean.TYPE || type == BStatusEnum.TYPE) {
                    bl = true;
                }
                return bl;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                boolean bl = false;
                if (type == BStatusNumeric.TYPE || type == BStatusEnum.TYPE) {
                    bl = true;
                }
                return bl;
            }
            case 6: 
            case 7: {
                boolean bl = false;
                if (type == BStatusNumeric.TYPE) {
                    bl = true;
                }
                return bl;
            }
            case 101: {
                boolean bl = false;
                if (type == BStatusString.TYPE) {
                    bl = true;
                }
                return bl;
            }
            case 8: {
                return true;
            }
        }
        return true;
    }

    private final boolean isChopanTypeOk(int n) {
        Type type = this.getParentPoint().getOutStatusValue().getType();
        if (n < 128) {
            return false;
        }
        switch (n) {
            case 128: {
                boolean bl = false;
                if (type == BStatusBoolean.TYPE || type == BStatusEnum.TYPE) {
                    bl = true;
                }
                return bl;
            }
            case 192: {
                boolean bl = false;
                if (type == BStatusNumeric.TYPE || type == BStatusEnum.TYPE) {
                    bl = true;
                }
                return bl;
            }
            case 256: {
                boolean bl = false;
                if (type == BStatusNumeric.TYPE) {
                    bl = true;
                }
                return bl;
            }
            case 320: {
                boolean bl = false;
                if (type == BStatusString.TYPE) {
                    bl = true;
                }
                return bl;
            }
        }
        return true;
    }

    private final void checkTypeId() {
        int n = this.getTypeId();
        if (this.getSedonaTuningPolicy().isChopan()) {
            this.setTypeId(SedPntUtil.sox2Chopan(n));
        } else {
            this.setTypeId(SedPntUtil.chopan2Sox(n));
        }
    }

    private final void checkResubscribe(Context context, boolean bl) {
        try {
            this.checkTypeId();
            if (this.getEnabled() && this.isSubscribedDesired()) {
                this.getSedonaNetwork().postAsync(new Async(this, context, bl){

                    public final void run() {
                        try {
                            BSedonaProxyExt.this.doProxyChanged(this.net, this.dev, this.cx, this.flag);
                        }
                        catch (Exception exception) {
                            BSedonaProxyExt.this.log().trace("Exception resubscribing " + this, (Throwable)exception);
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            this.log().trace("Exception resubscribing " + (Object)((Object)this), (Throwable)exception);
        }
    }

    private final void doProxyChanged(BSedonaBaseNetwork bSedonaBaseNetwork, BSedonaBaseDevice bSedonaBaseDevice, Context context, boolean bl) throws Exception {
        this.doReadUnsubscribed(bSedonaBaseNetwork, bSedonaBaseDevice, context);
        if (bl) {
            this.compId = -1;
            this.propId = -1;
            this.cfg = null;
            this.setTypeId(-1);
        }
        if (this.getSedonaTuningPolicy().isSoxEvent()) {
            this.doReadSubscribed(bSedonaBaseNetwork, bSedonaBaseDevice, context);
        } else {
            this.readSubscribed(context);
        }
    }

    static String toStr(Buf buf) throws IOException {
        byte[] byArray = buf.bytes;
        int n = buf.size;
        boolean bl = false;
        int n2 = n;
        while (--n2 >= 0) {
            if (byArray[n2] != 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            String string = buf.str();
            if (string.length() < buf.size - 1) {
                return BSedonaProxyExt.toStr(byArray);
            }
            return string;
        }
        return BSedonaProxyExt.toStr(byArray);
    }

    static String toStr(byte[] byArray) {
        int n = byArray.length;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        int n2 = 0;
        while (n2 < n) {
            if (n2 % 4 == 0) {
                printWriter.print(' ');
            }
            printWriter.print(TextUtil.byteToHexString((int)(byArray[n2] & 0xFF)));
            ++n2;
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    public final int getComponentId() {
        if (this.compId == -1) {
            this.compId = SedPntUtil.getComponentId(this.getAddress());
        }
        return this.compId;
    }

    public final int getPropId() {
        if (this.propId == -1) {
            this.propId = SedPntUtil.getPropId(this.getAddress());
        }
        return this.propId;
    }

    public final boolean getCfg() {
        if (this.cfg == null) {
            this.cfg = new Boolean(this.getConfig());
        }
        return this.cfg;
    }

    private final Log log() {
        return this.getSedonaNetwork().getLog();
    }

    private final Log logSox() {
        return this.getSedonaNetwork().getLogSox();
    }

    private final Log logCho() {
        return this.getSedonaNetwork().getLogCho();
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        try {
            spyWriter.startProps("Sedona Proxy Ext");
            spyWriter.prop((Object)"compId", this.compId);
            spyWriter.prop((Object)"propId", this.propId);
            spyWriter.prop((Object)"cfg", (Object)this.cfg);
            spyWriter.prop((Object)"polled", this.polled);
            spyWriter.prop((Object)"requestSize", this.requestSize);
            spyWriter.prop((Object)"responseSize", this.responseSize);
            spyWriter.endProps();
        }
        catch (Exception exception) {
            spyWriter.prop((Object)"ERROR:", (Object)exception.toString());
            this.log().trace("Exception generating spy for " + (Object)((Object)this), (Throwable)exception);
        }
        super.spy(spyWriter);
    }

    public String info() {
        return (Object)((Object)this) + " [compId=" + this.compId + " propId=" + this.propId + " typeId=" + this.getTypeId() + " address=" + this.getAddress() + " config=" + this.getConfig() + ']';
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.compId = -1;
        this.propId = -1;
        this.cfg = null;
        this.requestSize = 0;
        this.responseSize = 7;
        this.polled = false;
    }

    public BSedonaProxyExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$sedonanet$driver$point$BSedonaProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$sedonanet$driver$point$BSedonaProxyExt = BSedonaProxyExt.class("[Lcom.tridium.sedonanet.driver.point.BSedonaProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        SEDONA_BOOL_FALSE = lex.getText("sedonaBool.false");
        SEDONA_BOOL_TRUE = lex.getText("sedonaBool.true");
        SEDONA_BOOL_NULL = lex.getText("sedonaBool.null");
        SEDONA_BOOL_RANGE = BEnumRange.make((String[])new String[]{SEDONA_BOOL_FALSE, SEDONA_BOOL_TRUE, SEDONA_BOOL_NULL});
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Async
    implements Runnable {
        BSedonaBaseNetwork net;
        BSedonaBaseDevice dev;
        Context cx;
        boolean flag;

        public void run() {
        }

        Async(Context context) {
            this(context, false);
        }

        Async(Context context, boolean bl) {
            this.cx = context;
            this.flag = bl;
            this.net = BSedonaProxyExt.this.getSedonaNetwork();
            this.dev = BSedonaProxyExt.this.getSedonaDevice();
        }
    }
}

