/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.ui.datetime;

import com.tridium.nsedona.sys.BSedonaComponent;
import com.tridium.nsedona.ui.datetime.BRwTimeZoneFE;
import com.tridium.nsedona.ui.datetime.TimeUtil;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.sedona.sys.BSedonaBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BLong;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.TimeZoneDatabase;
import javax.baja.timezone.TimeZoneException;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;
import javax.baja.workbench.view.BWbView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDateTimeServiceView
extends BWbComponentView {
    public static final Action onTimeZoneModified = BDateTimeServiceView.newAction((int)4, null);
    public static final Type TYPE;
    static BFont bold;
    BTextField curTime;
    BWbFieldEditor desiredTime;
    BTextField curTimeZone;
    BWbFieldEditor desiredTimeZone;
    BTextField curOffset;
    BTextField desiredOffset;
    BTextField curMode;
    ToggleCommandGroup desiredMode;
    ToggleCommand modeOs;
    ToggleCommand modeConfig;
    static /* synthetic */ Class class$com$tridium$nsedona$ui$datetime$BDateTimeServiceView;

    public void onTimeZoneModified() {
        this.invoke(onTimeZoneModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        BTimeZone bTimeZone;
        String string;
        BSedonaComponent bSedonaComponent = (BSedonaComponent)bObject;
        long l = bSedonaComponent.getLong(bSedonaComponent.getProperty("nanos"));
        int n = bSedonaComponent.getInt(bSedonaComponent.getProperty("utcOffset"));
        boolean bl = ((BSedonaBoolean)bSedonaComponent.get("osUtcOffset")).getBoolean();
        BAbsTime bAbsTime = null;
        try {
            string = bSedonaComponent.getString(bSedonaComponent.getProperty("tz"));
            bTimeZone = TimeZoneDatabase.getTimeZone((String)string);
            if (bTimeZone != null && bTimeZone.getUtcOffset() == n) {
                bAbsTime = BAbsTime.make((long)(l / 1000000L + TimeUtil.epochMillis), (BTimeZone)bTimeZone);
            }
        }
        catch (TimeZoneException timeZoneException) {}
        if (bAbsTime == null) {
            bAbsTime = BAbsTime.make((long)(l / 1000000L + TimeUtil.epochMillis));
        }
        this.curTime = new BTextField("", 24, false);
        this.desiredTime = BWbFieldEditor.makeFor((BObject)bAbsTime, (Context)context);
        this.linkTo((BComponent)this.desiredTime, (Slot)BWbFieldEditor.pluginModified, (Slot)BWbView.setModified);
        this.curTimeZone = new BTextField("", 24, false);
        this.desiredTimeZone = new BRwTimeZoneFE();
        this.linkTo((BComponent)this.desiredTimeZone, (Slot)BWbFieldEditor.pluginModified, (Slot)onTimeZoneModified);
        this.curOffset = new BTextField("", 6, false);
        this.desiredOffset = new BTextField("", 6, false);
        this.curMode = new BTextField("", 24, false);
        this.modeOs = new ToggleCommand((BWidget)this, "Use System Offset");
        this.modeConfig = new ToggleCommand((BWidget)this, "Use Configured Offset");
        this.desiredMode = new ToggleCommandGroup(){

            public final void selected(ToggleCommand toggleCommand) {
                BDateTimeServiceView.this.setModified();
            }
        };
        this.desiredMode.add(this.modeOs);
        this.desiredMode.add(this.modeConfig);
        string = new BGridPane();
        string.add(null, (BValue)new BRadioButton(this.modeOs));
        string.add(null, (BValue)new BRadioButton(this.modeConfig));
        this.desiredTime.loadValue((BObject)bAbsTime, context);
        this.desiredTimeZone.loadValue((BObject)bAbsTime.getTimeZone(), context);
        this.desiredTimeZone.setReadonly(bl);
        if (bl) {
            this.modeOs.setSelected(true);
        } else {
            this.modeConfig.setSelected(true);
        }
        this.doOnTimeZoneModified();
        this.updateCurrent();
        bTimeZone = new BGridPane();
        bTimeZone.setColumnCount(3);
        bTimeZone.setValign(BValign.top);
        bTimeZone.setHalign(BHalign.left);
        bTimeZone.setColumnGap(10.0);
        bTimeZone.setRowGap(10.0);
        bTimeZone.add(null, (BValue)new BLabel(""));
        bTimeZone.add(null, (BValue)new BLabel("Current", bold));
        bTimeZone.add(null, (BValue)new BLabel("Desired", bold));
        bTimeZone.add(null, (BValue)new BLabel("Current Time", bold));
        bTimeZone.add(null, (BValue)this.curTime);
        bTimeZone.add(null, (BValue)this.desiredTime);
        bTimeZone.add(null, (BValue)new BLabel("Time Zone", bold));
        bTimeZone.add(null, (BValue)this.curTimeZone);
        bTimeZone.add(null, (BValue)this.desiredTimeZone);
        bTimeZone.add(null, (BValue)new BLabel("UTC Offset", bold));
        bTimeZone.add(null, (BValue)this.curOffset);
        bTimeZone.add(null, (BValue)this.desiredOffset);
        bTimeZone.add(null, (BValue)new BLabel("UTC Offset Mode", bold));
        bTimeZone.add(null, (BValue)this.curMode);
        bTimeZone.add(null, (BValue)string);
        bTimeZone.add(null, (BValue)new BLabel(""));
        bTimeZone.add(null, (BValue)new BLabel(""));
        bTimeZone.add(null, (BValue)new BButton((Command)new WbTime((BWidget)this)));
        BWizardHeader bWizardHeader = new BWizardHeader(BImage.make((String)"module://icons/x32/clock.png"), "DateTimeService", "Manage system clock for device");
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)bWizardHeader);
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)bTimeZone));
        BGridPane bGridPane = new BGridPane();
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setUniformColumnWidth(true);
        bGridPane.add(null, (BValue)new BButton(this.getWbShell().getRefreshCommand()));
        bGridPane.add(null, (BValue)new BButton(this.getWbShell().getSaveCommand()));
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setCenter((BWidget)new BBorderPane((BWidget)bEdgePane, BBorder.inset, BInsets.make((double)0.0)));
        bEdgePane2.setBottom((BWidget)new BBorderPane((BWidget)bGridPane, (double)5, (double)5, 0.0, (double)5));
        this.setContent((BWidget)bEdgePane2);
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws CannotSaveException, Exception {
        BAbsTime bAbsTime = (BAbsTime)this.desiredTime.saveValue(context);
        long l = (bAbsTime.getMillis() - TimeUtil.epochMillis) * 1000000L;
        if (l < 0L) {
            throw new CannotSaveException("Desired time is before the Sedona epoch: " + TimeUtil.epoch);
        }
        BSedonaComponent bSedonaComponent = (BSedonaComponent)bObject;
        boolean bl2 = ((BSedonaBoolean)bSedonaComponent.get("osUtcOffset")).getBoolean();
        if (!bl2) {
            int bl = bAbsTime.getTimeZoneOffset() / 1000;
            bSedonaComponent.setInt(bSedonaComponent.getProperty("utcOffset"), bl);
            bSedonaComponent.setString(bSedonaComponent.getProperty("tz"), bAbsTime.getTimeZone().getId());
        }
        boolean bl = this.modeOs.isSelected();
        bSedonaComponent.set(bSedonaComponent.getProperty("osUtcOffset"), (BValue)BSedonaBoolean.make(bl));
        this.desiredTimeZone.setReadonly(bl);
        if (!bl2 && bl) {
            bSedonaComponent.setString(bSedonaComponent.getProperty("tz"), "");
        }
        bSedonaComponent.invoke(bSedonaComponent.getAction("setSysClock"), (BValue)BLong.make((long)l));
        this.updateCurrent();
        return bSedonaComponent;
    }

    public void doOnTimeZoneModified() throws Exception {
        BTimeZone bTimeZone = (BTimeZone)this.desiredTimeZone.saveValue();
        BAbsTime bAbsTime = (BAbsTime)this.desiredTime.saveValue();
        bAbsTime = BAbsTime.make((long)bAbsTime.getMillis(), (BTimeZone)bTimeZone);
        this.desiredTime.loadValue((BObject)bAbsTime);
        int n = bAbsTime.getTimeZoneOffset() / 1000;
        this.desiredOffset.setText(BDateTimeServiceView.toOffsetStr(n));
        this.setModified();
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        this.updateCurrent();
    }

    public void updateCurrent() {
        BSedonaComponent bSedonaComponent = (BSedonaComponent)this.getCurrentValue();
        int n = bSedonaComponent.getInt(bSedonaComponent.getProperty("utcOffset"));
        boolean bl = ((BSedonaBoolean)bSedonaComponent.get(bSedonaComponent.getProperty("osUtcOffset"))).getBoolean();
        this.curTime.setText(BDateTimeServiceView.toTimeStr(bSedonaComponent));
        String string = bSedonaComponent.getString(bSedonaComponent.getProperty("tz"));
        if (string == null) {
            string = "";
        }
        this.curTimeZone.setText(string);
        this.curOffset.setText(BDateTimeServiceView.toOffsetStr(n));
        this.curMode.setText(bl ? "Using System Offset" : "Using Configured Offset");
    }

    public static String toOffsetStr(int n) {
        String string;
        String string2 = string = n > 0 ? "+" : "";
        if (n % 3600 == 0) {
            return string + n / 3600 + " hr";
        }
        return string + n + " sec";
    }

    public static String toTimeStr(BSedonaComponent bSedonaComponent) {
        try {
            int n = bSedonaComponent.getInt(bSedonaComponent.getProperty("hour"));
            int n2 = bSedonaComponent.getInt(bSedonaComponent.getProperty("minute"));
            int n3 = bSedonaComponent.getInt(bSedonaComponent.getProperty("second"));
            int n4 = bSedonaComponent.getInt(bSedonaComponent.getProperty("year"));
            int n5 = bSedonaComponent.getInt(bSedonaComponent.getProperty("month"));
            int n6 = bSedonaComponent.getInt(bSedonaComponent.getProperty("day"));
            int n7 = bSedonaComponent.getInt(bSedonaComponent.getProperty("dayOfWeek"));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(n6).append('-');
            try {
                stringBuffer.append(BMonth.make((int)(n5 - 1)).getShortDisplayTag(null));
            }
            catch (Exception exception) {
                stringBuffer.append(n5);
            }
            stringBuffer.append('-').append(n4).append(' ');
            if (n < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n).append(':');
            if (n2 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n2).append(':');
            if (n3 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n3).append(' ');
            try {
                stringBuffer.append(BWeekday.make((int)n7).getShortDisplayTag(null));
            }
            catch (Exception exception) {}
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "Error";
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$nsedona$ui$datetime$BDateTimeServiceView;
        if (clazz == null) {
            clazz = class$com$tridium$nsedona$ui$datetime$BDateTimeServiceView = BDateTimeServiceView.class("[Lcom.tridium.nsedona.ui.datetime.BDateTimeServiceView;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        bold = Theme.widget().getBoldText();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class WbTime
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            BDateTimeServiceView.this.desiredTime.loadValue((BObject)BAbsTime.now());
            if (BDateTimeServiceView.this.modeConfig.isSelected()) {
                BDateTimeServiceView.this.desiredTimeZone.loadValue((BObject)BTimeZone.getLocal());
                BDateTimeServiceView.this.onTimeZoneModified();
            }
            BDateTimeServiceView.this.setModified();
            return null;
        }

        public WbTime(BWidget bWidget) {
            super(bWidget, TYPE.getModule(), "cmd.wbtime");
        }
    }
}

