/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.env;

import com.tridium.nsedona.env.KitDb;
import com.tridium.nsedona.env.ManifestDb;
import com.tridium.nsedona.env.PlatformDb;
import com.tridium.nsedona.env.SedonaEnv;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.zip.ZipInputStream;
import javax.baja.file.FileUtil;
import javax.baja.license.LicenseException;
import javax.baja.log.Log;
import javax.baja.sys.Sys;
import sedona.Depend;
import sedona.KitPart;
import sedona.kit.KitFile;
import sedona.manifest.KitManifest;
import sedona.offline.OfflineApp;
import sedona.platform.PlatformDb;
import sedona.platform.PlatformManifest;
import sedona.util.TextUtil;
import sedona.util.Version;
import sedona.xml.XElem;
import sedona.xml.XParser;
import sedonac.Compiler;
import sedonac.CompilerLog;
import sedonac.ir.IrMethod;
import sedonac.ir.IrOp;
import sedonac.ir.IrSlot;
import sedonac.ir.IrType;
import sedonac.namespace.NativeId;

public class LocalSedonaEnv
implements SedonaEnv {
    protected static final Log log = Log.getLog((String)"sedona.localenv");

    public PlatformDb platformDb() {
        return new LocalPlatformDb(this);
    }

    public KitDb kitDb() {
        return new LocalKitDb(this);
    }

    public ManifestDb manifestDb() {
        return new LocalManifestDb(this);
    }

    public File buildApp(XElem xElem, CompilerLog compilerLog) throws Exception {
        File file = File.createTempFile("app", ".sab");
        compilerLog.info("  Compiling app.sab");
        OfflineApp offlineApp = OfflineApp.decodeAppXml((XElem)xElem);
        offlineApp.encodeAppBinary(file);
        compilerLog.info("  +----------------------------------");
        compilerLog.info("  |  RAM:   " + TextUtil.kb((int)offlineApp.ramSize()));
        compilerLog.info("  |  FLASH: " + TextUtil.kb((int)offlineApp.flashSize()));
        compilerLog.info("  +----------------------------------");
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File buildScode(XElem xElem, CompilerLog compilerLog) throws Exception {
        this.verifyJace2();
        String string = xElem.get("__platformId__", null);
        xElem.removeAttr("__platformId__");
        File file = File.createTempFile("kits", ".xml");
        xElem.write(file);
        Compiler compiler = new Compiler();
        compiler.log = compilerLog;
        try {
            compiler.compile(file);
            this.checkNativeCompatibility(string, compiler);
            String string2 = file.getName();
            String string3 = string2.substring(0, string2.lastIndexOf(46)) + ".scode";
            File file2 = new File(file.getParentFile(), string3);
            Object var7_9 = null;
            if (!file.delete()) {
                file.deleteOnExit();
            }
            return file2;
        }
        catch (Throwable throwable) {
            block3: {
                Object var7_10 = null;
                if (file.delete()) break block3;
                file.deleteOnExit();
            }
            throw throwable;
        }
    }

    private final void verifyJace2() throws Exception {
        String string = Sys.getHostId();
        if (string.indexOf("NPM2") >= 0) {
            try {
                Sys.getLicenseManager().checkFeature("tridium", "maxHeap");
            }
            catch (LicenseException licenseException) {
                throw new Exception("JACE2 must have the 'maxHeap' license feature to compile scode", licenseException);
            }
        }
    }

    private final void checkNativeCompatibility(String string, Compiler compiler) throws Exception {
        Object object;
        if (string == null) {
            return;
        }
        PlatformManifest platformManifest = this.platformDb().getPlatformManifest(string);
        if (platformManifest == null) {
            compiler.log.info("  Could not find platform manifest for " + string + ". Skipping native compatibility checks");
            return;
        }
        compiler.log.info("\n  Checking scode compatibility with target platform SVM");
        compiler.log.info("  Target platform is: " + string + '\n');
        HashMap<String, String> hashMap = new HashMap<String, String>(platformManifest.nativeMethods.length);
        int n = 0;
        while (n < platformManifest.nativeMethods.length) {
            hashMap.put(platformManifest.nativeMethods[n].nativeId, platformManifest.nativeMethods[n].qname);
            ++n;
        }
        n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < compiler.kits.length) {
            object = compiler.kits[n2];
            int n3 = 0;
            while (n3 < object.types.length) {
                IrType irType = object.types[n3];
                IrSlot[] irSlotArray = irType.declared;
                int n4 = 0;
                while (n4 < irSlotArray.length) {
                    if (irSlotArray[n4].isMethod()) {
                        IrMethod irMethod = (IrMethod)irSlotArray[n4];
                        if (irMethod.code != null) {
                            int n5 = 0;
                            while (n5 < irMethod.code.length) {
                                IrOp irOp = irMethod.code[n5];
                                switch (irOp.opcode) {
                                    case 223: 
                                    case 224: 
                                    case 225: {
                                        NativeId nativeId = irOp.argToMethod().nativeId;
                                        String string2 = irOp.arg;
                                        String string3 = (String)hashMap.get(nativeId.toString());
                                        if (string3 != null) {
                                            if (string3.equals(string2)) break;
                                            ++n;
                                            stringBuffer.append("[scode <> svm]: ").append(string2).append(" ").append(nativeId).append(" <> ").append(string3).append(" ").append(nativeId).append("\n");
                                            break;
                                        }
                                        ++n;
                                        stringBuffer.append(string2).append(" ").append(nativeId).append(" not implemented in the SVM\n");
                                        break;
                                    }
                                }
                                ++n5;
                            }
                        }
                    }
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        if (n > 0) {
            StringBuffer stringBuffer2 = new StringBuffer().append("Platform SVM is not natively compatible with generated scode.\n").append(n).append(" scode native compatibilty problem(s) identified:\n").append(stringBuffer.toString()).append('\n');
            object = new StringBuffer().append(stringBuffer2.toString()).append("Do you want to ignore the errors and install the scode anyway?\n");
            throw new Exception(stringBuffer2.toString());
        }
    }

    private static class LocalPlatformDb
    extends PlatformDb {
        private sedona.platform.PlatformDb db = sedona.platform.PlatformDb.db();

        public PlatformManifest getPlatformManifest(String string) {
            try {
                return this.db.loadExact(string);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public String getSvmUri(String string) {
            PlatformDb.DbVm dbVm = this.db.getVm(string);
            return dbVm == null ? null : dbVm.name();
        }

        public void extractPar(String string, File file) {
            this.db.extractPar(string, file);
        }

        public void installPar(ZipInputStream zipInputStream) {
            this.db.install(zipInputStream);
        }

        public LocalPlatformDb(SedonaEnv sedonaEnv) {
            super(sedonaEnv);
        }
    }

    private static class LocalKitDb
    extends KitDb {
        public String[] kits() {
            return sedona.kit.KitDb.kits();
        }

        public KitDb.KitSummary[] list(String string) throws Exception {
            KitFile[] kitFileArray = sedona.kit.KitDb.list((String)string);
            KitDb.KitSummary[] kitSummaryArray = new Summary[kitFileArray.length];
            int n = 0;
            while (n < kitFileArray.length) {
                XElem xElem = XParser.make((File)kitFileArray[n].file).parse();
                kitSummaryArray[n] = new Summary(KitManifest.fromXml((XElem)xElem));
                ++n;
            }
            return kitSummaryArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean extractKit(Depend depend, OutputStream outputStream) throws Exception {
            boolean bl;
            KitFile kitFile = sedona.kit.KitDb.matchBest((Depend)depend);
            if (kitFile == null) {
                return false;
            }
            FileInputStream fileInputStream = new FileInputStream(kitFile.file);
            try {
                FileUtil.pipe((InputStream)fileInputStream, (OutputStream)outputStream);
                bl = true;
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                fileInputStream.close();
                throw throwable;
            }
            fileInputStream.close();
            return bl;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void installKit(String string, int n, Version version, InputStream inputStream) throws Exception {
            File file = sedona.kit.KitDb.toFile((String)string, (int)n, (Version)version);
            file.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                FileUtil.pipe((InputStream)inputStream, (OutputStream)fileOutputStream);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                fileOutputStream.close();
                throw throwable;
            }
            {
                Object var8_9 = null;
            }
            fileOutputStream.close();
        }

        public LocalKitDb(SedonaEnv sedonaEnv) {
            super(sedonaEnv);
        }
    }

    private static class LocalManifestDb
    extends ManifestDb {
        public KitManifest extractManifest(KitPart kitPart) {
            try {
                return sedona.manifest.ManifestDb.load((KitPart)kitPart);
            }
            catch (Exception exception) {
                if (log.isTraceOn()) {
                    log.trace("exception loading " + kitPart, (Throwable)exception);
                }
                return null;
            }
        }

        public boolean installManifest(KitManifest kitManifest) {
            boolean bl = false;
            if (kitManifest != null) {
                bl = sedona.manifest.ManifestDb.save((KitManifest)kitManifest);
            }
            return bl;
        }

        public LocalManifestDb(SedonaEnv sedonaEnv) {
            super(sedonaEnv);
        }
    }

    private static class Summary
    extends KitDb.KitSummary {
        private final KitManifest m;

        public String name() {
            return this.m.name;
        }

        public int checksum() {
            return this.m.checksum;
        }

        public Version version() {
            return this.m.version;
        }

        public Depend[] depends() {
            return this.m.depends;
        }

        public boolean hasNatives() {
            return this.m.hasNatives;
        }

        public long buildTime() {
            return this.m.buildTime.getMillis();
        }

        public Summary(KitManifest kitManifest) {
            this.m = kitManifest;
        }
    }
}

