/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.env;

import com.tridium.nsedona.env.SedonaEnv;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.util.TextUtil;
import sedona.Depend;
import sedona.KitPart;
import sedona.sox.KitVersion;
import sedona.util.Version;

public abstract class KitDb {
    public final SedonaEnv env;

    public static String toKitFilename(String string, int n, Version version) {
        return string + '-' + Integer.toHexString(n) + '-' + version + ".kit";
    }

    public static String toKitFilename(KitVersion kitVersion) {
        return KitDb.toKitFilename(kitVersion.name, kitVersion.checksum, kitVersion.version);
    }

    public abstract String[] kits();

    public abstract KitSummary[] list(String var1) throws Exception;

    public final boolean extractKit(String string, int n, Version version, OutputStream outputStream) throws Exception {
        return this.extractKit(Depend.parse((String)(string + " 0x" + TextUtil.intToHexString((int)n) + ", " + version)), outputStream);
    }

    public abstract boolean extractKit(Depend var1, OutputStream var2) throws Exception;

    public abstract void installKit(String var1, int var2, Version var3, InputStream var4) throws Exception;

    public KitDb(SedonaEnv sedonaEnv) {
        this.env = sedonaEnv;
    }

    public static abstract class KitSummary {
        public abstract String name();

        public abstract int checksum();

        public abstract Version version();

        public abstract Depend[] depends();

        public abstract boolean hasNatives();

        public abstract long buildTime();

        public KitPart getKitPart() {
            return new KitPart(this.name(), this.checksum(), this.version());
        }

        public String fileName() {
            return KitDb.toKitFilename(this.name(), this.checksum(), this.version());
        }

        public String toString() {
            return this.fileName();
        }
    }
}

