/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.dasp;

import com.tridium.net.HttpUtil;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import javax.baja.log.Log;
import javax.baja.sedona.dasp.BRouteHandler;
import javax.baja.status.BStatus;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;
import sedona.dasp.DaspMsg;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BIpRouter
extends BRouteHandler
implements Runnable {
    public static final Property status = BIpRouter.newProperty((int)3, (BValue)BStatus.down, null);
    public static final Property faultCause = BIpRouter.newProperty((int)3, (String)"", null);
    public static final Type TYPE;
    private static final Log log;
    private volatile boolean isAlive;
    private DatagramSocket socket;
    private final DatagramPacket p;
    private Thread router;
    private final Queue routeQ;
    private Receiver receiver;
    private HashMap cache;
    static /* synthetic */ Class class$com$tridium$nsedona$dasp$BIpRouter;

    public final BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public final void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public final String getFaultCause() {
        return this.getString(faultCause);
    }

    public final void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        super.started();
        if (!this.isRunning()) {
            return;
        }
        this.routeQ.clear();
        this.cache.clear();
        this.isAlive = true;
        this.router = new Thread((Runnable)this, "BIpRouter.Router:?");
        this.router.start();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void stopped() throws Exception {
        super.stopped();
        this.isAlive = false;
        if (this.router == null) {
            return;
        }
        if (this.socket != null) {
            log.message("Ip router stopped on port " + this.socket.getLocalPort());
            this.socket.close();
            this.socket = null;
        }
        try {
            try {
                this.receiver.interrupt();
                this.router.interrupt();
                this.receiver.join();
                this.router.join();
            }
            catch (Exception exception) {
                if (log.isTraceOn()) {
                    log.trace("Stop failed", (Throwable)exception);
                }
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.receiver = null;
            this.router = null;
            this.setStatus(BStatus.down);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.receiver = null;
            this.router = null;
            this.setStatus(BStatus.down);
            return;
        }
    }

    public final void run() {
        this.openSocket();
        this.routeMessages();
    }

    private final void openSocket() {
        while (this.isAlive) {
            try {
                this.socket = new DatagramSocket();
                this.receiver = new Receiver();
                this.receiver.start();
                this.setStatus(BStatus.ok);
                this.setFaultCause("");
                Thread.currentThread().setName("BIpRouter.Router:" + this.socket.getLocalPort());
                log.message("Ip router started on port " + this.socket.getLocalPort());
                return;
            }
            catch (Exception exception) {
                this.setStatus(BStatus.fault);
                this.setFaultCause("Could not open socket: " + exception.getMessage());
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private final void routeMessages() {
        while (this.isAlive) {
            try {
                RouteTuple routeTuple = (RouteTuple)this.routeQ.dequeue(1000);
                if (routeTuple == null) continue;
                HostPort hostPort = this.decode(routeTuple.address);
                this.p.setSocketAddress(new InetSocketAddress(hostPort.host, hostPort.port));
                this.p.setLength(routeTuple.msg.encode(this.p.getData()));
                this.socket.send(this.p);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
                if (!log.isTraceOn()) continue;
                log.trace("route failed", (Throwable)exception);
            }
        }
    }

    public final boolean canRoute(String string) {
        return "ip".equals(string);
    }

    public final void route(DaspMsg daspMsg, String string) {
        this.routeQ.enqueue((Object)new RouteTuple(daspMsg, string));
    }

    private final HostPort decode(String string) {
        HostPort hostPort = (HostPort)this.cache.get(string);
        if (hostPort == null) {
            hostPort = new HostPort();
            hostPort.host = HttpUtil.parseHost((String)string);
            hostPort.port = HttpUtil.parsePort((String)string, (int)1876);
            this.cache.put(string, hostPort);
        }
        return hostPort;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.isAlive = false;
        this.routeQ = new Queue(2000);
        this.cache = new HashMap(13);
    }

    public BIpRouter() {
        this.this();
        this.p = new DatagramPacket(new byte[1024], 1024);
    }

    static {
        Class clazz = class$com$tridium$nsedona$dasp$BIpRouter;
        if (clazz == null) {
            clazz = class$com$tridium$nsedona$dasp$BIpRouter = BIpRouter.class("[Lcom.tridium.nsedona.dasp.BIpRouter;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"sedona.dasp.ipRouter");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Receiver
    extends Thread {
        DatagramPacket p;

        public void run() {
            while (BIpRouter.this.isAlive) {
                try {
                    this.p.setLength(1024);
                    BIpRouter.this.socket.receive(this.p);
                    BIpRouter.this.reroute(DaspMsg.decode((DatagramPacket)this.p));
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (Exception exception) {
                    if (!BIpRouter.this.isAlive || !log.isTraceOn()) continue;
                    log.trace("failed receive", (Throwable)exception);
                }
            }
        }

        private final /* synthetic */ void this() {
            this.p = new DatagramPacket(new byte[1024], 1024);
        }

        public Receiver() {
            super("IpRouter.Receiver:" + BIpRouter.this.socket.getLocalPort());
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class RouteTuple {
        public final DaspMsg msg;
        public final String address;

        public RouteTuple(DaspMsg daspMsg, String string) {
            this.msg = daspMsg;
            this.address = string;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class HostPort {
        public String host;
        public int port;

        public String toString() {
            return this.host + ':' + this.port;
        }

        HostPort() {
        }
    }
}

