/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jen6lp.messages;

import com.tridium.jen6lp.BMac154DeviceAddress;
import com.tridium.jen6lp.messages.JenserUnsCtrlMsg;
import com.tridium.jen6lp.util.JenserInputStream;

public class JennicRoutingEntryMsg
extends JenserUnsCtrlMsg {
    int u16EntryNum;
    int u16TotalEntries;
    BMac154DeviceAddress sDestAddr;
    BMac154DeviceAddress sNextHopAddr;

    public static JenserUnsCtrlMsg make(int n, JenserInputStream jenserInputStream) {
        JennicRoutingEntryMsg jennicRoutingEntryMsg = new JennicRoutingEntryMsg(n);
        jennicRoutingEntryMsg.u16EntryNum = jenserInputStream.readUint16();
        jennicRoutingEntryMsg.u16TotalEntries = jenserInputStream.readUint16();
        int n2 = jenserInputStream.readUint32();
        int n3 = jenserInputStream.readUint32();
        jennicRoutingEntryMsg.sDestAddr = BMac154DeviceAddress.make(n3, n2);
        n2 = jenserInputStream.readUint32();
        n3 = jenserInputStream.readUint32();
        jennicRoutingEntryMsg.sNextHopAddr = BMac154DeviceAddress.make(n3, n2);
        return jennicRoutingEntryMsg;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  Entry Num  \t").append(this.u16EntryNum + 1).append('\n');
        stringBuffer.append("  Tot Entries\t").append(this.u16TotalEntries).append('\n');
        stringBuffer.append("  Dest Addr  \t").append(this.sDestAddr.toString()).append('\n');
        stringBuffer.append("  Next Hop   \t").append(this.sNextHopAddr.toString()).append('\n');
        return stringBuffer.toString();
    }

    public String toShortString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Routing Table Entry [" + (this.u16EntryNum + 1) + '/' + this.u16TotalEntries + "] ");
        stringBuffer.append(this.sDestAddr.toString()).append(" next hop ").append(this.sNextHopAddr.toString());
        return stringBuffer.toString();
    }

    JennicRoutingEntryMsg(int n) {
        super(n);
    }
}

