/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jen6lp.messages;

import com.tridium.jen6lp.BMac154DeviceAddress;
import com.tridium.jen6lp.messages.JenserUnsCtrlMsg;
import com.tridium.jen6lp.util.JenserInputStream;

public class JennicNeighborEntryMsg
extends JenserUnsCtrlMsg {
    int u8EntryNum;
    int u8TotalEntries;
    BMac154DeviceAddress sAddr;
    boolean bSleepingED;
    int u8LinkQuality;
    int u16PktsLost;
    int u16PktsSent;
    int u16PktsRcvd;

    public static JenserUnsCtrlMsg make(int n, JenserInputStream jenserInputStream) {
        JennicNeighborEntryMsg jennicNeighborEntryMsg = new JennicNeighborEntryMsg(n);
        jennicNeighborEntryMsg.u8EntryNum = jenserInputStream.readUint8();
        jennicNeighborEntryMsg.u8TotalEntries = jenserInputStream.readUint8();
        jenserInputStream.readUint8();
        jenserInputStream.readUint8();
        int n2 = jenserInputStream.readUint32();
        int n3 = jenserInputStream.readUint32();
        jennicNeighborEntryMsg.sAddr = BMac154DeviceAddress.make(n3, n2);
        jennicNeighborEntryMsg.bSleepingED = jenserInputStream.readBool();
        jennicNeighborEntryMsg.u8LinkQuality = jenserInputStream.readUint8();
        jennicNeighborEntryMsg.u16PktsLost = jenserInputStream.readUint16();
        jennicNeighborEntryMsg.u16PktsSent = jenserInputStream.readUint16();
        jennicNeighborEntryMsg.u16PktsRcvd = jenserInputStream.readUint16();
        return jennicNeighborEntryMsg;
    }

    public final boolean isSleepingED() {
        return this.bSleepingED;
    }

    public final BMac154DeviceAddress getSAddr() {
        return this.sAddr;
    }

    public final int getU16PktsLost() {
        return this.u16PktsLost;
    }

    public final int getU16PktsSent() {
        return this.u16PktsSent;
    }

    public final int getU16PktsRcvd() {
        return this.u16PktsRcvd;
    }

    public final int getU8LinkQuality() {
        return this.u8LinkQuality;
    }

    public final int getU8EntryNum() {
        return this.u8EntryNum;
    }

    public final int getU8TotalEntries() {
        return this.u8TotalEntries;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  Entry Num  \t").append(this.u8EntryNum + 1).append('\n');
        stringBuffer.append("  Tot Entries\t").append(this.u8TotalEntries).append('\n');
        stringBuffer.append("  Addr       \t").append(this.sAddr.toString()).append('\n');
        stringBuffer.append("  Sleeping ED\t").append(this.bSleepingED ? "true" : "false").append('\n');
        stringBuffer.append("  LQI        \t").append(this.u8LinkQuality).append('\n');
        stringBuffer.append("  Pkts Lost  \t").append(this.u16PktsLost).append('\n');
        stringBuffer.append("  Pkts Sent  \t").append(this.u16PktsSent).append('\n');
        stringBuffer.append("  Pkts Rcvd  \t").append(this.u16PktsRcvd).append('\n');
        return stringBuffer.toString();
    }

    public String toShortString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Neighbor Entry [" + (this.u8EntryNum + 1) + '/' + this.u8TotalEntries + "] ");
        stringBuffer.append(this.sAddr.toString()).append(" LQI ").append(this.u8LinkQuality);
        stringBuffer.append(" tx/rx/lost ").append(this.u16PktsSent).append("/");
        stringBuffer.append(this.u16PktsRcvd).append("/").append(this.u16PktsLost);
        return stringBuffer.toString();
    }

    JennicNeighborEntryMsg(int n) {
        super(n);
    }
}

