/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jen6lp;

import com.tridium.jen6lp.BJennic154DeviceType;
import com.tridium.jen6lp.BMac154DeviceAddress;
import com.tridium.jen6lp.BPanInfoPoller;
import com.tridium.jen6lp.BSedonaJen6lpAbstractNetwork;
import com.tridium.jen6lp.BSedonaJen6lpDeviceFolder;
import com.tridium.jen6lp.BSedonaJen6lpNeighborEntry;
import com.tridium.jen6lp.util.JenserInputStream;
import com.tridium.jen6lp.util.PanInfoNeighborEntry;
import com.tridium.sedonanet.chopan.virtual.BChopanVirtualGateway;
import com.tridium.sedonanet.driver.BSedonaBaseDevice;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNotification;
import javax.baja.util.ByteArrayUtil;
import sedona.Buf;
import sedona.Kit;
import sedona.Schema;
import sedona.dasp.DaspException;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;
import sedona.web.WebReq;
import sedona.web.WebRes;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSedonaJen6lpDevice
extends BSedonaBaseDevice {
    public static final Property macAddress = BSedonaJen6lpDevice.newProperty((int)65, (BValue)BMac154DeviceAddress.DEFAULT, null);
    public static final Property nodeJoined = BSedonaJen6lpDevice.newProperty((int)67, (boolean)false, null);
    public static final Property nodeJoinedTime = BSedonaJen6lpDevice.newProperty((int)67, (BValue)BAbsTime.DEFAULT, null);
    public static final Property nodeLeftTime = BSedonaJen6lpDevice.newProperty((int)67, (BValue)BAbsTime.DEFAULT, null);
    public static final Property parentPanInfo = BSedonaJen6lpDevice.newProperty((int)65, (BValue)new BSedonaJen6lpNeighborEntry(), null);
    public static final Property childPanInfo = BSedonaJen6lpDevice.newProperty((int)65, (BValue)new BComponent(), null);
    public static final Property panInfoLoaded = BSedonaJen6lpDevice.newProperty((int)67, (boolean)false, null);
    public static final Property panInfoLoadTime = BSedonaJen6lpDevice.newProperty((int)67, (BValue)BAbsTime.DEFAULT, null);
    public static final Property deviceType = BSedonaJen6lpDevice.newProperty((int)0, (BValue)BJennic154DeviceType.unknown, null);
    public static final Property maintenanceModeRequested = BSedonaJen6lpDevice.newProperty((int)194, (boolean)false, null);
    public static final Property maintenanceModeActive = BSedonaJen6lpDevice.newProperty((int)3, (boolean)false, null);
    public static final Property maintenanceModeTimeout = BSedonaJen6lpDevice.newProperty((int)1, (BValue)BRelTime.DEFAULT, null);
    public static final Property chopanVirtual = BSedonaJen6lpDevice.newProperty((int)0, (BValue)new BChopanVirtualGateway(), null);
    public static final Action loadPanInfo = BSedonaJen6lpDevice.newAction((int)16, null);
    public static final Action loadPanInfoSync = BSedonaJen6lpDevice.newAction((int)4, null);
    public static final Action deleteAllPanInfo = BSedonaJen6lpDevice.newAction((int)0, null);
    public static final Action deleteStalePanInfo = BSedonaJen6lpDevice.newAction((int)0, null);
    public static final Action requestMaintenanceMode = BSedonaJen6lpDevice.newAction((int)0, null);
    public static final Action clearMaintenanceMode = BSedonaJen6lpDevice.newAction((int)4, null);
    public static final Type TYPE;
    protected static BFacets tff;
    private SoxComponent panInfoSvc;
    static /* synthetic */ Class class$com$tridium$jen6lp$BSedonaJen6lpDevice;

    public BMac154DeviceAddress getMacAddress() {
        return (BMac154DeviceAddress)this.get(macAddress);
    }

    public void setMacAddress(BMac154DeviceAddress bMac154DeviceAddress) {
        this.set(macAddress, (BValue)bMac154DeviceAddress, null);
    }

    public boolean getNodeJoined() {
        return this.getBoolean(nodeJoined);
    }

    public void setNodeJoined(boolean bl) {
        this.setBoolean(nodeJoined, bl, null);
    }

    public BAbsTime getNodeJoinedTime() {
        return (BAbsTime)this.get(nodeJoinedTime);
    }

    public void setNodeJoinedTime(BAbsTime bAbsTime) {
        this.set(nodeJoinedTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getNodeLeftTime() {
        return (BAbsTime)this.get(nodeLeftTime);
    }

    public void setNodeLeftTime(BAbsTime bAbsTime) {
        this.set(nodeLeftTime, (BValue)bAbsTime, null);
    }

    public BSedonaJen6lpNeighborEntry getParentPanInfo() {
        return (BSedonaJen6lpNeighborEntry)this.get(parentPanInfo);
    }

    public void setParentPanInfo(BSedonaJen6lpNeighborEntry bSedonaJen6lpNeighborEntry) {
        this.set(parentPanInfo, (BValue)bSedonaJen6lpNeighborEntry, null);
    }

    public BComponent getChildPanInfo() {
        return (BComponent)this.get(childPanInfo);
    }

    public void setChildPanInfo(BComponent bComponent) {
        this.set(childPanInfo, (BValue)bComponent, null);
    }

    public boolean getPanInfoLoaded() {
        return this.getBoolean(panInfoLoaded);
    }

    public void setPanInfoLoaded(boolean bl) {
        this.setBoolean(panInfoLoaded, bl, null);
    }

    public BAbsTime getPanInfoLoadTime() {
        return (BAbsTime)this.get(panInfoLoadTime);
    }

    public void setPanInfoLoadTime(BAbsTime bAbsTime) {
        this.set(panInfoLoadTime, (BValue)bAbsTime, null);
    }

    public BJennic154DeviceType getDeviceType() {
        return (BJennic154DeviceType)this.get(deviceType);
    }

    public void setDeviceType(BJennic154DeviceType bJennic154DeviceType) {
        this.set(deviceType, (BValue)bJennic154DeviceType, null);
    }

    public boolean getMaintenanceModeRequested() {
        return this.getBoolean(maintenanceModeRequested);
    }

    public void setMaintenanceModeRequested(boolean bl) {
        this.setBoolean(maintenanceModeRequested, bl, null);
    }

    public boolean getMaintenanceModeActive() {
        return this.getBoolean(maintenanceModeActive);
    }

    public void setMaintenanceModeActive(boolean bl) {
        this.setBoolean(maintenanceModeActive, bl, null);
    }

    public BRelTime getMaintenanceModeTimeout() {
        return (BRelTime)this.get(maintenanceModeTimeout);
    }

    public void setMaintenanceModeTimeout(BRelTime bRelTime) {
        this.set(maintenanceModeTimeout, (BValue)bRelTime, null);
    }

    public BChopanVirtualGateway getChopanVirtual() {
        return (BChopanVirtualGateway)this.get(chopanVirtual);
    }

    public void setChopanVirtual(BChopanVirtualGateway bChopanVirtualGateway) {
        this.set(chopanVirtual, (BValue)bChopanVirtualGateway, null);
    }

    public void loadPanInfo() {
        this.invoke(loadPanInfo, null, null);
    }

    public void loadPanInfoSync() {
        this.invoke(loadPanInfoSync, null, null);
    }

    public void deleteAllPanInfo() {
        this.invoke(deleteAllPanInfo, null, null);
    }

    public void deleteStalePanInfo() {
        this.invoke(deleteStalePanInfo, null, null);
    }

    public void requestMaintenanceMode() {
        this.invoke(requestMaintenanceMode, null, null);
    }

    public void clearMaintenanceMode() {
        this.invoke(clearMaintenanceMode, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        Type type = bComponent.getType();
        boolean bl = false;
        if (type.is(BSedonaJen6lpAbstractNetwork.TYPE) || type.is(BSedonaJen6lpDeviceFolder.TYPE) || type.getTypeName().equals("SedonaNetworkStub")) {
            bl = true;
        }
        return bl;
    }

    public final BSedonaJen6lpAbstractNetwork get6lpNetwork() {
        return (BSedonaJen6lpAbstractNetwork)this.getNetwork();
    }

    public void changed(Property property, Context context) {
        if (property.equals((Object)maintenanceModeActive)) {
            if (!this.isRunning()) {
                return;
            }
            if (this.getMaintenanceModeActive()) {
                BNotification bNotification = new BNotification();
                bNotification.add("message", (BValue)BString.make((String)"Maintenance mode active"));
                bNotification.add("title", (BValue)BString.make((String)this.getDisplayName(context)));
                bNotification.raise(true);
            }
        }
        if (property.equals((Object)deviceType)) {
            if (!this.isRunning()) {
                return;
            }
            if (this.getDeviceType() != BJennic154DeviceType.router) {
                this.configOk();
            }
        } else {
            super.changed(property, context);
        }
    }

    public Type getNetworkType() {
        return BSedonaJen6lpAbstractNetwork.TYPE;
    }

    public void doPing() {
        if (!this.isRunning() || !this.getEnabled()) {
            return;
        }
        if (!this.getAddress().isValid()) {
            this.pingFail("Invalid IP address");
            return;
        }
        if (!((BSedonaJen6lpAbstractNetwork)this.getNetwork()).getEnabled()) {
            return;
        }
        if (!((BSedonaJen6lpAbstractNetwork)this.getNetwork()).atNetworkSteadyState()) {
            return;
        }
        if (this.getMacAddress().equivalent((Object)BMac154DeviceAddress.DEFAULT)) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < 3) {
            try {
                bl = this.get6lpNetwork().isMacInNetwork(this.getMacAddress());
                bl2 = true;
                break;
            }
            catch (IOException iOException) {
                ++n;
            }
        }
        if (!bl2) {
            this.pingFail("No resp from coord");
        } else if (bl) {
            this.pingOk();
        } else {
            this.pingFail("Device not in coord table");
        }
    }

    private final Log getPanInfoLog() {
        return this.get6lpNetwork().getPanInfoLog();
    }

    private final void parseNeighborTable(byte[] byArray) {
        BComponent bComponent = this.getChildPanInfo();
        JenserInputStream jenserInputStream = new JenserInputStream(byArray);
        boolean bl = true;
        while (jenserInputStream.available() != 0) {
            PanInfoNeighborEntry panInfoNeighborEntry = new PanInfoNeighborEntry();
            panInfoNeighborEntry.decode(jenserInputStream);
            BSedonaJen6lpNeighborEntry bSedonaJen6lpNeighborEntry = BSedonaJen6lpNeighborEntry.make(panInfoNeighborEntry);
            if (bl) {
                this.getParentPanInfo().copyFrom((BComplex)bSedonaJen6lpNeighborEntry);
            } else {
                String string = bSedonaJen6lpNeighborEntry.getMac154().toOrdString();
                BSedonaJen6lpNeighborEntry bSedonaJen6lpNeighborEntry2 = (BSedonaJen6lpNeighborEntry)bComponent.get(string);
                if (bSedonaJen6lpNeighborEntry2 == null) {
                    bComponent.add(string, (BValue)bSedonaJen6lpNeighborEntry, 1);
                    this.getPanInfoLog().trace("adding new child : [" + string + ']' + (Object)((Object)bSedonaJen6lpNeighborEntry));
                } else {
                    ((BSedonaJen6lpNeighborEntry)bComponent.get(string)).copyFrom((BComplex)bSedonaJen6lpNeighborEntry);
                    this.getPanInfoLog().trace("updating child : [" + string + ']' + (Object)((Object)bSedonaJen6lpNeighborEntry));
                }
            }
            bl = false;
        }
    }

    private final String getDispName() {
        return this.getDisplayName(null);
    }

    public void doLoadPanInfo() {
        this.getSedonaNetwork().postAsync(new Runnable(){

            public final void run() {
                BSedonaJen6lpDevice.this.readPanInfo();
            }
        });
    }

    public void doLoadPanInfoSync() {
        this.readPanInfo();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readPanInfo() {
        block24: {
            BComponent bComponent;
            if (!this.isRunning()) {
                return;
            }
            boolean bl = this.getPanInfoLog().isTraceOn();
            this.getPanInfoLog().trace("load " + this.getDispName());
            BComponent bComponent2 = this.getChildPanInfo();
            BSedonaJen6lpNeighborEntry bSedonaJen6lpNeighborEntry = this.getParentPanInfo();
            bSedonaJen6lpNeighborEntry.setStale(true);
            SlotCursor slotCursor = bComponent2.loadSlots().getProperties();
            while (slotCursor.next()) {
                bComponent = (BSedonaJen6lpNeighborEntry)slotCursor.get();
                bComponent.setStale(true);
            }
            if (!this.getEnabled()) {
                this.getPanInfoLog().trace("  skipping " + this.getDispName() + " (not enabled)");
                return;
            }
            if (this.getMacAddress().equals((Object)BMac154DeviceAddress.DEFAULT)) {
                this.getPanInfoLog().trace("  skipping " + this.getDispName() + " (invalid MAC)");
                return;
            }
            if (this.isDown()) {
                this.getPanInfoLog().trace("  skipping " + this.getDispName() + " (device down)");
                return;
            }
            if (this.getDeviceType() != BJennic154DeviceType.router) {
                this.setPanInfoLoaded(true);
                this.setPanInfoLoadTime(BAbsTime.now());
                bSedonaJen6lpNeighborEntry.setUnavailable(true);
                this.getPanInfoLog().trace("  skipping " + this.getDispName() + " (deviceType != router)");
                return;
            }
            bComponent = (BPanInfoPoller)this.get6lpNetwork().getPaninfoPoller();
            if (bComponent.getUseChopan()) {
                try {
                    WebReq webReq = new WebReq();
                    webReq.uri = "pan/all";
                    webReq.set("Transaction-Id", "" + this.xid());
                    WebRes webRes = this.chopanComm().send(this.getAddress(), webReq);
                    this.getPanInfoLog().trace("paninfo pan/all response:");
                    if (webRes != null && webRes.body != null) {
                        if (webRes.code == 200) {
                            this.parseNeighborTable(webRes.body);
                            this.setPanInfoLoaded(true);
                            this.setPanInfoLoadTime(BAbsTime.now());
                            this.configOk();
                            if (bl) {
                                ByteArrayUtil.hexDump((byte[])webRes.body);
                            }
                            break block24;
                        }
                        String string = "Error response code <" + webRes.code + "> via chopan, check chopan, paninfo services ";
                        this.getPanInfoLog().trace(string + " on " + this.getDispName());
                        this.configFail("paninfo:" + string);
                        break block24;
                    }
                    String string = "NULL paninfo response via chopan, check chopan, paninfo services";
                    this.getPanInfoLog().trace(string + " on " + this.getDispName());
                    this.configFail("paninfo:" + string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.get6lpNetwork().getLog().message("Cannot read paninfo for " + this.getDispName() + " via Chopan:" + exception);
                    this.configFail("paninfo:" + exception);
                }
            } else {
                block26: {
                    SoxClient soxClient = null;
                    try {
                        block25: {
                            try {
                                soxClient = this.makeSoxClient(false);
                                if (this.getSedonaNetwork().getLinkDebug()) {
                                    soxClient.traceMsg = true;
                                }
                                if (this.panInfoSvc == null) {
                                    this.panInfoSvc = this.findPanInfoService(soxClient);
                                }
                                if (this.panInfoSvc == null) {
                                    String string = "Missing paninfo kit or service";
                                    this.get6lpNetwork().getLog().warning(string + this.getDispName());
                                    this.configFail("paninfo" + string);
                                    break block25;
                                }
                                soxClient.update(this.panInfoSvc, 4);
                                Buf buf = this.panInfoSvc.getBuf("neighborTable");
                                this.parseNeighborTable(buf.bytes);
                                this.setPanInfoLoaded(true);
                                this.setPanInfoLoadTime(BAbsTime.now());
                                this.configOk();
                            }
                            catch (Schema.MissingKitManifestException missingKitManifestException) {
                                this.configFail("paninfo: " + missingKitManifestException.getMessage());
                                this.get6lpNetwork().getLog().warning("Cannot read paninfo for " + this.getDispName() + ':' + (Object)((Object)missingKitManifestException));
                            }
                            catch (DaspException daspException) {
                                this.get6lpNetwork().getLog().warning("Cannot read paninfo for " + this.getDispName() + ':' + (Object)((Object)daspException));
                                daspException.printStackTrace();
                                this.pingFail("" + (Object)((Object)daspException));
                            }
                            catch (Exception exception) {
                                this.get6lpNetwork().getLog().warning("Cannot read paninfo for " + this.getDispName() + ':' + exception);
                                exception.printStackTrace();
                                this.configFail("paninfo: " + exception);
                            }
                        }
                        Object var8_14 = null;
                        if (soxClient == null) break block26;
                    }
                    catch (Throwable throwable) {
                        Object var8_13 = null;
                        if (soxClient != null) {
                            soxClient.close();
                        }
                        this.panInfoSvc = null;
                        throw throwable;
                    }
                    soxClient.close();
                }
                this.panInfoSvc = null;
            }
        }
        this.getPanInfoLog().trace("return...");
    }

    private final SoxComponent findPanInfoService(SoxClient soxClient) throws Exception {
        Schema schema = soxClient.readSchema();
        Kit kit = schema.kit("paninfo");
        if (kit == null) {
            return null;
        }
        sedona.Type type = kit.type("PanInfoService");
        int[] nArray = soxClient.queryService(type);
        if (nArray.length == 0) {
            return null;
        }
        return soxClient.load(nArray[0]);
    }

    public void doDeleteAllPanInfo() {
        this.setParentPanInfo(new BSedonaJen6lpNeighborEntry());
        BComponent bComponent = this.getChildPanInfo();
        bComponent.removeAll();
        this.setPanInfoLoaded(false);
        this.setPanInfoLoadTime(BAbsTime.NULL);
    }

    public void doDeleteStalePanInfo() {
        BComponent bComponent = this.getChildPanInfo();
        Property[] propertyArray = bComponent.getPropertiesArray();
        int n = 0;
        while (n < propertyArray.length) {
            BSedonaJen6lpNeighborEntry bSedonaJen6lpNeighborEntry;
            BValue bValue = bComponent.get(propertyArray[n]);
            if (bValue instanceof BSedonaJen6lpNeighborEntry && (bSedonaJen6lpNeighborEntry = (BSedonaJen6lpNeighborEntry)bValue).getStale()) {
                bComponent.remove((BComplex)bSedonaJen6lpNeighborEntry);
            }
            ++n;
        }
    }

    public void doRequestMaintenanceMode() {
        this.setMaintenanceModeRequested(true);
    }

    public void doClearMaintenanceMode() {
        this.setMaintenanceModeActive(false);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.panInfoSvc = null;
    }

    public BSedonaJen6lpDevice() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$jen6lp$BSedonaJen6lpDevice;
        if (clazz == null) {
            clazz = class$com$tridium$jen6lp$BSedonaJen6lpDevice = BSedonaJen6lpDevice.class("[Lcom.tridium.jen6lp.BSedonaJen6lpDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        tff = BFacets.make((String)"timeFormat", (BIDataValue)BString.make((String)"DD-MMM-YY h:mm:ss a z"), (String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE);
    }
}

