/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.util;

import javax.baja.sedona.sys.BSedonaBoolean;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import sedona.Bool;
import sedona.Buf;
import sedona.Byte;
import sedona.Double;
import sedona.Facets;
import sedona.Float;
import sedona.Int;
import sedona.Long;
import sedona.Short;
import sedona.Str;
import sedona.Value;
import sedona.util.TextUtil;

public class ValueUtil {
    public static final byte voidId = 0;
    public static final byte boolId = 1;
    public static final byte byteId = 2;
    public static final byte shortId = 3;
    public static final byte intId = 4;
    public static final byte longId = 5;
    public static final byte floatId = 6;
    public static final byte doubleId = 7;
    public static final byte bufId = 8;
    public static final byte strId = 101;
    public static final byte errorId = 1;

    public static Type toNiagaraType(sedona.Type type, Facets facets) {
        BSimple bSimple = ValueUtil.toNiagara(type, facets);
        if (bSimple == null) {
            return null;
        }
        return bSimple.getType();
    }

    public static BSimple toNiagara(sedona.Type type, Facets facets) {
        if (type.kit.id != 0) {
            throw new IllegalStateException("Not sys kit " + type);
        }
        String string = facets.gets("range");
        if (string != null && type.isInteger()) {
            return BDynamicEnum.DEFAULT;
        }
        switch (type.id) {
            case 0: {
                return null;
            }
            case 1: {
                return BSedonaBoolean.Null;
            }
            case 2: 
            case 3: 
            case 4: {
                return BInteger.DEFAULT;
            }
            case 5: {
                return BLong.DEFAULT;
            }
            case 6: {
                return BFloat.DEFAULT;
            }
            case 7: {
                return BDouble.DEFAULT;
            }
            case 8: {
                if (facets != null && facets.getb("asStr")) {
                    return BString.DEFAULT;
                }
                return BBlob.DEFAULT;
            }
        }
        throw new IllegalStateException("Unsupported value type " + type);
    }

    public static BSimple toNiagaraFacet(String string, Value value) {
        if (string.equals("range") && value instanceof Str) {
            return BEnumRange.make((String[])TextUtil.splitAndTrim((String)value.toString(), (char)','));
        }
        if (string.equals("unit") && value instanceof Str) {
            try {
                return BUnit.getUnit((String)value.toString().replace('_', ' '));
            }
            catch (Exception exception) {}
        }
        switch (value.typeId()) {
            case 1: {
                return BBoolean.make((boolean)((Bool)value).val);
            }
            case 2: 
            case 3: 
            case 4: {
                return BInteger.make((int)((Int)value).val);
            }
            case 5: {
                return BLong.make((long)((Long)value).val);
            }
            case 6: {
                return BFloat.make((float)((Float)value).val);
            }
            case 7: {
                return BDouble.make((double)((Double)value).val);
            }
            case 101: {
                return BString.make((String)((Str)value).val);
            }
        }
        throw new IllegalStateException("Unsupported value type " + value.typeId());
    }

    public static Value toSedona(sedona.Type type, BSimple bSimple) {
        if (type.kit.id != 0) {
            throw new IllegalStateException("Not sys kit " + type);
        }
        switch (type.id) {
            case 0: {
                return null;
            }
            case 1: {
                return ((BSedonaBoolean)bSimple).toBool();
            }
            case 2: {
                return Byte.make((int)ValueUtil.toInt(bSimple));
            }
            case 3: {
                return Short.make((int)ValueUtil.toInt(bSimple));
            }
            case 4: {
                return Int.make((int)ValueUtil.toInt(bSimple));
            }
            case 5: {
                return Long.make((long)((BLong)bSimple).getLong());
            }
            case 6: {
                return Float.make((float)((BFloat)bSimple).getFloat());
            }
            case 7: {
                return Double.make((double)((BDouble)bSimple).getDouble());
            }
            case 8: {
                if (bSimple instanceof BString) {
                    return Str.make((String)((BString)bSimple).getString());
                }
                return new Buf(((BBlob)bSimple).copyBytes());
            }
        }
        throw new IllegalStateException("Unsupported value type " + type);
    }

    private static final int toInt(BSimple bSimple) {
        if (bSimple instanceof BInteger) {
            return ((BInteger)bSimple).getInt();
        }
        return ((BEnum)bSimple).getOrdinal();
    }
}

