/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.ui.kitmgr;

import com.tridium.nsedona.env.KitDb;
import com.tridium.nsedona.kitmgr.KitManagerModel;
import com.tridium.nsedona.kitmgr.ManagerVerifier;
import com.tridium.nsedona.ui.kitmgr.BKitDetailsPane;
import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSubject;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import sedona.sox.KitVersion;
import sedona.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BKitManager
extends BEdgePane {
    public static final Action listItemSelected = BKitManager.newAction((int)0, null);
    public static final Topic kitModelUpdated = BKitManager.newTopic((int)0, null);
    public static final Type TYPE;
    static final BImage checked;
    static final BImage unchecked;
    static final BImage kitAdd;
    static final BImage kitDowngrade;
    static final BImage kitNoAction;
    static final BImage kitNotSupported;
    static final BImage kitRemove;
    static final BImage kitUpgrade;
    static final BImage kitLocked;
    static final BBrush notSupportedFg;
    static final BBrush notSupportedBg;
    static final BBrush modifiedBg;
    static final BBrush mouseFocusBg;
    static final BBrush mouseFocusBorder;
    static final Lexicon lex;
    static final BImage verifierErr;
    static final BImage resetImg;
    static final String lexKits;
    static final String lexInstall;
    static final String lexRemove;
    static final String lexDowngradeTo;
    static final String lexKeepAt;
    static final String lexUpgradeTo;
    static final String lexNotSupported;
    static final String lexError;
    static final String lexKitRequired;
    private final KitManagerModel mgrModel;
    private BTable kitTable;
    private BList list;
    private int mouseOverRow;
    private VerifierModel verifierModel;
    static /* synthetic */ Class class$com$tridium$nsedona$ui$kitmgr$BKitManager;

    public final void listItemSelected() {
        this.invoke(listItemSelected, null, null);
    }

    public final void fireKitModelUpdated(BValue bValue) {
        this.fire(kitModelUpdated, bValue, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final KitDb.KitSummary[] commit() {
        return this.mgrModel.commit();
    }

    public final boolean isScodeRebuildNeeded() {
        return ((KitModel)this.kitTable.getModel()).isScodeRebuildNeeded();
    }

    final void update() {
        this.kitTable.getModel().updateTable();
        this.verifierModel.update();
        this.fireKitModelUpdated(null);
    }

    static final BImage img(String string) {
        return BImage.make((String)("module://sedonaProvisioning/rc/" + string));
    }

    public final void doListItemSelected() {
        Item item = (Item)this.list.getSelectedItem();
        this.mgrModel.setDesiredVersion(this.mgrModel.getSortedKits()[this.mouseOverRow], item.version.version);
        UiEnv.get().closePopup((BWidget)this.list);
        this.update();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.mouseOverRow = -1;
    }

    public BKitManager() {
        this.this();
        this.mgrModel = null;
    }

    public BKitManager(KitManagerModel kitManagerModel) {
        this.this();
        this.mgrModel = kitManagerModel;
        this.kitTable = new BTable((TableModel)new KitModel());
        this.kitTable.setController((TableController)new KitController());
        this.kitTable.setCellRenderer((TableCellRenderer)new KitRenderer());
        this.verifierModel = new VerifierModel();
        BTable bTable = new BTable((TableModel)this.verifierModel);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)BTitlePane.makePane((String)lexKits, (BTable)this.kitTable, (String)lexKits.toLowerCase()));
        BSplitPane bSplitPane = new BSplitPane(BOrientation.vertical, 70.0);
        bSplitPane.setWidget1((BWidget)bEdgePane);
        bSplitPane.setWidget2((BWidget)BTitlePane.makePane((String)lex.getText("kitMgr.verifier"), (BTable)bTable, (String)lex.getText("kitMgr.errors")));
        this.setCenter((BWidget)bSplitPane);
        this.list = new BList();
        this.list.setController((ListController)new LController());
        this.list.setRenderer((ListRenderer)new LRenderer());
        this.linkTo((BComponent)this.list, (Slot)BList.actionPerformed, (Slot)listItemSelected);
        this.update();
    }

    static {
        Class clazz = class$com$tridium$nsedona$ui$kitmgr$BKitManager;
        if (clazz == null) {
            clazz = class$com$tridium$nsedona$ui$kitmgr$BKitManager = BKitManager.class("[Lcom.tridium.nsedona.ui.kitmgr.BKitManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        checked = BKitManager.img("checked.png");
        unchecked = BKitManager.img("unchecked.png");
        kitAdd = BKitManager.img("kitAdd.png");
        kitDowngrade = BKitManager.img("kitDowngrade.png");
        kitNoAction = BKitManager.img("kitNoAction.png");
        kitNotSupported = BKitManager.img("kitNotSupported.png");
        kitRemove = BKitManager.img("kitRemove.png");
        kitUpgrade = BKitManager.img("kitUpgrade.png");
        BIcon bIcon = BIcon.make((BIcon)BIcon.make((String)"module://nsedona/com/tridium/nsedona/ui/icons/saxFile.png"), (BIcon)BIcon.make((String)"module://sedonaProvisioning/rc/lockBadge.png"));
        kitLocked = BImage.make((BIcon)bIcon);
        notSupportedFg = BBrush.make((String)"#667");
        notSupportedBg = BBrush.make((String)"#ddd");
        modifiedBg = BBrush.make((String)"#ffd");
        mouseFocusBg = BBrush.make((String)"#ccf");
        mouseFocusBorder = BBrush.make((String)"#669");
        Class clazz2 = class$com$tridium$nsedona$ui$kitmgr$BKitManager;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$nsedona$ui$kitmgr$BKitManager = BKitManager.class("[Lcom.tridium.nsedona.ui.kitmgr.BKitManager;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        verifierErr = BImage.make((BIcon)BIcon.std((String)"job/failed.png"));
        resetImg = BImage.make((BIcon)BIcon.std((String)"undo.png"));
        lexKits = lex.getText("kitMgr.kits");
        lexInstall = lex.getText("action.install");
        lexRemove = lex.getText("action.remove");
        lexDowngradeTo = lex.getText("action.downgradeTo");
        lexKeepAt = lex.getText("action.keepAt");
        lexUpgradeTo = lex.getText("action.upgradeTo");
        lexNotSupported = lex.getText("action.notSupported");
        lexError = lex.getText("verifier.col.error");
        lexKitRequired = lex.getText("kitMgr.kitRequired");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class KitModel
    extends TableModel {
        private String[] cols;

        public int getRowCount() {
            return BKitManager.this.mgrModel.size();
        }

        public int getColumnCount() {
            return this.cols.length;
        }

        public String getColumnName(int n) {
            return this.cols[n];
        }

        public Object getValueAt(int n, int n2) {
            String string = BKitManager.this.mgrModel.getSortedKits()[n];
            Version version = null;
            Version version2 = null;
            Version version3 = null;
            switch (n2) {
                case 0: {
                    return string;
                }
                case 1: {
                    version = BKitManager.this.mgrModel.getInstalledVersion(string);
                    if (version == null) {
                        return "";
                    }
                    version2 = BKitManager.this.mgrModel.getLatestVersion(string);
                    if (version2 == null) {
                        return version.toString();
                    }
                    return version.compareTo((Object)version2) < 0 ? version + " (Out of Date)" : version.toString();
                }
                case 2: {
                    version2 = BKitManager.this.mgrModel.getLatestVersion(string);
                    if (version2 == null) {
                        return lex.getText("latest.noLocalKit");
                    }
                    return version2.toString();
                }
                case 3: {
                    if (!BKitManager.this.mgrModel.isKitSupported(string)) {
                        if (BKitManager.this.mgrModel.getInstalledVersion(string) != null) {
                            return lexRemove;
                        }
                        return lexNotSupported;
                    }
                    version = BKitManager.this.mgrModel.getInstalledVersion(string);
                    version3 = BKitManager.this.mgrModel.getDesiredVersion(string);
                    if (version == null) {
                        return version3 == null ? "" : lexInstall + ' ' + version3;
                    }
                    if (version3 == null) {
                        return lexRemove;
                    }
                    int n3 = version3.compareTo((Object)version);
                    if (n3 == 0 && BKitManager.this.mgrModel.getInstalledChecksum(string) != BKitManager.this.mgrModel.getDesiredChecksum(string)) {
                        n3 = 1;
                    }
                    switch (n3) {
                        case -1: {
                            return lexDowngradeTo + ' ' + version3;
                        }
                        case 0: {
                            return lexKeepAt + ' ' + version3;
                        }
                        case 1: {
                            return lexUpgradeTo + ' ' + version3;
                        }
                    }
                    throw new IllegalStateException("cmp=" + n3);
                }
            }
            return "";
        }

        boolean isScodeRebuildNeeded() {
            int n = this.getRowCount();
            int n2 = 0;
            while (n2 < n) {
                String string = this.getValueAt(n2, 3).toString();
                if (!(string.startsWith(lexKeepAt) || string.equals("") || string.startsWith(lexNotSupported))) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private final /* synthetic */ void this() {
            this.cols = new String[]{lex.getText("col.name"), lex.getText("col.installed"), lex.getText("col.latest"), lex.getText("col.action"), ""};
        }

        KitModel() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class VerifierModel
    extends TableModel {
        ManagerVerifier.VerifyItem[] errors;

        public void update() {
            this.errors = BKitManager.this.mgrModel.verify();
            this.getTable().getSelection().deselectAll();
            this.updateTable();
        }

        public int getRowCount() {
            return this.errors.length;
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int n) {
            return lexError;
        }

        public Object getValueAt(int n, int n2) {
            return this.errors[n].msg;
        }

        public BImage getRowIcon(int n) {
            return verifierErr;
        }

        VerifierModel() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Item {
        public KitVersion version;
        public String text;

        public String toString() {
            return this.text;
        }

        public Item(KitVersion kitVersion, String string) {
            this.version = kitVersion;
            this.text = string;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class KitController
    extends TableController {
        boolean isBubbleOpen;

        protected void cellEntered(BMouseEvent bMouseEvent, int n, int n2) {
            if (UiEnv.get().isPopupOpen((BWidget)BKitManager.this.list)) {
                return;
            }
            if (n2 == 3) {
                BKitManager.this.mouseOverRow = n;
                this.getModel().updateTable();
            }
        }

        protected void cellExited(BMouseEvent bMouseEvent, int n, int n2) {
            if (UiEnv.get().isPopupOpen((BWidget)BKitManager.this.list)) {
                return;
            }
            BKitManager.this.mouseOverRow = -1;
            this.getModel().updateTable();
        }

        protected void cellPressed(BMouseEvent bMouseEvent, int n, int n2) {
            String string = this.kit(n);
            super.cellPressed(bMouseEvent, n, n2);
            if (n2 == 0 && bMouseEvent.getX() < 18.0) {
                if (!BKitManager.this.mgrModel.isKitSupported(string)) {
                    return;
                }
                if (BKitManager.this.mgrModel.isKitRequiredByApp(string) && BKitManager.this.mgrModel.getInstalledVersion(string) != null) {
                    return;
                }
                Version version = BKitManager.this.mgrModel.getDesiredVersion(string);
                BKitManager.this.mgrModel.setDesiredVersion(string, version == null ? BKitManager.this.mgrModel.getLatestVersion(string) : null);
                BKitManager.this.update();
            } else if (n2 == 3) {
                Object object;
                BScrollBar bScrollBar;
                Version version;
                if (!BKitManager.this.mgrModel.isKitSupported(string)) {
                    return;
                }
                if (BKitManager.this.mgrModel.getDesiredVersion(string) == null) {
                    return;
                }
                BKitManager.this.list.removeAllItems();
                Version version2 = BKitManager.this.mgrModel.getInstalledVersion(string);
                KitVersion[] kitVersionArray = BKitManager.this.mgrModel.getAvailableVersions(string);
                int n3 = 0;
                while (n3 < kitVersionArray.length) {
                    version = kitVersionArray[n3].version;
                    bScrollBar = null;
                    object = null;
                    if (version2 == null) {
                        bScrollBar = kitAdd;
                        object = lexInstall;
                    } else {
                        switch (version.compareTo((Object)version2)) {
                            case -1: {
                                bScrollBar = kitDowngrade;
                                object = lexDowngradeTo;
                                break;
                            }
                            case 0: {
                                bScrollBar = kitNoAction;
                                object = lexKeepAt;
                                break;
                            }
                            case 1: {
                                bScrollBar = kitUpgrade;
                                object = lexUpgradeTo;
                                break;
                            }
                            default: {
                                throw new IllegalStateException();
                            }
                        }
                    }
                    BKitManager.this.list.addItem((BImage)bScrollBar, (Object)new Item(kitVersionArray[n3], (String)object + ' ' + version));
                    ++n3;
                }
                BTable bTable = this.getTable();
                version = bTable.getHscrollBar();
                bScrollBar = bTable.getVscrollBar();
                object = bTable.getCellBounds(n, n2);
                double d = object.x;
                double d2 = object.y + object.height;
                double d3 = bTable.getCellWidth(n2);
                if (version.isVisible()) {
                    d -= (double)version.getPosition();
                }
                if (bScrollBar.isVisible()) {
                    d2 -= (double)bScrollBar.getPosition() * object.height;
                }
                BKitManager.this.list.computePreferredSize();
                UiEnv.get().openPopup((BWidget)BKitManager.this.list, (BWidget)this.getTable(), d, d2, d3, -1.0);
                BKitManager.this.list.requestFocus();
            }
        }

        protected void cellHover(BMouseEvent bMouseEvent, int n, int n2) {
            if (n2 == 0) {
                String string = this.kit(n);
                if (BKitManager.this.mgrModel.isKitRequiredByApp(string) && bMouseEvent.getX() < 18.0) {
                    UiEnv.get().openBubbleHelp((BWidget)BKitManager.this, bMouseEvent.getX(), bMouseEvent.getY() - (double)2, lexKitRequired);
                    this.isBubbleOpen = true;
                }
            }
        }

        protected void cellMoved(BMouseEvent bMouseEvent, int n, int n2) {
            if (this.isBubbleOpen) {
                UiEnv.get().closeBubbleHelp();
                this.isBubbleOpen = false;
            }
        }

        protected BMenu makePopup(TableSubject tableSubject) {
            int n = tableSubject.getActiveRow();
            BMenu bMenu = new BMenu();
            if (n >= 0) {
                String string = this.kit(n);
                bMenu.add(null, (Command)new KitDetails((BWidget)BKitManager.this, string));
                bMenu.add(null, (BValue)new BSeparator());
            }
            bMenu.add(null, (Command)new UpgradeToLatest((BWidget)BKitManager.this));
            bMenu.add(null, (Command)new Reset((BWidget)BKitManager.this));
            if (Boolean.getBoolean("kitManager.debug")) {
                bMenu.add(null, (Command)new Commit((BWidget)BKitManager.this));
            }
            return bMenu;
        }

        String kit(int n) {
            return BKitManager.this.mgrModel.getSortedKits()[n];
        }

        private final /* synthetic */ void this() {
            this.isBubbleOpen = false;
        }

        KitController() {
            this.this();
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class KitDetails
        extends Command {
            final String kit;

            public CommandArtifact doInvoke() throws Exception {
                BKitDetailsPane bKitDetailsPane = new BKitDetailsPane(BKitManager.this.mgrModel.kitset(this.kit));
                BBrush bBrush = Theme.scrollPane().getControlBackground();
                BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)bKitDetailsPane, 10.0, 10.0, (double)5, 10.0));
                bScrollPane.setViewportBackground(bBrush);
                bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
                BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bScrollPane);
                bConstrainedPane.setFixedSize(500.0, 250.0);
                BDialog.message((BWidget)BKitManager.this, (String)lex.getText("kitMgr.details.label"), (Object)bConstrainedPane);
                return null;
            }

            public KitDetails(BWidget bWidget, String string) {
                super(bWidget, lex, "kitMgr.details");
                this.kit = string;
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class UpgradeToLatest
        extends Command {
            public BImage getIcon() {
                return kitUpgrade;
            }

            public CommandArtifact doInvoke() throws Exception {
                String[] stringArray = BKitManager.this.mgrModel.getSortedKits();
                int n = 0;
                while (n < stringArray.length) {
                    String string = stringArray[n];
                    Version version = BKitManager.this.mgrModel.getInstalledVersion(string);
                    Version version2 = BKitManager.this.mgrModel.getDesiredVersion(string);
                    if (version != null && version2 != null) {
                        BKitManager.this.mgrModel.setDesiredVersion(string, BKitManager.this.mgrModel.getLatestVersion(string));
                    }
                    ++n;
                }
                BKitManager.this.update();
                return null;
            }

            public UpgradeToLatest(BWidget bWidget) {
                super(bWidget, lex.getText("kitMgr.upgradeAll"));
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class Reset
        extends Command {
            public BImage getIcon() {
                return resetImg;
            }

            public CommandArtifact doInvoke() throws Exception {
                BKitManager.this.mgrModel.reset();
                BKitManager.this.update();
                return null;
            }

            public Reset(BWidget bWidget) {
                super(bWidget, lex.getText("kitMgr.reset"));
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class Commit
        extends Command {
            public CommandArtifact doInvoke() throws Exception {
                KitDb.KitSummary[] kitSummaryArray = BKitManager.this.mgrModel.commit();
                int n = 0;
                while (n < kitSummaryArray.length) {
                    System.out.println(n + ": " + kitSummaryArray[n]);
                    ++n;
                }
                System.out.println();
                return null;
            }

            public Commit(BWidget bWidget) {
                super(bWidget, "Commit");
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class KitRenderer
    extends TableCellRenderer {
        public BBrush getForeground(TableCellRenderer.Cell cell) {
            if (!BKitManager.this.mgrModel.isKitSupported(this.kit(cell))) {
                return notSupportedFg;
            }
            return super.getForeground(cell);
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            if (!BKitManager.this.mgrModel.isKitSupported(this.kit(cell))) {
                return notSupportedBg;
            }
            return super.getBackground(cell);
        }

        public double getCellHeight() {
            return 18.0;
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            double d = super.getPreferredCellWidth(cell);
            switch (cell.column) {
                case 0: {
                    return d + 20.0;
                }
                case 3: {
                    return this.getFont(cell).width("Downgrade to 10.10.10") + 20.0 + 22.0;
                }
            }
            return d;
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            if (cell.column == 0) {
                this.paintKitColumn(graphics, cell);
            } else if (cell.column == 3) {
                this.paintActionColumn(graphics, cell);
            } else {
                super.paintCell(graphics, cell);
            }
        }

        void paintKitColumn(Graphics graphics, TableCellRenderer.Cell cell) {
            String string = this.kit(cell);
            this.paintCellBackground(graphics, cell);
            if (BKitManager.this.mgrModel.isKitSupported(string)) {
                BImage bImage = BKitManager.this.mgrModel.getDesiredVersion(string) == null ? unchecked : (BKitManager.this.mgrModel.isKitRequiredByApp(string) ? kitLocked : checked);
                double d = (double)3 + (kitLocked.getWidth() - bImage.getWidth()) / (double)2;
                double d2 = (cell.height - kitLocked.getHeight()) / (double)2;
                graphics.drawImage(bImage, d, d2);
            }
            graphics.translate((double)3 + kitLocked.getWidth() + (double)2, 0.0);
            super.paintCell(graphics, cell);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void paintActionColumn(Graphics graphics, TableCellRenderer.Cell cell) {
            double d;
            String string = this.kit(cell);
            Version version = BKitManager.this.mgrModel.getInstalledVersion(string);
            Version version2 = BKitManager.this.mgrModel.getDesiredVersion(string);
            this.paintCellBackground(graphics, cell);
            if (cell.row == BKitManager.this.mouseOverRow && version2 != null) {
                graphics.setBrush(mouseFocusBg);
                graphics.fillRect(0.0, 0.0, cell.width, cell.height);
                graphics.setBrush(mouseFocusBorder);
                graphics.strokeRect(0.0, 0.0, cell.width - (double)2, cell.height - (double)2);
                graphics.setBrush(this.getForeground(cell));
            }
            if (version2 != null) {
                double d2 = cell.width - 9.0;
                double d3 = (cell.height - (double)3) / (double)2;
                graphics.strokeLine(d2, d3, d2 + (double)4, d3);
                graphics.strokeLine(d2 + 1.0, d3 + 1.0, d2 + (double)3, d3 + 1.0);
                graphics.strokeLine(d2 + (double)2, d3 + (double)2, d2 + (double)2, d3 + (double)2);
            }
            BImage bImage = BImage.NULL;
            String string2 = this.getCellText(cell);
            boolean bl = BKitManager.this.mgrModel.isKitSupported(string);
            if (!bl) {
                bImage = string2.startsWith(lexRemove) ? kitRemove : kitNotSupported;
            } else if (version2 != null) {
                if (version == null) {
                    bImage = kitAdd;
                } else if (string2.startsWith(lexDowngradeTo)) {
                    bImage = kitDowngrade;
                } else if (string2.startsWith(lexKeepAt)) {
                    bImage = kitNoAction;
                } else {
                    if (!string2.startsWith(lexUpgradeTo)) throw new IllegalStateException(string2);
                    bImage = kitUpgrade;
                }
            } else if (version != null) {
                bImage = kitRemove;
            }
            if (!bImage.isNull()) {
                d = 3;
                double d4 = (cell.height - checked.getHeight()) / (double)2;
                graphics.drawImage(bImage, d, d4);
            }
            d = 20.0;
            BFont bFont = this.getFont(cell);
            graphics.setFont(bFont);
            graphics.drawString(string2, d, (cell.height + bFont.getAscent() - bFont.getDescent()) / (double)2);
        }

        String kit(TableCellRenderer.Cell cell) {
            return BKitManager.this.mgrModel.getSortedKits()[cell.row];
        }

        KitRenderer() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class LController
    extends ListController {
        protected void itemEntered(BMouseEvent bMouseEvent, int n) {
            this.getSelection().deselectAll();
            this.getSelection().select(n);
        }

        LController() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class LRenderer
    extends ListRenderer {
        public void paintItem(Graphics graphics, ListRenderer.Item item) {
            this.paintItemBackground(graphics, item);
            double d = 4;
            graphics.drawImage(item.icon, d, (item.height - item.icon.getHeight()) / (double)2);
            String string = this.getItemText(item);
            double d2 = Theme.table().getCellFont().getHeight();
            double d3 = Theme.table().getCellFont().getAscent();
            double d4 = (item.height - d2) / (double)2;
            graphics.setFont(Theme.table().getCellFont());
            graphics.drawString(string, d += 17.0, d4 + d3);
        }

        LRenderer() {
        }
    }
}

