/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.dasp;

import com.tridium.nsedona.dasp.DaspTunnel;
import com.tridium.nsedona.sox.BSoxScheme;
import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.baja.sedona.dasp.BRouteHandler;
import javax.baja.sys.Clock;
import sedona.Buf;
import sedona.dasp.DaspMsg;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class TunnelSession {
    private static final SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss.SSS");
    final InetSocketAddress clientAddr;
    final int clientId;
    final BRouteHandler handler;
    final BSoxScheme.RouteSpec route;
    final boolean isTunnelExit;
    final int tunnelId;
    DaspTunnel.ClientKey clientToServer;
    DaspMsg tunnelHello;
    DaspMsg tunnelAuth;
    boolean tunnelWelcomed;
    volatile boolean trace;
    protected final long creation;
    protected long lastAccess;
    protected long receiveTimeout;

    public final void tune(DaspMsg daspMsg) {
        this.receiveTimeout = Math.max(this.receiveTimeout, daspMsg.receiveTimeout());
    }

    public final void route(DaspMsg daspMsg) {
        this.update();
        this.handler.route(daspMsg, this.route.address);
    }

    final void tunnelWelcomed() {
        this.tunnelWelcomed = true;
        this.tunnelHello = null;
        this.tunnelAuth = null;
    }

    final void update() {
        this.lastAccess = Clock.ticks();
    }

    public final long uptime() {
        return Clock.ticks() - this.creation;
    }

    public final long idletime() {
        return Clock.ticks() - this.lastAccess;
    }

    public final long receiveTimeout() {
        if (this.receiveTimeout < 0L) {
            return 300000L;
        }
        return this.receiveTimeout;
    }

    final DaspTunnel.ClientKey getOpenTuple() {
        return new DaspTunnel.ClientKey(this.clientAddr, this.clientId);
    }

    final void trace(boolean bl, DaspMsg daspMsg) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = daspMsg.msgType();
        stringBuffer.append(format.format(new Date())).append(' ').append(bl ? " -> " : " <- ").append(" s=").append(Integer.toHexString(daspMsg.sessionId())).append(":{" + Integer.toHexString(this.tunnelId) + '}').append(" seq=").append(Integer.toHexString(daspMsg.seqNum()));
        if (n == 1 || n == 2 || n == 4) {
            stringBuffer.append(" remId=").append(Integer.toHexString(daspMsg.remoteId()));
        }
        if (daspMsg.ack() >= 0) {
            stringBuffer.append(" ack=").append(Integer.toHexString(daspMsg.ack()));
            if (daspMsg.ackMore() != null) {
                stringBuffer.append(" ackMore=").append(new Buf(daspMsg.ackMore()));
            }
        }
        if (n == 6) {
            String string = daspMsg.payload()[1] == -1 ? "ff" : Integer.toHexString(daspMsg.payload()[1]);
            stringBuffer.append(" c=").append((char)daspMsg.payload()[0]).append(" r=").append(string).append(' ').append(new Buf(daspMsg.payload()));
        } else if (n == 7) {
            stringBuffer.append(" err=").append(Integer.toHexString(daspMsg.errorCode())).append(" msgType=").append(daspMsg.msgType()).append(' ').append(new Buf(daspMsg.payload()));
        } else {
            stringBuffer.append(" msgType=").append(n);
        }
        System.out.println(stringBuffer.toString());
    }

    private final /* synthetic */ void this() {
        this.tunnelWelcomed = false;
        this.trace = false;
        this.receiveTimeout = -1;
    }

    public TunnelSession(InetSocketAddress inetSocketAddress, int n, BRouteHandler bRouteHandler, BSoxScheme.RouteSpec[] routeSpecArray, int n2) {
        this.this();
        this.clientAddr = inetSocketAddress;
        this.clientId = n;
        this.handler = bRouteHandler;
        this.route = routeSpecArray[0];
        boolean bl = false;
        if (routeSpecArray.length == 1) {
            bl = true;
        }
        this.isTunnelExit = bl;
        this.tunnelId = n2;
        this.lastAccess = this.creation = Clock.ticks();
    }
}

