/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.dasp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.baja.log.Log;
import sedona.dasp.DaspSocketInterface;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HostDaspSocketInterface
extends DaspSocketInterface {
    private static final Log log = Log.getLog((String)"nsedona.dasp");
    private boolean isSockOpen;
    final InetAddress localAddr;
    final String ifName;
    DatagramSocket sock;
    InetAddress localBcastAddr;

    public boolean isOpen() {
        return this.isSockOpen;
    }

    public boolean routes(InetAddress inetAddress, int n) {
        return true;
    }

    public void send(DatagramPacket datagramPacket) throws IOException {
        if (this.sock == null) {
            return;
        }
        boolean bl = datagramPacket.getAddress().isMulticastAddress();
        if (bl && !this.isIPv6() && this.localBcastAddr != null) {
            datagramPacket.setAddress(this.localBcastAddr);
        }
        this.sock.send(datagramPacket);
    }

    protected void receive(DatagramPacket datagramPacket) throws IOException {
        if (this.sock == null) {
            return;
        }
        this.sock.receive(datagramPacket);
    }

    public void close() throws IOException {
        if (this.sock == null) {
            return;
        }
        this.sock.close();
        this.sock = null;
    }

    public String getName() {
        return this.ifName;
    }

    public String getIp() {
        return this.localAddr.toString();
    }

    public boolean isIPv6() {
        return this.localAddr instanceof Inet6Address;
    }

    public void determineIPv4BCastAddr(String string) {
        byte[] byArray;
        if (this.isIPv6()) {
            return;
        }
        byte[] byArray2 = this.localAddr.getAddress();
        try {
            byArray = InetAddress.getByName(string).getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            log.message("HostDaspSocketInterface " + this.getName() + ": Cannot set subnet mask for '" + string + '\'');
            return;
        }
        byte[] byArray3 = new byte[4];
        int n = 0;
        while (n < 4) {
            byArray3[n] = (byte)(byArray2[n] | ~byArray[n]);
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(byArray3[0] & 0xFF).append('.').append(byArray3[1] & 0xFF).append('.').append(byArray3[2] & 0xFF).append('.').append(byArray3[3] & 0xFF);
        try {
            this.localBcastAddr = InetAddress.getByName(stringBuffer.toString());
        }
        catch (UnknownHostException unknownHostException) {
            log.message("HostDaspSocketInterface " + this.getName() + ": Cannot set local broadcast address for '" + stringBuffer + '\'');
            return;
        }
    }

    public String toString() {
        return this.ifName + '[' + this.localAddr + ']';
    }

    private final /* synthetic */ void this() {
        this.isSockOpen = false;
        this.localBcastAddr = null;
    }

    public HostDaspSocketInterface(int n, String string, String string2) throws IOException {
        this.this();
        this.ifName = string;
        this.localAddr = InetAddress.getByName(string2);
        DatagramSocket datagramSocket = null;
        try {
            datagramSocket = new DatagramSocket(n, this.localAddr);
        }
        catch (IOException iOException) {
            log.message("  Error opening DatagramSocket on " + this.localAddr + " port " + n + ':' + iOException);
            datagramSocket = null;
        }
        boolean bl = false;
        if (datagramSocket != null) {
            bl = true;
        }
        this.isSockOpen = bl;
        this.sock = datagramSocket;
    }
}

