/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.util.HashMap;
import sedonac.Compiler;
import sedonac.CompilerException;
import sedonac.Location;
import sedonac.ast.Expr;
import sedonac.ast.UnresolvedType;
import sedonac.ir.IrField;
import sedonac.ir.IrFlat;
import sedonac.ir.IrMethod;
import sedonac.ir.IrOp;
import sedonac.ir.IrSlot;
import sedonac.ir.IrType;
import sedonac.namespace.ArrayType;
import sedonac.namespace.Field;
import sedonac.namespace.Slot;
import sedonac.namespace.StubType;
import sedonac.namespace.Type;
import sedonac.steps.ResolveTypes;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ResolveIR
extends ResolveTypes {
    HashMap unresolved;
    Location loc;
    static /* synthetic */ Class class$sedonac$ir$IrMethod;
    static /* synthetic */ Class class$sedonac$ir$IrField;

    public void run() {
        this.log.debug("  ResolveIR");
        IrFlat irFlat = this.compiler.flat;
        irFlat.preResolve();
        int n = 0;
        while (n < irFlat.types.length) {
            this.resolveBase(irFlat.types[n]);
            ++n;
        }
        n = 0;
        while (n < irFlat.fields.length) {
            this.resolveField(irFlat.fields[n]);
            ++n;
        }
        n = 0;
        while (n < irFlat.methods.length) {
            this.resolveMethod(irFlat.methods[n]);
            ++n;
        }
        this.quitIfErrors();
        irFlat.postResolve();
    }

    private final void resolveBase(IrType irType) {
        if (irType.base == null) {
            return;
        }
        irType.base = this.resolveType(irType.qname, irType.base);
    }

    private final void resolveField(IrField irField) {
        Object object;
        irField.type = this.resolveType(irField.qname, irField.type);
        if (irField.isConst() && irField.type.isArray() && irField.type.arrayOf().isRef()) {
            object = (ArrayType)irField.type;
            irField.type = new ArrayType(((ArrayType)object).loc, ((ArrayType)object).of, ((ArrayType)object).len, true);
        }
        if (irField.ctorLengthArg instanceof Expr.Name) {
            object = ((Expr.Name)irField.ctorLengthArg).name;
            Field field = (Field)this.ns.resolveSlot((String)object);
            if (field == null) {
                this.err("Unknown ctorLengthArg '" + (String)object + "' for '" + irField.qname + '\'', irField.ctorLengthArg.loc);
            } else {
                irField.ctorLengthArg = new Expr.Field(irField.ctorLengthArg.loc, null, field);
            }
        }
    }

    private final void resolveMethod(IrMethod irMethod) {
        irMethod.ret = this.resolveType(irMethod.qname, irMethod.ret);
        int n = 0;
        while (n < irMethod.params.length) {
            irMethod.params[n] = this.resolveType(irMethod.qname, irMethod.params[n]);
            ++n;
        }
        this.resolveOps(irMethod);
    }

    private final void resolveOps(IrMethod irMethod) {
        IrOp[] irOpArray = irMethod.code;
        if (irOpArray == null) {
            return;
        }
        int n = 0;
        while (n < irOpArray.length) {
            IrOp irOp = irOpArray[n];
            switch (irOp.argType()) {
                case 10: {
                    irOp.resolvedArg = this.resolveType(irMethod.qname, irOp.arg);
                    break;
                }
                case 11: {
                    irOp.resolvedArg = this.resolveSlot(irMethod, irOp.arg, null);
                    break;
                }
                case 13: {
                    String string = irOp.arg;
                    Class clazz = class$sedonac$ir$IrMethod;
                    if (clazz == null) {
                        clazz = ResolveIR.class("[Lsedonac.ir.IrMethod;", false);
                    }
                    irOp.resolvedArg = this.resolveSlot(irMethod, string, clazz);
                    break;
                }
                case 12: {
                    String string = irOp.arg;
                    Class clazz = class$sedonac$ir$IrField;
                    if (clazz == null) {
                        clazz = ResolveIR.class("[Lsedonac.ir.IrField;", false);
                    }
                    irOp.resolvedArg = this.resolveSlot(irMethod, string, clazz);
                    break;
                }
            }
            ++n;
        }
    }

    private final Type resolveType(String string, Type type) {
        String string2;
        Type type2;
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            arrayType.of = this.resolveType(string, arrayType.of);
            arrayType.len = this.arrayLength(arrayType.len, arrayType.loc);
            return arrayType;
        }
        if (type instanceof StubType) {
            StubType stubType = (StubType)type;
            Type type3 = this.ns.resolveType(stubType.qname);
            if (type3 == null) {
                throw new IllegalStateException(stubType.qname);
            }
            return type3;
        }
        if (type instanceof UnresolvedType && (type2 = this.resolveType(string, string2 = ((UnresolvedType)type).name)) != null) {
            return type2;
        }
        return type;
    }

    private final Type resolveType(String string, String string2) {
        Type type = this.ns.resolveType(string2);
        if (type == null && this.unresolved.put(string2, string2) == null) {
            this.err("Unresolvable type " + string2 + " used by " + string);
        }
        return type;
    }

    private final IrSlot resolveSlot(IrMethod irMethod, String string, Class clazz) {
        Slot slot = this.ns.resolveSlot(string);
        if ((slot == null || clazz != null && slot.getClass() != clazz) && this.unresolved.put(string, string) == null) {
            this.err("Unresolvable slot " + string + " in " + irMethod.qname);
        }
        return (IrSlot)slot;
    }

    public CompilerException err(String string) {
        return super.err(string, this.loc);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.unresolved = new HashMap();
    }

    public ResolveIR(Compiler compiler) {
        super(compiler);
        this.this();
    }
}

