/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.util.HashMap;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ast.Expr;
import sedonac.ast.FieldDef;
import sedonac.ast.MethodDef;
import sedonac.ast.SlotDef;
import sedonac.ast.Stmt;
import sedonac.ast.TypeDef;
import sedonac.namespace.Field;
import sedonac.namespace.Method;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;
import sedonac.namespace.TypeUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CheckErrors
extends CompilerStep {
    boolean hasUnsizedInlineArray;
    boolean isSys;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    public void run() {
        this.log.debug("  CheckErrors");
        this.walkAst(3);
        this.quitIfErrors();
    }

    public void enterType(TypeDef typeDef) {
        super.enterType(typeDef);
        this.hasUnsizedInlineArray = false;
        this.checkTypeFlags(typeDef);
        this.checkBase(typeDef);
        this.checkAbstractMethods(typeDef);
    }

    private final void checkTypeFlags(TypeDef typeDef) {
        Location location = typeDef.loc;
        if (typeDef.isAbstract() && typeDef.isFinal()) {
            this.err("Invalid combination of 'abstract' and 'final' modifiers", location);
        }
    }

    private final void checkBase(TypeDef typeDef) {
        if (typeDef.base == null) {
            return;
        }
        if (typeDef.base.isFinal()) {
            this.err("Cannot extend final class '" + typeDef.base + '\'', typeDef.loc);
        }
        if (typeDef.base.isInternal() && !typeDef.base.kit().name().equals(typeDef.kit().name())) {
            this.err("Cannot extend internal class '" + typeDef.base + "'. Not in same kit.", typeDef.loc);
        }
        this.checkDepend(typeDef.base, typeDef.loc);
    }

    private final void checkAbstractMethods(TypeDef typeDef) {
        if (typeDef.isAbstract()) {
            return;
        }
        Slot[] slotArray = typeDef.slots();
        int n = 0;
        while (n < slotArray.length) {
            Slot slot = slotArray[n];
            if (slot.isAbstract()) {
                if (slot.parent() == typeDef) {
                    this.err("Class '" + typeDef.name + "' must be abstract since it contains abstract methods", typeDef.loc);
                    return;
                }
                this.err("Concrete class '" + typeDef.name + "' must override '" + slot.qname() + '\'', typeDef.loc);
            }
            ++n;
        }
    }

    private final void checkDepend(Type type, Location location) {
        if (!TypeUtil.isTestOnly(this.curType) && TypeUtil.isTestOnly(type)) {
            this.err("Runtime class '" + this.curType.qname() + "' cannot depend on test class '" + type.qname() + '\'', location);
        }
    }

    public void enterField(FieldDef fieldDef) {
        super.enterField(fieldDef);
        this.checkProtectionFlags(fieldDef);
        this.checkFieldFlags(fieldDef);
        this.checkFieldInit(fieldDef);
        this.checkFieldDefine(fieldDef);
        this.checkFieldProp(fieldDef);
        this.checkFieldArray(fieldDef);
        this.checkFieldCtor(fieldDef);
        this.checkFieldDepend(fieldDef);
    }

    private final void checkFieldFlags(FieldDef fieldDef) {
        Type type = fieldDef.type;
        Location location = fieldDef.loc;
        if (fieldDef.isAbstract()) {
            this.err("Cannot use 'abstract' modifier on field", location);
        } else if (fieldDef.isVirtual()) {
            this.err("Cannot use 'virtual' modifier on field", location);
        }
        if (fieldDef.isNative()) {
            this.err("Cannot use 'native' modifier on field", location);
        }
        if (fieldDef.isOverride()) {
            this.err("Cannot use 'override' modifier on field", location);
        }
        if (fieldDef.isAction()) {
            this.err("Cannot use 'action' modifier on field", location);
        }
        if (fieldDef.isDefine() && fieldDef.isInline()) {
            this.err("Cannot use 'inline' modifier on define", location);
        }
        if (fieldDef.isProperty()) {
            if (fieldDef.isStatic()) {
                this.err("Cannot use 'static' modifier on property", location);
            }
            if (fieldDef.isConst()) {
                this.err("Cannot use 'const' modifier on property", location);
            }
            if (!fieldDef.isPublic()) {
                this.err("Properties must be public", location);
            }
        }
        if (fieldDef.isConst() && !fieldDef.isDefine() && !this.curType.kit().name().equals("sys")) {
            this.err("Only sys types may use 'const' modifier", location);
        }
        if (fieldDef.isInline() && type.isAbstract()) {
            this.err("Cannot inline fields whose type is abstract", location);
        }
        if (fieldDef.isInline() && !this.curType.kit.name.equals("sys")) {
            if (type.isPrimitive()) {
                this.err("Cannot use 'inline' modifier on '" + type + "' field", location);
            } else if (type.isConst()) {
                this.err("Cannot use 'inline' modifier with const type '" + type + '\'', location);
            }
        }
    }

    private final void checkFieldInit(FieldDef fieldDef) {
        if (fieldDef.init == null) {
            return;
        }
        Type type = fieldDef.type;
        if (fieldDef.init.id == 67) {
            if (!fieldDef.isInline()) {
                this.err("Cannot use '{...}' initializer on non-inline field", fieldDef.loc);
            } else if (!type.isArray()) {
                this.err("Cannot use '{...}' initializer on non-array type field", fieldDef.loc);
            } else if (!type.arrayOf().isRef()) {
                this.err("Cannot use '{...}' initializer on '" + type + "' field", fieldDef.loc);
            }
        }
        if (fieldDef.init.id == 13) {
            Object[] objectArray = ((Expr.Literal)fieldDef.init).asArray();
            if (objectArray.length == 0) {
                this.err("Cannot create empty array literal", fieldDef.init.loc);
            }
            if (!type.isArray()) {
                this.err("Cannot use array literal with non-array type", fieldDef.init.loc);
            }
            Type type2 = type.arrayOf();
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (!this.isArrayLiteralValueOk(type2, object)) {
                    this.err("Invalid literal value " + TypeUtil.toCodeStringSafe(object) + " for " + type + " array literal", fieldDef.init.loc);
                    break;
                }
                ++n;
            }
        }
        if (fieldDef.type.isBuf() && fieldDef.isInline()) {
            if (fieldDef.ctorArgs == null || fieldDef.ctorArgs.length == 0) {
                return;
            }
            int n = fieldDef.ctorArgs[0].toIntLiteral();
            if (fieldDef.init.id == 10 && fieldDef.init.toLiteral().asBuf().size > n || fieldDef.init.id == 9 && fieldDef.init.toLiteral().asString().length() >= n) {
                this.err("Buf is too small to hold initial value: " + fieldDef.toString(), fieldDef.init.loc);
            }
        }
    }

    private final boolean isArrayLiteralValueOk(Type type, Object object) {
        if (object == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        if (type.isByte()) {
            boolean bl = false;
            Class clazz2 = class$java$lang$Integer;
            if (clazz2 == null) {
                clazz2 = class$java$lang$Integer = CheckErrors.class("[Ljava.lang.Integer;", false);
            }
            if (clazz == clazz2) {
                bl = true;
            }
            return bl;
        }
        if (type.isShort()) {
            boolean bl = false;
            Class clazz3 = class$java$lang$Integer;
            if (clazz3 == null) {
                clazz3 = class$java$lang$Integer = CheckErrors.class("[Ljava.lang.Integer;", false);
            }
            if (clazz == clazz3) {
                bl = true;
            }
            return bl;
        }
        if (type.isInteger()) {
            boolean bl = false;
            Class clazz4 = class$java$lang$Integer;
            if (clazz4 == null) {
                clazz4 = class$java$lang$Integer = CheckErrors.class("[Ljava.lang.Integer;", false);
            }
            if (clazz == clazz4) {
                bl = true;
            }
            return bl;
        }
        if (type.isLong()) {
            boolean bl = false;
            Class clazz5 = class$java$lang$Long;
            if (clazz5 == null) {
                clazz5 = class$java$lang$Long = CheckErrors.class("[Ljava.lang.Long;", false);
            }
            if (clazz == clazz5) {
                bl = true;
            }
            return bl;
        }
        if (type.isFloat()) {
            boolean bl = false;
            Class clazz6 = class$java$lang$Float;
            if (clazz6 == null) {
                clazz6 = class$java$lang$Float = CheckErrors.class("[Ljava.lang.Float;", false);
            }
            if (clazz == clazz6) {
                bl = true;
            }
            return bl;
        }
        if (type.isDouble()) {
            boolean bl = false;
            Class clazz7 = class$java$lang$Double;
            if (clazz7 == null) {
                clazz7 = class$java$lang$Double = CheckErrors.class("[Ljava.lang.Double;", false);
            }
            if (clazz == clazz7) {
                bl = true;
            }
            return bl;
        }
        if (type.isStr()) {
            boolean bl = false;
            Class clazz8 = class$java$lang$String;
            if (clazz8 == null) {
                clazz8 = class$java$lang$String = CheckErrors.class("[Ljava.lang.String;", false);
            }
            if (clazz == clazz8) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    private final void checkFieldDefine(FieldDef fieldDef) {
        if (!fieldDef.isDefine()) {
            return;
        }
        String string = fieldDef.qname;
        if (fieldDef.init == null) {
            if (!fieldDef.type.isLog()) {
                this.err("Define '" + string + "' missing value definition", fieldDef.loc);
            }
        } else if (!fieldDef.init.isLiteral() && fieldDef.init.id != 13) {
            this.err("Define '" + string + "' must be defined as literal", fieldDef.loc);
        }
        if (!this.isValidDefineType(fieldDef.type)) {
            this.err("Unsupported type '" + fieldDef.type + "' for define field", fieldDef.loc);
        }
        if (!(fieldDef.init == null || fieldDef.type.isArray() || fieldDef.type.equals(fieldDef.init.type) || fieldDef.init.isNullLiteral(fieldDef.type))) {
            this.err("Define field '" + fieldDef.name + "' has type '" + fieldDef.type + "', but is initialized with expression of type '" + fieldDef.init.type + '\'', fieldDef.loc);
        }
    }

    private final boolean isValidDefineType(Type type) {
        if (type.isArray()) {
            Type type2 = type.arrayOf();
            if (type2.isByte()) {
                return true;
            }
            if (type2.isShort()) {
                return true;
            }
            if (type2.isInt()) {
                return true;
            }
            if (type2.isLong()) {
                return true;
            }
            if (type2.isFloat()) {
                return true;
            }
            if (type2.isDouble()) {
                return true;
            }
            if (type2.isStr()) {
                return true;
            }
        } else {
            if (type.isBool()) {
                return true;
            }
            if (type.isInt()) {
                return true;
            }
            if (type.isLong()) {
                return true;
            }
            if (type.isFloat()) {
                return true;
            }
            if (type.isDouble()) {
                return true;
            }
            if (type.isStr()) {
                return true;
            }
            if (type.isLog()) {
                return true;
            }
        }
        return false;
    }

    private final void checkFieldProp(FieldDef fieldDef) {
        if (!fieldDef.isProperty()) {
            if (fieldDef.facets().getb("config")) {
                this.err("Field '" + fieldDef.name + "' is marked @config, but is not a property", fieldDef.loc);
            } else if (fieldDef.facets().getb("asStr")) {
                this.err("Field '" + fieldDef.name + "' is marked @asStr, but is not a property", fieldDef.loc);
            }
            return;
        }
        String string = fieldDef.qname;
        if (!(fieldDef.type.isBool() || fieldDef.type.isByte() || fieldDef.type.isShort() || fieldDef.type.isInt() || fieldDef.type.isLong() || fieldDef.type.isFloat() || fieldDef.type.isDouble() || fieldDef.type.isBuf())) {
            this.err("Unsupported type '" + fieldDef.type + "' for property '" + string + '\'', fieldDef.loc);
        }
    }

    private final void checkFieldArray(FieldDef fieldDef) {
        Type type = fieldDef.type;
        if (!type.isArray()) {
            return;
        }
        if (fieldDef.isInline() && type.arrayLength() == null) {
            if (!this.curType.kit.name.equals("sys") || !fieldDef.isConst()) {
                if (this.hasUnsizedInlineArray) {
                    this.err("The class '" + this.curType.name + "' can only have have one unsized array", fieldDef.loc);
                } else {
                    this.hasUnsizedInlineArray = true;
                    if (fieldDef.ctorLengthParam <= 0) {
                        this.err("Unsized array '" + fieldDef.name + "' must have length assigned in constructor", fieldDef.loc);
                    }
                }
            }
        } else if (fieldDef.ctorLengthParam > 0) {
            this.err("Cannot specify length of non-inline field '" + fieldDef.name + '\'', fieldDef.loc);
        }
    }

    private final void checkFieldCtor(FieldDef fieldDef) {
        Field field;
        if (fieldDef.ctorArgs == null) {
            return;
        }
        if (!fieldDef.isInline()) {
            this.err("Cannot use constructor on non-inline field '" + fieldDef.name + '\'', fieldDef.loc);
        }
        if (fieldDef.ctorArgs != null && fieldDef.ctorArgs.length > 0 && (field = TypeUtil.getUnsizedArrayField(fieldDef.type)) != null) {
            Integer n;
            Expr expr = fieldDef.ctorArgs[field.ctorLengthParam() - 1];
            if (!expr.isLiteral() && !expr.isDefine()) {
                this.err("Constructor argument must be literal or define", expr.loc);
            } else if (fieldDef.isProperty() && (n = expr.toIntLiteral()) != null) {
                fieldDef.setFacet("max", n);
            }
        }
    }

    private final void checkFieldDepend(FieldDef fieldDef) {
        this.checkDepend(fieldDef.type, fieldDef.loc);
    }

    public void enterMethod(MethodDef methodDef) {
        super.enterMethod(methodDef);
        this.checkProtectionFlags(methodDef);
        this.checkMethodFlags(methodDef);
        this.checkMethodMax(methodDef);
        this.checkMethodValidVars(methodDef);
        this.checkMethodAction(methodDef);
        this.checkMethodCtor(methodDef);
        this.checkMethodDepend(methodDef);
    }

    private final void checkMethodFlags(MethodDef methodDef) {
        Location location = methodDef.loc;
        if (methodDef.isInline()) {
            this.err("Cannot use 'inline' modifier on method", location);
        }
        if (methodDef.isConst()) {
            this.err("Cannot use 'const' modifier on method", location);
        }
        if (methodDef.isProperty()) {
            this.err("Cannot use 'property' modifier on method", location);
        }
        if (methodDef.isNative()) {
            if (methodDef.isAbstract()) {
                this.err("Invalid combination of 'native' and 'abstract' modifiers", location);
            } else if (methodDef.isVirtual()) {
                this.err("Invalid combination of 'native' and 'virtual' modifiers", location);
            }
            if (methodDef.isOverride()) {
                this.err("Invalid combination of 'native' and 'override' modifiers", location);
            }
        }
        if (methodDef.isAction()) {
            if (methodDef.isStatic()) {
                this.err("Cannot use 'static' modifier on action", location);
            }
            if (!methodDef.isPublic()) {
                this.err("Actions must be public", location);
            }
        }
        if (methodDef.isStatic()) {
            if (methodDef.isAbstract()) {
                this.err("Invalid combination of 'static' and 'abstract' modifiers", location);
            } else if (methodDef.isVirtual()) {
                this.err("Invalid combination of 'static' and 'virtual' modifiers", location);
            }
            if (methodDef.isOverride()) {
                this.err("Invalid combination of 'static' and 'override' modifiers", location);
            }
        }
        if (methodDef.isAbstract() && methodDef.isOverride()) {
            this.err("Invalid combination of 'abstract' and 'override' modifiers", location);
        }
        if (methodDef.isVirtual() && !methodDef.parent().isaVirtual()) {
            this.err("Virtual methods can only be used on sys::Virtual subclasses", location);
        }
    }

    private final void checkMethodMax(MethodDef methodDef) {
        if (methodDef.params.length > 255) {
            this.err("Too many parameters", methodDef.loc);
        }
        if (methodDef.maxLocals > 255) {
            this.err("Too many locals", methodDef.loc);
        }
    }

    private final void checkMethodValidVars(MethodDef methodDef) {
        this.checkValidVar("Return", methodDef.ret, methodDef.loc);
        int n = 0;
        while (n < methodDef.params.length) {
            this.checkValidVar("Parameter", methodDef.params[n].type, methodDef.params[n].loc);
            ++n;
        }
    }

    private final void checkValidVar(String string, Type type, Location location) {
        if (type.isInteger() && !type.isInt()) {
            this.err(string + " type must be int, not " + type, location);
        }
    }

    private final void checkMethodAction(MethodDef methodDef) {
        if (!methodDef.isAction()) {
            return;
        }
        String string = methodDef.qname;
        if (!methodDef.ret.isVoid()) {
            this.err("Action '" + string + "' must be have void return type", methodDef.loc);
        }
        if (methodDef.params.length > 0) {
            Type type = methodDef.params[0].type;
            if (!(type.isBool() || type.isInt() || type.isLong() || type.isFloat() || type.isDouble() || type.isBuf())) {
                this.err("Unsupported argument type '" + type + "' for action '" + string + '\'', methodDef.loc);
            }
            if (methodDef.params.length > 1) {
                this.err("Action '" + string + "' can't have more than one parameter", methodDef.loc);
            }
        }
    }

    private final void checkMethodCtor(MethodDef methodDef) {
        if (!methodDef.isInstanceInit()) {
            return;
        }
        if (!methodDef.synthetic && !this.curType.isFinal()) {
            this.err("Class '" + this.curType.name + "' must be final since it declares constructor", this.curType.loc);
        }
        if (this.curType.isaComponent() && methodDef.params.length > 0) {
            this.err("Component class '" + this.curType.name + "' must have a no argument constructor", this.curType.loc);
        }
    }

    private final void checkMethodDepend(MethodDef methodDef) {
        this.checkDepend(methodDef.ret, methodDef.loc);
        int n = 0;
        while (n < methodDef.params.length) {
            this.checkDepend(methodDef.params[n].type, methodDef.params[n].loc);
            ++n;
        }
    }

    private final void checkProtectionFlags(SlotDef slotDef) {
        Location location = slotDef.loc;
        if (slotDef.isPublic()) {
            if (slotDef.isProtected()) {
                this.err("Invalid combination of 'public' and 'protected' modifiers", location);
            }
            if (slotDef.isPrivate()) {
                this.err("Invalid combination of 'public' and 'private' modifiers", location);
            }
            if (slotDef.isInternal()) {
                this.err("Invalid combination of 'public' and 'internal' modifiers", location);
            }
        } else if (slotDef.isProtected()) {
            if (slotDef.isPrivate()) {
                this.err("Invalid combination of 'protected' and 'private' modifiers", location);
            }
            if (slotDef.isInternal()) {
                this.err("Invalid combination of 'protected' and 'internal' modifiers", location);
            }
        } else if (slotDef.isPrivate()) {
            if (slotDef.isInternal()) {
                this.err("Invalid combination of 'private' and 'internal' modifiers", location);
            }
            if (slotDef.isAbstract()) {
                this.err("Invalid combination of 'private' and 'abstract' modifiers", location);
            } else if (slotDef.isVirtual()) {
                this.err("Invalid combination of 'private' and 'virtual' modifiers", location);
            }
        }
    }

    public void enterStmt(Stmt stmt) {
        switch (stmt.id) {
            case 1: {
                this.checkExprStmt((Stmt.ExprStmt)stmt);
                break;
            }
            case 2: {
                this.checkLocalDef((Stmt.LocalDef)stmt);
                break;
            }
            case 4: {
                this.checkIf((Stmt.If)stmt);
                break;
            }
            case 5: {
                this.checkFor((Stmt.For)stmt);
                break;
            }
            case 6: {
                this.checkForeach((Stmt.Foreach)stmt);
                break;
            }
            case 7: {
                this.checkWhile((Stmt.While)stmt);
                break;
            }
            case 8: {
                this.checkDoWhile((Stmt.DoWhile)stmt);
                break;
            }
            case 9: {
                this.checkBreak((Stmt.Break)stmt);
                break;
            }
            case 10: {
                this.checkContinue((Stmt.Continue)stmt);
                break;
            }
            case 3: {
                this.checkReturn((Stmt.Return)stmt);
                break;
            }
            case 11: {
                this.checkAssert((Stmt.Assert)stmt);
                break;
            }
            case 13: {
                this.checkSwitch((Stmt.Switch)stmt);
                break;
            }
        }
    }

    private final void checkExprStmt(Stmt.ExprStmt exprStmt) {
        if (!exprStmt.expr.isStmt()) {
            this.err("Not a statement", exprStmt.expr.loc);
        }
    }

    private final void checkLocalDef(Stmt.LocalDef localDef) {
        this.checkValidVar("Local variable", localDef.type, localDef.loc);
        this.checkDepend(localDef.type, localDef.loc);
        if (localDef.init != null) {
            this.checkAssignable(localDef.type, localDef.init, localDef.loc);
        }
    }

    private final void checkIf(Stmt.If if_) {
        if (!if_.cond.type.isBool()) {
            this.err("If condition must be bool, not '" + if_.cond.type + '\'', if_.cond.loc);
        }
    }

    private final void checkFor(Stmt.For for_) {
        if (for_.cond != null && !for_.cond.type.isBool()) {
            this.err("For condition must be bool, not '" + for_.cond.type + '\'', for_.cond.loc);
        }
    }

    private final void checkForeach(Stmt.Foreach foreach) {
        Type type = foreach.local.type;
        Type type2 = foreach.array.type;
        if (!type2.isArray()) {
            this.err("Foreach requires array type, not '" + type2 + '\'', foreach.array.loc);
            return;
        }
        if (foreach.length == null) {
            if (type2.arrayLength() == null) {
                this.err("Foreach without length requires bounded array type", foreach.array.loc);
            }
        } else if (!foreach.length.type.isInteger()) {
            this.err("Foreach length must be int, not type'" + foreach.length.type + '\'', foreach.length.loc);
        }
        if (!type.is(type2.arrayOf())) {
            this.err("Invalid type '" + type + "' to iterator '" + type2 + '\'', foreach.local.loc);
        }
    }

    private final void checkWhile(Stmt.While while_) {
        if (!while_.cond.type.isBool()) {
            this.err("While condition must be bool, not '" + while_.cond.type + '\'', while_.cond.loc);
        }
    }

    private final void checkDoWhile(Stmt.DoWhile doWhile) {
        if (!doWhile.cond.type.isBool()) {
            this.err("Do/while condition must be bool, not '" + doWhile.cond.type + '\'', doWhile.cond.loc);
        }
    }

    private final void checkBreak(Stmt.Break break_) {
    }

    private final void checkContinue(Stmt.Continue continue_) {
    }

    private final void checkReturn(Stmt.Return return_) {
        Type type = this.curMethod.ret;
        if (return_.expr == null) {
            if (!type.isVoid()) {
                this.err("Must return a value from non-void method", return_.loc);
            }
        } else if (!return_.expr.isNullLiteral(type) && !return_.expr.type.is(type)) {
            this.err("Cannot return '" + return_.expr.type + "' as '" + type + '\'', return_.expr.loc);
        }
    }

    private final void checkAssert(Stmt.Assert assert_) {
        if (!assert_.cond.type.isBool()) {
            this.err("Assert condition must be bool, not '" + assert_.cond.type + '\'', assert_.cond.loc);
        }
    }

    private final void checkSwitch(Stmt.Switch switch_) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        if (!switch_.cond.type.isInteger()) {
            this.err("Switch condition must be int, not '" + switch_.cond.type + '\'', switch_.cond.loc);
        }
        int n = 0;
        while (n < switch_.cases.length) {
            Stmt.Case case_ = switch_.cases[n];
            Integer n2 = case_.label.toIntLiteral();
            if (n2 == null) {
                this.err("Case label not an int literal", case_.label.loc);
            } else {
                if (hashMap.get(n2) != null) {
                    this.err("Duplicate case label", case_.label.loc);
                }
                hashMap.put(n2, n2);
            }
            ++n;
        }
    }

    public Expr expr(Expr expr) {
        switch (expr.id) {
            case 11: {
                this.checkTypeLiteral((Expr.Literal)expr);
                break;
            }
            case 20: {
                this.checkNumeric((Expr.Unary)expr);
                break;
            }
            case 21: {
                this.checkBool((Expr.Unary)expr);
                break;
            }
            case 22: {
                this.checkIntegerOrLong((Expr.Unary)expr);
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                this.checkIncr((Expr.Unary)expr);
                break;
            }
            case 27: 
            case 28: {
                this.checkBools((Expr.Cond)expr);
                break;
            }
            case 29: 
            case 30: {
                this.checkEquality((Expr.Binary)expr);
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                this.checkCompare((Expr.Binary)expr);
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                this.checkBoolOrBitwise((Expr.Binary)expr);
                break;
            }
            case 38: 
            case 39: {
                this.checkShift((Expr.Binary)expr);
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                this.checkMath((Expr.Binary)expr);
                break;
            }
            case 45: 
            case 75: {
                this.checkAssign((Expr.Binary)expr);
                this.checkPropAssign((Expr.Binary)expr);
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                this.checkMath((Expr.Binary)expr);
                this.checkPropAssign((Expr.Binary)expr);
                this.checkAssignable(((Expr.Binary)expr).lhs);
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                this.checkBoolOrBitwise((Expr.Binary)expr);
                this.checkPropAssign((Expr.Binary)expr);
                this.checkAssignable(((Expr.Binary)expr).lhs);
                break;
            }
            case 54: 
            case 55: {
                this.checkShift((Expr.Binary)expr);
                this.checkPropAssign((Expr.Binary)expr);
                this.checkAssignable(((Expr.Binary)expr).lhs);
                break;
            }
            case 56: {
                this.checkElvis((Expr.Binary)expr);
                break;
            }
            case 57: {
                this.checkTernary((Expr.Ternary)expr);
                break;
            }
            case 61: {
                this.checkThis((Expr.This)expr);
                break;
            }
            case 62: {
                this.checkSuper((Expr.Super)expr);
                break;
            }
            case 63: {
                this.checkField((Expr.Field)expr);
                break;
            }
            case 64: {
                this.checkIndex((Expr.Index)expr);
                break;
            }
            case 66: {
                this.checkCast((Expr.Cast)expr);
                break;
            }
            case 65: {
                this.checkCall((Expr.Call)expr);
                break;
            }
            case 72: {
                this.checkInterpolation((Expr.Interpolation)expr);
                break;
            }
            case 73: {
                this.checkHeap(expr);
                break;
            }
            case 74: {
                this.checkHeap(expr);
                break;
            }
        }
        return expr;
    }

    private final void checkTypeLiteral(Expr.Literal literal) {
        Type type = literal.asType();
        if (!type.isReflective()) {
            this.err("Cannot use type literal for non-reflective type '" + literal.asType() + '\'', literal.loc);
        }
    }

    private final void checkBool(Expr.Unary unary) {
        if (!unary.type.isBool()) {
            this.err("Cannot apply '" + unary.op + "' operator to '" + unary.type + '\'', unary.loc);
        }
    }

    private final void checkBools(Expr.Cond cond) {
        int n = 0;
        while (n < cond.operands.size()) {
            Expr expr = (Expr)cond.operands.get(n);
            if (!expr.type.isBool()) {
                this.err("Cannot apply '" + cond.op + "' operator to '" + cond.type + '\'', cond.loc);
            }
            ++n;
        }
    }

    private final void checkIntegerOrLong(Expr.Unary unary) {
        if ((unary.operand.type.isInteger() ^ true) & (unary.operand.type.isLong() ^ true)) {
            this.err("Cannot apply '" + unary.op + "' operator to '" + unary.operand.type + '\'', unary.loc);
        }
    }

    private final void checkNumeric(Expr.Unary unary) {
        if (!unary.operand.type.isNumeric()) {
            this.err("Cannot apply '" + unary.op + "' operator to '" + unary.operand.type + '\'', unary.loc);
        }
    }

    private final void checkIncr(Expr.Unary unary) {
        this.checkNumeric(unary);
        this.checkAssignable(unary.operand);
        if (unary.operand instanceof Expr.Field) {
            Expr.Field field = (Expr.Field)unary.operand;
            if (field.field.isProperty()) {
                this.warn("Should use ':=' assignment operator for properties", unary.loc);
            }
        }
    }

    private final void checkEquality(Expr.Binary binary) {
        Type type = binary.lhs.type;
        Type type2 = binary.rhs.type;
        if (binary.lhs.isNullLiteral(type2)) {
            return;
        }
        if (binary.rhs.isNullLiteral(type)) {
            return;
        }
        if (!type.is(type2) && !type2.is(type)) {
            this.err("Type mismatch: " + type + ' ' + binary.op + ' ' + type2, binary.loc);
        }
    }

    private final void checkCompare(Expr.Binary binary) {
        this.checkMatch(binary);
        this.checkNumeric(binary);
    }

    private final void checkBoolOrBitwise(Expr.Binary binary) {
        this.checkMatch(binary);
        if (!binary.lhs.type.isBool() || !binary.rhs.type.isBool()) {
            this.checkIntegerOrLong(binary);
        }
    }

    private final void checkShift(Expr.Binary binary) {
        if (!binary.lhs.type.isInteger() && !binary.lhs.type.isLong()) {
            this.err("Cannot apply '" + binary.op + "' operator to '" + binary.lhs.type + "' and '" + binary.rhs.type + '\'', binary.loc);
        }
        if (!binary.rhs.type.isInteger()) {
            this.err("Cannot apply '" + binary.op + "' operator to '" + binary.lhs.type + "' and '" + binary.rhs.type + '\'', binary.loc);
        }
    }

    private final void checkMath(Expr.Binary binary) {
        if (binary.lhs.type.isArray()) {
            this.checkPointerArithmetic(binary);
        } else {
            this.checkMatch(binary);
            this.checkNumeric(binary);
        }
    }

    private final void checkPointerArithmetic(Expr.Binary binary) {
        this.err("Cannot apply '" + binary.op + "' operator to '" + binary.lhs.type + "' and '" + binary.rhs.type + '\'', binary.loc);
    }

    private final void checkAssign(Expr.Binary binary) {
        this.checkAssignable(binary.lhs);
        this.checkAssignable(binary.lhs.type, binary.rhs, binary.loc);
    }

    private final void checkElvis(Expr.Binary binary) {
        if (!binary.lhs.type.isRef()) {
            this.err("Cannot apply '?:' operator to '" + binary.lhs.type + '\'', binary.loc);
        }
        this.checkAssignable(binary.lhs.type, binary.rhs, binary.rhs.loc);
    }

    private final void checkPropAssign(Expr.Binary binary) {
        if (binary.lhs.id == 63) {
            Expr.Field field = (Expr.Field)binary.lhs;
            if (field.field.isProperty()) {
                if (binary.op.toBinaryExprId() != 75 && !this.curMethod.isInstanceInit()) {
                    this.warn("Should use ':=' assignment operator for properties", binary.loc);
                }
                return;
            }
        }
        if (binary.op.toBinaryExprId() == 75) {
            this.err("Cannot apply ':=' operator to non-property", binary.loc);
        }
    }

    private final void checkTernary(Expr.Ternary ternary) {
        if (!ternary.cond.type.isBool()) {
            this.err("Ternary cond must be bool, not '" + ternary.cond.type + '\'', ternary.loc);
        }
        if (ternary.trueExpr.type != ternary.falseExpr.type) {
            this.err("Cannot apply ternary operator to '" + ternary.trueExpr.type + "' and '" + ternary.falseExpr.type + '\'', ternary.loc);
        }
    }

    private final void checkNumeric(Expr.Binary binary) {
        if (!binary.lhs.type.isNumeric()) {
            this.err("Cannot apply '" + binary.op + "' operator to '" + binary.lhs.type + '\'', binary.loc);
        }
        if (!binary.rhs.type.isNumeric()) {
            this.err("Cannot apply '" + binary.op + "' operator to '" + binary.rhs.type + '\'', binary.loc);
        }
    }

    private final void checkIntegerOrLong(Expr.Binary binary) {
        if (!binary.lhs.type.isInteger() && !binary.lhs.type.isLong()) {
            this.err("Cannot apply '" + binary.op + "' operator to '" + binary.lhs.type + '\'', binary.loc);
        }
        if (!binary.rhs.type.isInteger() && !binary.rhs.type.isLong()) {
            this.err("Cannot apply '" + binary.op + "' operator to '" + binary.rhs.type + '\'', binary.loc);
        }
    }

    private final void checkAssignable(Expr expr) {
        Object object;
        Expr expr2;
        if (!expr.isAssignable()) {
            expr2 = expr;
            if (expr2.id == 64) {
                expr2 = ((Expr.Index)expr2).target;
            }
            if (expr2.id == 63) {
                object = ((Expr.Field)expr2).field;
                String string = "Field";
                if (object.isInline()) {
                    string = "Inline field";
                } else if (object.isDefine()) {
                    string = "Define field";
                } else if (object.isConst()) {
                    string = "Const field";
                }
                this.err(string + " '" + object.qname() + "' is not assignable", expr.loc);
            } else {
                this.err("Not assignable", expr.loc);
            }
        }
        expr2 = expr;
        while (expr2 instanceof Expr.Name) {
            object = (Expr.Name)expr2;
            if (((Expr.Name)object).safeNav) {
                this.err("Cannot use ?. on left hand side of assignment", ((Expr.Name)object).loc);
            }
            expr2 = ((Expr.Name)object).target;
        }
    }

    private final void checkAssignable(Type type, Expr expr, Location location) {
        if (expr.isNullLiteral(type)) {
            return;
        }
        if (!expr.type.is(type)) {
            this.err("'" + expr.type + "' is not assignable to '" + type + '\'', location);
        }
    }

    private final void checkMatch(Expr.Binary binary) {
        Type type = binary.rhs.type;
        Type type2 = binary.lhs.type;
        if (!type.is(type2)) {
            this.err("Type mismatch: " + type2 + ' ' + binary.op + ' ' + type, binary.loc);
        }
    }

    private final void checkThis(Expr.This this_) {
        if (this.inStatic) {
            this.err("Cannot access 'this' in static context", this_.loc);
        }
    }

    private final void checkSuper(Expr.Super super_) {
        if (this.inStatic) {
            this.err("Cannot access 'super' in static context", super_.loc);
        }
    }

    private final void checkField(Expr.Field field) {
        this.checkSlotAccess(field.field, field.loc, "field");
        this.checkSlotTarget(field.field, field.loc, "access", "field", field.target);
    }

    private final void checkIndex(Expr.Index index) {
        if (!index.index.type.isInteger()) {
            this.err("Index must be int, not '" + index.index.type + '\'', index.loc);
        }
    }

    private final void checkCast(Expr.Cast cast) {
        Type type = cast.target.type;
        Type type2 = cast.type;
        if (type.isNumeric() && type2.isNumeric()) {
            return;
        }
        if (this.compiler.ast.name.equals("sys") && type.isArray() && type.arrayOf().isByte() || type2.isArray() && type2.arrayOf().isByte()) {
            return;
        }
        if (!type2.is(type)) {
            this.err("Expr type " + type + " cannot be cast as " + type2, cast.loc);
        }
    }

    private final void checkCall(Expr.Call call) {
        this.checkIllegalCalls(call);
        this.checkSlotAccess(call.method, call.loc, "method");
        this.checkSlotTarget(call.method, call.loc, "call", "method", call.target);
        this.checkArgs(call);
    }

    private final void checkIllegalCalls(Expr.Call call) {
        String string = call.method.qname();
        if (string.equals("sys::Sys.malloc")) {
            this.err("Must use new operator instead of Sys.malloc", call.loc);
        }
        if (string.equals("sys::Sys.free")) {
            this.err("Must use delete operator instead of Sys.free", call.loc);
        }
    }

    private final void checkInterpolation(Expr.Interpolation interpolation) {
        Location location = interpolation.loc;
        if (!interpolation.callOk) {
            this.err("Cannot use str interpolation here", location);
        }
        interpolation.printMethods = new Method[interpolation.parts.size()];
        int n = 1;
        while (n < interpolation.parts.size()) {
            Expr expr = (Expr)interpolation.parts.get(n);
            Method method = TypeUtil.toPrintMethod(this.ns, expr.type);
            if (method == null) {
                this.err("Cannot use str interpolation with '" + expr.type + '\'', expr.loc);
            } else {
                interpolation.printMethods[n] = method;
            }
            ++n;
        }
    }

    private final void checkHeap(Expr expr) {
        if (!this.isSys) {
            this.err("Heap operators only allowed in sys kit", expr.loc);
        }
    }

    private final void checkSlotAccess(Slot slot, Location location, String string) {
        String string2;
        String string3;
        String string4 = slot.qname();
        Type type = slot.parent();
        if (slot.isPrivate()) {
            if (!this.curType.equals(type)) {
                this.err("Private " + string + " '" + string4 + "' not accessible", location);
            }
        } else if (slot.isProtected()) {
            if (!this.curType.is(type)) {
                this.err("Protected " + string + " '" + string4 + "' not accessible", location);
            }
        } else if (slot.isInternal() && !(string3 = this.curType.kit.name).equals(string2 = type.kit().name())) {
            this.err("Internal " + string + " '" + string4 + "' not accessible", location);
        }
        this.checkDepend(slot.parent(), location);
    }

    private final void checkSlotTarget(Slot slot, Location location, String string, String string2, Expr expr) {
        String string3 = slot.qname();
        if (slot.isStatic()) {
            if (expr == null) {
                return;
            }
            if (expr.id != 70) {
                this.err("Cannot " + string + " static " + string2 + " '" + string3 + "' on instance", location);
            }
        } else if (expr == null || expr.id == 70) {
            this.err("Cannot " + string + " instance " + string2 + " '" + string3 + "' in static context", location);
        }
    }

    private final void checkArgs(Expr.Call call) {
        String string = call.name;
        Expr[] exprArray = call.args;
        Type[] typeArray = call.method.paramTypes();
        boolean bl = false;
        if (call.method.isInstanceInit()) {
            string = call.method.parent().name();
        }
        if (typeArray.length != exprArray.length) {
            bl = true;
        } else {
            int n = 0;
            while (n < exprArray.length && !bl) {
                Expr expr = exprArray[n];
                Type type = typeArray[n];
                if (!expr.isNullLiteral(type)) {
                    bl = expr.type.is(type) ^ true;
                }
                ++n;
            }
        }
        if (!bl) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Invalid args for ").append(string).append("(");
        int n = 0;
        while (n < typeArray.length) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(typeArray[n]);
            ++n;
        }
        stringBuffer.append("), not (");
        n = 0;
        while (n < exprArray.length) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(exprArray[n].type);
            ++n;
        }
        stringBuffer.append(")");
        this.err(stringBuffer.toString(), call.loc);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public CheckErrors(Compiler compiler) {
        super(compiler);
        this.isSys = compiler.ast.name.equals("sys");
    }
}

