/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet.user;

import com.tridium.nsedona.sox.SoxPlatformSession;
import com.tridium.sedonanet.driver.BISedonaDevice;
import com.tridium.sedonanet.driver.BSedonaBaseDevice;
import com.tridium.sedonanet.user.BSedonaRole;
import com.tridium.sedonanet.user.BSedonaRoleService;
import com.tridium.sedonanet.user.BSedonaUser;
import com.tridium.sedonanet.user.BSedonaUserService;
import com.tridium.sedonanet.user.BSedonaUsersExt;
import com.tridium.util.BRetryableAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNameMap;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import sedona.Buf;
import sedona.Byte;
import sedona.Component;
import sedona.Int;
import sedona.Schema;
import sedona.Value;
import sedona.offline.OfflineComponent;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;
import sedona.sox.SoxException;
import sedona.util.UserUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BUserSyncTask
extends BRetryableAction {
    public static final Type TYPE;
    private static final BIcon Icon;
    private String deviceSuperUser;
    private SoxPlatformSession session;
    private SoxClient c;
    private Schema schema;
    private BSedonaUserService users;
    private BSedonaRoleService roles;
    static /* synthetic */ Class class$com$tridium$sedonanet$user$BUserSyncTask;

    public final Type getType() {
        return TYPE;
    }

    public final IFuture post(Action action, BValue bValue, Context context) {
        if (BRetryableAction.execute == action) {
            return this.getExt().getManagementService().getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void doExecution() throws Exception {
        if (!this.getExt().isOperational()) {
            throw new Exception("The Sedona users extension is not operational: " + this.getExt().getStatus());
        }
        try {
            this.init();
            this.sync();
            this.session.saveApp();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.cleanup();
            throw throwable;
        }
        {
            Object var2_3 = null;
            this.cleanup();
            return;
        }
    }

    private final void init() throws Exception {
        BSedonaUsersExt bSedonaUsersExt = this.getExt();
        BSedonaBaseDevice bSedonaBaseDevice = (BSedonaBaseDevice)bSedonaUsersExt.getDevice();
        this.deviceSuperUser = bSedonaBaseDevice.getCredentials().getUsername();
        BNameMap bNameMap = bSedonaUsersExt.getUserMap();
        if (bNameMap.get(this.deviceSuperUser) != null) {
            bSedonaUsersExt.setUserMap(BNameMap.remove((BNameMap)bNameMap, (String)this.deviceSuperUser));
        }
        this.users = this.getExt().getManagementService().getUserService();
        this.roles = this.getExt().getManagementService().getRoleService();
        try {
            this.session = this.getSoxSession();
            bSedonaUsersExt.getDevice().pingOk();
        }
        catch (SoxException soxException) {
            bSedonaUsersExt.getDevice().pingFail(soxException.getMessage());
            throw soxException;
        }
        this.c = this.session.client;
        this.schema = this.c.readSchema();
    }

    private final void sync() throws Exception {
        String string;
        sedona.Type type = this.schema.type("sys::User");
        SoxComponent soxComponent = this.c.load(this.c.queryService(this.schema.type("sys::UserService"))[0]);
        SoxComponent[] soxComponentArray = soxComponent.children();
        HashMap<String, SoxComponent> hashMap = new HashMap<String, SoxComponent>();
        int n = 0;
        while (n < soxComponentArray.length) {
            hashMap.put(soxComponentArray[n].name(), soxComponentArray[n]);
            ++n;
        }
        String[] stringArray = this.getExt().getUsernames();
        int n2 = 0;
        while (n2 < stringArray.length) {
            string = stringArray[n2];
            if (string.equals(this.deviceSuperUser)) {
                throw new IllegalStateException("cannot sync device super user: " + this.deviceSuperUser);
            }
            Set set = this.getExt().getRoles(string);
            Component component = this.getUserPrototype(type, string, set);
            sedona.Slot[] slotArray = type.configProps();
            SoxComponent soxComponent2 = (SoxComponent)hashMap.get(string);
            if (soxComponent2 != null) {
                int n3 = 0;
                while (n3 < slotArray.length) {
                    this.c.write(soxComponent2, slotArray[n3], component.get(slotArray[n3]));
                    ++n3;
                }
                hashMap.remove(string);
            } else {
                Value[] valueArray = new Value[slotArray.length];
                int n4 = 0;
                while (n4 < slotArray.length) {
                    valueArray[n4] = component.get(slotArray[n4]);
                    ++n4;
                }
                this.c.add(soxComponent, type, string, valueArray);
            }
            ++n2;
        }
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            string = (SoxComponent)iterator.next();
            if (string.name().equals(this.deviceSuperUser)) continue;
            this.c.delete((SoxComponent)string);
        }
    }

    private final Component getUserPrototype(sedona.Type type, String string, Set set) throws Exception {
        BSedonaUser bSedonaUser = this.users.getSedonaUser(string);
        if (bSedonaUser == null) {
            throw new Exception("user: " + string + " not in user service");
        }
        BSedonaRole bSedonaRole = new BSedonaRole();
        OfflineComponent offlineComponent = set.iterator();
        while (offlineComponent.hasNext()) {
            String string2 = (String)offlineComponent.next();
            BSedonaRole bSedonaRole2 = this.roles.getSedonaRole(string2);
            if (bSedonaRole2 == null) {
                throw new Exception("role: " + string2 + " not in the Sedona roles service");
            }
            bSedonaRole = BSedonaRole.merge(bSedonaRole, bSedonaRole2);
        }
        offlineComponent = new OfflineComponent(type);
        offlineComponent.set("cred", (Value)new Buf(UserUtil.credentials((String)string, (String)bSedonaUser.getPassword().getString())));
        offlineComponent.set("perm", (Value)Int.make((int)bSedonaRole.getPermissions()));
        offlineComponent.set("prov", (Value)Byte.make((int)bSedonaRole.getProvisioning()));
        return offlineComponent;
    }

    private final void cleanup() {
        this.deviceSuperUser = null;
        this.c = null;
        this.schema = null;
        if (this.session != null) {
            this.session.close();
        }
    }

    private final BSedonaUsersExt getExt() {
        return (BSedonaUsersExt)this.getParent();
    }

    private final SoxPlatformSession getSoxSession() throws Exception {
        return (SoxPlatformSession)((BISedonaDevice)this.getExt().getDevice()).openPlatformSession(null);
    }

    public final boolean isParentLegal(BComponent bComponent) {
        boolean bl = false;
        if (super.isParentLegal(bComponent) && bComponent instanceof BSedonaUsersExt) {
            bl = true;
        }
        return bl;
    }

    public final BIcon getIcon() {
        return Icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BUserSyncTask() {
        this.setDelay(BRelTime.makeSeconds((int)5));
        this.setFlags((Slot)delay, this.getFlags((Slot)delay) | 4);
        this.setFlags((Slot)retryInterval, this.getFlags((Slot)retryInterval) | 4);
    }

    static {
        Class clazz = class$com$tridium$sedonanet$user$BUserSyncTask;
        if (clazz == null) {
            clazz = class$com$tridium$sedonanet$user$BUserSyncTask = BUserSyncTask.class("[Lcom.tridium.sedonanet.user.BUserSyncTask;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Icon = BIcon.std((String)"sync.png");
    }
}

