/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet.driver.point;

import com.tridium.nsedona.util.StringUtil;
import com.tridium.sedonanet.driver.BSedonaBaseDevice;
import com.tridium.sedonanet.driver.point.BSedonaPointDeviceExt;
import com.tridium.sedonanet.driver.point.BSedonaPointDiscoveryConfig;
import com.tridium.sedonanet.driver.point.BSedonaPointDiscoveryType;
import com.tridium.sedonanet.driver.point.BSedonaPointEntry;
import java.io.InputStream;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import sedona.Schema;
import sedona.Slot;
import sedona.offline.OfflineApp;
import sedona.offline.OfflineComponent;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSedonaDiscoverPointsJob
extends BJob {
    public static final Type TYPE;
    static Lexicon lex;
    BSedonaPointDeviceExt ext;
    BSedonaBaseDevice dev;
    BSedonaPointDiscoveryConfig config;
    JobThread thread;
    SoxClient soxClient;
    static /* synthetic */ Class class$com$tridium$sedonanet$driver$point$BSedonaDiscoverPointsJob;

    public Type getType() {
        return TYPE;
    }

    public void doRun(Context context) {
        this.thread = new JobThread(this.toPathString(), context);
        this.thread.start();
    }

    public void doCancel(Context context) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }

    public void run(Context context) throws Exception {
        if (this.config.getDiscoveryType() == BSedonaPointDiscoveryType.online) {
            this.discoverFromDevice();
        } else {
            this.discoverFromApp(this.config.getAppFileOrd());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void discoverFromDevice() {
        try {
            try {
                this.soxClient = this.dev.makeSoxClient(false);
                this.soxClient.connect();
                this.progress(5);
                SoxComponent soxComponent = this.soxClient.loadApp();
                this.progress(10);
                BSedonaPointEntry bSedonaPointEntry = this.getPointEntries(soxComponent, 10, 95);
                this.add(null, (BValue)bSedonaPointEntry);
                this.progress(95);
                this.success();
            }
            catch (Schema.MissingKitManifestException missingKitManifestException) {
                String string = StringUtil.formatMissingManifestException((Schema.MissingKitManifestException)missingKitManifestException);
                this.add("failureMsg", (BValue)BString.make((String)string), 0, BFacets.make((String)"multiLine", (boolean)true), null);
                this.log().failed(missingKitManifestException.toString());
                this.failed(missingKitManifestException);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                String string = lex.getText("ptMgr.learn.err.msg", new Object[]{exception.toString()});
                this.add("failureMsg", (BValue)BString.make((String)string));
                this.log().failed(exception.toString(), (Throwable)exception);
                this.failed(exception);
            }
        }
        catch (Throwable throwable) {
            Object var2_8 = null;
            this.soxClient.close();
            System.gc();
            throw throwable;
        }
        {
            Object var2_9 = null;
        }
        this.soxClient.close();
        System.gc();
    }

    private final BSedonaPointEntry getPointEntries(SoxComponent soxComponent, int n, int n2) throws Exception {
        Slot slot;
        int n3;
        this.log().message("Loading children for " + soxComponent.toString());
        this.progress(n);
        String string = soxComponent.name();
        int n4 = soxComponent.id();
        BSedonaPointEntry bSedonaPointEntry = new BSedonaPointEntry(soxComponent.name());
        SoxComponent[] soxComponentArray = soxComponent.children();
        int n5 = soxComponentArray.length;
        if (n5 > 0) {
            int n6 = (n2 - n) / n5;
            n3 = 0;
            while (n3 < n5) {
                bSedonaPointEntry.add(null, (BValue)this.getPointEntries(soxComponentArray[n3], n + n6 * n3, n + n6 * (n3 + 1)));
                ++n3;
            }
        }
        this.soxClient.load(soxComponent.id());
        n3 = 1;
        while ((slot = soxComponent.type.slot(n3++)) != null) {
            BSedonaPointEntry bSedonaPointEntry2 = new BSedonaPointEntry(string, n4, slot);
            bSedonaPointEntry.add(null, (BValue)bSedonaPointEntry2);
        }
        this.progress(n2);
        return bSedonaPointEntry;
    }

    public void discoverFromApp(BOrd bOrd) throws Exception {
        this.progress(5);
        BSedonaPointEntry bSedonaPointEntry = BSedonaDiscoverPointsJob.discoverFromFile(this, bOrd);
        this.progress(98);
        this.add(null, (BValue)bSedonaPointEntry);
        this.success();
    }

    public static BSedonaPointEntry discoverFromFile(BSedonaDiscoverPointsJob bSedonaDiscoverPointsJob, BOrd bOrd) throws Exception {
        String string = bOrd.toString();
        if (string.endsWith("sedona/store")) {
            throw new IllegalStateException(lex.getText("ptMgr.learn.err.notAssoc"));
        }
        BIFile bIFile = (BIFile)bOrd.get((BObject)BFileSystem.INSTANCE);
        String string2 = bIFile.getExtension();
        if (string2 == null) {
            throw new IllegalStateException(lex.getText("ptMgr.learn.badAppFile"));
        }
        OfflineApp offlineApp = null;
        if (string2.equals("sax")) {
            offlineApp = OfflineApp.decodeAppXml((String)bIFile.getFileName(), (InputStream)bIFile.getInputStream());
        } else if (string2.equals("sab")) {
            offlineApp = OfflineApp.decodeAppBinary((InputStream)bIFile.getInputStream());
        } else {
            throw new IllegalArgumentException("Unknown file ext: " + string2);
        }
        if (offlineApp == null) {
            throw new RuntimeException("Cannot decode app for " + bIFile);
        }
        OfflineComponent offlineComponent = offlineApp.lookup(0);
        BSedonaPointEntry bSedonaPointEntry = BSedonaDiscoverPointsJob.getPointEntries(bSedonaDiscoverPointsJob, offlineComponent, 10, 95);
        return bSedonaPointEntry;
    }

    public static BSedonaPointEntry getPointEntries(BSedonaDiscoverPointsJob bSedonaDiscoverPointsJob, OfflineComponent offlineComponent, int n, int n2) throws Exception {
        Slot slot;
        int n3;
        if (bSedonaDiscoverPointsJob != null) {
            bSedonaDiscoverPointsJob.progress(n);
        }
        String string = offlineComponent.name();
        int n4 = offlineComponent.id();
        BSedonaPointEntry bSedonaPointEntry = new BSedonaPointEntry(offlineComponent.name());
        OfflineComponent[] offlineComponentArray = offlineComponent.children();
        int n5 = offlineComponentArray.length;
        if (n5 > 0) {
            int n6 = (n2 - n) / n5;
            n3 = 0;
            while (n3 < n5) {
                bSedonaPointEntry.add(null, (BValue)BSedonaDiscoverPointsJob.getPointEntries(bSedonaDiscoverPointsJob, offlineComponentArray[n3], n + n6 * n3, n + n6 * (n3 + 1)));
                ++n3;
            }
        }
        n3 = 1;
        while ((slot = offlineComponent.type.slot(n3++)) != null) {
            BSedonaPointEntry bSedonaPointEntry2 = new BSedonaPointEntry(string, n4, slot);
            bSedonaPointEntry.add(null, (BValue)bSedonaPointEntry2);
        }
        if (bSedonaDiscoverPointsJob != null) {
            bSedonaDiscoverPointsJob.progress(n2);
        }
        return bSedonaPointEntry;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BSedonaDiscoverPointsJob() {
    }

    public BSedonaDiscoverPointsJob(BSedonaPointDeviceExt bSedonaPointDeviceExt) {
        this.ext = bSedonaPointDeviceExt;
        this.dev = bSedonaPointDeviceExt.getSedonaDevice();
        this.config = new BSedonaPointDiscoveryConfig(BSedonaPointDiscoveryType.online);
    }

    public BSedonaDiscoverPointsJob(BSedonaPointDeviceExt bSedonaPointDeviceExt, BSedonaPointDiscoveryConfig bSedonaPointDiscoveryConfig) {
        this.ext = bSedonaPointDeviceExt;
        this.dev = bSedonaPointDeviceExt.getSedonaDevice();
        this.config = bSedonaPointDiscoveryConfig;
    }

    static {
        Class clazz = class$com$tridium$sedonanet$driver$point$BSedonaDiscoverPointsJob;
        if (clazz == null) {
            clazz = class$com$tridium$sedonanet$driver$point$BSedonaDiscoverPointsJob = BSedonaDiscoverPointsJob.class("[Lcom.tridium.sedonanet.driver.point.BSedonaDiscoverPointsJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"sedonanet");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class JobThread
    extends Thread {
        Context cx;

        public void run() {
            try {
                BSedonaDiscoverPointsJob.this.run(this.cx);
            }
            catch (Throwable throwable) {
                BSedonaDiscoverPointsJob.this.failed(throwable);
            }
        }

        JobThread(String string, Context context) {
            super(string);
            this.cx = context;
        }
    }
}

