/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet.driver.comm;

import com.tridium.sedonanet.driver.comm.SoxComm;
import com.tridium.sedonanet.driver.comm.SoxTransaction;
import java.util.Iterator;
import java.util.Vector;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Clock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class SoxTransactionManager {
    private static final int MAX_TAG = 255;
    private SoxTransaction nextFree;
    private Vector inuseVect;
    private int lastTagUsed;
    private int transCnt;
    private SoxComm soxComm;

    final void start() {
        this.nextFree = null;
        this.lastTagUsed = 0;
        this.inuseVect = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void stop() {
        SoxTransactionManager soxTransactionManager = this;
        synchronized (soxTransactionManager) {
            int n = this.inuseVect.size() - 1;
            while (n >= 0) {
                SoxTransaction soxTransaction = (SoxTransaction)this.inuseVect.elementAt(n);
                this.inuseVect.removeElement(soxTransaction);
                this.freeTransaction(soxTransaction);
                --n;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final SoxTransaction getTransaction() {
        SoxTransactionManager soxTransactionManager = this;
        synchronized (soxTransactionManager) {
            SoxTransaction soxTransaction;
            block5: {
                block4: {
                    soxTransaction = this.nextFree;
                    if (soxTransaction == null) break block4;
                    this.nextFree = soxTransaction.next;
                    break block5;
                }
                soxTransaction = new SoxTransaction();
                ++this.transCnt;
            }
            if (++this.lastTagUsed > 255) {
                this.lastTagUsed = 1;
            }
            soxTransaction.tag = this.lastTagUsed;
            soxTransaction.startTime = Clock.ticks();
            this.inuseVect.add(soxTransaction);
            this.xdbg("getTransaction " + soxTransaction.tag + " ivsz=" + this.inuseVect.size());
            return soxTransaction;
        }
    }

    final synchronized void freeTransaction(SoxTransaction soxTransaction) {
        boolean bl = this.inuseVect.removeElement(soxTransaction);
        this.xdbg("freeTransaction " + soxTransaction.tag + " rmvd=" + bl + " ivsz=" + this.inuseVect.size());
        soxTransaction.clear();
        soxTransaction.next = this.nextFree;
        this.nextFree = soxTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final SoxTransaction getTransactionMatch(int n) {
        this.xdbg("getTransactionMatch " + n + " ivsz=" + this.inuseVect.size());
        SoxTransaction soxTransaction = null;
        SoxTransactionManager soxTransactionManager = this;
        synchronized (soxTransactionManager) {
            int n2 = 0;
            while (n2 < this.inuseVect.size()) {
                SoxTransaction soxTransaction2 = (SoxTransaction)this.inuseVect.elementAt(n2);
                if (soxTransaction2.tag != n) {
                    ++n2;
                    continue;
                }
                soxTransaction2.finishTime = Clock.ticks();
                soxTransaction2.delta = soxTransaction2.finishTime - soxTransaction2.startTime;
                boolean bl = this.inuseVect.removeElement(soxTransaction2);
                soxTransaction = soxTransaction2;
                if (!this.xdbg()) break;
                this.xdbg("found tag match: rmvd=" + bl + " ivsz=" + this.inuseVect.size() + "; xact=" + soxTransaction2);
                break;
            }
            return soxTransaction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void dump() {
        System.out.println("\nSox Transaction Dump");
        System.out.println(" lastTagUsed=" + this.lastTagUsed + " transCnt" + this.transCnt);
        if (this.nextFree != null) {
            System.out.println("nextFree=" + this.nextFree.tag);
        }
        SoxTransactionManager soxTransactionManager = this;
        synchronized (soxTransactionManager) {
            block6: {
                block5: {
                    if (this.inuseVect.size() <= 0) break block5;
                    int n = 0;
                    while (n < this.inuseVect.size()) {
                        System.out.println("inuseVect[" + n + "]:" + this.inuseVect.get(n));
                        ++n;
                    }
                    break block6;
                }
                System.out.println("inuseVect is EMPTY");
            }
            return;
        }
    }

    public final void clear() {
        System.out.println("Clearing Sox Transactions");
        this.dump();
        this.stop();
        this.start();
    }

    final void xdbg(Object object) {
        if (this.soxComm.transactionDebug || this.soxComm.network.getTransactionDebug()) {
            System.out.println("" + object);
        }
    }

    final boolean xdbg() {
        boolean bl = false;
        if (this.soxComm.transactionDebug || this.soxComm.network.getTransactionDebug()) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps("SoxTransactionManager");
        spyWriter.prop((Object)"lastTagUsed", this.lastTagUsed);
        spyWriter.prop((Object)"transCnt", this.transCnt);
        spyWriter.prop((Object)"nextFree", (Object)this.nextFree);
        spyWriter.trTitle((Object)"inuseVect", 2);
        SoxTransactionManager soxTransactionManager = this;
        synchronized (soxTransactionManager) {
            Iterator iterator = this.inuseVect.iterator();
            while (iterator.hasNext()) {
                spyWriter.prop((Object)"", iterator.next());
            }
        }
        spyWriter.endProps();
    }

    private final /* synthetic */ void this() {
        this.lastTagUsed = 0;
        this.transCnt = 0;
    }

    SoxTransactionManager(SoxComm soxComm) {
        this.this();
        this.soxComm = soxComm;
    }
}

