/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet.driver.comm;

import com.tridium.sedonanet.driver.BSedonaBaseDevice;
import com.tridium.sedonanet.driver.comm.SedByteArrayUtil;
import java.io.EOFException;
import java.io.IOException;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import sedona.Constants;
import sedona.sox.Msg;
import sedona.util.TextUtil;

public class SoxMsg
extends Msg
implements Constants {
    public static final int MAX_PACKET_SIZE = 1024;
    public BSedonaBaseDevice device;

    public static SoxMsg make(Msg msg) {
        return new SoxMsg(msg.bytes, msg.size);
    }

    public static SoxMsg make(BSedonaBaseDevice bSedonaBaseDevice, byte[] byArray, int n) {
        SoxMsg soxMsg = new SoxMsg(byArray, n);
        soxMsg.device = bSedonaBaseDevice;
        return soxMsg;
    }

    public static SoxMsg make(int n) {
        SoxMsg soxMsg = new SoxMsg();
        soxMsg.u1(n);
        soxMsg.u1(99);
        return soxMsg;
    }

    public static SoxMsg makeResponse(SoxMsg soxMsg) {
        SoxMsg soxMsg2 = new SoxMsg();
        soxMsg2.u1(Character.toUpperCase((char)soxMsg.getCommand()));
        soxMsg2.u1(soxMsg.replyNum());
        return soxMsg2;
    }

    public boolean isRequest() {
        boolean bl = false;
        if (this.bytes[0] >= 97 && this.bytes[0] <= 122) {
            bl = true;
        }
        return bl;
    }

    public boolean isFailed() {
        boolean bl = false;
        if (this.bytes[0] == 33) {
            bl = true;
        }
        return bl;
    }

    public int getCommand() {
        return this.bytes[0];
    }

    public String toString() {
        String string = this.device == null ? "null" : this.device.toPathString();
        return "SoxMsg [device=" + string + ']' + SedByteArrayUtil.toString(this.bytes, this.size);
    }

    public BSimple readValue() throws IOException {
        return this.readValue(this.read());
    }

    public BSimple readValue(int n) throws IOException {
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return this.readBool();
            }
            case 2: {
                return BInteger.make((int)this.u1());
            }
            case 3: {
                return BInteger.make((int)this.u2());
            }
            case 4: {
                return BInteger.make((int)this.i4());
            }
            case 5: {
                return BLong.make((long)this.i8());
            }
            case 6: {
                return BDouble.make((double)this.f4());
            }
            case 7: {
                return BDouble.make((double)this.f8());
            }
            case 101: {
                int n2 = this.u2();
                if (n2 == 0) {
                    return BString.DEFAULT;
                }
                return BString.make((String)this.str(n2));
            }
            case 8: {
                int n3 = this.u2();
                if (n3 == 0) {
                    return BBlob.DEFAULT;
                }
                return BBlob.make((byte[])this.buf(n3));
            }
        }
        throw new IllegalStateException("Unknown value type " + (char)n);
    }

    public void writeValue(BSimple bSimple, int n) throws IOException {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.writeBool((BBoolean)bSimple);
                break;
            }
            case 2: {
                this.u1(((BNumber)bSimple).getInt());
                break;
            }
            case 3: {
                this.u2(((BNumber)bSimple).getInt());
                break;
            }
            case 4: {
                this.i4(((BNumber)bSimple).getInt());
                break;
            }
            case 5: {
                this.i8(((BNumber)bSimple).getLong());
                break;
            }
            case 6: {
                this.f4(((BNumber)bSimple).getFloat());
                break;
            }
            case 7: {
                this.f8(((BNumber)bSimple).getDouble());
                break;
            }
            case 8: {
                String string = ((BString)bSimple).getString();
                int n2 = string.length();
                this.u2(n2);
                this.buf(string);
                break;
            }
            case 101: {
                String string = ((BString)bSimple).getString();
                this.u2(string.length() + 1);
                this.str(string);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown value type " + n + '\'' + (char)n + '\'');
            }
        }
    }

    public BBoolean readBool() throws IOException {
        int n = this.u1();
        switch (n) {
            case 0: {
                return BBoolean.FALSE;
            }
            case 1: {
                return BBoolean.TRUE;
            }
            case 2: {
                return null;
            }
        }
        throw new IOException("invalid bool:" + n);
    }

    public void writeBool(BBoolean bBoolean) {
        if (bBoolean == null) {
            this.u1(2);
        } else {
            this.u1(bBoolean.getBoolean() ? 1 : 0);
        }
    }

    public byte[] buf(int n) throws IOException {
        byte[] byArray = new byte[n];
        try {
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)this.u1();
                ++n2;
            }
        }
        catch (EOFException eOFException) {
            System.out.println("Found fewer than " + n + " bytes, got partial buf");
            eOFException.printStackTrace();
        }
        return byArray;
    }

    public String str(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        try {
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.u1();
                if (n3 == 0) {
                    bl = true;
                }
                if (!bl) {
                    stringBuffer.append((char)n3);
                }
                ++n2;
            }
        }
        catch (EOFException eOFException) {
            System.out.println("Found fewer than " + n + " bytes, got partial string '" + stringBuffer.toString() + '\'');
            eOFException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public void buf(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            int n2 = TextUtil.hexCharToInt((char)c);
            int n3 = TextUtil.hexCharToInt((char)string.charAt(++n));
            this.u1(n2 << 4 | n3);
            ++n;
        }
    }

    private SoxMsg() {
    }

    private SoxMsg(byte[] byArray, int n) {
        super(new byte[n]);
        System.arraycopy(byArray, 0, this.bytes, 0, n);
        this.size = n;
    }
}

