/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet.chopan;

import java.io.IOException;
import java.util.Iterator;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.util.IntHashMap;
import javax.baja.util.Lexicon;
import obix.Bool;
import obix.Int;
import obix.Obj;
import obix.Real;
import obix.Str;
import obix.Uri;
import obix.io.BinObix;
import obix.io.BinObixDecoder;
import obix.io.BinObixEncoder;

public class ObixUtil
implements BinObix {
    private static final Lexicon lex = Lexicon.make((String)"sedonanet");
    private static final IntHashMap statusCodeMap = new IntHashMap();

    public static BValue decodeBinary(byte[] byArray, BValue bValue) throws Exception {
        Obj obj = BinObixDecoder.fromBytes((byte[])byArray);
        BBoolean bBoolean = null;
        switch (obj.getBinCode()) {
            case 8: {
                bBoolean = BBoolean.make((boolean)obj.getBool());
                break;
            }
            case 16: {
                bBoolean = BDouble.make((double)obj.getReal());
                break;
            }
            case 12: {
                bBoolean = BLong.make((long)obj.getInt());
                break;
            }
            case 20: {
                bBoolean = BString.make((String)obj.getStr());
                break;
            }
            default: {
                bBoolean = BString.make((String)obj.toString());
            }
        }
        if (bValue instanceof BStatusValue) {
            if (bBoolean.getType().is(((BStatusValue)bValue).getValueValue().getType())) {
                BStatusValue bStatusValue = (BStatusValue)((BStatusValue)bValue).newCopy();
                bStatusValue.setStatusNull(obj.isNull());
                bStatusValue.setValueValue((BValue)bBoolean);
                return bStatusValue;
            }
        } else if (bBoolean.getType().is(bValue.getType())) {
            return bBoolean;
        }
        throw new IllegalArgumentException("Bad Type: exp=" + bValue.getType() + " act=" + bBoolean.getType());
    }

    public static byte[] encodeBinary(boolean bl) throws Exception {
        return BinObixEncoder.toBytes((Obj)new Bool(bl));
    }

    public static byte[] encodeBinary(BValue bValue) throws Exception {
        Object object = null;
        if (bValue.isSimple()) {
            if (!(bValue instanceof BAbsTime)) {
                object = bValue instanceof BIBoolean ? new Bool(((BIBoolean)bValue).getBoolean()) : (bValue instanceof BIEnum ? new Int((long)((BIEnum)bValue).getEnum().getOrdinal()) : (bValue instanceof BInteger ? new Int((long)((BInteger)bValue).getInt()) : (bValue instanceof BLong ? new Int(((BLong)bValue).getLong()) : (bValue instanceof BINumeric ? new Real(((BINumeric)bValue).getNumeric()) : (bValue instanceof BString ? new Str(((BString)bValue).getString()) : (bValue instanceof BOrd ? new Uri(((BOrd)bValue).toString()) : new Str(bValue.asSimple().encodeToString())))))));
            }
        } else if (bValue instanceof BIBoolean) {
            object = new Bool(((BIBoolean)bValue).getBoolean());
            if (bValue instanceof BStatusBoolean && ((BStatusBoolean)bValue).getStatus().isNull()) {
                object.setNull(true);
            }
        } else if (bValue instanceof BIEnum) {
            object = new Int((long)((BIEnum)bValue).getEnum().getOrdinal());
        } else if (bValue instanceof BINumeric) {
            object = new Real(((BINumeric)bValue).getNumeric());
        } else {
            BComplex bComplex = bValue.asComplex();
            object = new Str(bComplex.getName(), bComplex.toString());
        }
        return BinObixEncoder.toBytes(object);
    }

    public static String readStr(BinObixDecoder binObixDecoder) throws IOException {
        byte[] byArray = new byte[binObixDecoder.available()];
        int n = 0;
        while (n < byArray.length) {
            int n2 = binObixDecoder.read();
            if (n2 <= 0) break;
            byArray[n] = (byte)n2;
            ++n;
        }
        if (byArray[0] == 20) {
            return new String(byArray, 1, n - 1);
        }
        return new String(byArray, 0, n);
    }

    public static String statusCodeToString(int n) {
        String string = (String)statusCodeMap.get(n);
        if (string == null) {
            string = "sc=" + n;
        }
        return string;
    }

    public static final Iterator scMapIterator() {
        return statusCodeMap.iterator();
    }

    static {
        statusCodeMap.put(0, (Object)lex.getText("chopan.notRead"));
        statusCodeMap.put(1, (Object)lex.getText("chopan.decodingErr"));
        statusCodeMap.put(2, (Object)lex.getText("chopan.timeout"));
        statusCodeMap.put(64, (Object)lex.getText("chopan.ok"));
        statusCodeMap.put(128, (Object)lex.getText("chopan.badReq"));
        statusCodeMap.put(129, (Object)lex.getText("chopan.notAuth"));
        statusCodeMap.put(132, (Object)lex.getText("chopan.notFound"));
        statusCodeMap.put(160, (Object)lex.getText("chopan.serverErr"));
        statusCodeMap.put(161, (Object)lex.getText("chopan.notImpl"));
    }
}

