/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet.chopan;

import com.tridium.sedonanet.chopan.BNiagaraDiscoverPointsJob;
import com.tridium.sedonanet.chopan.ChopanWebReq;
import com.tridium.sedonanet.chopan.ObixUtil;
import com.tridium.sedonanet.driver.BSedonaBaseDevice;
import com.tridium.sedonanet.driver.BSedonaBaseNetwork;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Hashtable;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Array;
import javax.baja.util.ByteArrayUtil;
import sedona.web.ByteUtil;
import sedona.web.WebReq;
import sedona.web.WebRes;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BChopanServer
extends BComponent {
    public static final Property port = BChopanServer.newProperty((int)0, (int)1810, null);
    public static final Property enabled = BChopanServer.newProperty((int)0, (boolean)true, null);
    public static final Property debugOn = BChopanServer.newProperty((int)0, (boolean)false, null);
    public static final Property status = BChopanServer.newProperty((int)3, (BValue)BStatus.DEFAULT, null);
    public static final Property faultCause = BChopanServer.newProperty((int)3, (String)"", null);
    public static final Action submitNiagaraDiscoverPointsJob = BChopanServer.newAction((int)4, (BValue)BOrd.NULL, null);
    public static final Type TYPE;
    static BasicContext chopanContext;
    String XID;
    Thread serverThread;
    boolean alive;
    int oldStatus;
    String fault;
    Log log;
    DatagramSocket ds;
    Hashtable mmTickets;
    static /* synthetic */ Class class$com$tridium$sedonanet$chopan$BChopanServer;
    static /* synthetic */ Class class$javax$baja$sys$Slot;

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int n) {
        this.setInt(port, n, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public boolean getDebugOn() {
        return this.getBoolean(debugOn);
    }

    public void setDebugOn(boolean bl) {
        this.setBoolean(debugOn, bl, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BOrd submitNiagaraDiscoverPointsJob(BOrd bOrd) {
        return (BOrd)this.invoke(submitNiagaraDiscoverPointsJob, (BValue)bOrd, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.log = Log.getLog((String)("sedona-" + this.getNetwork().getName() + ".chopanSvr"));
        if (this.getEnabled()) {
            this.startServer();
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.getEnabled()) {
            this.stopServer();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)enabled)) {
            if (this.getEnabled()) {
                this.startServer();
            } else {
                this.stopServer();
            }
            this.updateStatus();
        } else if (property.equals((Object)port)) {
            if (this.getEnabled()) {
                this.stopServer();
                this.startServer();
            }
            this.updateStatus();
        }
    }

    void serverLoop() {
        try {
            this.ds = new DatagramSocket(this.getPort());
        }
        catch (Exception exception) {
            this.fault = "Cannot open port " + this.getPort() + ':' + exception;
            this.log.warning(this.fault);
            this.updateStatus();
            return;
        }
        this.fault = null;
        this.updateStatus();
        this.log.trace("CHoPAN Server opened on port " + this.getPort());
        ChopanWebReq chopanWebReq = new ChopanWebReq();
        WebRes webRes = new WebRes();
        while (this.alive) {
            try {
                Closeable closeable;
                byte[] byArray = new byte[500];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                this.ds.receive(datagramPacket);
                if (this.log.isTraceOn()) {
                    this.log.trace("Server:Received UDP request from " + datagramPacket.getAddress() + ':' + datagramPacket.getPort() + " [" + datagramPacket.getLength() + "] data len=" + datagramPacket.getData().length);
                    ByteUtil.hexDump((byte[])datagramPacket.getData(), (int)0, (int)datagramPacket.getLength());
                }
                try {
                    BChopanServer.clear(webRes);
                    closeable = new ByteArrayInputStream(datagramPacket.getData(), 0, datagramPacket.getLength());
                    chopanWebReq.readBinary((InputStream)closeable);
                    this.service(chopanWebReq, webRes, datagramPacket.getAddress().getHostAddress());
                }
                catch (Throwable throwable) {
                    if (this.alive) {
                        throwable.printStackTrace();
                    }
                    webRes.code = 400;
                    webRes.reason = throwable.toString();
                }
                closeable = new ByteArrayOutputStream();
                webRes.writeBinary((OutputStream)closeable);
                byte[] byArray2 = ((ByteArrayOutputStream)closeable).toByteArray();
                datagramPacket.setData(byArray2);
                datagramPacket.setLength(byArray2.length);
                if (this.log.isTraceOn()) {
                    this.log.trace("Server:Sending UDP response to " + datagramPacket.getAddress() + ':' + datagramPacket.getPort());
                    ByteUtil.hexDump((byte[])byArray2);
                }
                this.ds.send(datagramPacket);
            }
            catch (Exception exception) {
                if (this.alive) {
                    this.log.message("Exception in ChopanServer:", (Throwable)exception);
                }
                if (this.ds == null || this.ds.isClosed() || !this.ds.isBound()) break;
            }
        }
    }

    void service(ChopanWebReq chopanWebReq, WebRes webRes, String string) {
        try {
            BSedonaBaseDevice bSedonaBaseDevice = this.getNetwork().getDeviceByHostAddress(string);
            String string2 = chopanWebReq.get(this.XID);
            if (string2 != null) {
                webRes.set(this.XID, string2);
            }
            if (this.log.isTraceOn()) {
                this.log.trace("Received CHoPAN request from " + bSedonaBaseDevice + " [xid:" + string2 + ']');
                chopanWebReq.writeText(System.out);
            }
            if (bSedonaBaseDevice != null) {
                bSedonaBaseDevice.pingOk();
            }
            if (chopanWebReq.method == "GET") {
                this.doGet(chopanWebReq, webRes, bSedonaBaseDevice);
            } else if (chopanWebReq.method == "POST") {
                this.doPost(chopanWebReq, webRes);
            } else if (chopanWebReq.method == "PUT") {
                this.doPut(chopanWebReq, webRes);
            } else if (chopanWebReq.method == "TRACE" || chopanWebReq.method == "DELETE" || chopanWebReq.method == "HEAD" || chopanWebReq.method == "OPTIONS") {
                webRes.code = 501;
                webRes.reason = "Method not implemented";
            } else {
                webRes.code = 400;
                webRes.reason = "Unknown method:" + chopanWebReq.method;
            }
            if (this.log.isTraceOn()) {
                this.log.trace("Returning CHoPAN response:");
                webRes.writeText((OutputStream)System.out);
            }
        }
        catch (Throwable throwable) {
            if (this.alive) {
                this.log.message("Exception processing CHoPAN request:", throwable);
            }
            webRes.code = 500;
            webRes.reason = throwable.toString();
        }
    }

    BSedonaBaseNetwork getNetwork() {
        return (BSedonaBaseNetwork)this.getParent();
    }

    private final void doGet(ChopanWebReq chopanWebReq, WebRes webRes, BSedonaBaseDevice bSedonaBaseDevice) {
        try {
            if (chopanWebReq.uri.toLowerCase().startsWith("mm")) {
                this.checkMM(chopanWebReq, webRes, bSedonaBaseDevice);
                return;
            }
            if (chopanWebReq.uri.toLowerCase().startsWith("sp")) {
                this.checkSP(chopanWebReq, webRes, bSedonaBaseDevice);
                return;
            }
            if (this.parseReq(chopanWebReq, webRes, false)) {
                webRes.code = 200;
                webRes.reason = "OK";
                webRes.body = ObixUtil.encodeBinary(chopanWebReq.v);
            }
        }
        catch (Exception exception) {
            if (this.alive) {
                this.log.message("GET error: req=" + chopanWebReq.method + ' ' + chopanWebReq.uri);
                this.log.trace("", (Throwable)exception);
            }
            webRes.code = 400;
            webRes.reason = exception.toString();
        }
    }

    private final void doPut(ChopanWebReq chopanWebReq, WebRes webRes) {
        try {
            if (this.parseReq(chopanWebReq, webRes, false)) {
                BValue bValue = ObixUtil.decodeBinary(chopanWebReq.body, chopanWebReq.v);
                if (bValue.getType().is(BStatusValue.TYPE)) {
                    BStatusValue bStatusValue = (BStatusValue)bValue;
                    BStatusValue bStatusValue2 = (BStatusValue)chopanWebReq.o.asComplex().get(chopanWebReq.s.asProperty());
                    bStatusValue2.setValueValue(bStatusValue.getValueValue());
                    bStatusValue2.setStatusNull(bStatusValue.getStatus().isNull());
                } else {
                    chopanWebReq.o.asComplex().set(chopanWebReq.s.asProperty(), bValue, this.getChopanContext());
                }
                webRes.code = 200;
                webRes.reason = "OK";
                webRes.body = ObixUtil.encodeBinary(bValue);
            }
        }
        catch (PermissionException permissionException) {
            webRes.code = 401;
            webRes.reason = permissionException.toString();
        }
        catch (Exception exception) {
            if (this.alive) {
                this.log.message("PUT error: req=" + chopanWebReq.method + ' ' + chopanWebReq.uri + ' ' + ByteArrayUtil.toHexString((byte[])chopanWebReq.body));
                this.log.trace("", (Throwable)exception);
            }
            webRes.code = 400;
            webRes.reason = exception.toString();
        }
    }

    private final void doPost(ChopanWebReq chopanWebReq, WebRes webRes) {
        try {
            if (this.parseReq(chopanWebReq, webRes, true)) {
                BValue bValue = ObixUtil.decodeBinary(chopanWebReq.body, null);
                chopanWebReq.v = chopanWebReq.o.asComponent().invoke(chopanWebReq.s.asAction(), bValue, this.getChopanContext());
                webRes.code = 200;
                webRes.reason = "OK";
                if (chopanWebReq.v != null) {
                    webRes.body = ObixUtil.encodeBinary(chopanWebReq.v);
                }
            }
        }
        catch (PermissionException permissionException) {
            webRes.code = 401;
            webRes.reason = permissionException.toString();
        }
        catch (Exception exception) {
            if (this.alive) {
                this.log.message("POST error: req=" + chopanWebReq.method + ' ' + chopanWebReq.uri + ' ' + ByteArrayUtil.toHexString((byte[])chopanWebReq.body));
                this.log.trace("", (Throwable)exception);
            }
            webRes.code = 400;
            webRes.reason = exception.toString();
        }
    }

    public BOrd doSubmitNiagaraDiscoverPointsJob(BOrd bOrd, Context context) {
        if (!this.getEnabled()) {
            return null;
        }
        return new BNiagaraDiscoverPointsJob(bOrd).submit(context);
    }

    private final void updateStatus() {
        BStatus bStatus;
        int n = this.getStatus().getBits();
        BStatus bStatus2 = bStatus = this.getNetwork() == null ? BStatus.ok : this.getNetwork().getStatus();
        n = !this.getEnabled() || bStatus.isDisabled() ? (n |= 1) : (n &= 0xFFFFFFFE);
        n = bStatus.isDown() ? (n |= 4) : (n &= 0xFFFFFFFB);
        n = this.fault != null || bStatus.isFault() ? (n |= 2) : (n &= 0xFFFFFFFD);
        if (this.oldStatus == n) {
            return;
        }
        this.setStatus(BStatus.make((int)n));
        this.oldStatus = n;
        this.setFaultCause(this.fault == null ? "" : this.fault);
    }

    private final boolean checkLicense() {
        BSedonaBaseNetwork bSedonaBaseNetwork = (BSedonaBaseNetwork)this.getParent();
        Feature feature = bSedonaBaseNetwork.getLicenseFeature();
        if (feature != null) {
            return feature.getb("export", false);
        }
        return false;
    }

    private final void startServer() {
        if (!this.checkLicense()) {
            this.fault = "CHoPAN server capability not licensed";
            this.log.error(this.fault);
            this.updateStatus();
            return;
        }
        try {
            this.getChopanContext();
        }
        catch (Exception exception) {}
        this.alive = true;
        this.serverThread = new Thread(new Runnable(){

            public final void run() {
                BChopanServer.this.serverLoop();
            }
        }, this.getNetwork().getName() + ":ChopanSvr:" + this.getPort());
        this.serverThread.start();
    }

    private final void stopServer() {
        this.alive = false;
        if (this.serverThread != null) {
            this.serverThread.interrupt();
        }
        this.serverThread = null;
        if (this.ds != null) {
            this.ds.close();
        }
        this.ds = null;
    }

    private static final void clear(WebRes webRes) {
        webRes.version = "1.0";
        webRes.code = 200;
        webRes.reason = "-";
        webRes.body = null;
    }

    private final boolean parseReq(ChopanWebReq chopanWebReq, WebRes webRes, boolean bl) {
        boolean bl2 = false;
        if (this.getDebugOn() && this.log.isTraceOn()) {
            bl2 = true;
        }
        boolean bl3 = bl2;
        chopanWebReq.o = this.getObject(chopanWebReq.uri, bl3);
        if (bl3) {
            this.log.trace("o=" + chopanWebReq.o);
        }
        if (chopanWebReq.o == null) {
            webRes.code = 404;
            webRes.reason = chopanWebReq.uri + ":unknown object";
            return false;
        }
        if (!chopanWebReq.o.isComplex()) {
            webRes.code = 404;
            webRes.reason = chopanWebReq.uri + ":Object is not a BComplex";
            return false;
        }
        if (bl && !chopanWebReq.o.isComponent()) {
            webRes.code = 404;
            webRes.reason = chopanWebReq.uri + ":Object is not a BComponent";
            return false;
        }
        Array array = this.getSlot(chopanWebReq.o.asComplex(), chopanWebReq.uri);
        if (array.size() == 0) {
            webRes.code = 404;
            webRes.reason = chopanWebReq.uri + ":unknown slot";
            return false;
        }
        if (array.size() > 1) {
            webRes.code = 404;
            webRes.reason = chopanWebReq.uri + ":duplicate slot matches";
            return false;
        }
        chopanWebReq.s = (Slot)array.first();
        if (bl3) {
            this.log.trace("s=" + chopanWebReq.s);
        }
        if (bl) {
            if (!chopanWebReq.s.isAction()) {
                webRes.code = 404;
                webRes.reason = chopanWebReq.uri + ":Slot is not an Action";
                return false;
            }
            return true;
        }
        if (!chopanWebReq.s.isProperty()) {
            webRes.code = 404;
            webRes.reason = chopanWebReq.uri + ":Slot is not a Property";
            return false;
        }
        chopanWebReq.v = chopanWebReq.o.asComplex().get(chopanWebReq.s.asProperty());
        if (bl3) {
            this.log.trace("v=" + chopanWebReq.v);
        }
        if (chopanWebReq.v == null) {
            webRes.code = 404;
            webRes.reason = chopanWebReq.uri + ":Cannot get value";
            return false;
        }
        return true;
    }

    private final BObject getObject(String string, boolean bl) {
        int n = string.indexOf(".");
        if (n <= 0) {
            return null;
        }
        String string2 = string.substring(0, n);
        BOrd bOrd = BOrd.make((String)("h:" + string2));
        if (bl) {
            this.log.trace("hOrd=" + bOrd);
        }
        try {
            return bOrd.get((BObject)this);
        }
        catch (UnresolvedException unresolvedException) {
            return null;
        }
    }

    private final Array getSlot(BComplex bComplex, String string) {
        int n = string.indexOf(".");
        if (n <= 0) {
            return null;
        }
        String string2 = string.substring(n + 1);
        SlotCursor slotCursor = bComplex.getSlots();
        Class clazz = class$javax$baja$sys$Slot;
        if (clazz == null) {
            clazz = class$javax$baja$sys$Slot = BChopanServer.class("[Ljavax.baja.sys.Slot;", false);
        }
        Array array = new Array(clazz);
        while (slotCursor.next()) {
            if (slotCursor.slot().getName().equals(string2)) {
                array.clear();
                array.add((Object)slotCursor.slot());
                return array;
            }
            if (!slotCursor.slot().getName().startsWith(string2)) continue;
            array.add((Object)slotCursor.slot());
        }
        return array;
    }

    public Context getChopanContext() {
        if (chopanContext == null) {
            try {
                BUserService bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE);
                BUser bUser = bUserService.getUser("CHoPAN");
                if (bUser == null) {
                    bUser = (BUser)bUserService.get(bUserService.add("CHoPAN", (BValue)new BUser()));
                }
                if (!bUser.getEnabled()) {
                    throw new PermissionException("CHoPAN User not enabled");
                }
                chopanContext = new BasicContext(bUser);
            }
            catch (Exception exception) {
                this.log.error("Unable to retrieve CHoPAN user context!!", (Throwable)exception);
                throw new PermissionException("Error retrieving CHoPAN User context");
            }
        }
        return chopanContext;
    }

    private final void checkMM(WebReq webReq, WebRes webRes, BSedonaBaseDevice bSedonaBaseDevice) {
        block5: {
            try {
                webRes.code = 200;
                webRes.reason = "OK";
                if (bSedonaBaseDevice == null) {
                    webRes.body = ObixUtil.encodeBinary((BValue)BBoolean.FALSE);
                } else {
                    int n = 60;
                    byte[] byArray = webReq.body;
                    if (byArray != null && byArray.length > 0) {
                        n = ((BLong)ObixUtil.decodeBinary(byArray, (BValue)BLong.DEFAULT)).getInt();
                    }
                    boolean bl = this.checkMaintenanceMode(bSedonaBaseDevice);
                    this.setMMTimeout(bSedonaBaseDevice, bl, n);
                    webRes.body = ObixUtil.encodeBinary(bl);
                }
            }
            catch (Exception exception) {
                if (!this.alive || !this.log.isTraceOn()) break block5;
                this.log.trace("Exception processing maintenance mode check", (Throwable)exception);
            }
        }
    }

    private final void checkSP(ChopanWebReq chopanWebReq, WebRes webRes, BSedonaBaseDevice bSedonaBaseDevice) {
        block4: {
            try {
                webRes.code = 200;
                webRes.reason = "OK";
                if (bSedonaBaseDevice == null) {
                    this.log.message("Service pin rcvd for unknown device!");
                    webRes.body = ObixUtil.encodeBinary((BValue)BBoolean.FALSE);
                } else {
                    this.log.message("Service pin rcvd for " + bSedonaBaseDevice.getDisplayName(null));
                    webRes.body = ObixUtil.encodeBinary((BValue)BBoolean.TRUE);
                    this.getNetwork().fireServicePinReceived(bSedonaBaseDevice.getAddress());
                }
            }
            catch (Exception exception) {
                if (!this.alive || !this.log.isTraceOn()) break block4;
                this.log.trace("Exception processing service pin request", (Throwable)exception);
            }
        }
    }

    private final void setMMTimeout(BSedonaBaseDevice bSedonaBaseDevice, boolean bl, int n) {
        block5: {
            try {
                Property property = bSedonaBaseDevice.getProperty("maintenanceModeTimeout");
                Action action = bSedonaBaseDevice.getAction("clearMaintenanceMode");
                if (property != null) {
                    bSedonaBaseDevice.set(property, (BValue)BRelTime.makeSeconds((int)n));
                }
                if (bl && action != null) {
                    Clock.Ticket ticket = (Clock.Ticket)this.mmTickets.get(bSedonaBaseDevice);
                    if (ticket != null) {
                        ticket.cancel();
                    }
                    ticket = Clock.schedule((BComponent)bSedonaBaseDevice, (BRelTime)BRelTime.makeSeconds((int)n), (Action)action, null);
                    this.mmTickets.put(bSedonaBaseDevice, ticket);
                }
            }
            catch (Exception exception) {
                if (!this.alive || !this.log.isTraceOn()) break block5;
                this.log.trace("Exception setting maintenance mode timeout", (Throwable)exception);
            }
        }
    }

    private final boolean checkMaintenanceMode(BSedonaBaseDevice bSedonaBaseDevice) {
        try {
            boolean bl = false;
            Property property = bSedonaBaseDevice.getProperty("maintenanceModeRequested");
            Property property2 = bSedonaBaseDevice.getProperty("maintenanceModeActive");
            if (property != null) {
                bl = bSedonaBaseDevice.getBoolean(property);
                if (property2 != null) {
                    bSedonaBaseDevice.setBoolean(property2, bl);
                    bSedonaBaseDevice.setBoolean(property, false);
                }
            }
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.XID = "Transaction-Id";
        this.alive = false;
        this.oldStatus = BStatus.ok.getBits();
        this.fault = null;
        this.ds = null;
        this.mmTickets = new Hashtable();
    }

    public BChopanServer() {
        this.this();
    }

    public BChopanServer(boolean bl) {
        this.this();
        this.setEnabled(false);
    }

    static {
        Class clazz = class$com$tridium$sedonanet$chopan$BChopanServer;
        if (clazz == null) {
            clazz = class$com$tridium$sedonanet$chopan$BChopanServer = BChopanServer.class("[Lcom.tridium.sedonanet.chopan.BChopanServer;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

