/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonaProvisioning.tooltasks;

import com.tridium.nsedona.env.KitDb;
import com.tridium.nsedona.env.ManifestDb;
import com.tridium.nsedona.env.PlatformDb;
import com.tridium.sedonaProvisioning.ProvCx;
import com.tridium.sedonaProvisioning.ProvTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;
import sedona.KitPart;
import sedona.manifest.KitManifest;
import sedona.platform.PlatformManifest;
import sedona.sox.KitVersion;
import sedona.sox.SoxFile;
import sedona.sox.VersionInfo;
import sedona.util.Abstime;
import sedona.xml.XElem;
import sedona.xml.XWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Backup
implements ProvTask {
    public static final String MF_FNAME = "manifest.xml";
    public boolean doSvm;
    public boolean doRuntime;
    public boolean doKits;
    private BFileSpace fs;
    private FilePath zipPath;
    private File stage;
    private ProvCx cx;
    private Array entries;
    private PlatformManifest platformManifest;
    private String platformId;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$tridium$sedonaProvisioning$tooltasks$Backup;

    public String getSummary() {
        Class clazz = class$com$tridium$sedonaProvisioning$tooltasks$Backup;
        if (clazz == null) {
            clazz = class$com$tridium$sedonaProvisioning$tooltasks$Backup = Backup.class("[Lcom.tridium.sedonaProvisioning.tooltasks.Backup;", false);
        }
        Lexicon lexicon = Lexicon.make((Class)clazz);
        return lexicon.getText("backup.summary");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(ProvCx provCx) throws Exception {
        this.cx = provCx;
        provCx.log(this.getSummary());
        this.stage = new File(new File(System.getProperty("java.io.tmpdir")), "stage" + this.hashCode() + '-' + ((Object)((Object)provCx)).hashCode());
        if (!this.stage.mkdirs()) {
            throw new IOException("Could not create staging directory " + this.stage);
        }
        try {
            this.platformManifest = provCx.session().getPlatformManifest();
            if (this.platformManifest != null) {
                this.platformId = this.platformManifest.id;
            }
            this.backupSvm();
            this.backupRuntime();
            this.backupKits();
            this.backupPar();
            this.createManifest();
            this.zip();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            provCx.log("  Deleting stage directory: " + this.stage);
            FileUtil.delete((File)this.stage);
            throw throwable;
        }
        {
            Object var3_4 = null;
            provCx.log("  Deleting stage directory: " + this.stage);
        }
        FileUtil.delete((File)this.stage);
        provCx.log("");
    }

    private final void backupSvm() throws Exception {
        if (!this.doSvm) {
            return;
        }
        if (this.platformManifest == null) {
            throw new Exception("\nCannot backup svm. The platform is not in the platform database");
        }
        PlatformDb platformDb = this.cx.env().platformDb();
        String string = platformDb.getSvmUri(this.platformId);
        if (string == null) {
            throw new Exception("\nCould not determine svm uri for platform: " + this.platformId + "\nThe svm is probably not stored in the platform database.");
        }
        this.cx.log("  Backing up svm: " + string);
        this.cx.fileTransfer().getFile(string, SoxFile.make((File)new File(this.stage, string)));
        this.entries.add((Object)string);
    }

    private final void backupRuntime() throws Exception {
        if (!this.doRuntime) {
            return;
        }
        this.cx.log("  Backing up app.sab");
        this.cx.fileTransfer().getFile("app.sab", SoxFile.make((File)new File(this.stage, "app.sab")));
        this.cx.log("  Backing up kits.scode");
        this.cx.fileTransfer().getFile("kits.scode", SoxFile.make((File)new File(this.stage, "kits.scode")));
        this.entries.add((Object)"app.sab");
        this.entries.add((Object)"kits.scode");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void backupKits() throws Exception {
        if (!this.doKits) {
            return;
        }
        File file = new File(this.stage, "kits");
        File file2 = new File(this.stage, "manifests");
        file.mkdir();
        file2.mkdir();
        VersionInfo versionInfo = this.cx.session().getVersionInfo();
        KitVersion[] kitVersionArray = versionInfo.kits;
        KitDb kitDb = this.cx.env().kitDb();
        ManifestDb manifestDb = this.cx.env().manifestDb();
        int n = 0;
        while (true) {
            block12: {
                Object var15_13;
                if (n >= kitVersionArray.length) {
                    return;
                }
                KitVersion kitVersion = kitVersionArray[n];
                double d = (double)(n + 1) / (double)kitVersionArray.length * 100.0;
                this.cx.log("  Backing up " + kitVersion.name, d);
                File file3 = new File(file, KitDb.toKitFilename((KitVersion)kitVersion));
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                boolean bl = false;
                try {
                    bl = kitDb.extractKit(kitVersion.name, kitVersion.checksum, kitVersion.version, (OutputStream)fileOutputStream);
                }
                catch (Throwable throwable) {
                    var15_13 = null;
                    fileOutputStream.close();
                    throw throwable;
                }
                {
                    var15_13 = null;
                }
                fileOutputStream.close();
                if (bl) {
                    this.cx.log("    Backed up kit: " + file3.getName());
                    this.entries.add((Object)("kits/" + file3.getName()));
                } else {
                    Object var18_15;
                    this.cx.log("    " + file3.getName() + " is not in the kit database");
                    XWriter xWriter = null;
                    try {
                        KitPart kitPart = new KitPart(kitVersion.name, kitVersion.checksum, kitVersion.version);
                        KitManifest kitManifest = manifestDb.extractManifest(kitPart);
                        file3 = new File(file2, kitManifest.part().toString() + ".xml");
                        xWriter = new XWriter(file3);
                        kitManifest.encodeXml(xWriter);
                        this.entries.add((Object)("manifests/" + file3.getName()));
                        this.cx.log("    Backed up kit manifest: " + file3.getName());
                    }
                    catch (Throwable throwable) {
                        var18_15 = null;
                        if (xWriter != null) {
                            xWriter.close();
                        }
                        throw throwable;
                    }
                    {
                        var18_15 = null;
                        if (xWriter == null) break block12;
                    }
                    xWriter.close();
                }
            }
            ++n;
        }
    }

    private final void backupPar() throws Exception {
        if (!this.doKits) {
            return;
        }
        this.cx.log("  Backing up platform archive");
        if (this.platformManifest == null) {
            this.cx.log("    The platform is not in the platform database");
            return;
        }
        File file = new File(this.stage, "par");
        file.mkdirs();
        String string = this.platformId + ".par";
        File file2 = new File(file, string);
        try {
            this.cx.env().platformDb().extractPar(this.platformId, file2);
            this.entries.add((Object)("par/" + string));
            this.cx.log("    Backed up platform archive: " + this.platformId);
        }
        catch (Exception exception) {
            this.cx.log("  Could not backup platform archive: " + exception.getMessage());
            this.cx.log("  Platform archive will not be in the backup.");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void createManifest() throws Exception {
        if (this.platformManifest == null) {
            return;
        }
        File file = new File(this.stage, "meta-inf");
        file.mkdir();
        File file2 = new File(file, MF_FNAME);
        XWriter xWriter = new XWriter(file2);
        this.cx.log("Creating manifest [" + file2 + ']');
        try {
            xWriter.prolog();
            xWriter.w((Object)"<!-- Sedona backup manifest file -->\n");
            XElem xElem = new XElem("backupManifest");
            xElem.addAttr("backupTime", Abstime.now().encode());
            xElem.addAttr("platformId", this.platformId);
            xElem.write(xWriter);
            this.entries.add((Object)"meta-inf/manifest.xml");
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            xWriter.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        xWriter.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zip() throws Exception {
        BIFile bIFile = this.fs.makeFile(this.zipPath);
        ZipOutputStream zipOutputStream = new ZipOutputStream(bIFile.getOutputStream());
        InputStream inputStream = null;
        this.cx.log("  Creating backup " + bIFile.getAbsoluteOrd());
        try {
            try {
                String[] stringArray = (String[])this.entries.trim();
                int n = 0;
                while (n < stringArray.length) {
                    String string = stringArray[n];
                    this.cx.log("    Adding: " + string);
                    File file = new File(this.stage, string);
                    inputStream = new FileInputStream(file);
                    zipOutputStream.putNextEntry(new ZipEntry(string));
                    FileUtil.pipe((InputStream)inputStream, (OutputStream)zipOutputStream);
                    zipOutputStream.flush();
                    zipOutputStream.closeEntry();
                    inputStream.close();
                    ++n;
                }
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                zipOutputStream.close();
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            {
                Object var5_11 = null;
                zipOutputStream.close();
                if (inputStream == null) return;
                inputStream.close();
                return;
            }
        }
        catch (Exception exception) {
            this.fs.delete(this.zipPath);
            throw exception;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.doSvm = false;
        this.doRuntime = false;
        this.doKits = false;
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = Backup.class("[Ljava.lang.String;", false);
        }
        this.entries = new Array(clazz);
    }

    public Backup(BFileSpace bFileSpace, FilePath filePath) {
        this.this();
        this.fs = bFileSpace;
        this.zipPath = filePath;
    }
}

