/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jen6lp.messages;

import com.tridium.jen6lp.messages.JennicCoordMacAddrMsg;
import com.tridium.jen6lp.messages.JennicCoordNwkStatsMsg;
import com.tridium.jen6lp.messages.JennicCoordPanidErrorMsg;
import com.tridium.jen6lp.messages.JennicNeighborEntryMsg;
import com.tridium.jen6lp.messages.JennicRoutingEntryMsg;
import com.tridium.jen6lp.messages.JipErrorMsg;
import com.tridium.jen6lp.messages.PanNodeMsg;
import com.tridium.jen6lp.util.JenserInputStream;
import java.io.IOException;

public class JenserUnsCtrlMsg {
    int type;

    public int getType() {
        return this.type;
    }

    static String createHexStrZ(int n) {
        String string = Integer.toHexString(n);
        int n2 = 8 - string.length();
        int n3 = 0;
        while (n3 < n2) {
            string = "0" + string;
            ++n3;
        }
        return string;
    }

    public static JenserUnsCtrlMsg decode(byte[] byArray) throws IOException {
        JenserInputStream jenserInputStream = new JenserInputStream(byArray);
        int n = jenserInputStream.read();
        switch (n) {
            case 12: 
            case 13: {
                return PanNodeMsg.make(n, jenserInputStream);
            }
            case 10: {
                return JennicNeighborEntryMsg.make(n, jenserInputStream);
            }
            case 11: {
                return JennicRoutingEntryMsg.make(n, jenserInputStream);
            }
            case 7: 
            case 8: {
                return PanNodeMsg.make(n, jenserInputStream, true);
            }
            case 14: {
                return JennicCoordNwkStatsMsg.make(n, jenserInputStream);
            }
            case 15: {
                return JennicCoordPanidErrorMsg.make(n, jenserInputStream);
            }
            case 16: {
                return JennicCoordMacAddrMsg.make(n, jenserInputStream);
            }
            case 17: {
                return JipErrorMsg.make(n, jenserInputStream);
            }
        }
        throw new IllegalStateException("Unsupported unsol. control msg type rcvd " + n);
    }

    public JenserUnsCtrlMsg(int n) {
        this.type = n;
    }
}

