/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jen6lp;

import com.tridium.jen6lp.BAbstractPanInfoPoller;
import com.tridium.jen6lp.BIpv4Mac154Entry;
import com.tridium.jen6lp.BIpv4Mac154Table;
import com.tridium.jen6lp.BJennic154DeviceType;
import com.tridium.jen6lp.BMac154DeviceAddress;
import com.tridium.jen6lp.BPanInfoPoller;
import com.tridium.jen6lp.BSedonaJen6lpDevice;
import com.tridium.jen6lp.BSedonaJen6lpDeviceFolder;
import com.tridium.jen6lp.BSedonaJen6lpNeighborEntry;
import com.tridium.jen6lp.BSedonaJen6lpPingMonitor;
import com.tridium.jen6lp.messages.ControlDisassociateRequest;
import com.tridium.jen6lp.messages.ControlReadRequest;
import com.tridium.jen6lp.messages.ControlReadResponse;
import com.tridium.jen6lp.messages.ControlWriteRequest;
import com.tridium.jen6lp.messages.IJenserUnsCtrlMsgListener;
import com.tridium.jen6lp.messages.JennicCoordMacAddrMsg;
import com.tridium.jen6lp.messages.JennicMacNwkCheckRequest;
import com.tridium.jen6lp.messages.JennicMacNwkCheckResponse;
import com.tridium.jen6lp.messages.JennicNeighborEntryMsg;
import com.tridium.jen6lp.messages.JennicRoutingEntryMsg;
import com.tridium.jen6lp.messages.JenserControlMsg;
import com.tridium.jen6lp.messages.JenserUnsCtrlMsg;
import com.tridium.jen6lp.messages.PanNodeMsg;
import com.tridium.jen6lp.messages.ReadMemoryRequest;
import com.tridium.jen6lp.messages.ScanRfResponse;
import com.tridium.jen6lp.messages.WritePanidRequest;
import com.tridium.jen6lp.util.Mac154Address;
import com.tridium.nsedona.pan.BIPanNetwork;
import com.tridium.nsedona.pan.BPanLink;
import com.tridium.nsedona.pan.BPanNode;
import com.tridium.nsedona.pan.BSignalBars;
import com.tridium.nsedona.pan.IPanGraph;
import com.tridium.platJen6lp.BJen6lpAdapter;
import com.tridium.sedonanet.chopan.BChopanServer;
import com.tridium.sedonanet.driver.BSedonaAddress;
import com.tridium.sedonanet.driver.BSedonaBaseDevice;
import com.tridium.sedonanet.driver.BSedonaBaseNetwork;
import com.tridium.sedonanet.driver.BSedonaLearnDeviceEntry;
import com.tridium.sedonanet.driver.BSedonaLearnDevicesJob;
import com.tridium.sedonanet.driver.point.BSedonaTuningPolicy;
import com.tridium.sedonanet.driver.point.BSedonaTuningPolicyMap;
import com.tridium.util.ComponentTreeCursor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BSedonaJen6lpAbstractNetwork
extends BSedonaBaseNetwork
implements BIPanNetwork,
BIService {
    public static final Property monitor = BSedonaJen6lpAbstractNetwork.newProperty((int)0, (BValue)new BSedonaJen6lpPingMonitor(), null);
    public static final Property enabled = BSedonaJen6lpAbstractNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property tuningPolicies = BSedonaJen6lpAbstractNetwork.newProperty((int)0, (BValue)new BSedonaTuningPolicyMap(BSedonaTuningPolicy.makeChopan()), null);
    public static final Property chopanServer = BSedonaJen6lpAbstractNetwork.newProperty((int)0, (BValue)new BChopanServer(true), null);
    public static final Property adapterName = BSedonaJen6lpAbstractNetwork.newProperty((int)68, (String)"jenser1", null);
    public static final Property panid = BSedonaJen6lpAbstractNetwork.newProperty((int)0, (int)57082, (BFacets)BFacets.make((String)"radix", (int)16));
    public static final Property channel = BSedonaJen6lpAbstractNetwork.newProperty((int)0, (int)15, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)11), (String)"max", (BIDataValue)BInteger.make((int)26)));
    public static final Property diagLevel = BSedonaJen6lpAbstractNetwork.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"radix", (int)16));
    public static final Property radioPowerLevel = BSedonaJen6lpAbstractNetwork.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)-31, (int)0));
    public static final Property firmwareVersion = BSedonaJen6lpAbstractNetwork.newProperty((int)1, (String)"", null);
    public static final Property enableIpv4Mapping = BSedonaJen6lpAbstractNetwork.newProperty((int)0, (boolean)true, null);
    public static final Property addressMap = BSedonaJen6lpAbstractNetwork.newProperty((int)0, (BValue)new BIpv4Mac154Table(), null);
    public static final Property coordAddress = BSedonaJen6lpAbstractNetwork.newProperty((int)3, (BValue)BMac154DeviceAddress.make(0, 0), null);
    public static final Property panInfoLoadTime = BSedonaJen6lpAbstractNetwork.newProperty((int)67, (BValue)BAbsTime.DEFAULT, null);
    public static final Property childPanInfo = BSedonaJen6lpAbstractNetwork.newProperty((int)1, (BValue)new BComponent(), null);
    public static final Property paninfoPoller = BSedonaJen6lpAbstractNetwork.newProperty((int)0, (BValue)new BPanInfoPoller(), null);
    public static final Property networkSteadyStateTime = BSedonaJen6lpAbstractNetwork.newProperty((int)0, (BValue)BRelTime.make((long)60000L), null);
    public static final Property coordRcvTimeout = BSedonaJen6lpAbstractNetwork.newProperty((int)4, (BValue)BRelTime.makeSeconds((int)30), null);
    public static final Property ctrlMsgTimeout = BSedonaJen6lpAbstractNetwork.newProperty((int)4, (BValue)BRelTime.makeSeconds((int)1), null);
    public static final Property allowSleepingChildren = BSedonaJen6lpAbstractNetwork.newProperty((int)4, (boolean)true, null);
    public static final Action loadAllPanInfo = BSedonaJen6lpAbstractNetwork.newAction((int)16, null);
    public static final Action loadPanInfo = BSedonaJen6lpAbstractNetwork.newAction((int)0, null);
    public static final Action deleteAllPanInfo = BSedonaJen6lpAbstractNetwork.newAction((int)0, null);
    public static final Action deleteStalePanInfo = BSedonaJen6lpAbstractNetwork.newAction((int)0, null);
    public static final Action submitDeviceDiscoveryJob = BSedonaJen6lpAbstractNetwork.newAction((int)4, null);
    public static final Type TYPE;
    protected static final Log log;
    protected static final Log paninfoLog;
    private Hashtable unmatchedPanNodes;
    private Hashtable matchedPanNodes;
    private boolean initComplete;
    protected Thread unsCtrlThread;
    protected UnsCtrlHandler unsCtrlHandler;
    protected Thread coordKeepaliveThread;
    protected CoordKeepaliveHandler coordKeepaliveHandler;
    protected BJen6lpAdapter adapter;
    protected Array unsCtrlMsgListeners;
    long startupTicks;
    boolean atNetworkSteadyState;
    static /* synthetic */ Class class$com$tridium$jen6lp$BSedonaJen6lpAbstractNetwork;
    static /* synthetic */ Class class$com$tridium$jen6lp$BIpv4Mac154Entry;
    static /* synthetic */ Class class$com$tridium$jen6lp$BSedonaJen6lpDevice;
    static /* synthetic */ Class class$com$tridium$jen6lp$messages$IJenserUnsCtrlMsgListener;
    static /* synthetic */ Class class$com$tridium$sedonanet$driver$BSedonaBaseDevice;

    public String getAdapterName() {
        return this.getString(adapterName);
    }

    public void setAdapterName(String string) {
        this.setString(adapterName, string, null);
    }

    public int getPanid() {
        return this.getInt(panid);
    }

    public void setPanid(int n) {
        this.setInt(panid, n, null);
    }

    public int getChannel() {
        return this.getInt(channel);
    }

    public void setChannel(int n) {
        this.setInt(channel, n, null);
    }

    public int getDiagLevel() {
        return this.getInt(diagLevel);
    }

    public void setDiagLevel(int n) {
        this.setInt(diagLevel, n, null);
    }

    public int getRadioPowerLevel() {
        return this.getInt(radioPowerLevel);
    }

    public void setRadioPowerLevel(int n) {
        this.setInt(radioPowerLevel, n, null);
    }

    public String getFirmwareVersion() {
        return this.getString(firmwareVersion);
    }

    public void setFirmwareVersion(String string) {
        this.setString(firmwareVersion, string, null);
    }

    public boolean getEnableIpv4Mapping() {
        return this.getBoolean(enableIpv4Mapping);
    }

    public void setEnableIpv4Mapping(boolean bl) {
        this.setBoolean(enableIpv4Mapping, bl, null);
    }

    public BIpv4Mac154Table getAddressMap() {
        return (BIpv4Mac154Table)this.get(addressMap);
    }

    public void setAddressMap(BIpv4Mac154Table bIpv4Mac154Table) {
        this.set(addressMap, (BValue)bIpv4Mac154Table, null);
    }

    public BMac154DeviceAddress getCoordAddress() {
        return (BMac154DeviceAddress)this.get(coordAddress);
    }

    public void setCoordAddress(BMac154DeviceAddress bMac154DeviceAddress) {
        this.set(coordAddress, (BValue)bMac154DeviceAddress, null);
    }

    public BAbsTime getPanInfoLoadTime() {
        return (BAbsTime)this.get(panInfoLoadTime);
    }

    public void setPanInfoLoadTime(BAbsTime bAbsTime) {
        this.set(panInfoLoadTime, (BValue)bAbsTime, null);
    }

    public BComponent getChildPanInfo() {
        return (BComponent)this.get(childPanInfo);
    }

    public void setChildPanInfo(BComponent bComponent) {
        this.set(childPanInfo, (BValue)bComponent, null);
    }

    public BAbstractPanInfoPoller getPaninfoPoller() {
        return (BAbstractPanInfoPoller)this.get(paninfoPoller);
    }

    public void setPaninfoPoller(BAbstractPanInfoPoller bAbstractPanInfoPoller) {
        this.set(paninfoPoller, (BValue)bAbstractPanInfoPoller, null);
    }

    public BRelTime getNetworkSteadyStateTime() {
        return (BRelTime)this.get(networkSteadyStateTime);
    }

    public void setNetworkSteadyStateTime(BRelTime bRelTime) {
        this.set(networkSteadyStateTime, (BValue)bRelTime, null);
    }

    public BRelTime getCoordRcvTimeout() {
        return (BRelTime)this.get(coordRcvTimeout);
    }

    public void setCoordRcvTimeout(BRelTime bRelTime) {
        this.set(coordRcvTimeout, (BValue)bRelTime, null);
    }

    public BRelTime getCtrlMsgTimeout() {
        return (BRelTime)this.get(ctrlMsgTimeout);
    }

    public void setCtrlMsgTimeout(BRelTime bRelTime) {
        this.set(ctrlMsgTimeout, (BValue)bRelTime, null);
    }

    public boolean getAllowSleepingChildren() {
        return this.getBoolean(allowSleepingChildren);
    }

    public void setAllowSleepingChildren(boolean bl) {
        this.setBoolean(allowSleepingChildren, bl, null);
    }

    public void loadAllPanInfo() {
        this.invoke(loadAllPanInfo, null, null);
    }

    public void loadPanInfo() {
        this.invoke(loadPanInfo, null, null);
    }

    public void deleteAllPanInfo() {
        this.invoke(deleteAllPanInfo, null, null);
    }

    public void deleteStalePanInfo() {
        this.invoke(deleteStalePanInfo, null, null);
    }

    public BOrd submitDeviceDiscoveryJob() {
        return (BOrd)this.invoke(submitDeviceDiscoveryJob, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "jen6lp");
    }

    public void started() throws Exception {
        block5: {
            super.started();
            try {
                if (Sys.getService((Type)TYPE) != this) {
                    this.configFail("Duplicate BSedonaJen6lpAbstractNetwork");
                    throw new IllegalStateException("Only one BSedonaJen6lpAbstractNetwork allowed per station!");
                }
            }
            catch (ServiceNotFoundException serviceNotFoundException) {}
            try {
                this.init();
            }
            catch (Exception exception) {
                if (!this.getEnabled()) break block5;
                throw exception;
            }
        }
        this.startupTicks = Clock.ticks();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.cleanup();
    }

    public void changed(Property property, Context context) {
        block14: {
            super.changed(property, context);
            if (!this.isRunning()) {
                return;
            }
            if (property.equals((Object)enabled)) {
                try {
                    if (this.getEnabled()) {
                        if (!this.initComplete) {
                            this.init();
                        }
                        this.enableCoord();
                        break block14;
                    }
                    this.writeRestartCoord();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (property == diagLevel && this.getEnabled()) {
                try {
                    this.writeDiagLevel(this.getDiagLevel());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (property == coordRcvTimeout && this.getEnabled()) {
                try {
                    this.writeCoordRcvTimeout(this.getCoordRcvTimeout().getSeconds());
                    this.coordKeepaliveThread.interrupt();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public boolean atNetworkSteadyState() {
        if (!this.getEnabled()) {
            return false;
        }
        if (this.atNetworkSteadyState) {
            return true;
        }
        long l = this.getNetworkSteadyStateTime().getMillis();
        long l2 = Clock.ticks();
        if (l2 <= this.startupTicks + l) {
            return false;
        }
        this.atNetworkSteadyState = true;
        return true;
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (!this.isRunning()) {
            return;
        }
        BValue bValue = this.get(property);
        if (bValue instanceof BSedonaJen6lpDevice) {
            this.deviceAdded((BSedonaJen6lpDevice)bValue);
        }
    }

    void deviceAdded(BSedonaJen6lpDevice bSedonaJen6lpDevice) {
        BIpv4Mac154Entry bIpv4Mac154Entry;
        if (this.getEnableIpv4Mapping() && (bIpv4Mac154Entry = this.getAddressMap().getEntryByIpv4(bSedonaJen6lpDevice.getAddress().getIp())) != null) {
            bSedonaJen6lpDevice.setMacAddress(bIpv4Mac154Entry.getMac154());
        }
    }

    public Type getDeviceType() {
        return BSedonaJen6lpDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BSedonaJen6lpDeviceFolder.TYPE;
    }

    public boolean isDeviceDiscoverySupported() {
        return true;
    }

    public int getDeviceDiscoveryWaitTime() {
        return 0;
    }

    public BSedonaLearnDeviceEntry[] getDiscoveredDevices() throws Exception {
        BIpv4Mac154Table bIpv4Mac154Table = this.getAddressMap();
        Class clazz = class$com$tridium$jen6lp$BIpv4Mac154Entry;
        if (clazz == null) {
            clazz = class$com$tridium$jen6lp$BIpv4Mac154Entry = BSedonaJen6lpAbstractNetwork.class("[Lcom.tridium.jen6lp.BIpv4Mac154Entry;", false);
        }
        BIpv4Mac154Entry[] bIpv4Mac154EntryArray = (BIpv4Mac154Entry[])bIpv4Mac154Table.getChildren(clazz);
        Class clazz2 = class$com$tridium$jen6lp$BIpv4Mac154Entry;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$jen6lp$BIpv4Mac154Entry = BSedonaJen6lpAbstractNetwork.class("[Lcom.tridium.jen6lp.BIpv4Mac154Entry;", false);
        }
        Array array = new Array(clazz2);
        int n = 0;
        while (n < bIpv4Mac154EntryArray.length) {
            BIpv4Mac154Entry bIpv4Mac154Entry = bIpv4Mac154EntryArray[n];
            if (bIpv4Mac154Entry.getJoined()) {
                array.add((Object)bIpv4Mac154Entry);
            }
            ++n;
        }
        BSedonaLearnDeviceEntry[] bSedonaLearnDeviceEntryArray = new BSedonaLearnDeviceEntry[array.size()];
        int n2 = 0;
        while (n2 < bSedonaLearnDeviceEntryArray.length) {
            bSedonaLearnDeviceEntryArray[n2] = new BSedonaLearnDeviceEntry(new BSedonaAddress(((BIpv4Mac154Entry)((Object)array.get(n2))).getIpv4()));
            ++n2;
        }
        return bSedonaLearnDeviceEntryArray;
    }

    public void doDeleteAllPanInfo() {
        BComponent bComponent = this.getChildPanInfo();
        bComponent.removeAll();
        this.setPanInfoLoadTime(BAbsTime.NULL);
        BSedonaBaseDevice[] bSedonaBaseDeviceArray = this.getDeviceList();
        int n = 0;
        while (n < bSedonaBaseDeviceArray.length) {
            if (bSedonaBaseDeviceArray[n] instanceof BSedonaJen6lpDevice) {
                BSedonaJen6lpDevice bSedonaJen6lpDevice = (BSedonaJen6lpDevice)bSedonaBaseDeviceArray[n];
                bSedonaJen6lpDevice.doDeleteAllPanInfo();
            }
            ++n;
        }
    }

    public void doDeleteStalePanInfo() {
        Object object;
        BComponent bComponent = this.getChildPanInfo();
        Property[] propertyArray = bComponent.getPropertiesArray();
        int n = 0;
        while (n < propertyArray.length) {
            BValue bValue = bComponent.get(propertyArray[n]);
            if (bValue instanceof BSedonaJen6lpNeighborEntry && ((BSedonaJen6lpNeighborEntry)((Object)(object = (BSedonaJen6lpNeighborEntry)bValue))).getStale()) {
                bComponent.remove((BComplex)object);
            }
            ++n;
        }
        BSedonaBaseDevice[] bSedonaBaseDeviceArray = this.getDeviceList();
        int n2 = 0;
        while (n2 < bSedonaBaseDeviceArray.length) {
            if (bSedonaBaseDeviceArray[n2] instanceof BSedonaJen6lpDevice) {
                object = (BSedonaJen6lpDevice)bSedonaBaseDeviceArray[n2];
                ((BSedonaJen6lpDevice)((Object)object)).doDeleteStalePanInfo();
            }
            ++n2;
        }
    }

    public void doLoadAllPanInfo() {
        this.postAsync(new Runnable(){

            public final void run() {
                BSedonaJen6lpAbstractNetwork.this.doLoadPanInfo();
                BSedonaBaseDevice[] bSedonaBaseDeviceArray = BSedonaJen6lpAbstractNetwork.this.getDeviceList();
                int n = 0;
                while (n < bSedonaBaseDeviceArray.length) {
                    if (bSedonaBaseDeviceArray[n] instanceof BSedonaJen6lpDevice) {
                        BSedonaJen6lpDevice bSedonaJen6lpDevice = (BSedonaJen6lpDevice)bSedonaBaseDeviceArray[n];
                        bSedonaJen6lpDevice.setPanInfoLoaded(false);
                        bSedonaJen6lpDevice.doLoadPanInfoSync();
                    }
                    ++n;
                }
            }
        });
    }

    public void doLoadPanInfo() {
        Object object;
        Object object2;
        BComponent bComponent = this.getChildPanInfo();
        SlotCursor slotCursor = bComponent.loadSlots().getProperties();
        while (slotCursor.next()) {
            object2 = slotCursor.get();
            if (object2.getType() != BSedonaJen6lpNeighborEntry.TYPE) continue;
            object = (Object)((BSedonaJen6lpNeighborEntry)((Object)object2));
            ((BSedonaJen6lpNeighborEntry)((Object)object)).setStale(true);
        }
        try {
            object2 = new ControlReadRequest(7);
            object = ((JenserControlMsg)object2).encode();
            this.adapter.sendRcvControlMsg((byte[])object, (int)this.getCtrlMsgTimeout().getMillis());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public BOrd doSubmitDeviceDiscoveryJob(Context context) {
        if (this.isFatalFault()) {
            return null;
        }
        return new BSedonaLearnDevicesJob(null, null, (BSedonaBaseNetwork)this).submit(context);
    }

    /*
     * Unable to fully structure code
     */
    public BSedonaJen6lpDevice[] get6lpDeviceList() {
        v0 = BSedonaJen6lpAbstractNetwork.class$com$tridium$jen6lp$BSedonaJen6lpDevice;
        if (v0 == null) {
            v0 = BSedonaJen6lpAbstractNetwork.class$com$tridium$jen6lp$BSedonaJen6lpDevice = BSedonaJen6lpAbstractNetwork.class("[Lcom.tridium.jen6lp.BSedonaJen6lpDevice;", false);
        }
        var1_1 = new Array(v0);
        var2_2 = new ComponentTreeCursor((BComponent)this, null);
        if (true) ** GOTO lbl10
        do {
            var1_1.add((Object)((BSedonaJen6lpDevice)var2_2.get()));
lbl10:
            // 2 sources

            if ((v1 = BSedonaJen6lpAbstractNetwork.class$com$tridium$jen6lp$BSedonaJen6lpDevice) != null) continue;
            v1 = BSedonaJen6lpAbstractNetwork.class("[Lcom.tridium.jen6lp.BSedonaJen6lpDevice;", false);
        } while (var2_2.next(v1));
        return (BSedonaJen6lpDevice[])var1_1.trim();
    }

    private final void init() throws Exception {
        if (this.initComplete) {
            return;
        }
        Class clazz = class$com$tridium$jen6lp$messages$IJenserUnsCtrlMsgListener;
        if (clazz == null) {
            clazz = class$com$tridium$jen6lp$messages$IJenserUnsCtrlMsgListener = BSedonaJen6lpAbstractNetwork.class("[Lcom.tridium.jen6lp.messages.IJenserUnsCtrlMsgListener;", false);
        }
        this.unsCtrlMsgListeners = new Array(clazz);
        this.unsCtrlHandler = new UnsCtrlHandler();
        this.unsCtrlThread = new Thread((Runnable)this.unsCtrlHandler, "jen6lp-UnsRcv");
        this.coordKeepaliveHandler = new CoordKeepaliveHandler();
        this.coordKeepaliveThread = new Thread((Runnable)this.coordKeepaliveHandler, "jen6lp-coordKeepalive");
        this.adapter = this.openAdapter(this.getAdapterName());
        this.setFirmwareVersion(this.readVersion());
        this.unsCtrlThread.start();
        this.coordKeepaliveThread.start();
        if (this.getEnableIpv4Mapping()) {
            BIpv4Mac154Table bIpv4Mac154Table = this.getAddressMap();
            bIpv4Mac154Table.init(this, log);
        }
        this.initComplete = true;
    }

    protected abstract BJen6lpAdapter openAdapter(String var1) throws Exception;

    private final void cleanup() throws Exception {
        if (this.unsCtrlHandler != null) {
            this.unsCtrlHandler.setAlive(false);
            this.unsCtrlThread.interrupt();
            this.unsCtrlHandler = null;
            this.unsCtrlThread = null;
        }
        if (this.coordKeepaliveHandler != null) {
            this.coordKeepaliveHandler.setAlive(false);
            this.coordKeepaliveThread.interrupt();
            this.coordKeepaliveHandler = null;
            this.coordKeepaliveThread = null;
        }
        if (this.adapter != null) {
            this.adapter.close();
        }
        this.adapter = null;
        this.initComplete = false;
    }

    /*
     * Unable to fully structure code
     */
    protected final BSedonaJen6lpDevice getDeviceByIpv4Address(String var1_1) {
        v0 = BSedonaJen6lpAbstractNetwork.class$com$tridium$sedonanet$driver$BSedonaBaseDevice;
        if (v0 == null) {
            v0 = BSedonaJen6lpAbstractNetwork.class$com$tridium$sedonanet$driver$BSedonaBaseDevice = BSedonaJen6lpAbstractNetwork.class("[Lcom.tridium.sedonanet.driver.BSedonaBaseDevice;", false);
        }
        var2_2 = new Array(v0);
        var3_3 = new ComponentTreeCursor((BComponent)this, null);
        if (true) ** GOTO lbl13
        do {
            var4_4 = (BSedonaJen6lpDevice)var3_3.get();
            var4_4.lease();
            if (var4_4.getAddress().getIp().equals(var1_1)) {
                var2_2.add((Object)var4_4);
            }
lbl13:
            // 4 sources

            if ((v1 = BSedonaJen6lpAbstractNetwork.class$com$tridium$jen6lp$BSedonaJen6lpDevice) != null) continue;
            v1 = BSedonaJen6lpAbstractNetwork.class("[Lcom.tridium.jen6lp.BSedonaJen6lpDevice;", false);
        } while (var3_3.next(v1));
        if (var2_2.size() != 1) {
            return null;
        }
        return (BSedonaJen6lpDevice)var2_2.first();
    }

    public BSedonaJen6lpDevice getDeviceByMac154(BMac154DeviceAddress bMac154DeviceAddress) {
        this.getAddressMap().lease(2);
        BIpv4Mac154Entry bIpv4Mac154Entry = this.getAddressMap().getEntryByMac154(bMac154DeviceAddress);
        if (bIpv4Mac154Entry == null) {
            return null;
        }
        return this.getDeviceByIpv4Address(bIpv4Mac154Entry.getIpv4());
    }

    public void updateAdapterIpv4ToMac154Table() {
        this.adapter.updateIpv4ToMac154Table(this.getAddressMap().toTableString());
    }

    public void disassociateDevice(Mac154Address mac154Address) throws IOException {
        ControlDisassociateRequest controlDisassociateRequest = new ControlDisassociateRequest(mac154Address);
        this.adapter.sendRcvControlMsg(controlDisassociateRequest.encode(), (int)this.getCtrlMsgTimeout().getMillis());
    }

    public int scanRf() throws IOException {
        JenserControlMsg jenserControlMsg = new JenserControlMsg(6);
        byte[] byArray = this.adapter.sendRcvControlMsg(jenserControlMsg.encode(), (int)this.getCtrlMsgTimeout().getMillis());
        ScanRfResponse scanRfResponse = (ScanRfResponse)JenserControlMsg.decode(byArray);
        return scanRfResponse.getChannel();
    }

    public abstract void enableCoord() throws IOException;

    public void restartCoord() throws IOException {
        try {
            this.writeRestartCoord();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void programCoord() throws IOException {
        try {
            this.writeProgramCoord();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void requestPanDevices() throws IOException {
        ControlReadRequest controlReadRequest = new ControlReadRequest(3);
        byte[] byArray = controlReadRequest.encode();
        this.adapter.sendRcvControlMsg(byArray, (int)this.getCtrlMsgTimeout().getMillis());
    }

    public void requestPanDevicesToClear() throws IOException {
        ControlReadRequest controlReadRequest = new ControlReadRequest(8);
        byte[] byArray = controlReadRequest.encode();
        this.adapter.sendRcvControlMsg(byArray, (int)this.getCtrlMsgTimeout().getMillis());
    }

    public void requestCoordNwkStats() throws IOException {
        ControlReadRequest controlReadRequest = new ControlReadRequest(15);
        byte[] byArray = controlReadRequest.encode();
        this.adapter.sendRcvControlMsg(byArray, (int)this.getCtrlMsgTimeout().getMillis());
    }

    public boolean isMacInNetwork(BMac154DeviceAddress bMac154DeviceAddress) throws IOException {
        JennicMacNwkCheckRequest jennicMacNwkCheckRequest = new JennicMacNwkCheckRequest(bMac154DeviceAddress);
        byte[] byArray = jennicMacNwkCheckRequest.encode();
        byte[] byArray2 = this.adapter.sendRcvControlMsg(byArray, (int)this.getCtrlMsgTimeout().getMillis());
        if (byArray2 == null) {
            log.warning("isMacInNetwork null response " + this.getName());
            return false;
        }
        JennicMacNwkCheckResponse jennicMacNwkCheckResponse = (JennicMacNwkCheckResponse)JenserControlMsg.decode(byArray2);
        return jennicMacNwkCheckResponse.isOk();
    }

    public int readPanid() throws IOException {
        ControlReadRequest controlReadRequest = new ControlReadRequest(2);
        byte[] byArray = this.adapter.sendRcvControlMsg(controlReadRequest.encode(), (int)this.getCtrlMsgTimeout().getMillis());
        ControlReadResponse controlReadResponse = (ControlReadResponse)JenserControlMsg.decode(byArray);
        byte[] byArray2 = controlReadResponse.getData();
        int n = (byArray2[0] << 8 | byArray2[1] & 0xFF) & (char)-1;
        return n;
    }

    public byte[] readMemory(int n, int n2) throws IOException {
        ReadMemoryRequest readMemoryRequest = new ReadMemoryRequest(n, n2);
        byte[] byArray = this.adapter.sendRcvControlMsg(readMemoryRequest.encode(), (int)this.getCtrlMsgTimeout().getMillis());
        ControlReadResponse controlReadResponse = (ControlReadResponse)JenserControlMsg.decode(byArray);
        return controlReadResponse.getData();
    }

    protected void writePanid(int n) throws IOException {
        WritePanidRequest writePanidRequest = new WritePanidRequest(n);
        this.adapter.sendRcvControlMsg(writePanidRequest.encode(), (int)this.getCtrlMsgTimeout().getMillis());
    }

    public int readDiagLevel() throws IOException {
        ControlReadRequest controlReadRequest = new ControlReadRequest(4);
        byte[] byArray = this.adapter.sendRcvControlMsg(controlReadRequest.encode(), (int)this.getCtrlMsgTimeout().getMillis());
        ControlReadResponse controlReadResponse = (ControlReadResponse)JenserControlMsg.decode(byArray);
        byte[] byArray2 = controlReadResponse.getData();
        int n = byArray2[0] << 24 | byArray2[1] << 16 | byArray2[2] << 8 | byArray2[3];
        return n;
    }

    protected void writeDiagLevel(int n) throws IOException {
        ControlWriteRequest controlWriteRequest = ControlWriteRequest.makeInt32(4, n);
        this.adapter.sendRcvControlMsg(controlWriteRequest.encode(), (int)this.getCtrlMsgTimeout().getMillis());
    }

    protected void writeCoordRcvTimeout(int n) throws IOException {
        ControlWriteRequest controlWriteRequest = ControlWriteRequest.makeInt32(17, n);
        this.adapter.sendRcvControlMsg(controlWriteRequest.encode(), (int)this.getCtrlMsgTimeout().getMillis());
    }

    protected void writeAllowSleepingChildren(boolean bl) throws IOException {
        ControlWriteRequest controlWriteRequest = bl ? ControlWriteRequest.makeByte(18, 1) : ControlWriteRequest.makeByte(18, 0);
        this.adapter.sendRcvControlMsg(controlWriteRequest.encode(), (int)this.getCtrlMsgTimeout().getMillis());
    }

    public int readChannel() throws IOException {
        return this.readByteProperty(1);
    }

    protected void writeChannel(int n) throws IOException {
        ControlWriteRequest controlWriteRequest = ControlWriteRequest.makeByte(1, n);
        this.adapter.sendRcvControlMsg(controlWriteRequest.encode(), (int)this.getCtrlMsgTimeout().getMillis());
    }

    public byte[] readBeaconPayload() {
        throw new UnsupportedOperationException("Reading beacon payload not yet implemented");
    }

    protected void writeBeaconPayload(byte[] byArray) throws IOException {
        this.adapter.sendRcvControlMsg(new ControlWriteRequest(5, byArray).encode(), (int)this.getCtrlMsgTimeout().getMillis());
    }

    public int readRadioPowerLevel() throws IOException {
        return this.readByteProperty(13);
    }

    protected void writeRadioPowerLevel(int n) throws IOException {
        this.adapter.sendRcvControlMsg(ControlWriteRequest.makeByte(13, n).encode(), (int)this.getCtrlMsgTimeout().getMillis());
    }

    protected void writeChannelPanid(int n, int n2) throws IOException {
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[1];
        byArray[0] = (byte)(n2 >> 8 & 0xFF);
        byArray[1] = (byte)(n2 & 0xFF);
        byArray2[0] = (byte)(n & 0xFF);
        ControlWriteRequest controlWriteRequest = new ControlWriteRequest(2, byArray);
        byte[] byArray3 = controlWriteRequest.encode();
        this.adapter.sendRcvControlMsg(byArray3, (int)this.getCtrlMsgTimeout().getMillis());
        controlWriteRequest = new ControlWriteRequest(1, byArray2);
        byArray3 = controlWriteRequest.encode();
        this.adapter.sendRcvControlMsg(byArray3, (int)this.getCtrlMsgTimeout().getMillis());
    }

    protected void writeEnable() throws IOException {
        JenserControlMsg jenserControlMsg = new JenserControlMsg(3);
        byte[] byArray = jenserControlMsg.encode();
        this.adapter.sendRcvControlMsg(byArray, (int)this.getCtrlMsgTimeout().getMillis());
    }

    protected void writeRestartCoord() throws IOException {
        JenserControlMsg jenserControlMsg = new JenserControlMsg(4);
        byte[] byArray = jenserControlMsg.encode();
        this.adapter.sendRcvControlMsg(byArray, 0);
    }

    protected void writeProgramCoord() throws IOException {
        JenserControlMsg jenserControlMsg = new JenserControlMsg(9);
        byte[] byArray = jenserControlMsg.encode();
        this.adapter.sendRcvControlMsg(byArray, 0);
    }

    protected int readByteProperty(int n) throws IOException {
        ControlReadRequest controlReadRequest = new ControlReadRequest(n);
        byte[] byArray = controlReadRequest.encode();
        byte[] byArray2 = this.adapter.sendRcvControlMsg(byArray, (int)this.getCtrlMsgTimeout().getMillis());
        ControlReadResponse controlReadResponse = (ControlReadResponse)JenserControlMsg.decode(byArray2);
        return controlReadResponse.getData()[0];
    }

    protected String readVersion() throws IOException {
        ControlReadRequest controlReadRequest = new ControlReadRequest(6);
        byte[] byArray = controlReadRequest.encode();
        byte[] byArray2 = this.adapter.sendRcvControlMsg(byArray, (int)this.getCtrlMsgTimeout().getMillis());
        ControlReadResponse controlReadResponse = (ControlReadResponse)JenserControlMsg.decode(byArray2);
        byte[] byArray3 = controlReadResponse.getData();
        String string = new String(byArray3);
        return string;
    }

    public void registerUnsolictedCtrlMsgListener(IJenserUnsCtrlMsgListener iJenserUnsCtrlMsgListener) {
        if (!this.unsCtrlMsgListeners.contains((Object)iJenserUnsCtrlMsgListener)) {
            this.unsCtrlMsgListeners.add((Object)iJenserUnsCtrlMsgListener);
        }
    }

    public void unregisterUnsolicitedCtrlMsgListener(IJenserUnsCtrlMsgListener iJenserUnsCtrlMsgListener) {
        this.unsCtrlMsgListeners.remove((Object)iJenserUnsCtrlMsgListener);
    }

    protected void nodeJoined(PanNodeMsg panNodeMsg) {
        if (this.getEnableIpv4Mapping()) {
            BIpv4Mac154Table bIpv4Mac154Table = this.getAddressMap();
            BIpv4Mac154Entry bIpv4Mac154Entry = bIpv4Mac154Table.nodeJoined(panNodeMsg.getMac154());
            String string = bIpv4Mac154Entry.getIpv4();
            BSedonaJen6lpDevice bSedonaJen6lpDevice = this.getDeviceByIpv4Address(string);
            if (bSedonaJen6lpDevice != null) {
                bSedonaJen6lpDevice.setNodeJoined(true);
                bSedonaJen6lpDevice.setNodeJoinedTime(BAbsTime.now());
                bSedonaJen6lpDevice.setMacAddress(panNodeMsg.getMac154());
                bSedonaJen6lpDevice.pingOk();
            } else {
                log.message("Unknown IPv4 device joined network: " + (Object)((Object)bIpv4Mac154Entry));
            }
            this.adapter.updateIpv4ToMac154Table(bIpv4Mac154Table.toTableString());
        }
    }

    protected void nodeLeft(PanNodeMsg panNodeMsg) {
        if (this.getEnableIpv4Mapping()) {
            BIpv4Mac154Table bIpv4Mac154Table = this.getAddressMap();
            BIpv4Mac154Entry bIpv4Mac154Entry = bIpv4Mac154Table.getEntryByMac154(panNodeMsg.getMac154());
            if (bIpv4Mac154Entry == null) {
                log.message("Unmapped IPv4 device left network:" + (Object)((Object)panNodeMsg.getMac154()));
            } else {
                bIpv4Mac154Entry.setJoined(false);
                String string = bIpv4Mac154Entry.getIpv4();
                BSedonaJen6lpDevice bSedonaJen6lpDevice = this.getDeviceByIpv4Address(string);
                if (bSedonaJen6lpDevice != null) {
                    bSedonaJen6lpDevice.ping();
                    bSedonaJen6lpDevice.setNodeJoined(false);
                    bSedonaJen6lpDevice.setNodeLeftTime(BAbsTime.now());
                    log.message("Device " + bSedonaJen6lpDevice.getDisplayName(null) + " left network: " + (Object)((Object)bIpv4Mac154Entry.getMac154()));
                } else {
                    log.message("Unknown IPv4 device left network: " + (Object)((Object)bIpv4Mac154Entry));
                }
            }
        }
    }

    private final void recvNbrNodeInfo(JennicNeighborEntryMsg jennicNeighborEntryMsg) {
        this.setPanInfoLoadTime(Clock.time((int)1000));
        BMac154DeviceAddress bMac154DeviceAddress = jennicNeighborEntryMsg.getSAddr();
        BSedonaJen6lpNeighborEntry bSedonaJen6lpNeighborEntry = BSedonaJen6lpNeighborEntry.make(jennicNeighborEntryMsg);
        BComponent bComponent = this.getChildPanInfo();
        Property property = bComponent.getProperty(bMac154DeviceAddress.toOrdString());
        if (property == null) {
            bComponent.add(bMac154DeviceAddress.toOrdString(), (BValue)bSedonaJen6lpNeighborEntry, 1);
        } else {
            ((BSedonaJen6lpNeighborEntry)bComponent.get(bMac154DeviceAddress.toOrdString())).copyFrom((BComplex)bSedonaJen6lpNeighborEntry);
        }
    }

    private final void clearPanNodes() {
        this.unmatchedPanNodes.clear();
        this.matchedPanNodes.clear();
    }

    private final BPanNode findPanNode(BMac154DeviceAddress bMac154DeviceAddress) {
        BPanNode bPanNode = (BPanNode)this.matchedPanNodes.get((Object)bMac154DeviceAddress);
        if (bPanNode != null) {
            return bPanNode;
        }
        bPanNode = (BPanNode)this.unmatchedPanNodes.get((Object)bMac154DeviceAddress);
        if (bPanNode == null) {
            bPanNode = new BPanNode(bMac154DeviceAddress.toString());
            bPanNode.setIcon(BIcon.std((String)"questionMark.png"));
            this.unmatchedPanNodes.put(bMac154DeviceAddress, bPanNode);
        }
        return bPanNode;
    }

    public void loadPanGraph(IPanGraph iPanGraph) {
        BPanLink bPanLink;
        Object object;
        BSedonaJen6lpNeighborEntry bSedonaJen6lpNeighborEntry;
        Object object2;
        BSedonaJen6lpDevice bSedonaJen6lpDevice;
        BAbsTime bAbsTime;
        BAbsTime bAbsTime2 = bAbsTime = BAbsTime.now();
        this.clearPanNodes();
        this.lease();
        BPanNode bPanNode = new BPanNode("coordinator", this.getCoordAddress().toString());
        iPanGraph.setPanRoot(bPanNode);
        try {
            this.loadPanInfo();
            this.getPanInfoLog().trace("Reading Coordinator neighbor info...");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.getPanInfoLog().message("Error sending request for coordinator neighbor info!");
        }
        BDevice[] bDeviceArray = this.getDevices();
        int n = 0;
        while (n < bDeviceArray.length) {
            if (bDeviceArray[n] instanceof BSedonaJen6lpDevice) {
                bSedonaJen6lpDevice = (BSedonaJen6lpDevice)bDeviceArray[n];
                bSedonaJen6lpDevice.lease();
                object2 = new BPanNode(bSedonaJen6lpDevice.getDisplayName(null), bSedonaJen6lpDevice.getMacAddress().toString());
                object2.setStatus(bSedonaJen6lpDevice.getStatus());
                object2.setFaultCause(bSedonaJen6lpDevice.getFaultCause());
                this.matchedPanNodes.put(bSedonaJen6lpDevice.getMacAddress(), object2);
                if (bSedonaJen6lpDevice.getDeviceType().equals((Object)BJennic154DeviceType.endDevice)) {
                    object2.setIcon(BIcon.make((String)"module://pansheet/icons/endDevice.png"));
                } else if (bSedonaJen6lpDevice.getDeviceType().equals((Object)BJennic154DeviceType.router)) {
                    object2.setIcon(BIcon.make((String)"module://pansheet/icons/router.png"));
                } else {
                    object2.setIcon(BIcon.std((String)"questionMark.png"));
                }
                iPanGraph.addPanNode((BPanNode)object2);
            }
            ++n;
        }
        try {
            n = 0;
            while (n < bDeviceArray.length) {
                try {
                    bAbsTime = BAbsTime.now();
                    if (bDeviceArray[n] instanceof BSedonaJen6lpDevice) {
                        this.getPanInfoLog().trace("Reading paninfo for [" + n + "]:" + bDeviceArray[n].getDisplayName(null));
                        bSedonaJen6lpDevice = (BSedonaJen6lpDevice)bDeviceArray[n];
                        if (!bSedonaJen6lpDevice.getStatus().isValid()) {
                            this.getPanInfoLog().trace(bSedonaJen6lpDevice.getDisplayName(null) + " has invalid status, skipping");
                        } else {
                            if (!bSedonaJen6lpDevice.getPanInfoLoaded()) {
                                this.getPanInfoLog().trace(" paninfo not yet loaded for " + bSedonaJen6lpDevice.getDisplayName(null) + ", loading synchronously...");
                                bSedonaJen6lpDevice.loadPanInfoSync();
                                bSedonaJen6lpDevice.getComponentSpace().sync();
                            }
                            if (!bSedonaJen6lpDevice.getPanInfoLoaded()) {
                                this.getPanInfoLog().trace(" paninfo not yet loaded for " + bSedonaJen6lpDevice.getDisplayName(null) + ", skipping.");
                            } else {
                                object2 = bSedonaJen6lpDevice.getParentPanInfo();
                                object2.lease();
                                if (((BSedonaJen6lpNeighborEntry)((Object)object2)).getStale()) {
                                    this.getPanInfoLog().trace(" stale parentInfo for" + bSedonaJen6lpDevice.getDisplayName(null) + ", skipping");
                                } else {
                                    bSedonaJen6lpNeighborEntry = new BPanLink(((BSedonaJen6lpNeighborEntry)((Object)object2)).getLinkQuality(), ((BSedonaJen6lpNeighborEntry)((Object)object2)).getPacketsSent(), ((BSedonaJen6lpNeighborEntry)((Object)object2)).getPacketsLost());
                                    object = ((BSedonaJen6lpNeighborEntry)((Object)object2)).getMac154();
                                    bPanLink = object.equals((Object)this.getCoordAddress()) ? bPanNode : this.findPanNode((BMac154DeviceAddress)((Object)object));
                                    iPanGraph.addLink(this.findPanNode(bSedonaJen6lpDevice.getMacAddress()), (BPanNode)bPanLink, (BPanLink)bSedonaJen6lpNeighborEntry);
                                    this.getPanInfoLog().trace("  adding node-to-parent link from " + bSedonaJen6lpDevice.getDisplayName(null) + " to " + bPanLink + ':' + (Object)((Object)bSedonaJen6lpNeighborEntry) + " parentInfo " + object2);
                                }
                                bSedonaJen6lpNeighborEntry = bSedonaJen6lpDevice.getChildPanInfo();
                                bSedonaJen6lpNeighborEntry.lease(1);
                                bSedonaJen6lpNeighborEntry.getComponentSpace().sync();
                                object = bSedonaJen6lpNeighborEntry.loadSlots().getProperties();
                                this.getPanInfoLog().trace("  reading child info");
                                while (object.next()) {
                                    bPanLink = object.get();
                                    if (bPanLink.getType() != BSedonaJen6lpNeighborEntry.TYPE) continue;
                                    BSedonaJen6lpNeighborEntry bSedonaJen6lpNeighborEntry2 = (BSedonaJen6lpNeighborEntry)bPanLink;
                                    if (bSedonaJen6lpNeighborEntry2.getStale()) {
                                        this.getPanInfoLog().trace("  skipping stale entry " + (Object)((Object)bSedonaJen6lpNeighborEntry2.getMac154()));
                                        continue;
                                    }
                                    BPanNode bPanNode2 = this.findPanNode(bSedonaJen6lpNeighborEntry2.getMac154());
                                    BPanLink bPanLink2 = new BPanLink(bSedonaJen6lpNeighborEntry2.getLinkQuality(), bSedonaJen6lpNeighborEntry2.getPacketsSent(), bSedonaJen6lpNeighborEntry2.getPacketsLost());
                                    this.getPanInfoLog().trace("  adding parent-to-kid link from " + bSedonaJen6lpDevice.getDisplayName(null) + " to " + bPanNode2 + ':' + bPanLink2);
                                    iPanGraph.addLink(this.findPanNode(bSedonaJen6lpDevice.getMacAddress()), bPanNode2, bPanLink2);
                                }
                                this.getPanInfoLog().trace("  done reading child info.");
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.getPanInfoLog().error("Exception loading pan info data for " + bDeviceArray[n].getDisplayName(null));
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.getPanInfoLog().message("Error loading pan graph!");
        }
        try {
            this.getPanInfoLog().trace("\nAdding coord to child links...\n");
            BComponent bComponent = this.getChildPanInfo();
            bComponent.lease(1);
            bComponent.getComponentSpace().sync();
            bSedonaJen6lpDevice = bComponent.getProperties();
            while (bSedonaJen6lpDevice.next()) {
                object2 = bSedonaJen6lpDevice.get();
                if (object2.getType() != BSedonaJen6lpNeighborEntry.TYPE) continue;
                bSedonaJen6lpNeighborEntry = (BSedonaJen6lpNeighborEntry)((Object)object2);
                if (bSedonaJen6lpNeighborEntry.getStale()) {
                    this.getPanInfoLog().trace("  skipping stale entry " + (Object)((Object)bSedonaJen6lpNeighborEntry.getMac154()));
                    continue;
                }
                object = this.findPanNode(bSedonaJen6lpNeighborEntry.getMac154());
                bPanLink = new BPanLink(bSedonaJen6lpNeighborEntry.getLinkQuality(), bSedonaJen6lpNeighborEntry.getPacketsSent(), bSedonaJen6lpNeighborEntry.getPacketsLost());
                this.getPanInfoLog().trace("  adding coord-to-node link from coord to " + object + ':' + bPanLink);
                iPanGraph.addLink(bPanNode, object, bPanLink);
            }
            this.getPanInfoLog().trace("...finished coord to child links\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.getPanInfoLog().error("Can't load childPanInfo ");
        }
        if (this.getPanInfoLog().isTraceOn()) {
            bAbsTime = BAbsTime.now();
            this.getPanInfoLog().trace("Finished loading; Pan Graph Dump:");
            iPanGraph.dump((OutputStream)System.out);
            this.getPanInfoLog().trace("total load time: " + (BAbsTime.now().getMillis() - bAbsTime2.getMillis()) + "ms.");
        }
    }

    public BSignalBars getSignalBars(int n) {
        if (n <= 0) {
            return BSignalBars.zeroBars;
        }
        if (n <= 60) {
            return BSignalBars.oneBar;
        }
        if (n <= 70) {
            return BSignalBars.twoBars;
        }
        if (n <= 130) {
            return BSignalBars.threeBars;
        }
        return BSignalBars.fourBars;
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList.remove("sedonanet:SedonaDeviceManager");
        return agentList;
    }

    public Object _fw(int n, Object object, Object object2, Object object3, Object object4) {
        if (n == 9901) {
            throw new UnsupportedOperationException("Not implemented for this 6lp network type.");
        }
        return super._fw(n, object, object2, object3, object4);
    }

    public Log getLog() {
        return log;
    }

    public Log getPanInfoLog() {
        return paninfoLog;
    }

    static final /* synthetic */ void access$0(BSedonaJen6lpAbstractNetwork bSedonaJen6lpAbstractNetwork, JennicNeighborEntryMsg jennicNeighborEntryMsg) {
        bSedonaJen6lpAbstractNetwork.recvNbrNodeInfo(jennicNeighborEntryMsg);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.unmatchedPanNodes = new Hashtable();
        this.matchedPanNodes = new Hashtable();
        this.startupTicks = 0L;
        this.atNetworkSteadyState = false;
    }

    public BSedonaJen6lpAbstractNetwork() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$jen6lp$BSedonaJen6lpAbstractNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$jen6lp$BSedonaJen6lpAbstractNetwork = BSedonaJen6lpAbstractNetwork.class("[Lcom.tridium.jen6lp.BSedonaJen6lpAbstractNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"sedona.6lp");
        paninfoLog = Log.getLog((String)"sedona.6lp.paninfo");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class UnsCtrlHandler
    implements Runnable {
        boolean isAlive = true;

        public void setAlive(boolean bl) {
            this.isAlive = bl;
        }

        public boolean isAlive() {
            return this.isAlive;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block12: while (true) {
                if (!this.isAlive) {
                    return;
                }
                var2_2 = null;
                try {
                    try {
                        var1_1 = BSedonaJen6lpAbstractNetwork.this.adapter.receiveUnsCtrlMsg();
                        if (!this.isAlive) {
                            var4_3 = null;
                            var5_4 = 0;
                            while (var5_4 < BSedonaJen6lpAbstractNetwork.this.unsCtrlMsgListeners.size()) {
                                ((IJenserUnsCtrlMsgListener)BSedonaJen6lpAbstractNetwork.this.unsCtrlMsgListeners.get(var5_4)).unsolicitedCtrlMsgReceived(var2_2);
                                ++var5_4;
                            }
                            return;
                        }
                        var2_2 = JenserUnsCtrlMsg.decode(var1_1);
                        switch (var2_2.getType()) {
                            case 7: 
                            case 12: {
                                BSedonaJen6lpAbstractNetwork.this.nodeJoined((PanNodeMsg)var2_2);
                                break;
                            }
                            case 8: 
                            case 13: {
                                BSedonaJen6lpAbstractNetwork.this.nodeLeft((PanNodeMsg)var2_2);
                                break;
                            }
                            case 10: {
                                BSedonaJen6lpAbstractNetwork.access$0(BSedonaJen6lpAbstractNetwork.this, (JennicNeighborEntryMsg)var2_2);
                                BSedonaJen6lpAbstractNetwork.paninfoLog.trace(((JennicNeighborEntryMsg)var2_2).toShortString());
                                break;
                            }
                            case 11: {
                                BSedonaJen6lpAbstractNetwork.paninfoLog.trace(((JennicRoutingEntryMsg)var2_2).toShortString());
                                break;
                            }
                            case 16: {
                                BSedonaJen6lpAbstractNetwork.this.setCoordAddress(((JennicCoordMacAddrMsg)var2_2).getMac154Address());
                                break;
                            }
                        }
                    }
                    catch (Exception var6_5) {
                        BSedonaJen6lpAbstractNetwork.log.error("jenserd error", (Throwable)var6_5);
                        this.isAlive = false;
                    }
                    ** GOTO lbl-1000
                }
                catch (Throwable var3_6) {
                    var4_3 = null;
                    var5_4 = 0;
                }
                while (true) {
                    if (var5_4 >= BSedonaJen6lpAbstractNetwork.this.unsCtrlMsgListeners.size()) {
                        throw var3_6;
                    }
                    ((IJenserUnsCtrlMsgListener)BSedonaJen6lpAbstractNetwork.this.unsCtrlMsgListeners.get(var5_4)).unsolicitedCtrlMsgReceived(var2_2);
                    ++var5_4;
                }
lbl-1000:
                // 2 sources

                {
                    var4_3 = null;
                    var5_4 = 0;
                }
                while (true) {
                    if (var5_4 >= BSedonaJen6lpAbstractNetwork.this.unsCtrlMsgListeners.size()) continue block12;
                    ((IJenserUnsCtrlMsgListener)BSedonaJen6lpAbstractNetwork.this.unsCtrlMsgListeners.get(var5_4)).unsolicitedCtrlMsgReceived(var2_2);
                    ++var5_4;
                }
                break;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CoordKeepaliveHandler
    implements Runnable {
        boolean isAlive = true;

        public void setAlive(boolean bl) {
            this.isAlive = bl;
        }

        public boolean isAlive() {
            return this.isAlive;
        }

        public void run() {
            while (this.isAlive) {
                try {
                    long l = BSedonaJen6lpAbstractNetwork.this.getCoordRcvTimeout().getMillis();
                    if (BSedonaJen6lpAbstractNetwork.this.getEnabled() && l != 0L) {
                        BSedonaJen6lpAbstractNetwork.this.readChannel();
                        Thread.sleep(l / (long)2);
                        continue;
                    }
                    Thread.sleep(15000L);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    log.warning("coord keepalive thread xcp ", (Throwable)exception);
                }
            }
        }
    }
}

