/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jen6lp;

import com.tridium.jen6lp.BAbstractPanInfoPoller;
import com.tridium.jen6lp.BSedonaJen6lpAbstractNetwork;
import com.tridium.jen6lp.BSedonaJen6lpDevice;
import java.text.DecimalFormat;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPanInfoPoller
extends BAbstractPanInfoPoller
implements Runnable {
    public static final Property enabled = BPanInfoPoller.newProperty((int)0, (boolean)false, null);
    public static final Property useChopan = BPanInfoPoller.newProperty((int)0, (boolean)true, null);
    public static final Property desiredPollPeriod = BPanInfoPoller.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)5), null);
    public static final Property statisticsStart = BPanInfoPoller.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    public static final Property nodeCount = BPanInfoPoller.newProperty((int)3, (String)"-", null);
    public static final Property averageNodePollTime = BPanInfoPoller.newProperty((int)3, (String)"-", (BFacets)BFacets.make((BFacets)BFacets.make((String)"showSeconds", (boolean)true), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true)));
    public static final Property interNodeDelay = BPanInfoPoller.newProperty((int)3, (String)"-", null);
    public static final Property busyTime = BPanInfoPoller.newProperty((int)3, (String)"-", null);
    public static final Property actualPollPeriod = BPanInfoPoller.newProperty((int)3, (String)"-", null);
    public static final Property debug = BPanInfoPoller.newProperty((int)0, (boolean)false, null);
    public static final Action enable = BPanInfoPoller.newAction((int)0, null);
    public static final Action disable = BPanInfoPoller.newAction((int)0, null);
    public static final Action resetStatistics = BPanInfoPoller.newAction((int)128, null);
    public static final Type TYPE;
    private static final BIcon icon;
    static final DecimalFormat timeFormat1;
    static final DecimalFormat timeFormat2;
    protected boolean isAlive;
    protected Thread thread;
    protected long startTicks;
    protected long totalPollTime;
    protected int totalPollCount;
    protected int cycleCount;
    protected int totalSize;
    protected double averagePollTime;
    protected int statsCount;
    protected int lastNodeCount;
    static /* synthetic */ Class class$com$tridium$jen6lp$BPanInfoPoller;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public boolean getUseChopan() {
        return this.getBoolean(useChopan);
    }

    public void setUseChopan(boolean bl) {
        this.setBoolean(useChopan, bl, null);
    }

    public BRelTime getDesiredPollPeriod() {
        return (BRelTime)this.get(desiredPollPeriod);
    }

    public void setDesiredPollPeriod(BRelTime bRelTime) {
        this.set(desiredPollPeriod, (BValue)bRelTime, null);
    }

    public BAbsTime getStatisticsStart() {
        return (BAbsTime)this.get(statisticsStart);
    }

    public void setStatisticsStart(BAbsTime bAbsTime) {
        this.set(statisticsStart, (BValue)bAbsTime, null);
    }

    public String getNodeCount() {
        return this.getString(nodeCount);
    }

    public void setNodeCount(String string) {
        this.setString(nodeCount, string, null);
    }

    public String getAverageNodePollTime() {
        return this.getString(averageNodePollTime);
    }

    public void setAverageNodePollTime(String string) {
        this.setString(averageNodePollTime, string, null);
    }

    public String getInterNodeDelay() {
        return this.getString(interNodeDelay);
    }

    public void setInterNodeDelay(String string) {
        this.setString(interNodeDelay, string, null);
    }

    public String getBusyTime() {
        return this.getString(busyTime);
    }

    public void setBusyTime(String string) {
        this.setString(busyTime, string, null);
    }

    public String getActualPollPeriod() {
        return this.getString(actualPollPeriod);
    }

    public void setActualPollPeriod(String string) {
        this.setString(actualPollPeriod, string, null);
    }

    public boolean getDebug() {
        return this.getBoolean(debug);
    }

    public void setDebug(boolean bl) {
        this.setBoolean(debug, bl, null);
    }

    public void enable() {
        this.invoke(enable, null, null);
    }

    public void disable() {
        this.invoke(disable, null, null);
    }

    public void resetStatistics() {
        this.invoke(resetStatistics, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doEnable() {
        this.setEnabled(true);
    }

    public void doDisable() {
        this.setEnabled(false);
    }

    public void doResetStatistics() {
        this.d("Resetting Statistics...");
        this.startTicks = Clock.ticks();
        this.setStatisticsStart(Clock.time());
        this.totalPollTime = 0L;
        this.totalPollCount = 0;
        this.cycleCount = 0;
        this.totalSize = 0;
        this.averagePollTime = 0.0;
        this.statsCount = 0;
        BSedonaJen6lpDevice[] bSedonaJen6lpDeviceArray = this.getNetwork().get6lpDeviceList();
        int n = bSedonaJen6lpDeviceArray.length;
        this.computeStatistics(n, 0L);
    }

    public BSedonaJen6lpAbstractNetwork getNetwork() {
        return (BSedonaJen6lpAbstractNetwork)this.getParent();
    }

    public void started() throws Exception {
        super.started();
        if (Sys.atSteadyState()) {
            this.startThread();
        }
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        this.startThread();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.stopThread();
    }

    void startThread() {
        this.doResetStatistics();
        this.stopThread();
        this.isAlive = true;
        this.thread = new Thread((Runnable)this, this.getParent().getName() + ":6lpPanInfoPoller");
        this.thread.start();
    }

    void stopThread() {
        this.isAlive = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
    }

    private final void poll(BSedonaJen6lpDevice bSedonaJen6lpDevice) {
        if (!bSedonaJen6lpDevice.getEnabled()) {
            return;
        }
        this.d("\npan info poll: " + (Object)((Object)bSedonaJen6lpDevice));
        long l = Clock.ticks();
        try {
            bSedonaJen6lpDevice.doLoadPanInfo();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        long l2 = Clock.ticks();
        ++this.totalPollCount;
        this.totalPollTime += l2 - l;
        this.averagePollTime = (double)this.totalPollTime / (double)this.totalPollCount;
    }

    public void run() {
        long l = Clock.ticks() + 10000L;
        while (this.isAlive) {
            try {
                if (!this.getEnabled() || !this.getNetwork().atNetworkSteadyState()) {
                    Thread.sleep(1000L);
                    continue;
                }
                BSedonaJen6lpDevice[] bSedonaJen6lpDeviceArray = this.getNetwork().get6lpDeviceList();
                int n = bSedonaJen6lpDeviceArray.length;
                if (n == 0) {
                    Thread.sleep(1000L);
                    continue;
                }
                this.d("numNodes=" + n);
                long l2 = this.getDesiredPollPeriod().getMillis();
                this.d("sleep=" + l2);
                int n2 = 0;
                while (n2 < n) {
                    if (this.getEnabled()) {
                        this.poll(bSedonaJen6lpDeviceArray[n2]);
                        Thread.sleep(l2);
                    }
                    ++n2;
                }
                ++this.cycleCount;
                this.getNetwork().doLoadPanInfo();
                this.d("now=" + Clock.ticks() + "; stats=" + l);
                if (this.cycleCount > 2 && Clock.ticks() > l) {
                    this.computeStatistics(n, l2);
                    l = Clock.ticks() + 10000L;
                }
                this.d("finished cycle!");
            }
            catch (Throwable throwable) {
                if (!this.isAlive) continue;
                throwable.printStackTrace();
            }
        }
    }

    protected void computeStatistics(int n, long l) {
        this.d("Computing paninfo poll stats for " + n + " with sleepTime " + l + "ms...");
        long l2 = Clock.ticks();
        long l3 = l2 - this.startTicks;
        ++this.statsCount;
        this.totalSize += n;
        this.setNodeCount(this.toCount(n, this.totalSize));
        this.setAverageNodePollTime(this.duration(this.averagePollTime));
        this.setInterNodeDelay(this.duration(l));
        this.setActualPollPeriod(this.toCycle(this.cycleCount, l3));
        if (this.totalPollTime > 0L) {
            this.setBusyTime((int)(100.0 * ((double)this.totalPollTime / (double)l3)) + "% (" + this.duration(this.totalPollTime) + '/' + this.duration(l3) + ')');
        }
    }

    private final String toCount(int n, int n2) {
        return "current=" + n + " average=" + n2 / this.statsCount;
    }

    private final String toCycle(int n, long l) {
        if (n == 0) {
            return "-";
        }
        double d = (double)l / (double)n;
        if (d < 10000.0) {
            return "average = " + (int)d + "ms";
        }
        return "average = " + (int)(d / 1000.0) + "sec";
    }

    private final String duration(double d) {
        if (d < 1000.0) {
            return timeFormat1.format(d);
        }
        return timeFormat2.format(d / 1000.0);
    }

    public BIcon getIcon() {
        return icon;
    }

    protected void d(Object object) {
        if (this.getDebug()) {
            System.out.println(object);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.startTicks = 0L;
        this.totalPollTime = 0L;
        this.totalPollCount = 0;
        this.cycleCount = 0;
        this.averagePollTime = 0.0;
        this.statsCount = 0;
        this.lastNodeCount = 0;
    }

    public BPanInfoPoller() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$jen6lp$BPanInfoPoller;
        if (clazz == null) {
            clazz = class$com$tridium$jen6lp$BPanInfoPoller = BPanInfoPoller.class("[Lcom.tridium.jen6lp.BPanInfoPoller;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"monitor.png");
        timeFormat1 = new DecimalFormat("#ms");
        timeFormat2 = new DecimalFormat("0.0#sec");
    }
}

