/*
 * Decompiled with CFR 0.152.
 */
package sedonac.parser;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import sedona.Buf;
import sedona.util.TextUtil;
import sedonac.Compiler;
import sedonac.CompilerException;
import sedonac.CompilerSupport;
import sedonac.Location;
import sedonac.parser.Token;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Tokenizer
extends CompilerSupport {
    private static final CharArrayWriter chars = new CharArrayWriter(1024);
    private static final char[] charBuf = new char[1024];
    static final byte[] charMap = new byte[128];
    static final int ID_START = 1;
    static final int ID_CHAR = 2;
    static final int SPACE = 4;
    static final int DIGIT = 8;
    static final int HEX = 16;
    String filename;
    char[] buf;
    int pos;
    int cur;
    int peek;
    int line;
    int col;
    boolean doc;
    Token last;

    public static char[] readFile(File file) {
        Location location = new Location(file);
        try {
            return Tokenizer.readFile(location, new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CompilerException("Source file not found", location, fileNotFoundException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] readFile(Location location, InputStream inputStream) {
        char[] cArray;
        BufferedReader bufferedReader = null;
        try {
            try {
                chars.reset();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                while (true) {
                    int n;
                    if ((n = bufferedReader.read(charBuf)) == -1) {
                        cArray = chars.toCharArray();
                        Object var4_6 = null;
                        break;
                    }
                    chars.write(charBuf, 0, n);
                }
            }
            catch (IOException iOException) {
                throw new CompilerException("Cannot read source file", location, iOException);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            try {
                if (bufferedReader == null) throw throwable;
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        if (bufferedReader == null) return cArray;
        bufferedReader.close();
        return cArray;
    }

    public Token[] tokenize() {
        ArrayList<Token> arrayList = new ArrayList<Token>(1024);
        while (true) {
            Token token;
            if ((token = this.next(arrayList)) == null) {
                continue;
            }
            arrayList.add(token);
            if (token.type == 0) break;
        }
        return arrayList.toArray(new Token[arrayList.size()]);
    }

    private final Token next(ArrayList arrayList) {
        while (true) {
            if (this.isSpace(this.cur)) {
                this.consume();
                continue;
            }
            if (this.cur == 47 && this.peek == 47) {
                this.lineComment();
                continue;
            }
            if (this.cur == 47 && this.peek == 42) {
                this.blockComment();
                continue;
            }
            if (this.cur != 42 || this.peek != 42) break;
            if (this.doc) {
                return this.docComment();
            }
            this.lineComment();
        }
        if (this.isIdStart(this.cur)) {
            return this.idOrKeyword();
        }
        if (this.isDigit(this.cur)) {
            return this.numberLiteral();
        }
        if (this.cur == 39) {
            return this.charLiteral();
        }
        if (this.cur == 34) {
            this.strLiteral(arrayList);
            return null;
        }
        Token token = this.symbol();
        if (token != null) {
            return token;
        }
        if (this.cur < 0) {
            return new Token(this.location(), 0);
        }
        throw this.err("Unexpected token '" + (char)this.cur + '\'');
    }

    private final Token idOrKeyword() {
        Location location = this.location();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)this.cur);
        this.consume();
        while (this.isIdChar(this.cur)) {
            stringBuffer.append((char)this.consume());
        }
        String string = stringBuffer.toString();
        int n = Token.fromKeyword(string);
        if (n > 0) {
            return new Token(location, n);
        }
        return new Token(location, 1, string);
    }

    private final Token numberLiteral() {
        Location location = this.location();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.cur == 48 && this.peek == 120) {
            this.consume();
            this.consume();
            if (this.cur == 91) {
                return this.bufLiteral(location);
            }
            bl2 = true;
            if (!this.isDigit(this.cur) && !this.isHex(this.cur)) {
                throw this.err("Invalid hex literal");
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (this.isDigit(this.cur) || this.cur == 46 || this.cur == 95 || this.cur == 69 || this.cur == 101 || bl2 && this.isHex(this.cur)) {
            if (this.cur == 95) {
                this.consume();
                continue;
            }
            if (this.cur == 46) {
                if (bl2) {
                    throw this.err("Invalid hex literal");
                }
                bl = true;
            }
            if (!(bl2 || this.cur != 69 && this.cur != 101)) {
                bl = true;
                stringBuffer.append((char)this.consume()).append(this.exponentialPart());
                break;
            }
            stringBuffer.append((char)this.consume());
        }
        String string = stringBuffer.toString();
        long l = -1;
        if (!bl2) {
            if (this.cur == 110 && this.peek == 115) {
                this.consume();
                this.consume();
                l = 1L;
            } else if (this.cur == 109 && this.peek == 115) {
                this.consume();
                this.consume();
                l = 1000000L;
            } else if (this.cur == 115 && this.peek == 101) {
                this.consume();
                this.consume();
                if (this.cur != 99) {
                    throw this.err("Expected 'sec' in Time literal");
                }
                this.consume();
                l = 1000000000L;
            } else if (this.cur == 109 && this.peek == 105) {
                this.consume();
                this.consume();
                if (this.cur != 110) {
                    throw this.err("Expected 'min' in Time literal");
                }
                this.consume();
                l = 60000000000L;
            } else if (this.cur == 104 && this.peek == 114) {
                this.consume();
                this.consume();
                l = 3600000000000L;
            } else if (this.cur == 100 && this.peek == 97) {
                this.consume();
                this.consume();
                if (this.cur != 121 || this.peek != 115) {
                    throw this.err("Expected 'days' in Time literal");
                }
                this.consume();
                this.consume();
                l = 86400000000000L;
            }
        }
        switch (this.cur) {
            case 70: 
            case 102: {
                this.consume();
                bl = true;
                break;
            }
            case 68: 
            case 100: {
                this.consume();
                bl = true;
                bl3 = true;
                break;
            }
            case 76: 
            case 108: {
                this.consume();
                bl3 = true;
                if (!bl) break;
                throw this.err("Type mismatch. Cannot convert from floating point number to long: " + string + 'L', this.location());
            }
        }
        try {
            long l2;
            if (l >= 0L) {
                if (bl) {
                    l = (long)((double)l * Double.parseDouble(string));
                    return new Token(location, 8, new Long(l));
                }
                return new Token(location, 8, new Long(l *= Long.parseLong(string)));
            }
            if (bl) {
                if (bl3) {
                    return new Token(location, 6, new Double(string));
                }
                return new Token(location, 5, new Float(string));
            }
            if (bl2) {
                if (string.length() > 16 || !bl3 && string.length() > 8) {
                    throw this.err("Invalid range for int/long: 0x" + string, this.location());
                }
                l2 = TextUtil.parseHexLong((String)string);
                if (!bl3 && l2 > 0xFFFFFFFFL) {
                    throw this.err("Invalid range for int: 0x" + string, this.location());
                }
            } else {
                l2 = Long.parseLong(string);
                if (!(bl3 || l2 >= Integer.MIN_VALUE && 0x80000000L >= l2)) {
                    throw this.err("Invalid range for int: " + string, this.location());
                }
            }
            if (bl3) {
                return new Token(location, 4, new Long(l2));
            }
            return new Token(location, 3, new Integer((int)l2));
        }
        catch (CompilerException compilerException) {
            throw compilerException;
        }
        catch (Exception exception) {
            throw this.err("Invalid number: " + string, this.location());
        }
    }

    private final String exponentialPart() {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.cur == 95) {
            this.consume();
        }
        if (this.cur == 43 || this.cur == 45) {
            stringBuffer.append((char)this.consume());
        }
        while (this.cur == 95 || this.isDigit(this.cur)) {
            if (this.cur == 95) {
                this.consume();
                continue;
            }
            stringBuffer.append((char)this.consume());
        }
        return stringBuffer.toString();
    }

    private final Token charLiteral() {
        int n;
        Location location = this.location();
        this.consume();
        if (this.cur == 92) {
            n = this.escape();
        } else {
            n = this.cur;
            this.consume();
        }
        if (this.cur != 39) {
            throw this.err("Invalid character literal " + this.cur);
        }
        this.consume();
        return new Token(location, 3, new Integer(n));
    }

    private final void strLiteral(ArrayList arrayList) {
        Location location = this.location();
        this.consume();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while (true) {
            if (this.cur == 34) break;
            if (this.cur == 10) {
                throw this.err("Unexpected end of string literal");
            }
            if (this.cur == 36) {
                if (!bl) {
                    bl = true;
                    arrayList.add(new Token(this.location(), 44));
                }
                if (!this.strInterpolation(location, arrayList, stringBuffer.toString())) {
                    arrayList.add(new Token(this.location(), 45));
                    return;
                }
                stringBuffer.setLength(0);
                location = this.location();
                continue;
            }
            if (this.cur == 92) {
                stringBuffer.append((char)this.escape());
                continue;
            }
            stringBuffer.append((char)this.cur);
            this.consume();
        }
        this.consume();
        arrayList.add(new Token(location, 7, stringBuffer.toString()));
        if (bl) {
            arrayList.add(new Token(this.location(), 45));
        }
    }

    private final boolean strInterpolation(Location location, ArrayList arrayList, String string) {
        this.consume();
        arrayList.add(new Token(location, 7, string));
        arrayList.add(new Token(this.location(), 14));
        if (this.cur == 123) {
            arrayList.add(new Token(this.location(), 44));
            this.consume();
            while (true) {
                if (this.cur == 34) {
                    throw this.err("Unexpected end of string, missing }");
                }
                Token token = this.next(arrayList);
                if (token.type == 41) break;
                arrayList.add(token);
            }
            arrayList.add(new Token(this.location(), 45));
        } else {
            Token token = this.next(arrayList);
            if (token.type != 1) {
                throw this.err("Expected identifier after $");
            }
            arrayList.add(token);
            while (this.cur == 46) {
                arrayList.add(this.next(arrayList));
                token = this.next(arrayList);
                if (token.type != 1) {
                    throw this.err("Expected identifier");
                }
                arrayList.add(token);
            }
        }
        if (this.cur == 34) {
            this.consume();
            return false;
        }
        arrayList.add(new Token(this.location(), 14));
        return true;
    }

    private final int escape() {
        if (this.cur != 92) {
            throw new IllegalStateException();
        }
        this.consume();
        switch (this.cur) {
            case 48: {
                this.consume();
                return 0;
            }
            case 110: {
                this.consume();
                return 10;
            }
            case 114: {
                this.consume();
                return 13;
            }
            case 116: {
                this.consume();
                return 9;
            }
            case 34: {
                this.consume();
                return 34;
            }
            case 39: {
                this.consume();
                return 39;
            }
            case 92: {
                this.consume();
                return 92;
            }
            case 36: {
                this.consume();
                return 36;
            }
        }
        throw this.err("Invalid escape sequence " + (char)this.cur);
    }

    /*
     * Unable to fully structure code
     */
    private final Token bufLiteral(Location var1_1) {
        var2_2 = new Buf();
        if (this.consume() == 91) ** GOTO lbl19
        throw new IllegalStateException();
lbl-1000:
        // 1 sources

        {
            if (this.isSpace(this.cur)) {
                this.consume();
                continue;
            }
            if (this.cur == 47 && this.peek == 47) {
                this.lineComment();
                continue;
            }
            if (this.cur == 47 && this.peek == 42) {
                this.blockComment();
                continue;
            }
            if (this.cur == 42 && this.peek == 42) {
                this.lineComment();
                continue;
            }
            var3_3 = this.nibble() << 4 | this.nibble();
            var2_2.write(var3_3);
lbl19:
            // 6 sources

            ** while (this.cur != 93)
        }
lbl20:
        // 1 sources

        this.consume();
        return new Token(var1_1, 9, var2_2);
    }

    private final int nibble() {
        if (this.isDigit(this.cur) || this.isHex(this.cur)) {
            return TextUtil.hexCharToInt((char)((char)this.consume()));
        }
        throw this.err("Expected hex digit");
    }

    private final Token symbol() {
        Location location = this.location();
        switch (this.cur) {
            case 46: {
                this.consume();
                return new Token(location, 10);
            }
            case 44: {
                this.consume();
                return new Token(location, 11);
            }
            case 59: {
                this.consume();
                return new Token(location, 12);
            }
            case 58: {
                this.consume();
                if (this.cur == 58) {
                    this.consume();
                    return new Token(location, 23);
                }
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 59);
                }
                return new Token(location, 13);
            }
            case 43: {
                this.consume();
                if (this.cur == 43) {
                    this.consume();
                    return new Token(location, 37);
                }
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 47);
                }
                return new Token(location, 14);
            }
            case 45: {
                this.consume();
                if (this.cur == 45) {
                    this.consume();
                    return new Token(location, 38);
                }
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 48);
                }
                if (this.cur == 62) {
                    this.consume();
                    return new Token(location, 39);
                }
                return new Token(location, 15);
            }
            case 42: {
                this.consume();
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 49);
                }
                return new Token(location, 16);
            }
            case 47: {
                this.consume();
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 50);
                }
                return new Token(location, 17);
            }
            case 37: {
                this.consume();
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 51);
                }
                return new Token(location, 18);
            }
            case 38: {
                this.consume();
                if (this.cur == 38) {
                    this.consume();
                    return new Token(location, 21);
                }
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 52);
                }
                return new Token(location, 19);
            }
            case 124: {
                this.consume();
                if (this.cur == 124) {
                    this.consume();
                    return new Token(location, 22);
                }
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 53);
                }
                return new Token(location, 20);
            }
            case 94: {
                this.consume();
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 54);
                }
                return new Token(location, 24);
            }
            case 63: {
                this.consume();
                if (this.cur == 46) {
                    this.consume();
                    return new Token(location, 57);
                }
                if (this.cur == 58) {
                    this.consume();
                    return new Token(location, 58);
                }
                return new Token(location, 25);
            }
            case 33: {
                this.consume();
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 32);
                }
                return new Token(location, 26);
            }
            case 126: {
                this.consume();
                return new Token(location, 27);
            }
            case 60: {
                this.consume();
                if (this.cur == 60) {
                    this.consume();
                    if (this.cur == 61) {
                        this.consume();
                        return new Token(location, 55);
                    }
                    return new Token(location, 29);
                }
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 36);
                }
                return new Token(location, 35);
            }
            case 62: {
                this.consume();
                if (this.cur == 62) {
                    this.consume();
                    if (this.cur == 61) {
                        this.consume();
                        return new Token(location, 56);
                    }
                    return new Token(location, 30);
                }
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 34);
                }
                return new Token(location, 33);
            }
            case 123: {
                this.consume();
                return new Token(location, 40);
            }
            case 125: {
                this.consume();
                return new Token(location, 41);
            }
            case 91: {
                this.consume();
                return new Token(location, 42);
            }
            case 93: {
                this.consume();
                return new Token(location, 43);
            }
            case 40: {
                this.consume();
                return new Token(location, 44);
            }
            case 41: {
                this.consume();
                return new Token(location, 45);
            }
            case 61: {
                this.consume();
                if (this.cur == 61) {
                    this.consume();
                    return new Token(location, 31);
                }
                return new Token(location, 46);
            }
            case 64: {
                this.consume();
                return new Token(location, 28);
            }
        }
        return null;
    }

    private final void lineComment() {
        this.consume();
        this.consume();
        while (this.cur != 10 && this.cur > 0) {
            this.consume();
        }
        this.consume();
    }

    private final void blockComment() {
        int n = 1;
        this.consume();
        this.consume();
        while (this.cur > 0) {
            if (this.cur == 42 && this.peek == 47 && --n <= 0) break;
            if (this.cur == 47 && this.peek == 42) {
                ++n;
            }
            this.consume();
        }
        this.consume();
        this.consume();
    }

    /*
     * Unable to fully structure code
     */
    private final Token docComment() {
        var1_1 = this.location();
        while (this.cur == 42) {
            this.consume();
        }
        if (this.cur == 32) {
            this.consume();
        }
        var2_2 = new StringBuffer();
        while (this.cur > 0) {
            var3_3 = this.cur;
            var2_2.append((char)var3_3);
            this.consume();
            if (var3_3 == 10) ** GOTO lbl20
            continue;
lbl-1000:
            // 1 sources

            {
                this.consume();
lbl20:
                // 2 sources

                ** while (this.cur == 32 || this.cur == 9)
            }
lbl21:
            // 1 sources

            if (this.cur == 42 && this.peek == 42) ** GOTO lbl25
            break;
lbl-1000:
            // 1 sources

            {
                this.consume();
lbl25:
                // 2 sources

                ** while (this.cur == 42)
            }
lbl26:
            // 1 sources

            if (this.cur != 32 && this.cur != 9) continue;
            this.consume();
        }
        var3_4 = var2_2.toString().trim();
        return new Token(var1_1, 2, var3_4);
    }

    public CompilerException err(String string) {
        return super.err(string, this.location());
    }

    private final Location location() {
        return new Location(this.filename, this.line, this.col);
    }

    private final int consume() {
        if (this.cur < 0) {
            throw this.err("Unexpected end of file");
        }
        int n = this.cur;
        this.cur = this.peek;
        int n2 = this.peek = this.pos < this.buf.length ? this.buf[this.pos++] : -1;
        if (this.cur == 10) {
            ++this.line;
            this.col = 0;
        } else {
            ++this.col;
        }
        return n;
    }

    boolean isIdStart(int n) {
        boolean bl = false;
        if (n > 0 && n < 128) {
            bl = false;
            if ((charMap[n] & 1) != 0) {
                bl = true;
            }
        }
        return bl;
    }

    boolean isIdChar(int n) {
        boolean bl = false;
        if (n > 0 && n < 128) {
            bl = false;
            if ((charMap[n] & 2) != 0) {
                bl = true;
            }
        }
        return bl;
    }

    boolean isDigit(int n) {
        boolean bl = false;
        if (n > 0 && n < 128) {
            bl = false;
            if ((charMap[n] & 8) != 0) {
                bl = true;
            }
        }
        return bl;
    }

    boolean isHex(int n) {
        boolean bl = false;
        if (n > 0 && n < 128) {
            bl = false;
            if ((charMap[n] & 0x10) != 0) {
                bl = true;
            }
        }
        return bl;
    }

    boolean isSpace(int n) {
        boolean bl = false;
        if (n > 0 && n < 128) {
            bl = false;
            if ((charMap[n] & 4) != 0) {
                bl = true;
            }
        }
        return bl;
    }

    public static void main(String[] stringArray) throws Exception {
        try {
            File file = new File(stringArray[0]);
            Tokenizer tokenizer = new Tokenizer(new Compiler(), file.getName(), Tokenizer.readFile(file));
            Token[] tokenArray = tokenizer.tokenize();
            int n = 0;
            while (n < tokenArray.length) {
                Token token = tokenArray[n];
                if (token.type != 0) {
                    String string = token.toString();
                    if (token.type == 1) {
                        string = "@" + string;
                    }
                    System.out.println(TextUtil.padRight((String)(token.loc + ": "), (int)20) + string);
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (CompilerException compilerException) {
            System.out.println(compilerException.toLogString());
        }
    }

    private final /* synthetic */ void this() {
        this.last = new Token(new Location(null, 0, 0), 0);
    }

    public Tokenizer(Compiler compiler, String string, char[] cArray) {
        super(compiler);
        this.this();
        this.filename = string;
        this.buf = cArray;
        this.pos = 0;
        this.line = 1;
        this.col = -1;
        boolean bl = false;
        if (compiler != null) {
            bl = compiler.doc;
        }
        this.doc = bl;
        this.consume();
        this.consume();
    }

    static {
        int n = 65;
        while (n <= 90) {
            Tokenizer.charMap[n] = 3;
            ++n;
        }
        n = 97;
        while (n <= 122) {
            Tokenizer.charMap[n] = 3;
            ++n;
        }
        n = 48;
        while (n <= 57) {
            Tokenizer.charMap[n] = 10;
            ++n;
        }
        n = 97;
        while (n <= 102) {
            int n2 = n++;
            charMap[n2] = (byte)(charMap[n2] | 0x10);
        }
        n = 65;
        while (n <= 70) {
            int n3 = n++;
            charMap[n3] = (byte)(charMap[n3] | 0x10);
        }
        Tokenizer.charMap[95] = 3;
        Tokenizer.charMap[32] = 4;
        Tokenizer.charMap[9] = 4;
        Tokenizer.charMap[10] = 4;
        Tokenizer.charMap[13] = 4;
    }
}

