/* BEGIN HEADER ===============================================================
 
    Project name:	 Ethernet ARCNET Bridge 
    Program name:    arcnet_brigde
    Module name:
    File name:       protdef.h
 
    Description:     Definition of operations, error codes, data types
 
    Included global subroutines:
    Import:          -
    Export:          -
 
    Current version: 1.0
    Creation date:   12.12.01
 
    Author:          Klaus Falkner
    Company:        
 
    Changes:
 
    Version Date     ch. by ChIdx  Changes
    ------- -------- ------ ------ ------------
    1.1		12/19/03 RCW			Added members to 'op_sr' structure to be returned
    								by SQ (Status Query). Includes statistics
									added to brigde.

									Added OP_NDQ/OP_NDR for setting TCP_NODELAY.

									Added OP_CRES for resetting packet counters.
									
	1.2		2/13/04	RCW				Added 'ReadArcReg()' and 'WriteArcReg()' functions
									that use 'ioctl()' to access registers. Functions are
									in 'arcnet.cpp'.
									The arcnet driver was modified to implement 'do_ioctl'
									so that registers could be read and written.
									
	1.3		2/18/04	RCW				Added OP_CRESR response to counter reset.
									Added new structures for flag access via 'ioctl'; this
									will return the transmit and tx acknowledge status, as
									well as the number of recons.
									Added OP_TXWAIT and OP_RECONWAIT so we can do real
									waiting on events.Not implemented yet.
 
 
                  (c)2002 AUG e.V. 
== END HEADER ===============================================================*/

/* ------------------  COMPILER CONTROLS  ------------------*/
#ifndef __PROTDEF_H
#define __PROTDEF_H
//
// Linux uses 8 byte structure alignment.
//
// _DBUG: Structure sizes are different between i86 and ARM...
#pragma pack(8)

/* ------------------      INCLUDES       ------------------*/

/* ------------------       DEFINES       ------------------*/

// default connection port

#define DEFAULT_PORT 5001

// Number of supported ARCNET speeds

#define SPEEDS 9

// Interfaces

#define COAX 0
#define RS485 1

// ***************************************************************************

//                                error codes

// ***************************************************************************

#define ERR_OP_NOT_ALLOWED 1
#define ERR_OP_NOT_ALLOWED_SRC ERROR_SRC_BRIDGE
#define ERR_OP_NOT_ALLOWED_TEXT "Operation not allowed."


#define ERR_OP_UNKNOWN 2
#define ERR_OP_UNKNOWN_SRC ERROR_SRC_BRIDGE
#define ERR_OP_UNKNOWN_TEXT "Operation unknown."


#define ERR_INVALID_PIN 3
#define ERR_INVALID_PIN_SRC ERROR_SRC_OTHER
#define ERR_INVALID_PIN_TEXT "Invalid PIN."


#define ERR_OP_LEN 4
#define ERR_OP_LEN_SRC ERROR_SRC_BRIDGE
#define ERR_OP_LEN_TEXT "Wrong OP length."


#define ERR_OP_NOTHING_TO_SEND 5
#define ERR_OP_NOTHING_TO_SEND_SRC ERROR_SRC_OTHER
#define ERR_OP_NOTHING_TO_SEND_TEXT "No send data."

#define ERR_OP_PACKET_TO_LONG 6
#define ERR_OP_PACKET_TO_LONG_SRC ERROR_SRC_BRIDGE
#define ERR_OP_PACKET_TO_LONG_TEXT "Packet to long."

#define ERR_NO_RCVALL 7
#define ERR_NO_RCVALL_SRC ERROR_SRC_BRIDGE
#define ERR_NO_RCVALL_TEXT "Receive All not set."

#define ERR_OP_NOT_SUPPORTED 8
#define ERR_OP_NOT_SUPPORTED_SRC ERROR_SRC_BRIDGE
#define ERR_OP_NOT_SUPPORTED_TEXT "OP not supported."


#define ERR_NO_ADVISE_TIMEOUT 9
#define ERR_NO_ADVISE_TIMEOUT_SRC  ERROR_SRC_OTHER
#define ERR_NO_ADVISE_TIMEOUT_TEXT "No UDP advise timeout."

#define	ERR_INVALID_PARM 10
#define	ERR_INVALID_PARM_SRC ERROR_SRC_OTHER
#define	ERR_INVALID_PARM_TEXT "Invalid command parameter"

#define	ERR_IOCTL 11
#define	ERR_IOCTL_SRC ERROR_SRC_OTHER
#define	ERR_IOCTL_TEXT "ioctl() failure"


#define ERR_MSG(err) err,err##_SRC,err##_TEXT

typedef enum {
    ERROR_SRC_OTHER,
    ERROR_SRC_BRIDGE,
    ERROR_SRC_ARCNET
}E_ERROR_SRC;



/* ------------------      CONSTANTS      ------------------*/


/* ------------------  TYPEDECLARATIONS   ------------------*/
//
// _DBUG: Universal integer type.
//
typedef union _g_int
{
	unsigned char	c[4];
	unsigned short	s[2];
	unsigned long	l;
} g_int;

// type of thread function

typedef void * (* PTHREAD_START_FKTN)( void *pThreadParameter );

typedef unsigned char  uint8;
typedef unsigned short uint16;
typedef unsigned long  uint32;

// data field structure of OP_DR / OP_WQ operations
//
#define		WINSIZE_ARC_PAC		4
struct arc_pac
{
    uint8 sid;          // source id
    uint8 did;          // destination id
    uint16 len;         // length of data below
    uint8 data[];       // data
}
;

// ***************************************************************************

//                         Operations

// ***************************************************************************

// Operation codes                              direction

enum OP_CODE {
    OP_ER = 0x4552,     // error response   GW -> IP
    OP_CQ = 0x4351,     // config query     IP -> GW
    OP_CR = 0x4352,     // config report    GW -> IP
    OP_CS = 0x4353,     // config set       IP -> GW
    OP_PQ = 0x5051,     // promicuous (receive all) mode query      IP -> GW
    OP_PR = 0x5052,     // promicuous (receive all) mode report     GW -> IP
    OP_PS = 0x5053,     // promicuous (receive all) mode set        IP -> GW
    OP_SQ = 0x5351,     // status query     IP -> GW
    OP_SR = 0x5352,     // status report    GW -> IP
    OP_WQ = 0x5751,     // write request    IP -> GW -> ARC
    OP_WO = 0x574F,     // write o.k.       GW -> IP
    OP_DA = 0x4441,     // data advise      IP -> GW
    OP_DQ = 0x4451,     // data request     IP -> GW
    OP_DR = 0x4452,     // data response    (ARC ->) GW -> IP
    OP_NQ = 0x4E51,     // nodemap request  IP -> GW
    OP_NR = 0x4E52,     // nodemap response GW -> IP
    //
    OP_NDQ		= 0x6000,	// TCP/IP NODELAY mode query/set			IP -> GW
    OP_NDR		= 0x6001,	// Response.								GW -> IP
    //
    OP_CRESQ	= 0x6002,	// Status counter reset query.				IP -> GW
    OP_CRESR	= 0x6003,	// Response.								IP -> GW
    //
    OP_REGQ		= 0x6004,	// Arcnet register Read/Write query			IP -> GW
    OP_REGR		= 0x6005,	// Response.								GW -> IP
    //
    OP_FLAGQ	= 0x6006,	// Tx & Recon flag query.					IP -> GW
    OP_FLAGR	= 0x6007,	// Response.								GW -> IP
    //
    OP_TXWAITQ	= 0x6008,	// Enable/disable wait on tx complete.		IP -> GW
    OP_TXWAITR	= 0x6009,	// Response.								GW -> IP
    //
    OP_RECONQ	= 0x6010,	// Enable/disable wait on recon.			IP -> GW
    OP_RECONR	= 0x6011,	// Response.								GW -> IP
    OP_RECONM	= 0x6012,	// Recon event message.						GW -> IP
    //
    OP_TXTIMEOQ	= 0x6013,	// Set arcnet TX timeout.					IP -> GW
    OP_TXTIMEOR	= 0x6014,	// Response.								GW -> IP
    //
    OP_REBOOTQ	= 0x6015,	// Reboot the AI-SRVR.						IP -> GW
};

// Operation definition

// Minimal operation header

#define		WINSIZE_OPHDR			4

struct OpHdr
{
    uint16 op_len;     // Length of this operation (incl. header)
    uint16 op_type;    // Type specification for this operation
    uint8  op_data[];  // Parameter / data
}
;

#define		WINSIZE_OPSECUREHDR	8

struct OpSecureHdr
{
    uint16 op_len;    // Length of this operation (incl. header)
    uint16 op_type;   // Type specification for this operation
    uint8  op_security_code[4];  // security code
    uint8  op_data[];  // Parameter / data
}
;
//
//----------------------------------------------------------------------------
//
//  ER - Error Response
// 
// Direction: GW --> IP
// 
// Answers a failed operation
// 
// Possible response: --
// 
#define		WINSIZE_OP_ER			12

struct op_er
{
    uint16 op_len;   // Length of this operation (incl. header)
    uint16 op_type;  // Operation type: 'ER' (0x4552)
    uint16 er_opref; // Type of failed operation
    uint16 er_src;   // Error source
    //   0: Other
    //   1: Bridge
    //   2: ARCNET
    // ...
    uint32 er_code;  // Error code
    char   er_msg[]; // Error text null-terminated (optional)
}
;
//
//----------------------------------------------------------------------------
//
//  CQ - Config Query
// 
// Direction: IP --> GW
// 
// Requests bridge configuration 
// 
// Possible response: CR (config report), ER (error)
//
#define		WINSIZE_OP_CQ			8

struct op_cq
{
    uint16 op_len;   // Length of this operation (incl. header)
    uint16 op_type;  // Operation type:  'CQ' (0x4351)
    uint8  op_security_code[4];
};
//
// data struct OP_CR
//
#define		WINSIZE_CONFIG			8

struct config
{
    uint8  cf_node;     // Node number bridge (0: not initialized)
    uint8  cf_intf;     // Interface:  0,1
    uint8  cf_speed;    // ARCNET baudrate 0..9
    uint8  cf_timeout;  // ARCNET Timeout (ET1, ET2: 0..3)
    uint8  cf_rcntm;    // RECON Timeout (0..3)
    uint8  cf_rcvall;   // Receive all. 0: off, else: active
    uint16 cf_nltim;    // Timeout Node-List  [ 1/10 s]. If a node does not send
 						// during this time, it is supposed inactive.
}
;
//
//----------------------------------------------------------------------------
//
//   CR - Config Report
//  
// Direction: GW --> IP
//  
// Possible response: --
// 
#define		WINSIZE_OP_CR			18
 
struct op_cr
{
    uint16 op_len;      // Length of this operation (incl. header)
    uint16 op_type;     // Operation type 'CR' (0x4352)

    struct config cr_config;

    uint16 cr_fifo;     // FIFO depth
    uint16 cr_hwver;    // Hardware-Version Hi/Lo-byte
    uint16 cr_swver;    // Software-Version Hi/Lo-byte
    char   cr_vendor[];	// Vendor-Name, null-terminated
}
;
//
//----------------------------------------------------------------------------
//
//   CS - Config Set
//  
// Direction: IP --> GW
//  
// Sets ARCNET-Interface configuration 
//  
// Possible response: ER, CR
// 
#define		WINSIZE_OP_CS			16

struct op_cs
{
    uint16 op_len;      // Length of this operation (incl. header)
    uint16 op_type;     // Operation type  'CS' (0x4353)
    uint8  op_security_code[4];
    struct config cs_config;
};
//
//----------------------------------------------------------------------------
// 
// PQ - Promiscuous (Receive-all) Mode Query
//  
// Direction: IP --> GW
//  
// Requests promiscous mode status
//  
// Possible response: ER, PR
// 
#define		WINSIZE_OP_PQ			8

struct op_pq
{
    uint16 op_len;  // Length of this operation (incl. header)
    uint16 op_type; // Operations type  'PQ' (0x5051)
    uint8  op_security_code[4];
};
//
//----------------------------------------------------------------------------
// 
// PR - Promiscuous (Receive-All) Mode Report
//  
// Direction: GW --> IP
//  
// Reports Promiscuous mode status
//  
// Possible response: --
// 
#define		WINSIZE_OP_PR			6

struct op_pr
{
    uint16 op_len;    // Length of this operation (incl. header)
    uint16 op_type;   // Operations type 'PR' (0x5052)
    uint8  pr_rcvall; // Receive All. 0: off, else: on
}
;
//
//----------------------------------------------------------------------------
// 
//   PS - Promiscuous (Receive-All) Mode Set
//  
// Direction: IP --> GW
//  
// Meldung, ob bridge sein ARCNET-Interface im promiscuous mode betreibt.
//  
// Possible response: ER, PR
//
#define		WINSIZE_OP_PS			10
 
struct op_ps
{
    uint16 op_len;    // Length of this operation (incl. header)
    uint16 op_type;   // Operations-Typ Vorschlag: 'PS' (0x5053)
    uint8  op_security_code[4];
    uint8  ps_rcvall; // Receive All. 0: off, else: on
}
;
//
//----------------------------------------------------------------------------
// 
// SQ - Status Query
//  
// Direction: IP --> GW
//  
// Statusabfrage des ARCNET-Interface im bridge
//  
// Possible response: ER, SR
// 
#define		WINSIZE_OP_SQ			8

struct op_sq
{
    uint16 op_len;  // Length of this operation (incl. header)
    uint16 op_type; // Operations type  'SQ' (0x5351)
    uint8  op_security_code[4];
};
//
//----------------------------------------------------------------------------
// 
//   SR - Status Report
//  
// Direction: GW --> IP
//  
// Possible response: ER, SR
// 
#define		WINSIZE_OP_SR			24

struct op_sr
{
    uint16 op_len;				// Length of this operation (incl. header)
    uint16 op_type;				// Operations-typ 'SR' (0x5352)
    //
    uint32 arc_rxPacketCnt;		// Number of received arcnet packets.
    uint32 arc_txPacketCnt;		// Number of transmitted arcnet packets.
    //
    uint32 eth_rxPacketCnt;		// Number of received ethernet packets.
    uint32 eth_txPacketCnt;		// Number of transmitted ethernet packets.
    uint32 eth_clientCnt;		// Number of ethernet clients currently connected.
};
//
//----------------------------------------------------------------------------
// 
// CRESQ - Counter reset command.
//  
// Direction: IP --> GW
//  
// Resets packet counters.
//
// Response is just OpHdr with OP_CRESR as op_type.
// 
#define		WINSIZE_OP_CRESQ		8
 
struct op_cresq
{
    uint16 op_len;  // Length of this operation (incl. header)
    uint16 op_type; // Operations type  'CRESQ'
    uint8  op_security_code[4];
};
//
//----------------------------------------------------------------------------
// 
//   WQ - Write reQuest
//  
// Direction: IP --> GW --> ARC
//  
// Sends ARCNET-Telegram
//  
// Possible response: ER ,WO
//
#define		WINSIZE_OP_WQ			8
 
struct op_wq
{
    uint16 op_len;    // Length of this operation (incl. header)
    uint16 op_type;   // Operations type 'WQ' (0x5751)
    uint8  op_security_code[4];
    uint8  wq_data[]; // ARCNET-Telegram
    // Format: struct arc_pac
}
;
//
//----------------------------------------------------------------------------
// 
//   WO - Write O.K.
//  
// Direction: GW --> IP
//  
// ARCNET Telegram successfully sent to packet layer.
// The return code shows the result of the transmit operation.
//		  0: Tx complete, Tx acknowledged.
//		  1: Tx complete, Tx not acknowledged (broadcast).
//		  2: Timeout, tx not complete.
//		  3: Arcnet write failed.
//		<4>: Excessive NAKS.
//		<5>: Recon.
//
// NOTE: <4> and <5> not implemented yet.
// 
#define		WINSIZE_OP_WO			8
 
struct op_wo
{
    uint16 op_len;		// Length of this operation (incl. header)
    uint16 op_type;		// Operations type  'WO' (0x574F)
    uint32 op_result;	// What is returned from TxWait().
}
;
//
//----------------------------------------------------------------------------
// 
// DA - Data Advise
//  
// Direction: IP --> GW
//  
// Possible response: ER, DR
//  
// Note:
//  - Formerly 'DA' operations of this IP node will be overridden
//  - A zeroed 'da_map' resets all request of this node. 'da_time' and 'da_rcvall'
//    are ignored.
//  - If UDP is used, 'da_time' must not 0 sein, This prevents the bridge sending
//    data to 'dead' IP nodes. UDP notes should repeat this request periodically.
//  - "da_rcvall" flag indicates if the client is interested on all telegrams sent by
//    this ARCNET node or only sent to the bridge. The flag is used only in receive-all
//    mode.
// 
#define		WINSIZE_OP_DA			44

struct op_da
{
    uint16 op_len;    // Length of this operation (incl. header)
    uint16 op_type;   // Operation type  'DA' (0x4441)
    uint8  op_security_code[4];
    uint8  da_map[32]; // Bit-Flags for all ARCNET nodes
    // Bit 7 in da_map[1] = node 1,
    // Bit 0 in da_map[31] = Knoten 255
    uint16 da_time;   // After this time [ 1/10 s] the request will be deleted
    // automatically
    // 0 = forever
    uint8  da_rcvall; // 0: only telegrams sent to the bridge, else: all telegrams
}
;
//
//----------------------------------------------------------------------------
// 
// DQ - Data reQuest
//  
// Direction: IP --> GW
//  
// Request date from the node's FIFO
//  
// Possible response: ER, DR
//  
// Note:
//  - If there are less telegrams in FIFO as requested, the bridge sends a 'DR' 
//    operation with 0 bytes data and dr_telid = 0. This marks the end of the 
//    transmission.
//  - Bridge sends latest telegram first 
//
#define		WINSIZE_OP_DQ			10
 
struct op_dq
{
    uint16 op_len;  // Length of this operation (incl. header)
    uint16 op_type; // Operation type  'DQ' (0x4451)
    uint8  op_security_code[4];
    uint8  dq_node; // ARCNET node number of interest
    uint8  dq_fifo; // number of telegrams in FIFO
}
;
//
//----------------------------------------------------------------------------
// 
// DR - Data Response
//  
// Direction: ( ARC --> ) GW --> IP
//  
// ARCNET-Telegram to client
//  
// Possible response: --
//  
// Note:
//  - If the 'DR' operation is sent in cause of a 'DA' request 'dr_fifo' is 0.
//  - If there are less telegrams in FIFO as are requested by a 'DQ' request
//    dr_data is empty and dr_telid = 0. In this case op_len = 9.
//
#define		WINSIZE_OP_DR			12

struct op_dr
{
    uint16 op_len;    // Length of this operation (incl. header)
    uint16 op_type;   // Operation type  'DR' (0x4452)
    uint32 dr_telid;  // unique ID  of the ARCNET-Telegram
    uint8  dr_fifo;   // FIFO Position of the ARCNET-Telegram (0: latest)
    uint8  dr_data[]; // ARCNET telegram of struct arc_pac
}
;
//
//----------------------------------------------------------------------------
// 
// NQ - Nodemap reQuest
//  
// Direction: IP --> GW
//  
// Possible response: ER, NR
// 
#define		WINSIZE_OP_NQ			8

struct op_nq
{
    uint16 op_len;    // Length of this operation (incl. header)
    uint16 op_type;   // Operations-Typ Vorschlag: 'NQ' (0x4E51)
    uint8  op_security_code[4];
};
//
//----------------------------------------------------------------------------
// 
//   NR - Nodemap Response
//  
// Direction: GW --> IP
//  
// Not yet supported
//  
// Possible response: --
//  
// Note:
//  - Node map is only build in receive all mode. Else the bridge sends an error code.
// 
#define		WINSIZE_OP_NR			36

struct op_nr
{
    uint16 op_len;    // Length of this operation (incl. header)
    uint16 op_type;   // Operation type  'NR' (0x4E52)
    uint8  nr_map[32]; // Bit-Flags for all ARCNET nodes, If a flag is set,
    // the node is active
    // Bit 1 von nr_map[0] correspons node 1,
    // Bit 7 von nr_map[31] correspons note 255
}
;
//
//----------------------------------------------------------------------------
//
// TCP_NODELAY Query/set/clear.
//  
// Direction: IP --> GW
//
// Response: ER , OP_NDR
//
#define		WINSIZE_OP_NDQ			10

struct op_ndq
{
	uint16	op_len;		// Length of this operation (incl.header).
	uint16	op_type;	// Operation: 'NDQ'.
    uint8	op_security_code[4];
	uint16	action;		// Action: 0=set OFF, 1=set ON, 2=report current status.
}
;
//
//----------------------------------------------------------------------------
//
// TCP_NODELAY Response.
//  
// Direction: GW --> IP
//
#define		WINSIZE_OP_NDR			6

struct op_ndr
{
	uint16	op_len;		// Length of this operation (incl.header).
	uint16	op_type;	// Operation: 'NDR'.
	uint16	status;		// TCP_NODELAY: off=0 on=1.
}
;
//
//----------------------------------------------------------------------------
//
// Arcnet Register Read/Write Query.
//
// Direction: IP -> GW
//
// Response: ER ,OP_REGR.
//
#define		WINSIZE_OP_REGQ		12

struct op_regq
{
	uint16	op_len;		// Length of this operation (incl.header).
	uint16	op_type;	// Operation: 'REGQ'.
    uint8	op_security_code[4];
	uint8	write;		// 0=read , 1=write.
	uint8	reg;		// Arcnet register number.
	uint8	value;		// Read/write value.
}
;
//
//----------------------------------------------------------------------------
//
// Arcnet Register Read/Write Response.
//
// Direction: GW -> IP
//
#define		WINSIZE_OP_REGR		6

struct op_regr
{
	uint16	op_len;		// Length of this operation (incl.header).
	uint16	op_type;	// Operation: 'REGR'.
	uint8	value;		// Read/write value.
}
;
//
//----------------------------------------------------------------------------
//
// Arcnet flags query.
//
// Direction: IP -> GW
//
// Response: ER , OP_FLAGR
//
#define		WINSIZE_OP_FLAGQ		8

struct op_flagq
{
	uint16	op_len;		// Length of this operation (incl.header).
	uint16	op_type;	// Operation: 'FLAGQ'.
    uint8	op_security_code[4];
}
;
//
//----------------------------------------------------------------------------
//
// Arcnet flags response.
//
// Direction: GW -> IP
//
// NOTE: recon_count is not word aligned, so it will have to be loaded byte-by-byte.
//
#define		WINSIZE_OP_FLAGR		12

struct op_flagr
{
	uint16	op_len;				// Length of this operation (incl.header).
	uint16	op_type;			// Operation: 'FLAGR'.
	uint8	tx_complete;
	uint8	tx_acknowledged;
	uint32	recon_count;
}
;
//
//----------------------------------------------------------------------------
//
// Wake on tx complete query.
//
// Direction: IP -> GW
//
// Response: ER , OP_TXWAITR
//
#define		WINSIZE_OP_TXWAITQ		10

struct op_txwaitq
{
	uint16	op_len;		// Length of this operation (incl.header).
	uint16	op_type;	// Operation: 'TXWAITR'.
    uint8	op_security_code[4];
	uint8	op_value;	// 0=disable , 1=enable , 2=report current value.
}
;
//
//----------------------------------------------------------------------------
//
// Wake on tx complete response.
//
// Direction: GW -> IP
//
#define		WINSIZE_OP_TXWAITR		6

struct op_txwaitr
{
	uint16	op_len;		// Length of this operation (incl.header).
	uint16	op_type;	// Operation: 'TXWAITR'.
	uint8	op_value;	// 0=disabled , 1=enabled.
}
;
//
//----------------------------------------------------------------------------
//
// Wake on recon query.
//
// Direction: IP -> GW
//
// Response: ER , OP_RECONR
//
#define		WINSIZE_OP_RECONQ		10

struct op_reconq
{
	uint16	op_len;		// Length of this operation (incl.header).
	uint16	op_type;	// Operation: 'RECONR'.
    uint8	op_security_code[4];
	uint8	op_value;	// 0=disable , 1=enable , 2=report current value.
}
;
//
//----------------------------------------------------------------------------
//
// Wake on recon response.
//
// Direction: GW -> IP
//
#define		WINSIZE_OP_RECONR		6

struct op_reconr
{
	uint16	op_len;		// Length of this operation (incl.header).
	uint16	op_type;	// Operation: 'RECONR'.
	uint8	op_value;	// 0=disabled , 1=enabled , 2=error:can't start thread.
}
;
//
//----------------------------------------------------------------------------
//
// Set arcnet TX timeout value.
//
// Direction: IP -> GW
//
// Response: ER , OP_TXTIMEOR
//
#define		WINSIZE_OP_TXTIMEOQ	12

struct op_txtimeoq
{
	uint16	op_len;		// Length of this operation (incl.header).
	uint16	op_type;	// Operation: 'TXTIMEOQ'.
    uint8	op_security_code[4];
	uint32	op_timeout;	// Timeout in milliseconds.
}
;
//
//----------------------------------------------------------------------------
//
// TX timeout response.
//
// Direction: GW -> IP
//
#define		WINSIZE_OP_TXTIMEOR	8

struct op_txtimeor
{
	uint16	op_len;		// Length of this operation (incl.header).
	uint16	op_type;	// Operation: 'TXTIMEOR'.
	uint32	op_result;	// 0=Success 1=failure.
}
;
//
//----------------------------------------------------------------------------
//
// REBOOTQ - Reboot the AI.
//
// Direction: IP --> GW
//
// Reboots the AI.
//
// There is no response.
//
#define		WINSIZE_OP_REBOOTQ		8

struct op_rebootq
{
    uint16 op_len;  // Length of this operation (incl. header)
    uint16 op_type; // Operations type  'REBOOTQ'
    uint8  op_security_code[4];
};

/* ---------------  MODULE INTERNAL VARIABLES  -------------*/

/* ------------------  GLOBAL VARIABLES  -------------------*/

/* -----------------  EXTERNAL VARIABLES  ------------------*/

/* -----------------  EXTERNAL FUNCTIONS  ------------------*/
//
// Restore default structure alignment.
//
#pragma pack()

#endif
